/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.validation;

import org.gbif.ipt.action.BaseAction;
import org.gbif.ipt.model.User;
import org.gbif.ipt.validation.BaseValidator;
import org.gbif.ipt.validation.EmailValidationMessageTranslator;
import org.gbif.ipt.validation.ValidationResult;

public class UserValidator
extends BaseValidator {
    public boolean validate(BaseAction action, User user) {
        return this.validate(action, user, true);
    }

    public boolean validate(BaseAction action, User user, boolean validatePassword) {
        boolean valid = true;
        if (user != null) {
            if (this.exists(user.getEmail())) {
                ValidationResult result = this.checkEmailValid(user.getEmail());
                if (!result.isValid()) {
                    valid = false;
                    action.addFieldError("user.email", action.getText(EmailValidationMessageTranslator.EMAIL_ERROR_TRANSLATIONS.getOrDefault(result.getMessage(), "validation.email.invalid")));
                }
            } else {
                action.addFieldError("user.email", action.getText("validation.email.required"));
                valid = false;
            }
            if (!this.exists(user.getFirstname(), 1)) {
                valid = false;
                action.addFieldError("user.firstname", action.getText("validation.firstname.required"));
            }
            if (!this.exists(user.getLastname(), 1)) {
                valid = false;
                action.addFieldError("user.lastname", action.getText("validation.lastname.required"));
            }
            if (validatePassword && !this.exists(user.getPassword(), 4)) {
                valid = false;
                action.addFieldError("newPassword", action.getText("validation.password.required"));
                action.addFieldError("user.password", action.getText("validation.password.required"));
            }
        }
        return valid;
    }

    public boolean validatePassword(BaseAction action, String password) {
        boolean valid = true;
        if (!this.exists(password, 4)) {
            valid = false;
            action.addFieldError("newPassword", action.getText("validation.password.required"));
            action.addFieldError("user.password", action.getText("validation.password.required"));
        }
        return valid;
    }
}

