/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.validation;

import java.util.LinkedHashMap;
import java.util.Map;
import org.gbif.ipt.model.voc.MetadataSection;
import org.gbif.ipt.validation.ActionValidationResult;
import org.gbif.ipt.validation.ErrorCollector;

public class SectionErrorCollector
implements ErrorCollector {
    private final Map<String, ActionValidationResult> result = new LinkedHashMap();
    private MetadataSection currentSection;

    public SectionErrorCollector() {
        for (MetadataSection section : MetadataSection.values()) {
            this.result.put(section.toString(), new ActionValidationResult());
        }
    }

    private ActionValidationResult section() {
        return (ActionValidationResult)this.result.get(this.currentSection.toString());
    }

    public void addFieldError(String field, String msg) {
        this.section().addFieldError(field, msg);
    }

    public void addActionError(String msg) {
        this.section().addActionError(msg);
    }

    public void addActionWarning(String msg) {
        this.section().addWarning(msg);
    }

    public boolean hasActionErrors() {
        return this.result.values().stream().anyMatch(ActionValidationResult::hasActionErrors);
    }

    public boolean hasFieldErrors() {
        return this.result.values().stream().anyMatch(ActionValidationResult::hasFieldErrors);
    }

    public boolean hasErrors() {
        return this.hasActionErrors() || this.hasFieldErrors();
    }

    public Map<String, ActionValidationResult> getResult() {
        return this.result;
    }

    public MetadataSection getCurrentSection() {
        return this.currentSection;
    }

    public void setCurrentSection(MetadataSection currentSection) {
        this.currentSection = currentSection;
    }
}

