/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.validation;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.gbif.api.vocabulary.Language;
import org.gbif.ipt.action.BaseAction;
import org.gbif.ipt.config.AppConfig;
import org.gbif.ipt.i18n.I18n;
import org.gbif.ipt.i18n.StrutsI18n;
import org.gbif.ipt.model.Resource;
import org.gbif.ipt.model.voc.MetadataSection;
import org.gbif.ipt.service.admin.RegistrationManager;
import org.gbif.ipt.struts2.SimpleTextProvider;
import org.gbif.ipt.validation.ActionErrorCollector;
import org.gbif.ipt.validation.BaseValidator;
import org.gbif.ipt.validation.EmailValidationMessageTranslator;
import org.gbif.ipt.validation.EmlValidator;
import org.gbif.ipt.validation.ErrorCollector;
import org.gbif.ipt.validation.SectionErrorCollector;
import org.gbif.ipt.validation.ValidationResult;
import org.gbif.metadata.eml.EMLProfileVersion;
import org.gbif.metadata.eml.InvalidEmlException;
import org.gbif.metadata.eml.ipt.IptEmlWriter;
import org.gbif.metadata.eml.ipt.model.Address;
import org.gbif.metadata.eml.ipt.model.Agent;
import org.gbif.metadata.eml.ipt.model.BBox;
import org.gbif.metadata.eml.ipt.model.Citation;
import org.gbif.metadata.eml.ipt.model.Eml;
import org.gbif.metadata.eml.ipt.model.GeospatialCoverage;
import org.gbif.metadata.eml.ipt.model.JGTICuratorialUnit;
import org.gbif.metadata.eml.ipt.model.JGTICuratorialUnitType;
import org.gbif.metadata.eml.ipt.model.KeywordSet;
import org.gbif.metadata.eml.ipt.model.MaintenanceUpdateFrequency;
import org.gbif.metadata.eml.ipt.model.PhysicalData;
import org.gbif.metadata.eml.ipt.model.Point;
import org.gbif.metadata.eml.ipt.model.Project;
import org.gbif.metadata.eml.ipt.model.ProjectAward;
import org.gbif.metadata.eml.ipt.model.StudyAreaDescription;
import org.gbif.metadata.eml.ipt.model.TaxonKeyword;
import org.gbif.metadata.eml.ipt.model.TaxonomicCoverage;
import org.gbif.metadata.eml.ipt.model.TemporalCoverage;
import org.gbif.metadata.eml.ipt.model.TemporalCoverageType;
import org.gbif.metadata.eml.ipt.model.UserId;

/*
 * Exception performing whole class analysis ignored.
 */
public class EmlValidator
extends BaseValidator {
    private static final Logger LOG = LogManager.getLogger(EmlValidator.class);
    private static final String EML_VALIDATION_ERROR_PATTERN = "^[^;]*;\\s*lineNumber:\\s*\\d+;\\s*columnNumber:\\s*\\d+;\\s*(?:[^:]*:\\s*)?";
    protected static Pattern phonePattern = Pattern.compile("[\\w ()/+-\\.]+");
    private AppConfig cfg;
    private RegistrationManager regManager;
    private SimpleTextProvider simpleTextProvider;
    private org.gbif.metadata.eml.EmlValidator emlProfileValidator;
    private static final Map<String, String> TAG_REPLACEMENTS = new HashMap();

    @Inject
    public EmlValidator(AppConfig cfg, RegistrationManager registrationManager, SimpleTextProvider simpleTextProvider) {
        this.cfg = cfg;
        this.regManager = registrationManager;
        this.simpleTextProvider = simpleTextProvider;
        try {
            this.emlProfileValidator = org.gbif.metadata.eml.EmlValidator.newValidator((EMLProfileVersion)EMLProfileVersion.GBIF_1_3);
        }
        catch (Exception e) {
            LOG.error("Failed to initialize EML Profile Validator", (Throwable)e);
        }
    }

    public static String formatURL(String url) {
        if (StringUtils.isNotBlank((CharSequence)url)) {
            try {
                URI uri = URI.create(url);
                if (uri.isAbsolute()) {
                    return url;
                }
                return "http://" + url;
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
        return null;
    }

    public static boolean isWellFormedURI(String url) {
        if (url != null) {
            try {
                new URI(url);
                return true;
            }
            catch (URISyntaxException e) {
                return false;
            }
        }
        return false;
    }

    public static boolean isValidInteger(String integer) {
        try {
            Integer.parseInt(integer);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean isValidPhoneNumber(String phone) {
        return StringUtils.isNotBlank((CharSequence)phone) && phonePattern.matcher(phone).matches();
    }

    public boolean isValid(Resource resource, @Nullable MetadataSection section) {
        BaseAction action = new BaseAction(this.simpleTextProvider, this.cfg, this.regManager);
        ActionErrorCollector ec = new ActionErrorCollector(action);
        StrutsI18n i18n = new StrutsI18n(action);
        this.validate(resource, section, (ErrorCollector)ec, (I18n)i18n);
        return !action.hasActionErrors() && !action.hasFieldErrors();
    }

    public boolean areAllSectionsValid(Resource resource, SectionErrorCollector ec, I18n i18n) {
        boolean problemsEncountered = false;
        for (MetadataSection section : MetadataSection.values()) {
            ec.setCurrentSection(section);
            this.validate(resource, section, (ErrorCollector)ec, i18n);
            if (!ec.hasErrors()) continue;
            problemsEncountered = true;
        }
        return !problemsEncountered;
    }

    public boolean isSectionValid(Resource resource, MetadataSection section, ErrorCollector ec, I18n i18n) {
        this.validate(resource, section, ec, i18n);
        if (ec.hasActionErrors() || ec.hasFieldErrors()) {
            ec.addActionError(i18n.getText("manage.failed", new String[]{i18n.getText("submenu." + section.getName())}));
            return false;
        }
        return true;
    }

    public void validate(Resource resource, @Nullable MetadataSection section, ErrorCollector ec, I18n i18n) {
        if (resource != null) {
            Eml eml;
            Eml eml2 = eml = resource.getEml() == null ? new Eml() : resource.getEml();
            if (section == null) {
                section = MetadataSection.BASIC_SECTION;
            }
            switch (1.$SwitchMap$org$gbif$ipt$model$voc$MetadataSection[section.ordinal()]) {
                case 1: {
                    String strippedDescription;
                    if (StringUtils.isBlank((CharSequence)eml.getTitle())) {
                        ec.addFieldError("eml.title", i18n.getText("validation.required", new String[]{i18n.getText("eml.title")}));
                    }
                    if (resource.getShortname() != null && resource.getShortname().equals(eml.getTitle())) {
                        ec.addActionWarning(i18n.getText("eml.title.shortname.match"));
                    }
                    if (StringUtils.isEmpty((CharSequence)(strippedDescription = Optional.ofNullable(eml.getDescription()).map(d -> d.replaceAll("<[^>]*>", "")).map(d -> d.replace("&nbsp;", " ")).map(String::trim).orElse("")))) {
                        ec.addActionError(i18n.getText("validation.required", new String[]{i18n.getText("eml.description")}));
                    } else if (!this.exists(strippedDescription, 5)) {
                        ec.addActionError(i18n.getText("validation.short", new String[]{i18n.getText("eml.description"), "5"}));
                    } else if (this.emlProfileValidator == null) {
                        ec.addActionError(i18n.getText("validation.cannnot.be.performed"));
                    } else {
                        try {
                            Eml stubValidationEml = EmlValidator.getStubEml();
                            String descriptionWithNbspReplaced = Optional.ofNullable(eml.getDescription()).map(d -> d.replace("&nbsp;", " ")).orElse("");
                            stubValidationEml.setDescription(descriptionWithNbspReplaced);
                            String emlString = IptEmlWriter.writeEmlAsString((Eml)stubValidationEml);
                            this.emlProfileValidator.validate(emlString);
                        }
                        catch (InvalidEmlException e) {
                            ec.addActionError(i18n.getText("validation.invalid.ext", new String[]{i18n.getText("eml.description"), EmlValidator.simplifyDocBookValidationErrorMessage((String)e.getMessage())}));
                        }
                        catch (Exception e) {
                            ec.addActionError(i18n.getText("validation.failed.see.logs", new String[]{i18n.getText("eml.description")}));
                            LOG.error("Failed to validate description", (Throwable)e);
                        }
                    }
                    if (StringUtils.isBlank((CharSequence)eml.getIntellectualRights())) {
                        ec.addFieldError("eml.intellectualRights.license", i18n.getText("validation.required", new String[]{i18n.getText("eml.intellectualRights.license")}));
                    }
                    if (StringUtils.isBlank((CharSequence)resource.getCoreType())) {
                        ec.addFieldError("resource.coreType", i18n.getText("validation.required", new String[]{i18n.getText("resource.coreType")}));
                    }
                    if (StringUtils.isBlank((CharSequence)eml.getMetadataLanguage())) {
                        ec.addActionWarning(i18n.getText("eml.metadataLanguage.default"));
                        eml.setMetadataLanguage(Language.ENGLISH.getIso3LetterCode());
                    }
                    if (StringUtils.isBlank((CharSequence)eml.getLanguage()) && resource.getCoreType() != null && !resource.getCoreType().equalsIgnoreCase(Resource.CoreRowType.METADATA.toString())) {
                        ec.addActionWarning(i18n.getText("eml.language.default"));
                        eml.setLanguage(Language.ENGLISH.getIso3LetterCode());
                    }
                    if (eml.getUpdateFrequency() != null) break;
                    if (resource.getUpdateFrequency() != null) {
                        eml.setUpdateFrequency(resource.getUpdateFrequency().getIdentifier());
                        ec.addActionWarning(i18n.getText("eml.updateFrequency.default.interval", new String[]{resource.getUpdateFrequency().getIdentifier()}));
                        break;
                    }
                    ec.addActionWarning(i18n.getText("eml.updateFrequency.default"));
                    eml.setUpdateFrequency(MaintenanceUpdateFrequency.UNKNOWN.getIdentifier());
                    break;
                }
                case 2: {
                    int homepageIndex;
                    int phoneIndex;
                    int emailIndex;
                    Agent c;
                    int index;
                    if (this.isAgentsListEmpty(eml.getContacts())) {
                        ec.addActionError(i18n.getText("eml.contact.required"));
                    } else {
                        for (index = 0; index < eml.getContacts().size(); ++index) {
                            c = (Agent)eml.getContacts().get(index);
                            if (this.exists(c.getFirstName()) && !this.exists(c.getLastName())) {
                                ec.addFieldError("eml.contacts[" + index + "].lastName", i18n.getText("validation.firstname.lastname"));
                            }
                            if (!c.getUserIds().isEmpty()) {
                                for (int identifierIndex = 0; identifierIndex < c.getUserIds().size(); ++identifierIndex) {
                                    if (this.exists(((UserId)c.getUserIds().get(identifierIndex)).getDirectory()) && !this.exists(((UserId)c.getUserIds().get(identifierIndex)).getIdentifier())) {
                                        ec.addFieldError("eml.contacts[" + index + "].userIds[" + identifierIndex + "].identifier", i18n.getText("validation.personnel"));
                                        continue;
                                    }
                                    if (!this.exists(((UserId)c.getUserIds().get(identifierIndex)).getDirectory()) && this.exists(((UserId)c.getUserIds().get(identifierIndex)).getIdentifier())) {
                                        ec.addFieldError("eml.contacts[" + index + "].userIds[" + identifierIndex + "].directory", i18n.getText("validation.directory"));
                                        continue;
                                    }
                                    if (this.exists(((UserId)c.getUserIds().get(identifierIndex)).getDirectory()) || this.exists(((UserId)c.getUserIds().get(identifierIndex)).getIdentifier())) continue;
                                    ec.addFieldError("eml.contacts[" + index + "].userIds[" + identifierIndex + "].identifier", i18n.getText("validation.invalid", new String[]{i18n.getText("eml.contact.identifier")}));
                                    ec.addFieldError("eml.contacts[" + index + "].userIds[" + identifierIndex + "].directory", i18n.getText("validation.invalid", new String[]{i18n.getText("eml.contact.directory")}));
                                }
                            }
                            if (!(this.exists(c.getOrganisation()) || this.exists(c.getLastName()) || !c.getPosition().isEmpty() && this.exists((String)c.getPosition().get(0)))) {
                                ec.addActionError(i18n.getText("validation.lastname.organisation.position"));
                                ec.addFieldError("eml.contacts[" + index + "].organisation", i18n.getText("validation.required", new String[]{i18n.getText("eml.contact.organisation")}));
                                ec.addFieldError("eml.contacts[" + index + "].lastName", i18n.getText("validation.required", new String[]{i18n.getText("eml.contact.lastName")}));
                                ec.addFieldError("eml.contacts[" + index + "].position", i18n.getText("validation.required", new String[]{i18n.getText("eml.contact.position")}));
                            }
                            if (c.getAddress() != null && c.getAddress().getAddress() != null && !c.getAddress().getAddress().isEmpty()) {
                                for (int addressIndex = 0; addressIndex < c.getAddress().getAddress().size(); ++addressIndex) {
                                    if (!StringUtils.isBlank((CharSequence)((CharSequence)c.getAddress().getAddress().get(addressIndex)))) continue;
                                    ec.addFieldError("eml.contacts[" + index + "].address.address[" + addressIndex + "]", i18n.getText("validation.invalid", new String[]{i18n.getText("eml.contact.address.address")}));
                                }
                            }
                            if (!c.getPosition().isEmpty()) {
                                for (int positionIndex = 0; positionIndex < c.getPosition().size(); ++positionIndex) {
                                    if (!StringUtils.isBlank((CharSequence)((CharSequence)c.getPosition().get(positionIndex)))) continue;
                                    ec.addFieldError("eml.contacts[" + index + "].position[" + positionIndex + "]", i18n.getText("validation.invalid", new String[]{i18n.getText("eml.contact.position")}));
                                }
                            }
                            if (!c.getEmail().isEmpty()) {
                                for (emailIndex = 0; emailIndex < c.getEmail().size(); ++emailIndex) {
                                    ValidationResult emailValidationResult = this.checkEmailValid((String)c.getEmail().get(emailIndex));
                                    if (emailValidationResult.isValid()) continue;
                                    ec.addFieldError("eml.contacts[" + index + "].email[" + emailIndex + "]", i18n.getText(EmailValidationMessageTranslator.EMAIL_ERROR_TRANSLATIONS.getOrDefault(emailValidationResult.getMessage(), "validation.email.invalid")));
                                }
                            }
                            if (!c.getPhone().isEmpty()) {
                                for (phoneIndex = 0; phoneIndex < c.getPhone().size(); ++phoneIndex) {
                                    if (EmlValidator.isValidPhoneNumber((String)((String)c.getPhone().get(phoneIndex)))) continue;
                                    ec.addFieldError("eml.contacts[" + index + "].phone[" + phoneIndex + "]", i18n.getText("validation.invalid", new String[]{i18n.getText("eml.contact.phone")}));
                                }
                            }
                            if (c.getHomepage().isEmpty()) continue;
                            for (homepageIndex = 0; homepageIndex < c.getHomepage().size(); ++homepageIndex) {
                                if (EmlValidator.formatURL((String)((String)c.getHomepage().get(homepageIndex))) == null) {
                                    ec.addFieldError("eml.contacts[" + index + "].homepage[" + homepageIndex + "]", i18n.getText("validation.invalid", new String[]{i18n.getText("eml.contact.homepage")}));
                                    continue;
                                }
                                c.getHomepage().set(homepageIndex, EmlValidator.formatURL((String)((String)c.getHomepage().get(homepageIndex))));
                            }
                        }
                    }
                    if (this.isAgentsListEmpty(eml.getCreators())) {
                        ec.addActionError(i18n.getText("eml.resourceCreator.required"));
                    } else {
                        for (index = 0; index < eml.getCreators().size(); ++index) {
                            c = (Agent)eml.getCreators().get(index);
                            if (this.exists(c.getFirstName()) && !this.exists(c.getLastName())) {
                                ec.addFieldError("eml.creators[" + index + "].lastName", i18n.getText("validation.firstname.lastname"));
                            }
                            if (!c.getUserIds().isEmpty()) {
                                for (int identifierIndex = 0; identifierIndex < c.getUserIds().size(); ++identifierIndex) {
                                    if (this.exists(((UserId)c.getUserIds().get(identifierIndex)).getDirectory()) && !this.exists(((UserId)c.getUserIds().get(identifierIndex)).getIdentifier())) {
                                        ec.addFieldError("eml.creators[" + index + "].userIds[" + identifierIndex + "].identifier", i18n.getText("validation.personnel"));
                                        continue;
                                    }
                                    if (!this.exists(((UserId)c.getUserIds().get(identifierIndex)).getDirectory()) && this.exists(((UserId)c.getUserIds().get(identifierIndex)).getIdentifier())) {
                                        ec.addFieldError("eml.creators[" + index + "].userIds[" + identifierIndex + "].directory", i18n.getText("validation.directory"));
                                        continue;
                                    }
                                    if (this.exists(((UserId)c.getUserIds().get(identifierIndex)).getDirectory()) || this.exists(((UserId)c.getUserIds().get(identifierIndex)).getIdentifier())) continue;
                                    ec.addFieldError("eml.creators[" + index + "].userIds[" + identifierIndex + "].identifier", i18n.getText("validation.invalid", new String[]{i18n.getText("eml.contact.identifier")}));
                                    ec.addFieldError("eml.creators[" + index + "].userIds[" + identifierIndex + "].directory", i18n.getText("validation.invalid", new String[]{i18n.getText("eml.contact.directory")}));
                                }
                            }
                            if (!(this.exists(c.getOrganisation()) || this.exists(c.getLastName()) || !c.getPosition().isEmpty() && this.exists((String)c.getPosition().get(0)))) {
                                ec.addActionError(i18n.getText("validation.lastname.organisation.position"));
                                ec.addFieldError("eml.creators[" + index + "].organisation", i18n.getText("validation.required", new String[]{i18n.getText("eml.resourceCreator.organisation")}));
                                ec.addFieldError("eml.creators[" + index + "].lastName", i18n.getText("validation.required", new String[]{i18n.getText("eml.resourceCreator.lastName")}));
                                ec.addFieldError("eml.creators[" + index + "].position", i18n.getText("validation.required", new String[]{i18n.getText("eml.resourceCreator.position")}));
                            }
                            if (c.getAddress() != null && c.getAddress().getAddress() != null && !c.getAddress().getAddress().isEmpty()) {
                                for (int addressIndex = 0; addressIndex < c.getAddress().getAddress().size(); ++addressIndex) {
                                    if (!StringUtils.isBlank((CharSequence)((CharSequence)c.getAddress().getAddress().get(addressIndex)))) continue;
                                    ec.addFieldError("eml.creators[" + index + "].address.address[" + addressIndex + "]", i18n.getText("validation.invalid", new String[]{i18n.getText("eml.contact.address.address")}));
                                }
                            }
                            if (!c.getPosition().isEmpty()) {
                                for (int positionIndex = 0; positionIndex < c.getPosition().size(); ++positionIndex) {
                                    if (!StringUtils.isBlank((CharSequence)((CharSequence)c.getPosition().get(positionIndex)))) continue;
                                    ec.addFieldError("eml.creators[" + index + "].position[" + positionIndex + "]", i18n.getText("validation.invalid", new String[]{i18n.getText("eml.contact.position")}));
                                }
                            }
                            if (!c.getEmail().isEmpty()) {
                                for (emailIndex = 0; emailIndex < c.getEmail().size(); ++emailIndex) {
                                    ValidationResult emailValidationResult = this.checkEmailValid((String)c.getEmail().get(emailIndex));
                                    if (emailValidationResult.isValid()) continue;
                                    ec.addFieldError("eml.creators[" + index + "].email[" + emailIndex + "]", i18n.getText(EmailValidationMessageTranslator.EMAIL_ERROR_TRANSLATIONS.getOrDefault(emailValidationResult.getMessage(), "validation.email.invalid")));
                                }
                            }
                            if (!c.getPhone().isEmpty()) {
                                for (phoneIndex = 0; phoneIndex < c.getPhone().size(); ++phoneIndex) {
                                    if (EmlValidator.isValidPhoneNumber((String)((String)c.getPhone().get(phoneIndex)))) continue;
                                    ec.addFieldError("eml.creators[" + index + "].phone[" + phoneIndex + "]", i18n.getText("validation.invalid", new String[]{i18n.getText("eml.resourceCreator.phone")}));
                                }
                            }
                            if (c.getHomepage().isEmpty()) continue;
                            for (homepageIndex = 0; homepageIndex < c.getHomepage().size(); ++homepageIndex) {
                                if (EmlValidator.formatURL((String)((String)c.getHomepage().get(homepageIndex))) == null) {
                                    ec.addFieldError("eml.creators[" + index + "].homepage[" + homepageIndex + "]", i18n.getText("validation.invalid", new String[]{i18n.getText("eml.resourceCreator.homepage")}));
                                    continue;
                                }
                                c.getHomepage().set(homepageIndex, EmlValidator.formatURL((String)((String)c.getHomepage().get(homepageIndex))));
                            }
                        }
                    }
                    for (index = 0; index < eml.getMetadataProviders().size(); ++index) {
                        c = (Agent)eml.getMetadataProviders().get(index);
                        if (this.exists(c.getFirstName()) && !this.exists(c.getLastName())) {
                            ec.addFieldError("eml.metadataProviders[" + index + "].lastName", i18n.getText("validation.firstname.lastname"));
                        }
                        if (!c.getUserIds().isEmpty()) {
                            for (int identifierIndex = 0; identifierIndex < c.getUserIds().size(); ++identifierIndex) {
                                if (this.exists(((UserId)c.getUserIds().get(identifierIndex)).getDirectory()) && !this.exists(((UserId)c.getUserIds().get(identifierIndex)).getIdentifier())) {
                                    ec.addFieldError("eml.metadataProviders[" + index + "].userIds[" + identifierIndex + "].identifier", i18n.getText("validation.personnel"));
                                    continue;
                                }
                                if (!this.exists(((UserId)c.getUserIds().get(identifierIndex)).getDirectory()) && this.exists(((UserId)c.getUserIds().get(identifierIndex)).getIdentifier())) {
                                    ec.addFieldError("eml.metadataProviders[" + index + "].userIds[" + identifierIndex + "].directory", i18n.getText("validation.directory"));
                                    continue;
                                }
                                if (this.exists(((UserId)c.getUserIds().get(identifierIndex)).getDirectory()) || this.exists(((UserId)c.getUserIds().get(identifierIndex)).getIdentifier())) continue;
                                ec.addFieldError("eml.metadataProviders[" + index + "].userIds[" + identifierIndex + "].identifier", i18n.getText("validation.invalid", new String[]{i18n.getText("eml.contact.identifier")}));
                                ec.addFieldError("eml.metadataProviders[" + index + "].userIds[" + identifierIndex + "].directory", i18n.getText("validation.invalid", new String[]{i18n.getText("eml.contact.directory")}));
                            }
                        }
                        if (!(this.exists(c.getOrganisation()) || this.exists(c.getLastName()) || !c.getPosition().isEmpty() && this.exists((String)c.getPosition().get(0)))) {
                            ec.addActionError(i18n.getText("validation.lastname.organisation.position"));
                            ec.addFieldError("eml.metadataProviders[" + index + "].organisation", i18n.getText("validation.required", new String[]{i18n.getText("eml.metadataProvider.organisation")}));
                            ec.addFieldError("eml.metadataProviders[" + index + "].lastName", i18n.getText("validation.required", new String[]{i18n.getText("eml.metadataProvider.lastName")}));
                            ec.addFieldError("eml.metadataProviders[" + index + "].position", i18n.getText("validation.required", new String[]{i18n.getText("eml.metadataProvider.position")}));
                        }
                        if (c.getAddress() != null && c.getAddress().getAddress() != null && !c.getAddress().getAddress().isEmpty()) {
                            for (int addressIndex = 0; addressIndex < c.getAddress().getAddress().size(); ++addressIndex) {
                                if (!StringUtils.isBlank((CharSequence)((CharSequence)c.getAddress().getAddress().get(addressIndex)))) continue;
                                ec.addFieldError("eml.metadataProviders[" + index + "].address.address[" + addressIndex + "]", i18n.getText("validation.invalid", new String[]{i18n.getText("eml.contact.address.address")}));
                            }
                        }
                        if (!c.getPosition().isEmpty()) {
                            for (int positionIndex = 0; positionIndex < c.getPosition().size(); ++positionIndex) {
                                if (!StringUtils.isBlank((CharSequence)((CharSequence)c.getPosition().get(positionIndex)))) continue;
                                ec.addFieldError("eml.metadataProviders[" + index + "].position[" + positionIndex + "]", i18n.getText("validation.invalid", new String[]{i18n.getText("eml.contact.position")}));
                            }
                        }
                        if (!c.getEmail().isEmpty()) {
                            for (emailIndex = 0; emailIndex < c.getEmail().size(); ++emailIndex) {
                                ValidationResult emailValidationResult = this.checkEmailValid((String)c.getEmail().get(emailIndex));
                                if (emailValidationResult.isValid()) continue;
                                ec.addFieldError("eml.metadataProviders[" + index + "].email[" + emailIndex + "]", i18n.getText(EmailValidationMessageTranslator.EMAIL_ERROR_TRANSLATIONS.getOrDefault(emailValidationResult.getMessage(), "validation.email.invalid")));
                            }
                        }
                        if (!c.getPhone().isEmpty()) {
                            for (phoneIndex = 0; phoneIndex < c.getPhone().size(); ++phoneIndex) {
                                if (EmlValidator.isValidPhoneNumber((String)((String)c.getPhone().get(phoneIndex)))) continue;
                                ec.addFieldError("eml.metadataProviders[" + index + "].phone[" + phoneIndex + "]", i18n.getText("validation.invalid", new String[]{i18n.getText("eml.metadataProvider.phone")}));
                            }
                        }
                        if (c.getHomepage().isEmpty()) continue;
                        for (homepageIndex = 0; homepageIndex < c.getHomepage().size(); ++homepageIndex) {
                            if (EmlValidator.formatURL((String)((String)c.getHomepage().get(homepageIndex))) == null) {
                                ec.addFieldError("eml.metadataProviders[" + index + "].homepage[" + homepageIndex + "]", i18n.getText("validation.invalid", new String[]{i18n.getText("eml.metadataProvider.homepage")}));
                                continue;
                            }
                            c.getHomepage().set(homepageIndex, EmlValidator.formatURL((String)((String)c.getHomepage().get(homepageIndex))));
                        }
                    }
                    for (index = 0; index < eml.getAssociatedParties().size(); ++index) {
                        Agent ap = (Agent)eml.getAssociatedParties().get(index);
                        if (this.exists(ap.getFirstName()) && !this.exists(ap.getLastName())) {
                            ec.addFieldError("eml.associatedParties[" + index + "].lastName", i18n.getText("validation.firstname.lastname"));
                        }
                        if (!ap.getUserIds().isEmpty()) {
                            for (int identifierIndex = 0; identifierIndex < ap.getUserIds().size(); ++identifierIndex) {
                                if (this.exists(((UserId)ap.getUserIds().get(identifierIndex)).getDirectory()) && !this.exists(((UserId)ap.getUserIds().get(identifierIndex)).getIdentifier())) {
                                    ec.addFieldError("eml.associatedParties[" + index + "].userIds[" + identifierIndex + "].identifier", i18n.getText("validation.personnel"));
                                    continue;
                                }
                                if (!this.exists(((UserId)ap.getUserIds().get(identifierIndex)).getDirectory()) && this.exists(((UserId)ap.getUserIds().get(identifierIndex)).getIdentifier())) {
                                    ec.addFieldError("eml.associatedParties[" + index + "].userIds[" + identifierIndex + "].directory", i18n.getText("validation.directory"));
                                    continue;
                                }
                                if (this.exists(((UserId)ap.getUserIds().get(identifierIndex)).getDirectory()) || this.exists(((UserId)ap.getUserIds().get(identifierIndex)).getIdentifier())) continue;
                                ec.addFieldError("eml.associatedParties[" + index + "].userIds[" + identifierIndex + "].identifier", i18n.getText("validation.invalid", new String[]{i18n.getText("eml.associatedParties.identifier")}));
                                ec.addFieldError("eml.associatedParties[" + index + "].userIds[" + identifierIndex + "].directory", i18n.getText("validation.invalid", new String[]{i18n.getText("eml.associatedParties.directory")}));
                            }
                        }
                        if (!(this.exists(ap.getOrganisation()) || this.exists(ap.getLastName()) || !ap.getPosition().isEmpty() && this.exists((String)ap.getPosition().get(0)))) {
                            ec.addActionError(i18n.getText("validation.lastname.organisation.position"));
                            ec.addFieldError("eml.associatedParties[" + index + "].organisation", i18n.getText("validation.required", new String[]{i18n.getText("eml.associatedParties.organisation")}));
                            ec.addFieldError("eml.associatedParties[" + index + "].lastName", i18n.getText("validation.required", new String[]{i18n.getText("eml.associatedParties.lastName")}));
                            ec.addFieldError("eml.associatedParties[" + index + "].position", i18n.getText("validation.required", new String[]{i18n.getText("eml.associatedParties.position")}));
                        }
                        if (ap.getAddress() != null && ap.getAddress().getAddress() != null && !ap.getAddress().getAddress().isEmpty()) {
                            for (int addressIndex = 0; addressIndex < ap.getAddress().getAddress().size(); ++addressIndex) {
                                if (!StringUtils.isBlank((CharSequence)((CharSequence)ap.getAddress().getAddress().get(addressIndex)))) continue;
                                ec.addFieldError("eml.associatedParties[" + index + "].address.address[" + addressIndex + "]", i18n.getText("validation.invalid", new String[]{i18n.getText("eml.contact.address.address")}));
                            }
                        }
                        if (!ap.getPosition().isEmpty()) {
                            for (int positionIndex = 0; positionIndex < ap.getPosition().size(); ++positionIndex) {
                                if (!StringUtils.isBlank((CharSequence)((CharSequence)ap.getPosition().get(positionIndex)))) continue;
                                ec.addFieldError("eml.associatedParties[" + index + "].position[" + positionIndex + "]", i18n.getText("validation.invalid", new String[]{i18n.getText("eml.contact.position")}));
                            }
                        }
                        if (!ap.getEmail().isEmpty()) {
                            for (emailIndex = 0; emailIndex < ap.getEmail().size(); ++emailIndex) {
                                ValidationResult emailValidationResult = this.checkEmailValid((String)ap.getEmail().get(emailIndex));
                                if (emailValidationResult.isValid()) continue;
                                ec.addFieldError("eml.associatedParties[" + index + "].email[" + emailIndex + "]", i18n.getText(EmailValidationMessageTranslator.EMAIL_ERROR_TRANSLATIONS.getOrDefault(emailValidationResult.getMessage(), "validation.email.invalid")));
                            }
                        }
                        if (!ap.getPhone().isEmpty()) {
                            for (phoneIndex = 0; phoneIndex < ap.getPhone().size(); ++phoneIndex) {
                                if (EmlValidator.isValidPhoneNumber((String)((String)ap.getPhone().get(phoneIndex)))) continue;
                                ec.addFieldError("eml.associatedParties[" + index + "].phone[" + phoneIndex + "]", i18n.getText("validation.invalid", new String[]{i18n.getText("eml.associatedParties.phone")}));
                            }
                        }
                        if (ap.getHomepage().isEmpty()) continue;
                        for (homepageIndex = 0; homepageIndex < ap.getHomepage().size(); ++homepageIndex) {
                            if (EmlValidator.formatURL((String)((String)ap.getHomepage().get(homepageIndex))) == null) {
                                ec.addFieldError("eml.associatedParties[" + index + "].homepage[" + homepageIndex + "]", i18n.getText("validation.invalid", new String[]{i18n.getText("eml.associatedParties.homepage")}));
                                continue;
                            }
                            ap.getHomepage().set(homepageIndex, EmlValidator.formatURL((String)((String)ap.getHomepage().get(homepageIndex))));
                        }
                    }
                    break;
                }
                case 3: {
                    if (this.emlProfileValidator == null) {
                        ec.addActionError(i18n.getText("validation.cannnot.be.performed"));
                        break;
                    }
                    try {
                        Eml stubValidationEml = EmlValidator.getStubEml();
                        String acknowledgementsWithNbspReplaced = Optional.ofNullable(eml.getAcknowledgements()).map(d -> d.replace("&nbsp;", " ")).orElse("");
                        stubValidationEml.setAcknowledgements(acknowledgementsWithNbspReplaced);
                        String emlString = IptEmlWriter.writeEmlAsString((Eml)stubValidationEml);
                        this.emlProfileValidator.validate(emlString);
                    }
                    catch (InvalidEmlException e) {
                        ec.addActionError(i18n.getText("validation.invalid.ext", new String[]{i18n.getText("manage.metadata.acknowledgements"), EmlValidator.simplifyDocBookValidationErrorMessage((String)e.getMessage())}));
                    }
                    catch (Exception e) {
                        ec.addActionError(i18n.getText("validation.failed.see.logs", new String[]{i18n.getText("manage.metadata.acknowledgements")}));
                        LOG.error("Failed to validate acknowledgements", (Throwable)e);
                    }
                    break;
                }
                case 4: {
                    if (!this.isGeoPageEmpty(eml)) {
                        for (int index = 0; index < eml.getGeospatialCoverages().size(); ++index) {
                            if (eml.getGeospatialCoverages().isEmpty()) continue;
                            Double coord1 = ((GeospatialCoverage)eml.getGeospatialCoverages().get(index)).getBoundingCoordinates().getMin().getLongitude();
                            if (coord1 == null) {
                                ec.addFieldError("eml.geospatialCoverages[" + index + "].boundingCoordinates.min.longitude", i18n.getText("validation.required", new String[]{i18n.getText("eml.geospatialCoverages.boundingCoordinates.min.longitude")}));
                            } else if (Double.isNaN(coord1)) {
                                ec.addFieldError("eml.geospatialCoverages[" + index + "].boundingCoordinates.min.longitude", i18n.getText("validation.invalid", new String[]{i18n.getText("eml.geospatialCoverages.boundingCoordinates.min.longitude")}));
                            }
                            Double coord2 = ((GeospatialCoverage)eml.getGeospatialCoverages().get(index)).getBoundingCoordinates().getMax().getLongitude();
                            if (coord2 == null) {
                                ec.addFieldError("eml.geospatialCoverages[" + index + "].boundingCoordinates.max.longitude", i18n.getText("validation.required", new String[]{i18n.getText("eml.geospatialCoverages.boundingCoordinates.max.longitude")}));
                            } else if (Double.isNaN(coord2)) {
                                ec.addFieldError("eml.geospatialCoverages[" + index + "].boundingCoordinates.max.longitude", i18n.getText("validation.invalid", new String[]{i18n.getText("eml.geospatialCoverages.boundingCoordinates.max.longitude")}));
                            }
                            coord1 = ((GeospatialCoverage)eml.getGeospatialCoverages().get(index)).getBoundingCoordinates().getMax().getLatitude();
                            if (coord1 == null) {
                                ec.addFieldError("eml.geospatialCoverages[" + index + "].boundingCoordinates.max.latitude", i18n.getText("validation.required", new String[]{i18n.getText("eml.geospatialCoverages.boundingCoordinates.max.latitude")}));
                            } else if (Double.isNaN(coord1)) {
                                ec.addFieldError("eml.geospatialCoverages[" + index + "].boundingCoordinates.max.latitude", i18n.getText("validation.invalid", new String[]{i18n.getText("eml.geospatialCoverages.boundingCoordinates.max.latitude")}));
                            }
                            coord2 = ((GeospatialCoverage)eml.getGeospatialCoverages().get(index)).getBoundingCoordinates().getMin().getLatitude();
                            if (coord2 == null) {
                                ec.addFieldError("eml.geospatialCoverages[" + index + "].boundingCoordinates.min.latitude", i18n.getText("validation.required", new String[]{i18n.getText("eml.geospatialCoverages.boundingCoordinates.min.latitude")}));
                            } else if (Double.isNaN(coord2)) {
                                ec.addFieldError("eml.geospatialCoverages[" + index + "].boundingCoordinates.min.latitude", i18n.getText("validation.invalid", new String[]{i18n.getText("eml.geospatialCoverages.boundingCoordinates.min.latitude")}));
                            }
                            if (coord1 != null && coord2 != null && coord1 < coord2) {
                                ec.addFieldError("eml.geospatialCoverages[" + index + "].boundingCoordinates.min.latitude", i18n.getText("validation.coordinates.swapped.less", new String[]{i18n.getText("eml.geospatialCoverages.boundingCoordinates.min.longitude"), i18n.getText("eml.geospatialCoverages.boundingCoordinates.max.longitude")}));
                                ec.addFieldError("eml.geospatialCoverages[" + index + "].boundingCoordinates.max.latitude", i18n.getText("validation.coordinates.swapped.greater", new String[]{i18n.getText("eml.geospatialCoverages.boundingCoordinates.max.longitude"), i18n.getText("eml.geospatialCoverages.boundingCoordinates.min.longitude")}));
                            }
                            if (StringUtils.isBlank((CharSequence)((GeospatialCoverage)eml.getGeospatialCoverages().get(index)).getDescription())) {
                                ec.addFieldError("eml.geospatialCoverages[" + index + "].description", i18n.getText("validation.required", new String[]{i18n.getText("eml.geospatialCoverages.description")}));
                                continue;
                            }
                            if (this.exists(((GeospatialCoverage)eml.getGeospatialCoverages().get(index)).getDescription(), 2)) continue;
                            ec.addFieldError("eml.geospatialCoverages[" + index + "].description", i18n.getText("validation.short", new String[]{i18n.getText("eml.geospatialCoverages.description"), "2"}));
                        }
                        break;
                    }
                    eml.getGeospatialCoverages().clear();
                    break;
                }
                case 5: {
                    if (this.isTaxonomicPageEmpty(eml)) break;
                    int index = 0;
                    for (TaxonomicCoverage tc : eml.getTaxonomicCoverages()) {
                        int kw = 0;
                        if (tc != null) {
                            for (TaxonKeyword k : tc.getTaxonKeywords()) {
                                if (!this.exists(k.getScientificName())) {
                                    ec.addFieldError("eml.taxonomicCoverages[" + index + "].taxonKeywords[" + kw + "].scientificName", i18n.getText("validation.required", new String[]{i18n.getText("eml.taxonomicCoverages.taxonKeyword.scientificName")}));
                                }
                                ++kw;
                            }
                        }
                        ++index;
                    }
                    break;
                }
                case 6: {
                    if (this.isTemporalPageEmpty(eml)) break;
                    int index = 0;
                    for (TemporalCoverage tc : eml.getTemporalCoverages()) {
                        if (tc != null) {
                            if (tc.getType() == TemporalCoverageType.SINGLE_DATE && !this.exists(tc.getStartDate())) {
                                ec.addFieldError("eml.temporalCoverages[" + index + "].startDate", i18n.getText("validation.required", new String[]{i18n.getText("eml.temporalCoverages.startDate")}));
                            }
                            if (tc.getType() == TemporalCoverageType.DATE_RANGE) {
                                if (!this.exists(tc.getStartDate())) {
                                    ec.addFieldError("eml.temporalCoverages[" + index + "].startDate", i18n.getText("validation.required", new String[]{i18n.getText("eml.temporalCoverages.startDate")}));
                                }
                                if (!this.exists(tc.getEndDate())) {
                                    ec.addFieldError("eml.temporalCoverages[" + index + "].endDate", i18n.getText("validation.required", new String[]{i18n.getText("eml.temporalCoverages.endDate")}));
                                }
                            }
                            if (tc.getType() == TemporalCoverageType.FORMATION_PERIOD && !this.exists(tc.getFormationPeriod())) {
                                ec.addFieldError("eml.temporalCoverages[" + index + "].formationPeriod", i18n.getText("validation.required", new String[]{i18n.getText("eml.temporalCoverages.formationPeriod")}));
                            }
                            if (tc.getType() == TemporalCoverageType.LIVING_TIME_PERIOD && !this.exists(tc.getLivingTimePeriod())) {
                                ec.addFieldError("eml.temporalCoverages[" + index + "].livingTimePeriod", i18n.getText("validation.required", new String[]{i18n.getText("eml.temporalCoverages.livingTimePeriod")}));
                            }
                        }
                        ++index;
                    }
                    break;
                }
                case 7: {
                    String emlString;
                    Eml stubValidationEml;
                    if (this.emlProfileValidator == null) {
                        ec.addActionError(i18n.getText("validation.cannnot.be.performed"));
                        break;
                    }
                    try {
                        stubValidationEml = EmlValidator.getStubEml();
                        String purposeWithNbspReplaced = Optional.ofNullable(eml.getPurpose()).map(d -> d.replace("&nbsp;", " ")).orElse("");
                        stubValidationEml.setGettingStarted(purposeWithNbspReplaced);
                        emlString = IptEmlWriter.writeEmlAsString((Eml)stubValidationEml);
                        this.emlProfileValidator.validate(emlString);
                    }
                    catch (InvalidEmlException e) {
                        ec.addActionError(i18n.getText("validation.invalid.ext", new String[]{i18n.getText("eml.purpose"), EmlValidator.simplifyDocBookValidationErrorMessage((String)e.getMessage())}));
                    }
                    catch (Exception e) {
                        ec.addActionError(i18n.getText("validation.failed.see.logs", new String[]{i18n.getText("eml.purpose")}));
                        LOG.error("Failed to validate purpose", (Throwable)e);
                    }
                    try {
                        stubValidationEml = EmlValidator.getStubEml();
                        String gettingStartedWithNbspReplaced = Optional.ofNullable(eml.getGettingStarted()).map(d -> d.replace("&nbsp;", " ")).orElse("");
                        stubValidationEml.setGettingStarted(gettingStartedWithNbspReplaced);
                        emlString = IptEmlWriter.writeEmlAsString((Eml)stubValidationEml);
                        this.emlProfileValidator.validate(emlString);
                    }
                    catch (InvalidEmlException e) {
                        ec.addActionError(i18n.getText("validation.invalid.ext", new String[]{i18n.getText("manage.metadata.gettingStarted"), EmlValidator.simplifyDocBookValidationErrorMessage((String)e.getMessage())}));
                    }
                    catch (Exception e) {
                        ec.addActionError(i18n.getText("validation.failed.see.logs", new String[]{i18n.getText("manage.metadata.gettingStarted")}));
                        LOG.error("Failed to validate getting started", (Throwable)e);
                    }
                    try {
                        stubValidationEml = EmlValidator.getStubEml();
                        String introductionWithNbspReplaced = Optional.ofNullable(eml.getIntroduction()).map(d -> d.replace("&nbsp;", " ")).orElse("");
                        stubValidationEml.setIntroduction(introductionWithNbspReplaced);
                        emlString = IptEmlWriter.writeEmlAsString((Eml)stubValidationEml);
                        this.emlProfileValidator.validate(emlString);
                    }
                    catch (InvalidEmlException e) {
                        ec.addActionError(i18n.getText("validation.invalid.ext", new String[]{i18n.getText("manage.metadata.introduction"), EmlValidator.simplifyDocBookValidationErrorMessage((String)e.getMessage())}));
                    }
                    catch (Exception e) {
                        ec.addActionError(i18n.getText("validation.failed.see.logs", new String[]{i18n.getText("manage.metadata.introduction")}));
                        LOG.error("Failed to validate introduction", (Throwable)e);
                    }
                    break;
                }
                case 8: {
                    if (this.isKeywordsPageEmpty(eml)) break;
                    int index = 0;
                    for (KeywordSet ks : eml.getKeywords()) {
                        if (!this.exists(ks.getKeywordsString())) {
                            ec.addFieldError("eml.keywords[" + index + "].keywordsString", i18n.getText("validation.required", new String[]{i18n.getText("eml.keywords.keywordsString")}));
                        }
                        if (!this.exists(ks.getKeywordThesaurus())) {
                            ec.addFieldError("eml.keywords[" + index + "].keywordThesaurus", i18n.getText("validation.required", new String[]{i18n.getText("eml.keywords.keywordThesaurus")}));
                        }
                        ++index;
                    }
                    break;
                }
                case 9: {
                    int index;
                    if (this.isProjectPageEmpty(eml)) break;
                    if (!this.exists(eml.getProject().getTitle()) || eml.getProject().getTitle().trim().isEmpty()) {
                        ec.addFieldError("eml.project.title", i18n.getText("validation.required", new String[]{i18n.getText("eml.project.title")}));
                    }
                    for (index = 0; index < eml.getProject().getAwards().size(); ++index) {
                        ProjectAward pa = (ProjectAward)eml.getProject().getAwards().get(index);
                        if (!this.exists(pa.getTitle())) {
                            ec.addFieldError("eml.project.awards[" + index + "].title", i18n.getText("validation.required", new String[]{i18n.getText("eml.project.award.title")}));
                        }
                        if (this.exists(pa.getFunderName())) continue;
                        ec.addFieldError("eml.project.awards[" + index + "].funderName", i18n.getText("validation.required", new String[]{i18n.getText("eml.project.award.funderName")}));
                    }
                    for (index = 0; index < eml.getProject().getRelatedProjects().size(); ++index) {
                        Project rp = (Project)eml.getProject().getRelatedProjects().get(index);
                        if (!this.exists(rp.getTitle())) {
                            ec.addFieldError("eml.project.relatedProjects[" + index + "].title", i18n.getText("validation.required", new String[]{i18n.getText("eml.project.relatedProject.title")}));
                        }
                        if (this.isAgentsListEmpty(rp.getPersonnel())) {
                            ec.addActionError(i18n.getText("eml.project.relatedProject.personnel.required"));
                            continue;
                        }
                        for (int personnelIndex = 0; personnelIndex < ((Project)eml.getProject().getRelatedProjects().get(index)).getPersonnel().size(); ++personnelIndex) {
                            Agent p = (Agent)((Project)eml.getProject().getRelatedProjects().get(index)).getPersonnel().get(personnelIndex);
                            if (this.exists(p.getFirstName()) && !this.exists(p.getLastName())) {
                                ec.addFieldError("eml.project.relatedProjects[" + index + "].personnel[" + personnelIndex + "].lastName", i18n.getText("validation.firstname.lastname"));
                            } else if (!this.exists(p.getLastName())) {
                                ec.addFieldError("eml.project.relatedProjects[" + index + "].personnel[" + personnelIndex + "].lastName", i18n.getText("validation.required", new String[]{i18n.getText("eml.project.personnel.lastName")}));
                            }
                            if (p.getUserIds().isEmpty()) continue;
                            if (this.exists(((UserId)p.getUserIds().get(0)).getDirectory()) && !this.exists(((UserId)p.getUserIds().get(0)).getIdentifier())) {
                                ec.addFieldError("eml.project.relatedProjects[" + index + "].personnel[" + personnelIndex + "].userIds[0].identifier", i18n.getText("validation.personnel"));
                                continue;
                            }
                            if (this.exists(((UserId)p.getUserIds().get(0)).getDirectory()) || !this.exists(((UserId)p.getUserIds().get(0)).getIdentifier())) continue;
                            ec.addFieldError("eml.project.relatedProjects[" + index + "].personnel[" + personnelIndex + "].userIds[0].directory", i18n.getText("validation.directory"));
                        }
                    }
                    if (this.isAgentsListEmpty(eml.getProject().getPersonnel())) {
                        ec.addActionError(i18n.getText("eml.project.personnel.required"));
                        break;
                    }
                    for (index = 0; index < eml.getProject().getPersonnel().size(); ++index) {
                        Agent p = (Agent)eml.getProject().getPersonnel().get(index);
                        if (this.exists(p.getFirstName()) && !this.exists(p.getLastName())) {
                            ec.addFieldError("eml.project.personnel[" + index + "].lastName", i18n.getText("validation.firstname.lastname"));
                        } else if (!this.exists(p.getLastName())) {
                            ec.addFieldError("eml.project.personnel[" + index + "].lastName", i18n.getText("validation.required", new String[]{i18n.getText("eml.project.personnel.lastName")}));
                        }
                        if (p.getUserIds().isEmpty()) continue;
                        if (this.exists(((UserId)p.getUserIds().get(0)).getDirectory()) && !this.exists(((UserId)p.getUserIds().get(0)).getIdentifier())) {
                            ec.addFieldError("eml.project.personnel[" + index + "].userIds[0].identifier", i18n.getText("validation.personnel"));
                            continue;
                        }
                        if (this.exists(((UserId)p.getUserIds().get(0)).getDirectory()) || !this.exists(((UserId)p.getUserIds().get(0)).getIdentifier())) continue;
                        ec.addFieldError("eml.project.personnel[" + index + "].userIds[0].directory", i18n.getText("validation.directory"));
                    }
                    break;
                }
                case 10: {
                    if (this.isMethodsPageEmpty(eml)) break;
                    boolean emptyFields = false;
                    if (StringUtils.isBlank((CharSequence)eml.getSampleDescription()) && StringUtils.isBlank((CharSequence)eml.getStudyExtent()) && StringUtils.isBlank((CharSequence)eml.getQualityControl())) {
                        eml.setSampleDescription(null);
                        eml.setStudyExtent(null);
                        eml.setQualityControl(null);
                        emptyFields = true;
                    }
                    int index = 0;
                    for (String method : eml.getMethodSteps()) {
                        if (method.trim().isEmpty()) {
                            if (emptyFields && index == 0) {
                                eml.getMethodSteps().clear();
                                break;
                            }
                            ec.addFieldError("eml.methodSteps[" + index + "]", i18n.getText("validation.required", new String[]{i18n.getText("validation.field.required")}));
                        }
                        ++index;
                    }
                    if (emptyFields) break;
                    if (StringUtils.isNotBlank((CharSequence)eml.getSampleDescription()) && StringUtils.isBlank((CharSequence)eml.getStudyExtent())) {
                        ec.addFieldError("eml.studyExtent", i18n.getText("validation.required", new String[]{i18n.getText("eml.studyExtent")}));
                    }
                    if (!StringUtils.isNotBlank((CharSequence)eml.getStudyExtent()) || !StringUtils.isBlank((CharSequence)eml.getSampleDescription())) break;
                    ec.addFieldError("eml.sampleDescription", i18n.getText("validation.required", new String[]{i18n.getText("eml.sampleDescription")}));
                    break;
                }
                case 11: {
                    if (this.isCitationsPageEmpty(eml) && !resource.isCitationAutoGenerated()) break;
                    if (resource.isCitationAutoGenerated() && eml.getCitation() != null) {
                        URI homepage = this.cfg.getResourceVersionUri(resource.getShortname(), resource.getNextVersion());
                        String citation = resource.generateResourceCitation(resource.getNextVersion(), homepage);
                        eml.getCitation().setCitation(citation);
                    }
                    if (eml.getCitation() != null) {
                        if (StringUtils.isNotBlank((CharSequence)eml.getCitation().getIdentifier()) && !this.existsInRange(eml.getCitation().getIdentifier(), 2, 200)) {
                            ec.addFieldError("eml.citation.identifier", i18n.getText("validation.field.invalidSize", new String[]{i18n.getText("eml.citation.identifier"), "2", "200"}));
                        }
                        if (this.exists(eml.getCitation().getIdentifier()) && !this.exists(eml.getCitation().getCitation())) {
                            ec.addFieldError("eml.citation.citation", i18n.getText("validation.required", new String[]{i18n.getText("eml.citation.citation")}));
                        }
                    }
                    int index = 0;
                    for (Citation citation : eml.getBibliographicCitations()) {
                        if (StringUtils.isNotBlank((CharSequence)citation.getIdentifier()) && !this.exists(citation.getIdentifier())) {
                            ec.addFieldError("eml.bibliographicCitationSet.bibliographicCitations[" + index + "].identifier", i18n.getText("validation.field.blank", new String[]{i18n.getText("eml.bibliographicCitationSet.bibliographicCitations.identifier")}));
                        }
                        if (!this.exists(citation.getCitation())) {
                            ec.addFieldError("eml.bibliographicCitationSet.bibliographicCitations[" + index + "].citation", i18n.getText("validation.required", new String[]{i18n.getText("validation.field.required")}));
                        }
                        ++index;
                    }
                    break;
                }
                case 12: {
                    int index;
                    if (this.isCollectionsPageEmpty(eml)) break;
                    if (eml.getCollections().isEmpty()) {
                        ec.addActionError(i18n.getText("eml.collection.required"));
                    }
                    for (index = 0; index < eml.getCollections().size(); ++index) {
                        org.gbif.metadata.eml.ipt.model.Collection c = (org.gbif.metadata.eml.ipt.model.Collection)eml.getCollections().get(index);
                        if (this.exists(c.getCollectionName())) continue;
                        ec.addFieldError("eml.collections[" + index + "].collectionName", i18n.getText("validation.required", new String[]{i18n.getText("eml.collectionName")}));
                    }
                    for (index = 0; index < eml.getSpecimenPreservationMethods().size(); ++index) {
                        String preservationMethod = (String)eml.getSpecimenPreservationMethods().get(index);
                        if (!StringUtils.isBlank((CharSequence)preservationMethod)) continue;
                        ec.addFieldError("eml.specimenPreservationMethods[" + index + "]", i18n.getText("validation.required", new String[]{i18n.getText("eml.specimenPreservationMethod")}));
                    }
                    index = 0;
                    for (JGTICuratorialUnit jcu : eml.getJgtiCuratorialUnits()) {
                        if (jcu.getType() == JGTICuratorialUnitType.COUNT_RANGE) {
                            if (!this.exists(jcu.getRangeStart())) {
                                ec.addFieldError("eml.jgtiCuratorialUnits[" + index + "].rangeStart", i18n.getText("validation.required", new String[]{i18n.getText("validation.field.required")}));
                            }
                            if (!this.exists(jcu.getRangeEnd())) {
                                ec.addFieldError("eml.jgtiCuratorialUnits[" + index + "].rangeEnd", i18n.getText("validation.required", new String[]{i18n.getText("validation.field.required")}));
                            }
                        }
                        if (jcu.getType() == JGTICuratorialUnitType.COUNT_WITH_UNCERTAINTY) {
                            if (!this.exists(jcu.getRangeMean())) {
                                ec.addFieldError("eml.jgtiCuratorialUnits[" + index + "].rangeMean", i18n.getText("validation.required", new String[]{i18n.getText("validation.field.required")}));
                            }
                            if (!this.exists(jcu.getUncertaintyMeasure())) {
                                ec.addFieldError("eml.jgtiCuratorialUnits[" + index + "].uncertaintyMeasure", i18n.getText("validation.required", new String[]{i18n.getText("validation.field.required")}));
                            }
                        }
                        if (!this.exists(jcu.getUnitType())) {
                            ec.addFieldError("eml.jgtiCuratorialUnits[" + index + "].unitType", i18n.getText("validation.required", new String[]{i18n.getText("eml.jgtiCuratorialUnits.unitType")}));
                        }
                        ++index;
                    }
                    break;
                }
                case 13: {
                    if (this.isPhysicalPageEmpty(eml)) break;
                    if (StringUtils.isNotBlank((CharSequence)eml.getDistributionUrl())) {
                        String formattedUrl = EmlValidator.formatURL((String)eml.getDistributionUrl());
                        if (!EmlValidator.isWellFormedURI((String)formattedUrl)) {
                            ec.addFieldError("eml.distributionUrl", i18n.getText("validation.invalid", new String[]{i18n.getText("eml.distributionUrl")}));
                        } else {
                            eml.setDistributionUrl(formattedUrl);
                        }
                    }
                    int index = 0;
                    for (PhysicalData pd : eml.getPhysicalData()) {
                        String formattedDistributionUrl;
                        if (!this.exists(pd.getName())) {
                            ec.addFieldError("eml.physicalData[" + index + "].name", i18n.getText("validation.required", new String[]{i18n.getText("eml.physicalData.name")}));
                        }
                        if (!this.exists(pd.getCharset())) {
                            ec.addFieldError("eml.physicalData[" + index + "].charset", i18n.getText("validation.required", new String[]{i18n.getText("eml.physicalData.charset")}));
                        }
                        if (!this.exists(pd.getDistributionUrl())) {
                            ec.addFieldError("eml.physicalData[" + index + "].distributionUrl", i18n.getText("validation.required", new String[]{i18n.getText("eml.physicalData.distributionUrl")}));
                        }
                        if (!this.exists(pd.getFormat())) {
                            ec.addFieldError("eml.physicalData[" + index + "].format", i18n.getText("validation.required", new String[]{i18n.getText("eml.physicalData.format")}));
                        }
                        if (!EmlValidator.isWellFormedURI((String)(formattedDistributionUrl = EmlValidator.formatURL((String)pd.getDistributionUrl())))) {
                            ec.addFieldError("eml.physicalData[" + index + "].distributionUrl", i18n.getText("validation.invalid", new String[]{i18n.getText("eml.physicalData.distributionUrl")}));
                        } else {
                            pd.setDistributionUrl(formattedDistributionUrl);
                        }
                        ++index;
                    }
                    break;
                }
                case 14: {
                    if (this.isAdditionalPageEmpty(eml)) break;
                    int index = 0;
                    for (String ai : eml.getAlternateIdentifiers()) {
                        if (!this.exists(ai)) {
                            ec.addFieldError("eml.alternateIdentifiers[" + index + "]", i18n.getText("validation.required", new String[]{i18n.getText("eml.alternateIdentifier")}));
                        }
                        ++index;
                    }
                    break;
                }
            }
        }
    }

    private boolean isProjectPageEmpty(Eml eml) {
        if (eml.getProject() != null) {
            Project project = eml.getProject();
            List personnelList = project.getPersonnel();
            StudyAreaDescription area = project.getStudyAreaDescription();
            String title = project.getTitle();
            String funding = project.getFunding();
            String design = project.getDesignDescription();
            String desc = area.getDescriptorValue();
            return StringUtils.isBlank((CharSequence)title) && StringUtils.isBlank((CharSequence)funding) && StringUtils.isBlank((CharSequence)design) && StringUtils.isBlank((CharSequence)desc) && this.isAgentsListEmpty(personnelList);
        }
        return false;
    }

    private boolean isMethodsPageEmpty(Eml eml) {
        String studyExtent = eml.getStudyExtent();
        String sample = eml.getSampleDescription();
        String quality = eml.getQualityControl();
        List methods = eml.getMethodSteps();
        for (String method : methods) {
            if (!StringUtils.isNotBlank((CharSequence)method)) continue;
            return false;
        }
        return StringUtils.isBlank((CharSequence)studyExtent) && StringUtils.isBlank((CharSequence)sample) && StringUtils.isBlank((CharSequence)quality);
    }

    private boolean isCitationsPageEmpty(Eml eml) {
        boolean citationIsEmpty = this.isCitationEmpty(eml.getCitation());
        if (!citationIsEmpty) {
            return false;
        }
        for (Citation bibCitation : eml.getBibliographicCitations()) {
            boolean isBibCitationEmpty = this.isCitationEmpty(bibCitation);
            if (isBibCitationEmpty) continue;
            return false;
        }
        return true;
    }

    private boolean isCitationEmpty(Citation citation) {
        if (citation != null) {
            String citationId = citation.getIdentifier();
            String citationText = citation.getCitation();
            return StringUtils.isBlank((CharSequence)citationId) && StringUtils.isBlank((CharSequence)citationText);
        }
        return true;
    }

    private boolean isCollectionsPageEmpty(Eml eml) {
        for (String preservationMethod : eml.getSpecimenPreservationMethods()) {
            if (!StringUtils.isNotBlank((CharSequence)preservationMethod)) continue;
            return false;
        }
        for (org.gbif.metadata.eml.ipt.model.Collection collection : eml.getCollections()) {
            boolean isCollectionEmpty = this.isCollectionEmpty(collection);
            if (isCollectionEmpty) continue;
            return false;
        }
        for (JGTICuratorialUnit unit : eml.getJgtiCuratorialUnits()) {
            boolean isUnitEmpty = this.isJGTICuratorialUnitEmpty(unit);
            if (isUnitEmpty) continue;
            return false;
        }
        return true;
    }

    private boolean isJGTICuratorialUnitEmpty(JGTICuratorialUnit unit) {
        if (unit != null) {
            String unitType = unit.getUnitType();
            int rangeEnd = unit.getRangeEnd() == null ? 0 : unit.getRangeEnd();
            int rangeStart = unit.getRangeStart() == null ? 0 : unit.getRangeStart();
            int uncertainty = unit.getUncertaintyMeasure() == null ? 0 : unit.getUncertaintyMeasure();
            int mean = unit.getRangeMean() == null ? 0 : unit.getRangeMean();
            return unitType == null && rangeEnd == 0 && rangeStart == 0 && uncertainty == 0 && mean == 0;
        }
        return true;
    }

    private boolean isCollectionEmpty(org.gbif.metadata.eml.ipt.model.Collection collection) {
        if (collection != null) {
            String collectionName = collection.getCollectionName();
            String collectionId = collection.getCollectionId();
            String parentCollectionId = collection.getParentCollectionId();
            return StringUtils.isBlank((CharSequence)collectionName) && StringUtils.isBlank((CharSequence)collectionId) && StringUtils.isBlank((CharSequence)parentCollectionId);
        }
        return true;
    }

    private boolean isPhysicalPageEmpty(Eml eml) {
        String homepageUrl = eml.getDistributionUrl();
        for (PhysicalData data : eml.getPhysicalData()) {
            boolean isLinkEmpty = this.isExternalLinkEmpty(data);
            if (isLinkEmpty) continue;
            return false;
        }
        return StringUtils.isBlank((CharSequence)homepageUrl);
    }

    private boolean isExternalLinkEmpty(PhysicalData data) {
        if (data != null) {
            String charset = data.getCharset();
            String format = data.getFormat();
            String formatVersion = data.getFormatVersion();
            String distributionUrl = data.getDistributionUrl();
            String name = data.getName();
            return StringUtils.isBlank((CharSequence)charset) && StringUtils.isBlank((CharSequence)format) && StringUtils.isBlank((CharSequence)formatVersion) && StringUtils.isBlank((CharSequence)distributionUrl) && StringUtils.isBlank((CharSequence)name);
        }
        return true;
    }

    private boolean isKeywordsPageEmpty(Eml eml) {
        if (!eml.getKeywords().isEmpty()) {
            KeywordSet set1 = (KeywordSet)eml.getKeywords().get(0);
            return StringUtils.isBlank((CharSequence)set1.getKeywordsString()) && StringUtils.isBlank((CharSequence)set1.getKeywordThesaurus());
        }
        return true;
    }

    private boolean isAdditionalPageEmpty(Eml eml) {
        String logo = eml.getLogoUrl();
        String rights = eml.getRights();
        String info = eml.getAdditionalInfo();
        String purpose = eml.getPurpose();
        for (String id : eml.getAlternateIdentifiers()) {
            if (!StringUtils.isNotBlank((CharSequence)id)) continue;
            return false;
        }
        return StringUtils.isBlank((CharSequence)logo) && StringUtils.isBlank((CharSequence)rights) && StringUtils.isBlank((CharSequence)info) && StringUtils.isBlank((CharSequence)purpose);
    }

    private boolean isTemporalPageEmpty(Eml eml) {
        List coverages = eml.getTemporalCoverages();
        for (TemporalCoverage coverage : coverages) {
            boolean isEmtpy = this.isTemporalCoverageEmpty(coverage);
            if (isEmtpy) continue;
            return false;
        }
        return true;
    }

    private boolean isTemporalCoverageEmpty(TemporalCoverage cov) {
        if (cov != null) {
            String formationPeriod = cov.getFormationPeriod();
            Date end = cov.getEndDate();
            String period = cov.getLivingTimePeriod();
            Date start = cov.getStartDate();
            return StringUtils.isBlank((CharSequence)formationPeriod) && end == null && StringUtils.isBlank((CharSequence)period) && start == null;
        }
        return true;
    }

    private boolean isTaxonomicPageEmpty(Eml eml) {
        for (TaxonomicCoverage cov : eml.getTaxonomicCoverages()) {
            boolean isTaxonomicCoverageEmpty = cov == null;
            if (isTaxonomicCoverageEmpty) continue;
            return false;
        }
        return true;
    }

    private boolean isGeoPageEmpty(Eml eml) {
        if (!eml.getGeospatialCoverages().isEmpty()) {
            GeospatialCoverage cov1 = (GeospatialCoverage)eml.getGeospatialCoverages().get(0);
            String description = cov1.getDescription();
            BBox bbox = cov1.getBoundingCoordinates();
            Point p1 = bbox.getMin();
            Point p2 = bbox.getMax();
            if (p1 != null && p2 != null) {
                Double lat1 = p1.getLatitude();
                Double lon1 = p1.getLongitude();
                Double lat2 = p2.getLatitude();
                Double lon2 = p2.getLongitude();
                return lat1 == null && lon1 == null && lat2 == null && lon2 == null && StringUtils.isBlank((CharSequence)description);
            }
            return StringUtils.isBlank((CharSequence)description);
        }
        return true;
    }

    private boolean isAgentEmpty(Agent agent) {
        if (agent != null) {
            String first = agent.getFirstName();
            String last = agent.getLastName();
            List email = agent.getEmail();
            List home = agent.getHomepage();
            String org = agent.getOrganisation();
            List phone = agent.getPhone();
            List position = agent.getPosition();
            String city = null;
            List street = null;
            String country = null;
            String code = null;
            String province = null;
            Address address = agent.getAddress();
            if (address != null) {
                city = address.getCity();
                street = address.getAddress();
                country = address.getCountry();
                code = address.getPostalCode();
                province = address.getProvince();
            }
            ArrayList<String> directories = new ArrayList<String>();
            ArrayList<String> identifiers = new ArrayList<String>();
            List userIds = agent.getUserIds();
            if (!userIds.isEmpty()) {
                for (UserId userId : userIds) {
                    directories.add(userId.getDirectory());
                    identifiers.add(userId.getIdentifier());
                }
            }
            return StringUtils.isBlank((CharSequence)city) && CollectionUtils.isEmpty((Collection)street) && StringUtils.isBlank((CharSequence)country) && StringUtils.isBlank((CharSequence)code) && StringUtils.isBlank((CharSequence)province) && StringUtils.isBlank((CharSequence)first) && StringUtils.isBlank((CharSequence)last) && CollectionUtils.isEmpty((Collection)email) && CollectionUtils.isEmpty((Collection)home) && StringUtils.isBlank((CharSequence)org) && CollectionUtils.isEmpty((Collection)phone) && CollectionUtils.isEmpty((Collection)position) && CollectionUtils.isEmpty(directories) && CollectionUtils.isEmpty(identifiers);
        }
        return true;
    }

    private boolean isAgentsListEmpty(List<Agent> agents) {
        for (Agent agent : agents) {
            boolean isEmpty = this.isAgentEmpty(agent);
            if (isEmpty) continue;
            return false;
        }
        return true;
    }

    private static Eml getStubEml() {
        Eml eml = new Eml();
        eml.setTitle("title");
        eml.setLanguage("EN");
        eml.setMetadataLanguage("EN");
        eml.setIntellectualRights("This work is licensed under a <a href=\"http://creativecommons.org/licenses/by-nc/4.0/legalcode\">Creative Commons Attribution Non Commercial (CC-BY-NC 4.0) License</a>.");
        eml.setDescription("description");
        eml.setUpdateFrequency("unknown");
        Agent contact = new Agent();
        contact.setLastName("Contact 1");
        eml.addContact(contact);
        eml.addCreator(contact);
        return eml;
    }

    public static String simplifyDocBookValidationErrorMessage(String technicalMessage) {
        String simplifiedMessage = technicalMessage.replaceFirst("^[^;]*;\\s*lineNumber:\\s*\\d+;\\s*columnNumber:\\s*\\d+;\\s*(?:[^:]*:\\s*)?", "");
        for (Map.Entry entry : TAG_REPLACEMENTS.entrySet()) {
            String originalTag = "'" + (String)entry.getKey() + "'";
            String replacementTag = "'" + (String)entry.getValue() + "'";
            simplifiedMessage = simplifiedMessage.replace(originalTag, replacementTag);
            simplifiedMessage = simplifiedMessage.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
        }
        return simplifiedMessage.trim();
    }

    static {
        TAG_REPLACEMENTS.put("title", "h");
        TAG_REPLACEMENTS.put("section", "div");
        TAG_REPLACEMENTS.put("para", "p");
        TAG_REPLACEMENTS.put("value", "value");
        TAG_REPLACEMENTS.put("itemizedlist", "ul");
        TAG_REPLACEMENTS.put("orderedlist", "ol");
        TAG_REPLACEMENTS.put("emphasis", "b");
        TAG_REPLACEMENTS.put("subscript", "sub");
        TAG_REPLACEMENTS.put("superscript", "sup");
        TAG_REPLACEMENTS.put("literalLayout", "pre");
        TAG_REPLACEMENTS.put("ulink", "a");
    }
}

