/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.validation;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.apache.commons.lang3.RegExUtils;
import org.apache.commons.lang3.StringUtils;
import org.gbif.ipt.action.BaseAction;
import org.gbif.ipt.model.Resource;
import org.gbif.ipt.model.datapackage.metadata.DataPackageMetadata;
import org.gbif.ipt.model.datapackage.metadata.FrictionlessMetadata;
import org.gbif.ipt.model.datapackage.metadata.camtrap.CamtrapMetadata;
import org.gbif.ipt.model.datapackage.metadata.camtrap.Taxonomic;
import org.gbif.ipt.model.datapackage.metadata.col.ColMetadata;
import org.gbif.ipt.model.voc.CamtrapMetadataSection;
import org.gbif.ipt.model.voc.DataPackageMetadataSection;
import org.gbif.ipt.model.voc.FrictionlessMetadataSection;
import org.gbif.ipt.service.InvalidMetadataException;
import org.gbif.ipt.validation.BasicMetadata;
import org.gbif.ipt.validation.DataPackageMetadataValidator;
import org.gbif.ipt.validation.GeographicScopeMetadata;
import org.gbif.ipt.validation.KeywordsMetadata;
import org.gbif.ipt.validation.OtherMetadata;
import org.gbif.ipt.validation.ProjectMetadata;
import org.gbif.ipt.validation.TaxonomicScopeMetadata;
import org.gbif.ipt.validation.TemporalScopeMetadata;
import org.hibernate.validator.HibernateValidator;
import org.hibernate.validator.HibernateValidatorConfiguration;

public class DataPackageMetadataValidator {
    private final Validator validator;
    private static final Pattern VERNACULAR_NAME_KEY_PATTERN = Pattern.compile("^[a-z]{3}$");

    public DataPackageMetadataValidator() {
        try (ValidatorFactory validatorFactory = ((HibernateValidatorConfiguration)Validation.byProvider(HibernateValidator.class).configure()).buildValidatorFactory();){
            this.validator = validatorFactory.getValidator();
        }
    }

    public boolean isValid(Resource resource) {
        Set violations = this.validator.validate((Object)resource.getDataPackageMetadata(), new Class[]{BasicMetadata.class, GeographicScopeMetadata.class, TaxonomicScopeMetadata.class, TemporalScopeMetadata.class, KeywordsMetadata.class, ProjectMetadata.class, OtherMetadata.class});
        return violations.isEmpty();
    }

    public void validate(BaseAction action, DataPackageMetadata metadata) throws InvalidMetadataException {
        boolean problemsEncountered = false;
        if (metadata instanceof CamtrapMetadata) {
            for (CamtrapMetadataSection section : CamtrapMetadataSection.values()) {
                this.validateCamtrap(action, (CamtrapMetadata)metadata, section);
                if (!action.hasActionErrors() && !action.hasFieldErrors() || problemsEncountered) continue;
                problemsEncountered = true;
            }
        } else {
            this.validateFrictionless(action, metadata, null);
            if ((action.hasActionErrors() || action.hasFieldErrors()) && !problemsEncountered) {
                problemsEncountered = true;
            }
        }
        if (problemsEncountered) {
            throw new InvalidMetadataException("Validation failed");
        }
    }

    public boolean isSectionValid(BaseAction action, Resource resource, DataPackageMetadataSection section) {
        boolean problemsEncountered = false;
        this.validate(action, resource, section);
        if (action.hasActionErrors() || action.hasFieldErrors()) {
            action.addActionError(action.getText("manage.failed", new String[]{action.getText("submenu.datapackagemetadata.camtrap." + section.getName())}));
            problemsEncountered = true;
        }
        return !problemsEncountered;
    }

    public void validate(BaseAction action, Resource resource, @Nullable DataPackageMetadataSection section) {
        if (resource != null) {
            FrictionlessMetadata metadata;
            Object object = metadata = resource.getDataPackageMetadata() == null ? new FrictionlessMetadata() : resource.getDataPackageMetadata();
            if ("camtrap-dp".equals(resource.getCoreType())) {
                this.validateCamtrap(action, (CamtrapMetadata)metadata, (CamtrapMetadataSection)section);
            } else {
                this.validateFrictionless(action, (DataPackageMetadata)metadata, (FrictionlessMetadataSection)section);
            }
        }
    }

    public void validateCamtrap(BaseAction action, CamtrapMetadata metadata, @Nullable CamtrapMetadataSection section) {
        if (section == null) {
            section = CamtrapMetadataSection.BASIC_SECTION;
        }
        switch (1.$SwitchMap$org$gbif$ipt$model$voc$CamtrapMetadataSection[section.ordinal()]) {
            case 1: {
                Set basicSectionViolations = this.validator.validate((Object)metadata, new Class[]{BasicMetadata.class});
                for (ConstraintViolation violation : basicSectionViolations) {
                    if (StringUtils.equalsAny((CharSequence)violation.getPropertyPath().toString(), (CharSequence[])new CharSequence[]{"licenses", "licenses.name", "contributors", "sources"})) {
                        action.addActionError(action.getText(violation.getMessage()));
                        continue;
                    }
                    if (violation.getMessage().equals("validation.datapackage.metadata.license.name.required")) {
                        String index = RegExUtils.removeAll((String)violation.getPropertyPath().toString(), (String)"[a-zA-z.\\[\\]]*");
                        action.addFieldError("metadata.licenses[" + index + "].name", action.getText(action.getText(violation.getMessage())));
                        continue;
                    }
                    this.addDefaultFieldError(action, violation);
                }
                break;
            }
            case 2: {
                Set geographicSectionViolations = this.validator.validate((Object)metadata, new Class[]{GeographicScopeMetadata.class});
                for (ConstraintViolation violation : geographicSectionViolations) {
                    action.addActionError(action.getText(violation.getMessage()));
                }
                break;
            }
            case 3: {
                Set taxonomicSectionViolations = this.validator.validate((Object)metadata, new Class[]{TaxonomicScopeMetadata.class});
                for (ConstraintViolation violation : taxonomicSectionViolations) {
                    this.addDefaultFieldError(action, violation);
                }
                this.validateVernacularNames(action, (DataPackageMetadata)metadata);
                break;
            }
            case 4: {
                Set temporalSectionViolations = this.validator.validate((Object)metadata, new Class[]{TemporalScopeMetadata.class});
                for (ConstraintViolation violation : temporalSectionViolations) {
                    this.addDefaultFieldError(action, violation);
                }
                break;
            }
            case 5: {
                Set keywordsSectionViolations = this.validator.validate((Object)metadata, new Class[]{KeywordsMetadata.class});
                for (ConstraintViolation violation : keywordsSectionViolations) {
                    action.addActionError(action.getText(violation.getMessage()));
                }
                break;
            }
            case 6: {
                Set projectSectionViolations = this.validator.validate((Object)metadata, new Class[]{ProjectMetadata.class});
                for (ConstraintViolation violation : projectSectionViolations) {
                    this.addDefaultFieldError(action, violation);
                }
                break;
            }
            case 7: {
                Set otherMetadataSectionViolations = this.validator.validate((Object)metadata, new Class[]{OtherMetadata.class});
                for (ConstraintViolation violation : otherMetadataSectionViolations) {
                    this.addDefaultFieldError(action, violation);
                }
                break;
            }
        }
    }

    public void validateFrictionless(BaseAction action, DataPackageMetadata metadata, @Nullable FrictionlessMetadataSection section) {
        if (section == null) {
            section = FrictionlessMetadataSection.BASIC_SECTION;
        }
        if (section == FrictionlessMetadataSection.BASIC_SECTION) {
            Set basicSectionViolations = this.validator.validate((Object)metadata, new Class[]{BasicMetadata.class});
            for (ConstraintViolation violation : basicSectionViolations) {
                if (StringUtils.equalsAny((CharSequence)violation.getPropertyPath().toString(), (CharSequence[])new CharSequence[]{"licenses", "licenses.name", "contributors", "sources"})) {
                    action.addActionError(action.getText(violation.getMessage()));
                    continue;
                }
                if (violation.getMessage().equals("validation.datapackage.metadata.license.name.required")) {
                    String index = RegExUtils.removeAll((String)violation.getPropertyPath().toString(), (String)"[a-zA-z.\\[\\]]*");
                    action.addFieldError("metadata.licenses[" + index + "].name", action.getText(action.getText(violation.getMessage())));
                    continue;
                }
                this.addDefaultFieldError(action, violation);
            }
        }
    }

    public void validateColMetadata(BaseAction action, ColMetadata metadata) {
        Set violations = this.validator.validate((Object)metadata, new Class[0]);
        String violationsSquashed = violations.stream().map(ConstraintViolation::getMessage).collect(Collectors.joining("\n", "-", ""));
        action.addActionError("Validation failed:\n" + violationsSquashed);
    }

    private boolean isValidationProperty(String message) {
        return message.startsWith("validation.");
    }

    private void addDefaultFieldError(BaseAction action, ConstraintViolation<DataPackageMetadata> violation) {
        if (this.isValidationProperty(violation.getMessage())) {
            action.addFieldError("metadata." + String.valueOf(violation.getPropertyPath()), action.getText(violation.getMessage(), new String[]{violation.getPropertyPath().toString()}));
        } else {
            action.addFieldError("metadata." + String.valueOf(violation.getPropertyPath()), violation.getMessage());
        }
    }

    private void validateVernacularNames(BaseAction action, DataPackageMetadata metadata) {
        if (metadata instanceof CamtrapMetadata) {
            CamtrapMetadata camtrapMetadata = (CamtrapMetadata)metadata;
            List taxonomics = camtrapMetadata.getTaxonomic();
            for (int taxonomicIndex = 0; taxonomicIndex < taxonomics.size(); ++taxonomicIndex) {
                Taxonomic taxonomic = (Taxonomic)taxonomics.get(taxonomicIndex);
                Map vernacularNames = taxonomic.getVernacularNames();
                Set vernacularNamesKeys = vernacularNames.keySet();
                ArrayList listKeys = new ArrayList(vernacularNamesKeys);
                for (int vernacularNameIndex = 0; vernacularNameIndex < listKeys.size(); ++vernacularNameIndex) {
                    if (VERNACULAR_NAME_KEY_PATTERN.matcher((CharSequence)listKeys.get(vernacularNameIndex)).matches()) continue;
                    action.addFieldError("vernacularNames-key-" + taxonomicIndex + "-" + vernacularNameIndex, action.getText("validation.camtrap.metadata.taxonomic.vernacularNames"));
                }
            }
        }
    }
}

