/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.validation;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.gbif.ipt.model.DataPackageField;
import org.gbif.ipt.model.DataPackageMapping;
import org.gbif.ipt.model.DataPackageSchema;
import org.gbif.ipt.model.DataPackageTableSchema;
import org.gbif.ipt.model.Resource;
import org.gbif.ipt.validation.DataPackageMappingValidator;

public class DataPackageMappingValidator {
    public ValidationStatus validate(DataPackageMapping mapping, Resource resource, List<String> columns) {
        ValidationStatus v = new ValidationStatus();
        DataPackageSchema dataPackageSchema = mapping.getDataPackageSchema();
        String resourceName = mapping.getDataPackageTableSchemaName().getName();
        if (dataPackageSchema != null) {
            for (DataPackageTableSchema tableSchema : dataPackageSchema.getTableSchemas()) {
                if (!resourceName.equals(tableSchema.getName())) continue;
                for (DataPackageField field : tableSchema.getFields()) {
                    String fieldName = field.getName();
                    if (!this.isRequiredSchemaField(field) || mapping.getField(fieldName) != null && (mapping.getField(fieldName).getIndex() != null || !StringUtils.isEmpty((CharSequence)mapping.getField(fieldName).getDefaultValue()))) continue;
                    v.addMissingRequiredField(field);
                }
            }
        }
        return v;
    }

    private boolean isRequiredSchemaField(DataPackageField field) {
        return field.getConstraints() != null && field.getConstraints().getRequired() != null && field.getConstraints().getRequired() != false;
    }
}

