/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.utils;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.validator.routines.UrlValidator;
import org.apache.http.HttpHost;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public class URLUtils {
    private static final Logger LOG = LogManager.getLogger(URLUtils.class);
    private static final UrlValidator URL_VALIDATOR = new UrlValidator(new String[]{"http", "https"}, 8L);
    private static final String LOCAL_IP = "127.0.0.1";
    private static final String LOCAL_HOST = "localhost";
    public static final Set<String> VALID_CONTENT_TYPES = new HashSet();

    private URLUtils() {
    }

    public static boolean isLocalhost(URL url) {
        return "localhost".equalsIgnoreCase(url.getHost()) || "127.0.0.1".equalsIgnoreCase(url.getHost());
    }

    public static boolean isHostName(URL url) {
        return url.getHost().equalsIgnoreCase(URLUtils.getHostName());
    }

    public static String getHostName() {
        String hostName = "";
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            LOG.info("No IP address for the local hostname could be found", (Throwable)e);
        }
        return hostName;
    }

    public static boolean hasPort(String url) {
        return StringUtils.isNotBlank((CharSequence)url) && url.split(":").length > 2;
    }

    public static boolean isURLValid(String url) {
        return URL_VALIDATOR.isValid(url);
    }

    public static HttpHost getHost(String httpUrl) throws MalformedURLException {
        URL url = new URL(httpUrl);
        HttpHost host = URLUtils.hasPort((String)httpUrl) ? new HttpHost(url.getHost(), url.getPort()) : new HttpHost(url.getHost());
        return host;
    }

    public static String getUrlContentType(String urlString) throws IOException, MimeTypeParseException {
        URL url = new URL(urlString);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("HEAD");
        String contentType = connection.getContentType();
        LOG.debug("Raw content type: {}", (Object)contentType);
        if (contentType != null) {
            MimeType mimeType = new MimeType(contentType);
            return mimeType.getBaseType();
        }
        return null;
    }

    public static String encode(String rawUrl) {
        try {
            String decodedURL = URLDecoder.decode(rawUrl, StandardCharsets.UTF_8);
            URL url = new URL(decodedURL);
            URI uri = new URI(url.getProtocol(), url.getUserInfo(), url.getHost(), url.getPort(), url.getPath(), url.getQuery(), url.getRef());
            return uri.toURL().toString();
        }
        catch (Exception ex) {
            LOG.error("URL encoding error", (Throwable)ex);
            throw new IllegalArgumentException(ex);
        }
    }

    public static Optional<String> getRedirectedUrl(String url) {
        try {
            HttpURLConnection con = (HttpURLConnection)new URL(url).openConnection();
            con.setRequestMethod("HEAD");
            String redirect = con.getHeaderField("Location");
            if (redirect != null && !redirect.isEmpty()) {
                return Optional.of(redirect);
            }
            return Optional.empty();
        }
        catch (Exception ex) {
            LOG.error("URL redirection error", (Throwable)ex);
            throw new IllegalArgumentException(ex);
        }
    }

    static {
        VALID_CONTENT_TYPES.add("text/csv");
        VALID_CONTENT_TYPES.add("text/tab-separated-values");
        VALID_CONTENT_TYPES.add("application/csv");
        VALID_CONTENT_TYPES.add("application/vnd.ms-excel");
        VALID_CONTENT_TYPES.add("application/zip");
        VALID_CONTENT_TYPES.add("text/plain");
    }
}

