/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.utils;

import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.gbif.ipt.utils.Base64Coder;
import org.gbif.ipt.utils.PBEEncrypt;

public class PBEEncrypt {
    private static final String ALGORITHM = "PBEWithSHA1AndDESede";
    private final String characterEncoding = "UTF-8";
    private Cipher encryptCipher;
    private Cipher decryptCipher;

    public PBEEncrypt(String passphrase, byte[] salt, int iterationCount) throws EncryptionException {
        assert (passphrase != null);
        assert (passphrase.length() >= 6);
        assert (salt != null);
        assert (salt.length == 8);
        assert (iterationCount > 6 && iterationCount < 20);
        try {
            PBEParameterSpec params = new PBEParameterSpec(salt, iterationCount);
            PBEKeySpec keySpec = new PBEKeySpec(passphrase.toCharArray());
            SecretKey key = SecretKeyFactory.getInstance(ALGORITHM, "SunJCE").generateSecret(keySpec);
            this.encryptCipher = Cipher.getInstance(ALGORITHM, "SunJCE");
            this.encryptCipher.init(1, (Key)key, params);
            this.decryptCipher = Cipher.getInstance(ALGORITHM, "SunJCE");
            this.decryptCipher.init(2, (Key)key, params);
        }
        catch (Exception e) {
            throw new EncryptionException("Problem constructing " + this.getClass().getName(), e);
        }
    }

    public synchronized String decrypt(String encodedEncryptedDataString) throws EncryptionException {
        assert (encodedEncryptedDataString != null);
        try {
            byte[] encryptedDataStringBytes = Base64Coder.decode((String)encodedEncryptedDataString);
            byte[] dataStringBytes = this.decryptCipher.doFinal(encryptedDataStringBytes);
            return new String(dataStringBytes, "UTF-8");
        }
        catch (Exception e) {
            throw new EncryptionException("Problem decrypting string", e);
        }
    }

    public synchronized String encrypt(String dataString) throws EncryptionException {
        assert (dataString != null);
        try {
            byte[] dataStringBytes = dataString.getBytes("UTF-8");
            byte[] encryptedDataStringBytes = this.encryptCipher.doFinal(dataStringBytes);
            return String.valueOf(Base64Coder.encode((byte[])encryptedDataStringBytes));
        }
        catch (Exception e) {
            throw new EncryptionException("Problem encrypting string", e);
        }
    }
}

