/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.utils;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.gbif.ipt.utils.StringUtils;

public final class MapUtils {
    private MapUtils() {
    }

    public static Map<String, String> getMapWithLowercaseKeys(Map<String, String> m) {
        LinkedHashMap<String, String> copy = new LinkedHashMap<String, String>();
        for (Map.Entry<String, String> entry : m.entrySet()) {
            copy.put(entry.getKey().toLowerCase(), entry.getValue());
        }
        return copy;
    }

    public static Map<String, String> getMapWithSnakecaseKeys(Map<String, String> m) {
        LinkedHashMap<String, String> copy = new LinkedHashMap<String, String>();
        for (Map.Entry<String, String> entry : m.entrySet()) {
            copy.put(StringUtils.camelToSnake((String)entry.getKey()), entry.getValue());
        }
        return copy;
    }

    public static Map<String, String> removeNonMatchingKeys(Map<String, String> m, List<String> ls) {
        m.entrySet().removeIf(entry -> !ls.contains(((String)entry.getKey()).toLowerCase()));
        return m;
    }
}

