/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.utils;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class LangUtils {
    private static final Map<String, String> COMMON_3LETTER_LANG_CODE;
    private static final Map<String, String> COMMON_2LETTER_LANG_CODE;

    private LangUtils() {
    }

    public static String iso2(String language) {
        if (language != null && language.length() == 2) {
            return language;
        }
        if (language != null && language.length() == 3) {
            return (String)COMMON_3LETTER_LANG_CODE.get(language.toLowerCase());
        }
        return null;
    }

    public static String iso3(String language) {
        if (language != null && language.length() == 3) {
            return language;
        }
        if (language != null && language.length() == 2) {
            return (String)COMMON_2LETTER_LANG_CODE.get(language.toLowerCase());
        }
        return null;
    }

    static {
        HashMap<String, String> common3letterLangCodeInternal = new HashMap<String, String>();
        common3letterLangCodeInternal.put("eng", "en");
        common3letterLangCodeInternal.put("fra", "fr");
        common3letterLangCodeInternal.put("fre", "fr");
        common3letterLangCodeInternal.put("deu", "de");
        common3letterLangCodeInternal.put("ger", "de");
        common3letterLangCodeInternal.put("spa", "es");
        common3letterLangCodeInternal.put("ita", "it");
        common3letterLangCodeInternal.put("por", "pt");
        COMMON_3LETTER_LANG_CODE = Collections.unmodifiableMap(common3letterLangCodeInternal);
        HashMap<String, String> common2letterLangCodeInternal = new HashMap<String, String>();
        common2letterLangCodeInternal.put("en", "eng");
        common2letterLangCodeInternal.put("fr", "fre");
        common2letterLangCodeInternal.put("de", "ger");
        common2letterLangCodeInternal.put("es", "spa");
        common2letterLangCodeInternal.put("it", "ita");
        common2letterLangCodeInternal.put("pt", "por");
        COMMON_2LETTER_LANG_CODE = Collections.unmodifiableMap(common2letterLangCodeInternal);
    }
}

