/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.utils;

import java.net.URI;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.gbif.api.model.common.DOI;
import org.gbif.doi.metadata.datacite.Affiliation;
import org.gbif.doi.metadata.datacite.Box;
import org.gbif.doi.metadata.datacite.ContributorType;
import org.gbif.doi.metadata.datacite.DataCiteMetadata;
import org.gbif.doi.metadata.datacite.DateType;
import org.gbif.doi.metadata.datacite.DescriptionType;
import org.gbif.doi.metadata.datacite.NameIdentifier;
import org.gbif.doi.metadata.datacite.ObjectFactory;
import org.gbif.doi.metadata.datacite.RelatedIdentifierType;
import org.gbif.doi.metadata.datacite.RelationType;
import org.gbif.doi.metadata.datacite.ResourceType;
import org.gbif.doi.service.InvalidMetadataException;
import org.gbif.ipt.config.Constants;
import org.gbif.ipt.model.Resource;
import org.gbif.metadata.eml.ipt.model.Agent;
import org.gbif.metadata.eml.ipt.model.Citation;
import org.gbif.metadata.eml.ipt.model.Eml;
import org.gbif.metadata.eml.ipt.model.GeospatialCoverage;
import org.gbif.metadata.eml.ipt.model.KeywordSet;
import org.gbif.metadata.eml.ipt.model.PhysicalData;
import org.gbif.metadata.eml.ipt.model.TemporalCoverage;
import org.gbif.metadata.eml.ipt.model.TemporalCoverageType;
import org.gbif.metadata.eml.ipt.model.UserId;

/*
 * Exception performing whole class analysis ignored.
 */
public class DataCiteMetadataBuilder {
    public static final String DOI_IDENTIFIER_TYPE = "DOI";
    public static final String ORCID_NAME_IDENTIFIER_SCHEME = "ORCID";
    public static final String RESEARCHERID_NAME_IDENTIFIER_SCHEME = "ResearcherID";
    public static final String DWC_FORMAT_NAME = "Data as a Darwin Core Archive file";
    public static final String EML_FORMAT_NAME = "Metadata as an EML file";
    public static final String RTF_FORMAT_NAME = "Metadata as an RTF file";
    public static final String ALTERNATE_IDENTIFIER_TYPE_TEXT = "Another identifier for this resource";
    public static final String CONTACT_ROLE = "pointOfContact";
    public static final String METADATA_PROVIDER_ROLE = "metadataProvider";
    public static final String HTTP_PROTOCOL = "http";
    public static final String RECORDS_NAME = "records";
    private static final Logger LOG = LogManager.getLogger(DataCiteMetadataBuilder.class);
    private static final ObjectFactory FACTORY = new ObjectFactory();
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");

    public static DataCiteMetadata createDataCiteMetadata(DOI doi, Resource resource) throws InvalidMetadataException {
        DataCiteMetadata dataCiteMetadata = FACTORY.createDataCiteMetadata();
        DataCiteMetadata.Identifier identifier = DataCiteMetadataBuilder.getDOIIdentifier((DOI)doi);
        dataCiteMetadata.setIdentifier(identifier);
        Eml eml = resource.getEml();
        DataCiteMetadata.Titles titles = DataCiteMetadataBuilder.convertEmlTitles((Eml)eml);
        dataCiteMetadata.setTitles(titles);
        DataCiteMetadata.Creators creators = DataCiteMetadataBuilder.convertEmlCreators((List)eml.getCreators());
        dataCiteMetadata.setCreators(creators);
        DataCiteMetadata.Publisher publisher = FACTORY.createDataCiteMetadataPublisher();
        publisher.setValue(DataCiteMetadataBuilder.getPublisher((Resource)resource));
        dataCiteMetadata.setPublisher(publisher);
        String publicationYear = DataCiteMetadataBuilder.getPublicationYear((Eml)eml);
        dataCiteMetadata.setPublicationYear(publicationYear);
        DataCiteMetadata.ResourceType resourceType = DataCiteMetadataBuilder.getResourceType((Resource)resource);
        dataCiteMetadata.setResourceType(resourceType);
        dataCiteMetadata.setVersion(resource.getEmlVersion().toPlainString());
        List emlContributors = DataCiteMetadataBuilder.prepareContributorsFromEmlAgents((List)eml.getContacts(), (List)eml.getMetadataProviders(), (List)eml.getAssociatedParties());
        DataCiteMetadata.Contributors contributors = DataCiteMetadataBuilder.convertEmlContributors((List)emlContributors);
        dataCiteMetadata.setContributors(contributors);
        DataCiteMetadata.Subjects subjects = DataCiteMetadataBuilder.convertEmlKeywords((List)eml.getKeywords(), (String)eml.getMetadataLanguage());
        dataCiteMetadata.setSubjects(subjects);
        DataCiteMetadata.Dates dates = DataCiteMetadataBuilder.convertEmlDates((Date)eml.getDateStamp(), (List)eml.getTemporalCoverages());
        dataCiteMetadata.setDates(dates);
        dataCiteMetadata.setLanguage(eml.getLanguage());
        DataCiteMetadata.AlternateIdentifiers alternateIdentifiers = DataCiteMetadataBuilder.convertEmlAlternateIdentifiers((List)eml.getAlternateIdentifiers());
        dataCiteMetadata.setAlternateIdentifiers(alternateIdentifiers);
        DataCiteMetadata.RelatedIdentifiers ridsBibliographicCitations = DataCiteMetadataBuilder.convertRelatedIdentifiers((List)eml.getBibliographicCitations(), (List)eml.getPhysicalData());
        dataCiteMetadata.setRelatedIdentifiers(ridsBibliographicCitations);
        DataCiteMetadata.Formats formats = DataCiteMetadataBuilder.getFormats((Resource)resource);
        dataCiteMetadata.setFormats(formats);
        DataCiteMetadata.Sizes sizes = DataCiteMetadataBuilder.getSizes((Resource)resource);
        dataCiteMetadata.setSizes(sizes);
        DataCiteMetadata.RightsList rights = DataCiteMetadataBuilder.getRightsList((Eml)eml);
        dataCiteMetadata.setRightsList(rights);
        DataCiteMetadata.Descriptions descriptions = DataCiteMetadataBuilder.getDescriptions((Eml)eml);
        dataCiteMetadata.setDescriptions(descriptions);
        DataCiteMetadata.GeoLocations geoLocations = DataCiteMetadataBuilder.getGeoLocations((List)eml.getGeospatialCoverages());
        dataCiteMetadata.setGeoLocations(geoLocations);
        return dataCiteMetadata;
    }

    protected static DataCiteMetadata.Identifier getDOIIdentifier(@NotNull DOI doi) {
        DataCiteMetadata.Identifier identifier = FACTORY.createDataCiteMetadataIdentifier();
        identifier.setValue(doi.getDoiName());
        identifier.setIdentifierType("DOI");
        return identifier;
    }

    protected static DataCiteMetadata.Formats getFormats(Resource resource) {
        DataCiteMetadata.Formats formats = FACTORY.createDataCiteMetadataFormats();
        if (resource.getCoreType() != null && resource.getCoreType().equalsIgnoreCase(Resource.CoreRowType.METADATA.toString())) {
            formats.getFormat().add("Metadata as an EML file");
            formats.getFormat().add("Metadata as an RTF file");
        } else {
            formats.getFormat().add("Data as a Darwin Core Archive file");
            formats.getFormat().add("Metadata as an EML file");
            formats.getFormat().add("Metadata as an RTF file");
        }
        return formats;
    }

    protected static DataCiteMetadata.Sizes getSizes(Resource resource) {
        DataCiteMetadata.Sizes sizes = FACTORY.createDataCiteMetadataSizes();
        if (resource.hasPublishedData()) {
            sizes.getSize().add(resource.getRecordsPublished() + " records");
        }
        return sizes;
    }

    protected static DataCiteMetadata.Descriptions getDescriptions(Eml eml) {
        DataCiteMetadata.Descriptions descriptions = FACTORY.createDataCiteMetadataDescriptions();
        if (eml.getDescription() != null) {
            DataCiteMetadata.Descriptions.Description description = FACTORY.createDataCiteMetadataDescriptionsDescription();
            description.setDescriptionType(DescriptionType.ABSTRACT);
            description.setLang(eml.getMetadataLanguage());
            description.getContent().add(eml.getDescription());
            descriptions.getDescription().add(description);
        }
        return descriptions;
    }

    protected static DataCiteMetadata.GeoLocations getGeoLocations(List<GeospatialCoverage> geospatialCoverages) {
        DataCiteMetadata.GeoLocations geoLocations = FACTORY.createDataCiteMetadataGeoLocations();
        for (GeospatialCoverage coverage : geospatialCoverages) {
            if (!StringUtils.isNotBlank((CharSequence)coverage.getDescription())) continue;
            DataCiteMetadata.GeoLocations.GeoLocation geoLocation = FACTORY.createDataCiteMetadataGeoLocationsGeoLocation();
            geoLocation.getGeoLocationPlaceOrGeoLocationPointOrGeoLocationBox().add(coverage.getDescription());
            if (coverage.getBoundingCoordinates().isValid()) {
                Box box = FACTORY.createBox();
                box.setWestBoundLongitude(coverage.getBoundingCoordinates().getMin().getLongitude().floatValue());
                box.setEastBoundLongitude(coverage.getBoundingCoordinates().getMax().getLongitude().floatValue());
                box.setSouthBoundLatitude(coverage.getBoundingCoordinates().getMin().getLatitude().floatValue());
                box.setNorthBoundLatitude(coverage.getBoundingCoordinates().getMax().getLatitude().floatValue());
                geoLocation.getGeoLocationPlaceOrGeoLocationPointOrGeoLocationBox().add(box);
            }
            geoLocations.getGeoLocation().add(geoLocation);
        }
        return geoLocations;
    }

    protected static DataCiteMetadata.RightsList getRightsList(Eml eml) {
        DataCiteMetadata.RightsList rightsList = FACTORY.createDataCiteMetadataRightsList();
        if (StringUtils.isNotBlank((CharSequence)eml.parseLicenseUrl()) && StringUtils.isNotBlank((CharSequence)eml.parseLicenseTitle())) {
            DataCiteMetadata.RightsList.Rights rights = FACTORY.createDataCiteMetadataRightsListRights();
            rights.setValue(eml.parseLicenseTitle());
            rights.setRightsURI(eml.parseLicenseUrl());
            rightsList.getRights().add(rights);
        }
        return rightsList;
    }

    protected static DataCiteMetadata.AlternateIdentifiers convertEmlAlternateIdentifiers(List<String> alternateIdentifiers) {
        DataCiteMetadata.AlternateIdentifiers alternates = FACTORY.createDataCiteMetadataAlternateIdentifiers();
        for (String alternateIdentifier : alternateIdentifiers) {
            DataCiteMetadata.AlternateIdentifiers.AlternateIdentifier alternate = FACTORY.createDataCiteMetadataAlternateIdentifiersAlternateIdentifier();
            alternate.setValue(alternateIdentifier);
            alternate.setAlternateIdentifierType("Another identifier for this resource");
            alternates.getAlternateIdentifier().add(alternate);
        }
        return alternates;
    }

    protected static DataCiteMetadata.RelatedIdentifiers convertRelatedIdentifiers(List<Citation> bibliographicCitations, List<PhysicalData> physicalDatas) {
        DataCiteMetadata.RelatedIdentifiers.RelatedIdentifier rid;
        DataCiteMetadata.RelatedIdentifiers rids = FACTORY.createDataCiteMetadataRelatedIdentifiers();
        for (Citation citation : bibliographicCitations) {
            if (!StringUtils.isNotBlank((CharSequence)citation.getIdentifier())) continue;
            rid = FACTORY.createDataCiteMetadataRelatedIdentifiersRelatedIdentifier();
            rid.setValue(citation.getIdentifier());
            rid.setRelationType(RelationType.REFERENCES);
            rid.setRelatedIdentifierType(RelatedIdentifierType.URL);
            rids.getRelatedIdentifier().add(rid);
        }
        for (PhysicalData data : physicalDatas) {
            if (!StringUtils.isNotBlank((CharSequence)data.getDistributionUrl()) || !data.getDistributionUrl().startsWith("http")) continue;
            rid = FACTORY.createDataCiteMetadataRelatedIdentifiersRelatedIdentifier();
            try {
                URI val = new URI(data.getDistributionUrl());
                rid.setValue(val.toString());
                rid.setRelatedIdentifierType(RelatedIdentifierType.URL);
                rid.setRelationType(RelationType.IS_VARIANT_FORM_OF);
                rids.getRelatedIdentifier().add(rid);
            }
            catch (URISyntaxException e) {
                LOG.error("Failed to convert distributionUrl into URI: " + data.getDistributionUrl());
            }
        }
        return rids;
    }

    protected static DataCiteMetadata.ResourceType getResourceType(Resource resource) throws InvalidMetadataException {
        DataCiteMetadata.ResourceType resourceType = FACTORY.createDataCiteMetadataResourceType();
        resourceType.setResourceTypeGeneral(ResourceType.DATASET);
        if (resource.getCoreType() != null) {
            resourceType.setValue(StringUtils.capitalize((String)resource.getCoreType().toLowerCase()));
            return resourceType;
        }
        throw new InvalidMetadataException("DataCite schema (v4) requires a resource type");
    }

    protected static String getPublisher(Resource resource) throws InvalidMetadataException {
        if (resource.getOrganisation() != null && StringUtils.isNotBlank((CharSequence)resource.getOrganisation().getName()) && !resource.getOrganisation().getKey().equals(Constants.DEFAULT_ORG_KEY)) {
            return resource.getOrganisation().getName();
        }
        throw new InvalidMetadataException("DataCite schema (v4) requires a publishing organisation");
    }

    protected static String getPublicationYear(Eml eml) throws InvalidMetadataException {
        if (eml.getDateStamp() != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(eml.getDateStamp());
            return String.valueOf(cal.get(1));
        }
        throw new InvalidMetadataException("DataCite schema (v4) requires the publication year");
    }

    protected static DataCiteMetadata.Creators convertEmlCreators(List<Agent> agents) throws InvalidMetadataException {
        DataCiteMetadata.Creators creators = FACTORY.createDataCiteMetadataCreators();
        if (!agents.isEmpty()) {
            for (Agent agent : agents) {
                DataCiteMetadata.Creators.Creator.CreatorName creatorName;
                DataCiteMetadata.Creators.Creator creator = FACTORY.createDataCiteMetadataCreatorsCreator();
                if (StringUtils.isNotBlank((CharSequence)agent.getFullName())) {
                    creatorName = FACTORY.createDataCiteMetadataCreatorsCreatorCreatorName();
                    creatorName.setValue(agent.getFullName());
                    creator.setCreatorName(creatorName);
                    if (!agent.getUserIds().isEmpty()) {
                        for (UserId userId : agent.getUserIds()) {
                            NameIdentifier nid = DataCiteMetadataBuilder.convertEmlUserIdIntoCreatorNameIdentifier((UserId)userId);
                            if (nid == null) continue;
                            creator.getNameIdentifier().add(nid);
                            break;
                        }
                    }
                    if (StringUtils.isNotBlank((CharSequence)agent.getOrganisation())) {
                        Affiliation affiliation = FACTORY.createAffiliation();
                        affiliation.setValue(agent.getOrganisation());
                        creator.getAffiliation().add(affiliation);
                    }
                } else if (StringUtils.isNotBlank((CharSequence)agent.getOrganisation())) {
                    creatorName = FACTORY.createDataCiteMetadataCreatorsCreatorCreatorName();
                    creatorName.setValue(agent.getOrganisation());
                    creator.setCreatorName(creatorName);
                } else {
                    throw new InvalidMetadataException("DataCite schema (v4) requires creator have a name! Creator can be an organisation or person. Check creator/agent: " + String.valueOf(agent));
                }
                creators.getCreator().add(creator);
            }
            return creators;
        }
        throw new InvalidMetadataException("DataCite schema (v4) requires at least one creator");
    }

    private static List<Agent> prepareContributorsFromEmlAgents(List<Agent> contacts, List<Agent> metadataProviders, List<Agent> associatedParties) {
        ArrayList<Agent> ls = new ArrayList<Agent>();
        for (Agent contact : contacts) {
            contact.setRole("pointOfContact");
        }
        ls.addAll(contacts);
        for (Agent metadataProvider : metadataProviders) {
            metadataProvider.setRole("metadataProvider");
        }
        ls.addAll(metadataProviders);
        ls.addAll(associatedParties);
        return ls;
    }

    protected static DataCiteMetadata.Contributors convertEmlContributors(List<Agent> agents) throws InvalidMetadataException {
        DataCiteMetadata.Contributors contributors = FACTORY.createDataCiteMetadataContributors();
        for (Agent agent : agents) {
            Affiliation affiliation;
            DataCiteMetadata.Contributors.Contributor.ContributorName contributorName;
            DataCiteMetadata.Contributors.Contributor contributor = FACTORY.createDataCiteMetadataContributorsContributor();
            if (StringUtils.isNotBlank((CharSequence)agent.getFullName())) {
                contributorName = FACTORY.createDataCiteMetadataContributorsContributorContributorName();
                contributorName.setValue(agent.getFullName());
                contributor.setContributorName(contributorName);
                if (!agent.getUserIds().isEmpty()) {
                    for (UserId userId : agent.getUserIds()) {
                        NameIdentifier nid = DataCiteMetadataBuilder.convertEmlUserIdIntoContributorNameIdentifier((UserId)userId);
                        if (nid == null) continue;
                        contributor.getNameIdentifier().add(nid);
                        break;
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)agent.getOrganisation())) {
                    affiliation = FACTORY.createAffiliation();
                    affiliation.setValue(agent.getOrganisation());
                    contributor.getAffiliation().add(affiliation);
                }
            } else if (StringUtils.isNotBlank((CharSequence)agent.getOrganisation())) {
                contributorName = FACTORY.createDataCiteMetadataContributorsContributorContributorName();
                contributorName.setValue(agent.getOrganisation());
                contributor.setContributorName(contributorName);
            } else if (!agent.getPosition().isEmpty() && StringUtils.isNotBlank((CharSequence)((CharSequence)agent.getPosition().get(0)))) {
                contributorName = FACTORY.createDataCiteMetadataContributorsContributorContributorName();
                contributorName.setValue((String)agent.getPosition().get(0));
                contributor.setContributorName(contributorName);
                if (StringUtils.isNotBlank((CharSequence)agent.getOrganisation())) {
                    affiliation = FACTORY.createAffiliation();
                    affiliation.setValue(agent.getOrganisation());
                    contributor.getAffiliation().add(affiliation);
                }
            } else {
                throw new InvalidMetadataException("DataCite schema (v4) requires contributor have a name! Check contributor/agent: " + String.valueOf(agent));
            }
            String role = agent.getRole();
            if (StringUtils.isBlank((CharSequence)role)) {
                throw new InvalidMetadataException("DataCite schema (v4) requires contributor have a type! Check contributor/agent: " + String.valueOf(agent));
            }
            ContributorType type = role.equalsIgnoreCase("editor") || role.equalsIgnoreCase("publisher") ? ContributorType.EDITOR : (role.equalsIgnoreCase("contentProvider") ? ContributorType.DATA_COLLECTOR : (role.equalsIgnoreCase("custodianSteward") ? ContributorType.DATA_MANAGER : (role.equalsIgnoreCase("curator") || role.equalsIgnoreCase("metadataProvider") ? ContributorType.DATA_CURATOR : (role.equalsIgnoreCase("distributor") ? ContributorType.DISTRIBUTOR : (role.equalsIgnoreCase("owner") ? ContributorType.RIGHTS_HOLDER : (role.equalsIgnoreCase("pointOfContact") ? ContributorType.CONTACT_PERSON : (role.equalsIgnoreCase("originator") ? ContributorType.DATA_COLLECTOR : (role.equalsIgnoreCase("principalInvestigator") ? ContributorType.PROJECT_LEADER : (role.equalsIgnoreCase("processor") || role.equalsIgnoreCase("programmer") ? ContributorType.PRODUCER : ContributorType.RELATED_PERSON)))))))));
            contributor.setContributorType(type);
            contributors.getContributor().add(contributor);
        }
        return contributors;
    }

    protected static DataCiteMetadata.Titles convertEmlTitles(Eml eml) throws InvalidMetadataException {
        if (StringUtils.isNotBlank((CharSequence)eml.getTitle())) {
            DataCiteMetadata.Titles titles = FACTORY.createDataCiteMetadataTitles();
            DataCiteMetadata.Titles.Title primary = FACTORY.createDataCiteMetadataTitlesTitle();
            primary.setValue(eml.getTitle());
            primary.setLang(eml.getMetadataLanguage());
            titles.getTitle().add(primary);
            return titles;
        }
        throw new InvalidMetadataException("DataCite schema (v4) requires at least one title");
    }

    protected static DataCiteMetadata.Subjects convertEmlKeywords(List<KeywordSet> keywordSets, String language) throws InvalidMetadataException {
        DataCiteMetadata.Subjects subjects = FACTORY.createDataCiteMetadataSubjects();
        for (KeywordSet keywordSet : keywordSets) {
            for (String keyword : keywordSet.getKeywords()) {
                DataCiteMetadata.Subjects.Subject subject = FACTORY.createDataCiteMetadataSubjectsSubject();
                subject.setValue(keyword);
                if (StringUtils.isNotBlank((CharSequence)language)) {
                    subject.setLang(language);
                }
                subject.setLang(language);
                String thesaurus = keywordSet.getKeywordThesaurus();
                if (StringUtils.isNotBlank((CharSequence)thesaurus)) {
                    if (thesaurus.startsWith("http")) {
                        try {
                            URI schemeUri = new URI(keywordSet.getKeywordThesaurus());
                            subject.setSchemeURI(schemeUri.toString());
                        }
                        catch (URISyntaxException e) {
                            LOG.debug("Could not convert keyword thesaurus to URI: " + keywordSet.getKeywordThesaurus());
                        }
                    } else {
                        subject.setSubjectScheme(thesaurus);
                    }
                }
                subjects.getSubject().add(subject);
            }
        }
        return subjects;
    }

    protected static DataCiteMetadata.Dates convertEmlDates(Date created, List<TemporalCoverage> coverages) {
        DataCiteMetadata.Dates dates = FACTORY.createDataCiteMetadataDates();
        if (created != null) {
            DataCiteMetadata.Dates.Date createdDate = FACTORY.createDataCiteMetadataDatesDate();
            createdDate.setValue(dateFormat.format(created));
            createdDate.setDateType(DateType.CREATED);
            dates.getDate().add(createdDate);
        }
        DataCiteMetadata.Dates.Date updatedDate = FACTORY.createDataCiteMetadataDatesDate();
        updatedDate.setValue(dateFormat.format(new Date()));
        updatedDate.setDateType(DateType.UPDATED);
        dates.getDate().add(updatedDate);
        for (TemporalCoverage coverage : coverages) {
            if (coverage.getType().equals((Object)TemporalCoverageType.SINGLE_DATE)) {
                DataCiteMetadata.Dates.Date singleDate = FACTORY.createDataCiteMetadataDatesDate();
                singleDate.setValue(dateFormat.format(coverage.getStartDate()));
                singleDate.setDateType(DateType.VALID);
                dates.getDate().add(singleDate);
                continue;
            }
            if (!coverage.getType().equals((Object)TemporalCoverageType.DATE_RANGE)) continue;
            DataCiteMetadata.Dates.Date range = FACTORY.createDataCiteMetadataDatesDate();
            String start = dateFormat.format(coverage.getStartDate());
            String end = dateFormat.format(coverage.getEndDate());
            range.setValue(start + "/" + end);
            range.setDateType(DateType.VALID);
            dates.getDate().add(range);
        }
        return dates;
    }

    private String convertDateToYearMonthDay(Date date) {
        return dateFormat.format(date);
    }

    protected static NameIdentifier convertEmlUserIdIntoCreatorNameIdentifier(UserId userId) {
        if (StringUtils.isNotBlank((CharSequence)userId.getIdentifier()) && StringUtils.isNotBlank((CharSequence)userId.getDirectory())) {
            String directory = StringUtils.trimToEmpty((String)userId.getDirectory()).toLowerCase();
            if (directory.contains("ORCID".toLowerCase()) || directory.contains("ResearcherID".toLowerCase())) {
                NameIdentifier nid = FACTORY.createNameIdentifier();
                nid.setValue(userId.getIdentifier());
                nid.setSchemeURI(userId.getDirectory());
                nid.setNameIdentifierScheme(directory.contains("ORCID".toLowerCase()) ? "ORCID" : "ResearcherID");
                return nid;
            }
            LOG.debug("UserId has unrecognized directory (" + directory + "), only ORCID and ResearcherID are supported");
            return null;
        }
        return null;
    }

    protected static NameIdentifier convertEmlUserIdIntoContributorNameIdentifier(UserId userId) {
        if (StringUtils.isNotBlank((CharSequence)userId.getIdentifier()) && StringUtils.isNotBlank((CharSequence)userId.getDirectory())) {
            String directory = StringUtils.trimToEmpty((String)userId.getDirectory()).toLowerCase();
            if (directory.contains("ORCID".toLowerCase()) || directory.contains("ResearcherID".toLowerCase())) {
                NameIdentifier nid = FACTORY.createNameIdentifier();
                nid.setValue(userId.getIdentifier());
                nid.setSchemeURI(userId.getDirectory());
                nid.setNameIdentifierScheme(directory.contains("ORCID".toLowerCase()) ? "ORCID" : "ResearcherID");
                return nid;
            }
            LOG.debug("UserId has unrecognized directory (" + directory + "), only ORCID and ResearcherID are supported");
            return null;
        }
        return null;
    }

    public static void addIsNewVersionOfDOIRelatedIdentifier(@NotNull DataCiteMetadata metadata, @NotNull DOI replaced) throws InvalidMetadataException {
        DataCiteMetadata.RelatedIdentifiers.RelatedIdentifier rid = FACTORY.createDataCiteMetadataRelatedIdentifiersRelatedIdentifier();
        rid.setRelatedIdentifierType(RelatedIdentifierType.DOI);
        rid.setValue(replaced.getDoiName());
        rid.setRelationType(RelationType.IS_NEW_VERSION_OF);
        metadata.getRelatedIdentifiers().getRelatedIdentifier().add(rid);
    }

    public static void addIsPreviousVersionOfDOIRelatedIdentifier(@NotNull DataCiteMetadata metadata, @NotNull DOI replacing) {
        DataCiteMetadata.RelatedIdentifiers.RelatedIdentifier rid = FACTORY.createDataCiteMetadataRelatedIdentifiersRelatedIdentifier();
        rid.setRelatedIdentifierType(RelatedIdentifierType.DOI);
        rid.setValue(replacing.getDoiName());
        rid.setRelationType(RelationType.IS_PREVIOUS_VERSION_OF);
        metadata.getRelatedIdentifiers().getRelatedIdentifier().add(rid);
    }
}

