/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.utils;

import java.util.Objects;
import javax.validation.constraints.NotNull;
import org.apache.commons.text.RandomStringGenerator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.gbif.api.model.common.DOI;
import org.gbif.ipt.model.voc.DOIRegistrationAgency;

public class DOIUtils {
    protected static final Logger LOG = LogManager.getLogger(DOIUtils.class);
    private static final int DOI_SUFFIX_LENGTH = 6;
    private static final String DOI_ALLOWED_CHARS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890";
    private static final RandomStringGenerator DOI_SUFFIX_GENERATOR = new RandomStringGenerator.Builder().selectFrom("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890".toCharArray()).build();

    private DOIUtils() {
    }

    @NotNull
    public static DOI mintDOI(DOIRegistrationAgency agency, String prefix) {
        Objects.requireNonNull(agency);
        Objects.requireNonNull(prefix);
        String suffix = DOI_SUFFIX_GENERATOR.generate(6).toLowerCase();
        return new DOI(prefix, suffix);
    }
}

