/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.task;

import io.frictionlessdata.datapackage.JSONBase;
import io.frictionlessdata.datapackage.Package;
import io.frictionlessdata.datapackage.exceptions.DataPackageValidationException;
import io.frictionlessdata.datapackage.resource.FilebasedResource;
import io.frictionlessdata.datapackage.resource.Resource;
import io.frictionlessdata.tableschema.exception.ForeignKeyException;
import io.frictionlessdata.tableschema.exception.PrimaryKeyException;
import io.frictionlessdata.tableschema.exception.ValidationException;
import io.frictionlessdata.tableschema.schema.Schema;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Level;
import org.gbif.ipt.config.AppConfig;
import org.gbif.ipt.config.DataDir;
import org.gbif.ipt.model.DataPackageField;
import org.gbif.ipt.model.DataPackageFieldMapping;
import org.gbif.ipt.model.DataPackageMapping;
import org.gbif.ipt.model.DataPackageSchema;
import org.gbif.ipt.model.DataPackageTableSchema;
import org.gbif.ipt.model.DataPackageTableSchemaName;
import org.gbif.ipt.model.DataPackageTableSchemaRequirement;
import org.gbif.ipt.model.RecordFilter;
import org.gbif.ipt.model.datapackage.metadata.col.ColMetadata;
import org.gbif.ipt.service.manage.MetadataReader;
import org.gbif.ipt.service.manage.SourceManager;
import org.gbif.ipt.task.GenerateDataPackage;
import org.gbif.ipt.task.GeneratorException;
import org.gbif.ipt.task.ReportHandler;
import org.gbif.ipt.task.ReportingTask;
import org.gbif.ipt.task.StatusReport;
import org.gbif.utils.file.ClosableReportingIterator;

public class GenerateDataPackage
extends ReportingTask
implements Callable<Map<String, Integer>> {
    private static final Pattern ESCAPE_CHARS = Pattern.compile("[\t\n\r]");
    private final org.gbif.ipt.model.Resource resource;
    private final SourceManager sourceManager;
    private MetadataReader metadataReader;
    private final AppConfig cfg;
    private STATE state = STATE.WAITING;
    private Exception exception;
    private File dataPackageFolder;
    private Package dataPackage;
    private int currRecords = 0;
    private int currRecordsSkipped = 0;
    private String currSchema;
    private String currTableSchema;
    private Map<String, Integer> recordsByTableSchema = new HashMap();

    public GenerateDataPackage(org.gbif.ipt.model.Resource resource, ReportHandler handler, DataDir dataDir, SourceManager sourceManager, AppConfig cfg, MetadataReader metadataReader) {
        super(1000, resource.getShortname(), handler, dataDir);
        this.resource = resource;
        this.sourceManager = sourceManager;
        this.cfg = cfg;
        this.metadataReader = metadataReader;
    }

    @Override
    public Map<String, Integer> call() throws Exception {
        try {
            this.checkForInterruption();
            this.setState(STATE.STARTED);
            this.addMessage(Level.INFO, "Data Package generation started for version #" + String.valueOf(this.resource.getDataPackageMetadataVersion()));
            this.dataPackageFolder = this.dataDir.tmpDir();
            if ("coldp".equals(this.resource.getCoreType())) {
                this.createDataResources();
                this.addMetadata();
            } else {
                this.addMetadata();
                this.createDataResources();
            }
            this.bundleArchive();
            this.addMessage(Level.INFO, "Archive version #" + String.valueOf(this.resource.getDataPackageMetadataVersion()) + " generated successfully!");
            this.setState(STATE.COMPLETED);
            Map map = this.recordsByTableSchema;
            return map;
        }
        catch (GeneratorException e) {
            this.setState((Exception)((Object)e));
            if (this.cfg.debug()) {
                this.writeFailureToPublicationLog((Throwable)e);
            } else {
                this.log.error("Exception occurred trying to generate data package for resource " + this.resource.getTitleAndShortname() + ": " + e.getMessage(), (Throwable)e);
            }
            throw e;
        }
        catch (InterruptedException e) {
            this.setState((Exception)e);
            this.writeFailureToPublicationLog((Throwable)e);
            throw e;
        }
        catch (Exception e) {
            this.setState(e);
            this.writeFailureToPublicationLog((Throwable)e);
            throw new GeneratorException((Throwable)e);
        }
        finally {
            if (this.dataPackageFolder != null && this.dataPackageFolder.exists()) {
                FileUtils.deleteQuietly((File)this.dataPackageFolder);
            }
            this.closePublicationLogWriter();
        }
    }

    protected boolean completed() {
        return STATE.COMPLETED == this.state;
    }

    protected Exception currentException() {
        return this.exception;
    }

    protected String currentState() {
        switch (1.$SwitchMap$org$gbif$ipt$task$GenerateDataPackage$STATE[this.state.ordinal()]) {
            case 1: {
                return "Not started yet";
            }
            case 2: {
                return "Starting Data Package generation";
            }
            case 3: {
                return "Processing record " + this.currRecords + " for Data Resource <em>" + this.currTableSchema + "</em>";
            }
            case 4: {
                return "Creating metadata files";
            }
            case 5: {
                return "Compressing Data Package (archive)";
            }
            case 6: {
                return "Data Package generated!";
            }
            case 7: {
                return "Validating Data Package, " + this.currRecords + " for Data Resource <em>" + this.currTableSchema + "</em>";
            }
            case 8: {
                return "Archiving version of data package";
            }
            case 9: {
                return "Data Package generation cancelled";
            }
            case 10: {
                return "Data Package generation failed";
            }
        }
        return "You should never see this";
    }

    private void bundleArchive() throws Exception {
        block11: {
            this.checkForInterruption();
            this.setState(STATE.BUNDLING);
            File zip = null;
            BigDecimal version = this.resource.getDataPackageMetadataVersion();
            try {
                this.checkRelationsAndPrimaryKeys();
                zip = this.dataDir.tmpFile("datapackage", ".zip");
                if ("coldp".equals(this.resource.getCoreType())) {
                    this.dataPackage.write(zip, arg_0 -> this.writeCustomColDPMetadata(arg_0), true);
                } else {
                    this.dataPackage.write(zip, true);
                }
                if (zip.exists()) {
                    File versionedFile = this.dataDir.resourceDataPackageFile(this.resource.getShortname(), version);
                    if (versionedFile.exists()) {
                        FileUtils.forceDelete((File)versionedFile);
                    }
                    FileUtils.moveFile((File)zip, (File)versionedFile);
                    break block11;
                }
                throw new GeneratorException("Archive bundling failed: temp archive not created: " + zip.getAbsolutePath());
            }
            catch (IOException e) {
                throw new GeneratorException("Problem occurred while bundling data package", (Throwable)e);
            }
            catch (DataPackageValidationException | ForeignKeyException | PrimaryKeyException e) {
                throw new GeneratorException(e.getMessage());
            }
            finally {
                if (zip != null && zip.exists()) {
                    FileUtils.deleteQuietly((File)zip);
                }
            }
        }
        this.addMessage(Level.INFO, "Archive has been compressed");
    }

    private void writeCustomColDPMetadata(Path outputDir) {
        Path target = outputDir.getFileSystem().getPath("metadata.yaml", new String[0]);
        try (BufferedWriter writer = Files.newBufferedWriter(target, StandardCharsets.UTF_8, StandardOpenOption.CREATE);){
            this.metadataReader.writeValue((Writer)writer, (Object)this.resource.getDataPackageMetadata());
        }
        catch (IOException e) {
            this.log.error("Failed to write metadata.yaml", (Throwable)e);
            this.addMessage(Level.ERROR, "Failed to write metadata.yaml");
        }
    }

    private void checkForInterruption() throws InterruptedException {
        if (Thread.interrupted()) {
            StatusReport report = this.report();
            String msg = "Interrupting data package generator. Last status: " + report.getState();
            this.log.info(msg);
            throw new InterruptedException(msg);
        }
    }

    private void checkForInterruption(int line) throws InterruptedException {
        if (Thread.interrupted()) {
            StatusReport report = this.report();
            String msg = "Interrupting package generator at line " + line + ". Last status: " + report.getState();
            this.log.info(msg);
            throw new InterruptedException(msg);
        }
    }

    private void setState(STATE s) {
        this.state = s;
        this.report();
    }

    private void setState(Exception e) {
        this.exception = e;
        this.state = this.exception instanceof InterruptedException ? STATE.CANCELLED : STATE.FAILED;
        this.report();
    }

    private void createDataResources() throws GeneratorException, InterruptedException {
        this.checkForInterruption();
        this.setState(STATE.DATARESOURCES);
        if (this.resource.getDataPackageIdentifier() == null && CollectionUtils.isEmpty((Collection)this.resource.getDataPackageMappings())) {
            throw new GeneratorException("Data package identifier or mappings are not set");
        }
        List allMappings = this.resource.getDataPackageMappings();
        Set mappedTableSchemas = allMappings.stream().map(DataPackageMapping::getDataPackageTableSchemaName).map(DataPackageTableSchemaName::getName).collect(Collectors.toSet());
        DataPackageSchema dataPackageSchema = ((DataPackageMapping)this.resource.getDataPackageMappings().get(0)).getDataPackageSchema();
        this.currSchema = dataPackageSchema.getName();
        this.checkRequiredTableSchemasMapped(mappedTableSchemas, dataPackageSchema);
        for (DataPackageTableSchema tableSchema : dataPackageSchema.getTableSchemas()) {
            if (!mappedTableSchemas.contains(tableSchema.getName())) continue;
            this.report();
            try {
                this.addDataResource(this.currSchema, tableSchema, allMappings);
            }
            catch (IOException | IllegalArgumentException e) {
                throw new GeneratorException("Problem occurred while writing Data Resource", (Throwable)e);
            }
        }
        this.addMessage(Level.INFO, "All Data Resources completed");
        this.report();
    }

    private void checkRequiredTableSchemasMapped(Set<String> mappedTableSchemas, DataPackageSchema dataPackageSchema) throws GeneratorException {
        DataPackageTableSchemaRequirement.ValidationResult validationResult;
        DataPackageTableSchemaRequirement requirements = dataPackageSchema.getTableSchemasRequirements();
        if (requirements != null && !(validationResult = requirements.validate(mappedTableSchemas)).isValid()) {
            throw new GeneratorException(validationResult.getReason());
        }
    }

    public void addDataResource(String schemaName, DataPackageTableSchema tableSchema, List<DataPackageMapping> allMappings) throws IOException, IllegalArgumentException, InterruptedException, GeneratorException {
        this.checkForInterruption();
        if (tableSchema == null || CollectionUtils.isEmpty(allMappings)) {
            return;
        }
        this.currRecords = 0;
        this.currRecordsSkipped = 0;
        this.currTableSchema = tableSchema.getName();
        List fields = tableSchema.getFields();
        String header = fields.stream().map(DataPackageField::getName).collect(Collectors.joining(",", "", "\n"));
        int totalColumns = fields.size();
        String fn = tableSchema.getName() + ".csv";
        File dataFile = new File(this.dataPackageFolder, fn);
        try (Writer writer = org.gbif.utils.file.FileUtils.startNewUtf8File((File)dataFile);){
            this.addMessage(Level.INFO, "Start creating Data Resource " + tableSchema.getName());
            boolean headerWritten = false;
            for (DataPackageMapping dataPackageMapping : allMappings) {
                if (!dataPackageMapping.getDataPackageTableSchemaName().getName().equals(tableSchema.getName())) continue;
                if (!headerWritten) {
                    writer.write(header);
                    headerWritten = true;
                }
                this.dumpData(writer, dataPackageMapping, dataPackageMapping.getFields(), totalColumns);
                this.recordsByTableSchema.put(tableSchema.getName(), this.currRecords);
            }
        }
        catch (IOException e) {
            this.log.error("Fatal Package Generator Error encountered while writing header line to Data Resource", (Throwable)e);
            this.setState((Exception)e);
            throw new GeneratorException("Error writing header line to Data Resource", (Throwable)e);
        }
        FilebasedResource packageResource = new FilebasedResource(tableSchema.getName(), Collections.singleton(new File(fn)), this.dataPackageFolder);
        packageResource.setProfile("tabular-data-resource");
        packageResource.setFormat("csv");
        if (tableSchema.getUrl() != null) {
            ((JSONBase)packageResource).getOriginalReferences().put("schema", tableSchema.getUrl().toString());
        }
        try {
            Schema schema = Schema.fromJson((URL)tableSchema.getUrl(), (boolean)true);
            packageResource.setSchema(schema);
        }
        catch (ValidationException e) {
            this.log.error("Failed to validate schema {}. Errors: {}", (Object)tableSchema.getName(), (Object)e.getMessages(), (Object)e);
            this.addMessage(Level.ERROR, "Failed to validate schema " + tableSchema.getName());
            this.setState((Exception)((Object)e));
            throw new GeneratorException("Validation error while adding schema file", (Throwable)e);
        }
        catch (Exception e) {
            this.log.error("Fatal Package Generator Error encountered while adding schema data {}", (Object)tableSchema.getIdentifier(), (Object)e);
            this.addMessage(Level.ERROR, "Error while adding schema data " + tableSchema.getIdentifier());
            this.setState(e);
            throw new GeneratorException("Error while adding schema file", (Throwable)e);
        }
        if (this.dataPackage == null) {
            this.dataPackage = new Package(Collections.singleton(packageResource));
        } else {
            this.dataPackage.addResource((Resource)packageResource);
        }
        this.addMessage(Level.INFO, "Data Resource " + this.currTableSchema + " created with " + this.currRecords + " records and " + totalColumns + " columns");
        if (this.currRecordsSkipped > 0) {
            this.addMessage(Level.WARN, "!!! " + this.currRecordsSkipped + " records were skipped for " + this.currTableSchema + " due to errors interpreting line, or because the line was empty");
        }
    }

    private void dumpData(Writer writer, DataPackageMapping schemaMapping, List<DataPackageFieldMapping> tableSchemaFieldMappings, int dataFileRowSize) throws GeneratorException, InterruptedException {
        RecordFilter filter = schemaMapping.getFilter();
        int recordsWithError = 0;
        int linesWithWrongColumnNumber = 0;
        int recordsFiltered = 0;
        int emptyLines = 0;
        ClosableReportingIterator iter = null;
        int line = 0;
        Optional<Integer> maxMappedColumnIndexOpt = tableSchemaFieldMappings.stream().map(DataPackageFieldMapping::getIndex).filter(Objects::nonNull).max(Comparator.naturalOrder());
        try {
            iter = this.sourceManager.rowIterator(schemaMapping.getSource());
            while (iter.hasNext()) {
                String newRow;
                String[] in;
                if (++line % 1000 == 0) {
                    this.checkForInterruption(line);
                    this.reportIfNeeded();
                }
                if ((in = (String[])iter.next()) == null || in.length == 0) continue;
                if (iter.hasRowError()) {
                    this.writePublicationLogMessage("Error reading line #" + line + "\n" + iter.getErrorMessage());
                    ++recordsWithError;
                    ++this.currRecordsSkipped;
                    continue;
                }
                if (this.isEmptyLine(in)) {
                    this.writePublicationLogMessage("Empty line was skipped. SourceBase:" + schemaMapping.getSource().getName() + " Line #" + line + ": " + this.printLine(in));
                    ++emptyLines;
                    ++this.currRecordsSkipped;
                    continue;
                }
                if (maxMappedColumnIndexOpt.isPresent() && in.length <= maxMappedColumnIndexOpt.get()) {
                    this.writePublicationLogMessage("Line with fewer columns than mapped. SourceBase:" + schemaMapping.getSource().getName() + " Line #" + line + " has " + in.length + " Columns: " + this.printLine(in));
                    String[] in2 = new String[maxMappedColumnIndexOpt.get() + 1];
                    System.arraycopy(in, 0, in2, 0, in.length);
                    in = in2;
                    ++linesWithWrongColumnNumber;
                }
                String[] translated = new String[dataFileRowSize];
                boolean alreadyTranslated = false;
                if (filter != null && filter.getColumn() != null && filter.getComparator() != null && filter.getParam() != null) {
                    boolean matchesFilter;
                    if (filter.getFilterTime() == RecordFilter.FilterTime.AfterTranslation) {
                        this.applyTranslations(tableSchemaFieldMappings, in, translated);
                        matchesFilter = filter.matches(in);
                        alreadyTranslated = true;
                    } else {
                        matchesFilter = filter.matches(in);
                    }
                    if (!matchesFilter) {
                        this.writePublicationLogMessage("Line did not match the filter criteria and was skipped. SourceBase:" + schemaMapping.getSource().getName() + " Line #" + line + ": " + this.printLine(in));
                        ++recordsFiltered;
                        continue;
                    }
                }
                if (!alreadyTranslated) {
                    this.applyTranslations(tableSchemaFieldMappings, in, translated);
                }
                if ((newRow = this.commaRow(translated)) == null) continue;
                writer.write(newRow);
                ++this.currRecords;
            }
        }
        catch (InterruptedException e) {
            this.setState((Exception)e);
            throw e;
        }
        catch (Exception e) {
            this.log.error("Fatal Data Package Generator Error encountered", (Throwable)e);
            this.setState(e);
            throw new GeneratorException("Error writing Data Resource for mapping " + this.currTableSchema + " in source " + schemaMapping.getSource().getName() + ", line " + line, (Throwable)e);
        }
        finally {
            if (iter != null) {
                if (!iter.hasRowError() && iter.getErrorMessage() != null) {
                    this.writePublicationLogMessage("Error reading data: " + iter.getErrorMessage());
                }
                try {
                    iter.close();
                }
                catch (Exception e) {
                    this.log.error("Error while closing iterator", (Throwable)e);
                }
            }
        }
        String mp = " for mapping " + schemaMapping.getDataPackageSchema().getTitle() + " in source " + schemaMapping.getSource().getName();
        if (recordsWithError > 0) {
            this.addMessage(Level.WARN, recordsWithError + " record(s) skipped due to errors" + mp);
        } else {
            this.writePublicationLogMessage("No lines were skipped due to errors" + mp);
        }
        if (emptyLines > 0) {
            this.addMessage(Level.WARN, emptyLines + " empty line(s) skipped" + mp);
        } else {
            this.writePublicationLogMessage("No lines were skipped due to errors" + mp);
        }
        if (linesWithWrongColumnNumber > 0) {
            this.addMessage(Level.WARN, linesWithWrongColumnNumber + " line(s) with fewer columns than mapped" + mp);
        } else {
            this.writePublicationLogMessage("No lines with fewer columns than mapped" + mp);
        }
        if (recordsFiltered > 0) {
            this.addMessage(Level.INFO, recordsFiltered + " line(s) did not match the filter criteria and got skipped " + mp);
        } else {
            this.writePublicationLogMessage("All lines match the filter criteria" + mp);
        }
    }

    private void applyTranslations(List<DataPackageFieldMapping> inCols, String[] in, String[] translated) {
        for (int i = 0; i < inCols.size(); ++i) {
            DataPackageFieldMapping mapping = inCols.get(i);
            String val = null;
            if (mapping != null) {
                if (mapping.getIndex() != null) {
                    val = in[mapping.getIndex()];
                    if (mapping.getTranslation() != null && mapping.getTranslation().containsKey(val)) {
                        in[mapping.getIndex().intValue()] = val = (String)mapping.getTranslation().get(val);
                    }
                }
                if (val == null) {
                    val = mapping.getDefaultValue();
                }
            }
            translated[i] = val;
        }
    }

    protected String commaRow(String[] columns) {
        Objects.requireNonNull(columns);
        boolean empty = true;
        for (int i = 0; i < columns.length; ++i) {
            if (columns[i] == null) continue;
            empty = false;
            columns[i] = StringUtils.trimToNull((String)ESCAPE_CHARS.matcher(columns[i]).replaceAll(""));
            boolean containsDoubleQuotes = StringUtils.contains((CharSequence)columns[i], (int)34);
            boolean containsComma = StringUtils.contains((CharSequence)columns[i], (int)44);
            if (containsDoubleQuotes) {
                columns[i] = StringUtils.replace((String)columns[i], (String)"\"", (String)"\"\"");
            }
            if (!containsComma && !containsDoubleQuotes) continue;
            columns[i] = StringUtils.wrap((String)columns[i], (char)'\"');
        }
        if (empty) {
            return null;
        }
        return StringUtils.join((Object[])columns, (char)',') + "\n";
    }

    private boolean isEmptyLine(String[] line) {
        String joined = Arrays.stream(line).filter(Objects::nonNull).collect(Collectors.joining(""));
        return StringUtils.isBlank((CharSequence)joined);
    }

    private String printLine(String[] in) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < in.length; ++i) {
            sb.append(in[i]);
            if (i == in.length - 1) continue;
            sb.append("; ");
        }
        sb.append("]");
        return sb.toString();
    }

    private void writeFailureToPublicationLog(Throwable e) {
        StringBuilder sb = new StringBuilder();
        sb.append("Data package generation failed!\n");
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        sb.append(sw);
        this.writePublicationLogMessage(sb.toString());
    }

    private void addMetadata() throws GeneratorException, InterruptedException {
        this.checkForInterruption();
        this.setState(STATE.METADATA);
        try {
            String type = this.resource.getCoreType();
            if ("camtrap-dp".equals(type)) {
                this.addCamtrapMetadata();
            } else if ("coldp".equals(type)) {
                this.addColMetadata();
            } else {
                this.addMessage(Level.WARN, "Metadata was not added: unknown type " + type);
            }
        }
        catch (Exception e) {
            this.addMessage(Level.ERROR, e.getMessage());
            throw new GeneratorException("Problem occurred while adding metadata file to data package folder", (Throwable)e);
        }
        this.addMessage(Level.INFO, "Metadata added");
    }

    private void addColMetadata() throws IOException {
        File metadataFile = this.dataDir.resourceDatapackageMetadataFile(this.resource.getShortname(), this.resource.getCoreType());
        ColMetadata colMetadata = (ColMetadata)this.metadataReader.readValue(metadataFile, ColMetadata.class);
        this.setDataPackageProperty("created", (Object)new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'").format(new Date()));
        this.setDataPackageProperty("version", (Object)colMetadata.getVersion());
        this.setDataPackageStringProperty("title", colMetadata.getTitle());
        this.setDataPackageCollectionProperty("contributors", (Collection)colMetadata.getContributor());
        this.setDataPackageStringProperty("description", colMetadata.getDescription());
        this.setDataPackageCollectionProperty("keywords", (Collection)colMetadata.getKeyword());
        this.setDataPackageProperty("homepage", (Object)colMetadata.getUrl());
        this.setDataPackageCollectionProperty("licenses", Collections.singleton(colMetadata.getLicense()));
        colMetadata.getAdditionalProperties().forEach((key, value) -> this.dataPackage.setProperty(key, value));
    }

    private void addCamtrapMetadata() throws Exception {
        File metadataFile = this.dataDir.resourceDatapackageMetadataFile(this.resource.getShortname(), this.resource.getCoreType());
        this.dataPackage = new Package(metadataFile.toPath(), false);
        this.setDataPackageProperty("created", (Object)new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'").format(new Date()));
    }

    private void setDataPackageProperty(String name, Object property) {
        if (property != null) {
            this.dataPackage.setProperty(name, property);
        }
    }

    private void setDataPackageStringProperty(String name, String property) {
        if (StringUtils.isNotEmpty((CharSequence)property)) {
            this.dataPackage.setProperty(name, (Object)property);
        }
    }

    private void setDataPackageCollectionProperty(String name, Collection property) {
        if (property != null && !property.isEmpty()) {
            this.dataPackage.setProperty(name, (Object)property);
        }
    }

    private void checkRelationsAndPrimaryKeys() throws Exception {
        boolean isFkValidationEnabled = this.cfg.isDatapackageForeignKeysValidationEnabled();
        for (Resource dataPackageResource : this.dataPackage.getResources()) {
            if (isFkValidationEnabled) {
                dataPackageResource.checkRelations(this.dataPackage);
            }
            dataPackageResource.checkPrimaryKeys();
        }
    }
}

