/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.struts2.converter;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.util.Map;
import org.apache.commons.lang3.Range;
import org.apache.struts2.conversion.TypeConversionException;
import org.apache.struts2.util.StrutsTypeConverter;

public abstract class CoordinateFormatConverter
extends StrutsTypeConverter {
    private static final String ANGLE = "coordinate.angle";
    private static final char ALTERNATIVE_DECIMAL_SEPARATOR = ',';
    private static final String DECIMAL_PATTERN = "###.##";

    public Object convertFromString(Map context, String[] values, Class toClass) {
        if (values[0].isEmpty()) {
            return null;
        }
        Object coordObject = context.get(ANGLE);
        if (coordObject == null) {
            throw new TypeConversionException("Invalid decimal number: " + values[0]);
        }
        String coordinate = context.get(ANGLE).toString();
        Range range = coordinate.equals("LAT") ? Range.between((Comparable)Double.valueOf(-90.0), (Comparable)Double.valueOf(90.0)) : Range.between((Comparable)Double.valueOf(-180.0), (Comparable)Double.valueOf(180.0));
        try {
            Double number = Double.parseDouble(values[0]);
            if (range.contains((Object)number)) {
                return number;
            }
            throw new TypeConversionException("Invalid decimal number: " + values[0]);
        }
        catch (NumberFormatException e) {
            DecimalFormatSymbols symbols = new DecimalFormatSymbols();
            symbols.setDecimalSeparator(',');
            DecimalFormat decimal = new DecimalFormat(DECIMAL_PATTERN, symbols);
            try {
                Double number = decimal.parse(values[0]).doubleValue();
                if (range.contains((Object)number)) {
                    return number;
                }
                throw new TypeConversionException("Invalid decimal number: " + values[0]);
            }
            catch (ParseException e1) {
                throw new TypeConversionException("Invalid decimal number: " + values[0]);
            }
        }
    }

    public String convertToString(Map context, Object o) {
        if (o instanceof Double) {
            return o.toString();
        }
        throw new TypeConversionException("Invalid decimal number: " + o.toString());
    }
}

