/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.struts2;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.interceptor.AbstractInterceptor;
import java.util.HashSet;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.dispatcher.Parameter;
import org.gbif.ipt.action.BaseAction;
import org.gbif.ipt.config.ConfigWarnings;
import org.gbif.ipt.config.SetupAction;
import org.gbif.ipt.service.admin.ConfigManager;

public class SetupAndCancelInterceptor
extends AbstractInterceptor {
    private static final long serialVersionUID = 1988717332926909383L;
    private static final Logger LOG = LogManager.getLogger(SetupAndCancelInterceptor.class);
    public static final String SETUP_RESULTNAME = "setupIncomplete";
    private ConfigManager configManager;
    private ConfigWarnings warnings;

    public String intercept(ActionInvocation invocation) throws Exception {
        BaseAction ba;
        Object action;
        if (!this.configManager.setupComplete()) {
            Object action2 = invocation.getAction();
            if (action2 instanceof SetupAction) {
                return invocation.invoke();
            }
            LOG.info("Setup incomplete - redirect to setup");
            return SETUP_RESULTNAME;
        }
        Parameter cancel = invocation.getInvocationContext().getParameters().get((Object)"cancel");
        if (cancel.isDefined()) {
            action = invocation.getAction();
            if (action instanceof BaseAction) {
                ba = (BaseAction)action;
                ba.setCancel("true");
            } else {
                return "cancel";
            }
        }
        if (this.warnings.hasStartupErrors() && (action = invocation.getAction()) instanceof BaseAction) {
            ba = (BaseAction)action;
            HashSet<String> existing = new HashSet<String>();
            for (String warning : ba.getActionWarnings()) {
                if (existing.contains(StringUtils.trimToEmpty((String)warning))) continue;
                existing.add(warning);
            }
            for (String msg : this.warnings.getStartupErrors()) {
                if (existing.contains(StringUtils.trimToEmpty((String)msg))) continue;
                existing.add(msg);
            }
            ba.getActionWarnings().clear();
            ba.addActionWarning(ba.getText("admin.startup.warnings"));
            ba.getActionWarnings().addAll(existing);
        }
        return invocation.invoke();
    }

    @Inject
    public void setConfigManager(ConfigManager configManager) {
        this.configManager = configManager;
    }

    @Inject
    public void setWarnings(ConfigWarnings warnings) {
        this.warnings = warnings;
    }
}

