/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.struts2;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.interceptor.AbstractInterceptor;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.gbif.ipt.model.User;

public class RequireAdminInterceptor
extends AbstractInterceptor {
    private static final Logger LOG = LogManager.getLogger(RequireAdminInterceptor.class);

    public String intercept(ActionInvocation invocation) throws Exception {
        Map session = invocation.getInvocationContext().getSession();
        User user = (User)session.get("curr_user");
        if (user == null) {
            LOG.debug("User is not logged in, redirecting to login page");
            ActionContext context = invocation.getInvocationContext();
            HttpServletRequest request = (HttpServletRequest)context.get("com.opensymphony.xwork2.dispatcher.HttpServletRequest");
            String queryString = request.getQueryString();
            Object referer = request.getServletPath();
            if (queryString != null) {
                referer = (String)referer + "?" + queryString;
            }
            LOG.debug("Put referer into session: {}", referer);
            session.put("referer", referer);
            return "login";
        }
        if (user.hasAdminRights()) {
            return invocation.invoke();
        }
        return "401";
    }
}

