/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.struts2;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.Result;
import com.opensymphony.xwork2.interceptor.MethodFilterInterceptor;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.struts2.result.ServletActionRedirectResult;
import org.apache.struts2.result.ServletRedirectResult;
import org.gbif.ipt.action.BaseAction;

public class RedirectMessageInterceptor
extends MethodFilterInterceptor {
    private static final long serialVersionUID = -1847557437429753540L;
    public static final String FIELD_ERRORS_KEY = "RedirectMessageInterceptor_FieldErrors";
    public static final String ACTION_ERRORS_KEY = "RedirectMessageInterceptor_ActionErrors";
    public static final String ACTION_MESSAGES_KEY = "RedirectMessageInterceptor_ActionMessages";
    public static final String ACTION_WARNINGS_KEY = "RedirectMessageInterceptor_ActionWarnings";

    protected void after(ActionInvocation invocation, BaseAction action) throws Exception {
        Result result = invocation.getResult();
        if (result != null && (result instanceof ServletRedirectResult || result instanceof ServletActionRedirectResult)) {
            Map fieldErrors;
            Collection actionMessages;
            Collection actionErrors;
            Map session = invocation.getInvocationContext().getSession();
            List actionWarnings = action.getWarnings();
            if (actionWarnings != null && !actionWarnings.isEmpty()) {
                session.put(ACTION_WARNINGS_KEY, actionWarnings);
            }
            if ((actionErrors = action.getActionErrors()) != null && !actionErrors.isEmpty()) {
                session.put(ACTION_ERRORS_KEY, actionErrors);
            }
            if ((actionMessages = action.getActionMessages()) != null && !actionMessages.isEmpty()) {
                session.put(ACTION_MESSAGES_KEY, actionMessages);
            }
            if ((fieldErrors = action.getFieldErrors()) != null && !fieldErrors.isEmpty()) {
                session.put(FIELD_ERRORS_KEY, fieldErrors);
            }
        }
    }

    protected void before(ActionInvocation invocation, BaseAction action) throws Exception {
        Map fieldErrors;
        Collection actionMessages;
        Collection actionWarnings;
        Map session = invocation.getInvocationContext().getSession();
        Collection actionErrors = (Collection)session.remove(ACTION_ERRORS_KEY);
        if (actionErrors != null && !actionErrors.isEmpty()) {
            for (Object error : actionErrors) {
                action.addActionError((String)error);
            }
        }
        if ((actionWarnings = (Collection)session.remove(ACTION_WARNINGS_KEY)) != null && !actionWarnings.isEmpty()) {
            for (Object error : actionWarnings) {
                action.addActionWarning((String)error);
            }
        }
        if ((actionMessages = (Collection)session.remove(ACTION_MESSAGES_KEY)) != null && !actionMessages.isEmpty()) {
            for (String message : actionMessages) {
                action.addActionMessage(message);
            }
        }
        if ((fieldErrors = (Map)session.remove(FIELD_ERRORS_KEY)) != null && !fieldErrors.isEmpty()) {
            for (Map.Entry fieldError : fieldErrors.entrySet()) {
                for (String message : (List)fieldError.getValue()) {
                    action.addFieldError((String)fieldError.getKey(), message);
                }
            }
        }
    }

    public String doIntercept(ActionInvocation invocation) throws Exception {
        Object action = invocation.getAction();
        if (action instanceof BaseAction) {
            this.before(invocation, (BaseAction)action);
        }
        String result = invocation.invoke();
        if (action instanceof BaseAction) {
            this.after(invocation, (BaseAction)action);
        }
        return result;
    }
}

