/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.struts2;

import java.util.Locale;
import javax.inject.Inject;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.interceptor.I18nInterceptor;
import org.gbif.ipt.config.AppConfig;

public class IptI18nInterceptor
extends I18nInterceptor {
    private static final long serialVersionUID = -177385481327691899L;
    private static final Logger LOG = LogManager.getLogger(IptI18nInterceptor.class);
    private AppConfig appConfig;

    protected Locale getLocaleFromParam(Object requestedLocale) {
        Locale locale = null;
        try {
            if (requestedLocale != null) {
                Locale locale2 = locale = requestedLocale instanceof Locale ? (Locale)requestedLocale : LocaleUtils.toLocale((String)requestedLocale.toString());
                if (locale != null && LOG.isDebugEnabled()) {
                    LOG.debug("Applied request locale: {}", (Object)locale.getLanguage());
                }
            }
        }
        catch (IllegalArgumentException e) {
            LOG.debug("Invalid request locale: {}", requestedLocale);
            locale = Locale.getDefault();
        }
        if (Locale.ENGLISH.equals(locale)) {
            locale = Locale.UK;
        }
        if (locale != null && !this.appConfig.isSupportedLocale(locale)) {
            locale = Locale.getDefault();
        }
        return locale;
    }

    @Inject
    public void setAppConfig(AppConfig appConfig) {
        this.appConfig = appConfig;
    }
}

