/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.service.manage.impl;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Logger;
import org.gbif.dwc.Archive;
import org.gbif.dwc.ArchiveFile;
import org.gbif.dwc.DwcFiles;
import org.gbif.dwc.UnsupportedArchiveException;
import org.gbif.ipt.config.AppConfig;
import org.gbif.ipt.config.DataDir;
import org.gbif.ipt.model.ExcelFileSource;
import org.gbif.ipt.model.FileSource;
import org.gbif.ipt.model.Resource;
import org.gbif.ipt.model.RowIterable;
import org.gbif.ipt.model.Source;
import org.gbif.ipt.model.SqlSource;
import org.gbif.ipt.model.TextFileSource;
import org.gbif.ipt.model.UrlMetadata;
import org.gbif.ipt.model.UrlSource;
import org.gbif.ipt.service.AlreadyExistingException;
import org.gbif.ipt.service.BaseManager;
import org.gbif.ipt.service.ImportException;
import org.gbif.ipt.service.InvalidFilenameException;
import org.gbif.ipt.service.SourceException;
import org.gbif.ipt.service.file.DataFile;
import org.gbif.ipt.service.file.FileStoreManager;
import org.gbif.ipt.service.manage.ResourceUpdateListener;
import org.gbif.ipt.service.manage.SourceManager;
import org.gbif.ipt.service.manage.impl.SourceManagerImpl;
import org.gbif.ipt.utils.URLUtils;
import org.gbif.utils.file.ClosableIterator;
import org.gbif.utils.file.ClosableReportingIterator;
import org.gbif.utils.file.csv.UnknownDelimitersException;

/*
 * Exception performing whole class analysis ignored.
 */
public class SourceManagerImpl
extends BaseManager
implements SourceManager {
    private static final int FETCH_SIZE = 10;
    private static final int CONNECTION_TIMEOUT_SECS = 5;
    private static final String ACCEPTED_FILE_NAMES = "[\\w.\\-\\s\\)\\(]+";
    private FileStoreManager fileStoreManager;
    private Pattern acceptedPattern = Pattern.compile("[\\w.\\-\\s\\)\\(]+");
    private final List<ResourceUpdateListener> listeners = new ArrayList();

    public SourceManagerImpl(AppConfig cfg, DataDir dataDir, FileStoreManager fileStoreManager) {
        super(cfg, dataDir);
        this.fileStoreManager = fileStoreManager;
    }

    public static void copyArchiveFileProperties(File from, TextFileSource to) {
        to.setEncoding("UTF-8");
        to.setFieldsEnclosedBy(null);
        to.setFieldsTerminatedBy(",");
        to.setIgnoreHeaderLines(Integer.valueOf(1));
        to.setDateFormat("YYYY-MM-DD");
    }

    public static void copyArchiveFileProperties(ArchiveFile from, TextFileSource to) {
        to.setEncoding(from.getEncoding());
        to.setFieldsEnclosedBy(from.getFieldsEnclosedBy() == null ? "\"" : from.getFieldsEnclosedBy().toString());
        to.setFieldsTerminatedBy(from.getFieldsTerminatedBy());
        to.setIgnoreHeaderLines(from.getIgnoreHeaderLines());
        to.setDateFormat(from.getDateFormat());
    }

    public static void copyArchiveFileProperties(ArchiveFile from, UrlSource to) {
        to.setEncoding(from.getEncoding());
        to.setFieldsEnclosedBy(from.getFieldsEnclosedBy() == null ? "\"" : from.getFieldsEnclosedBy().toString());
        to.setFieldsTerminatedBy(from.getFieldsTerminatedBy());
        to.setIgnoreHeaderLines(from.getIgnoreHeaderLines());
        to.setDateFormat(from.getDateFormat());
    }

    protected boolean acceptableFileName(String fileName) {
        boolean matches = this.acceptedPattern.matcher(fileName).matches();
        if (!matches) {
            this.LOG.error("File name contains illegal characters: " + fileName);
        }
        return matches;
    }

    private ExcelFileSource addExcelFile() throws ImportException {
        ExcelFileSource src = new ExcelFileSource();
        src.setSheetIdx(0);
        return src;
    }

    private TextFileSource addTextFile(File file) throws ImportException {
        TextFileSource src = new TextFileSource();
        try {
            Archive arch = DwcFiles.fromLocation((Path)file.toPath());
            SourceManagerImpl.copyArchiveFileProperties((ArchiveFile)arch.getCore(), (TextFileSource)src);
        }
        catch (UnknownDelimitersException e) {
            this.LOG.warn(e.getMessage());
            throw new ImportException((Throwable)e);
        }
        catch (IOException e) {
            this.LOG.warn(e.getMessage());
            throw new ImportException((Throwable)e);
        }
        catch (UnsupportedArchiveException e) {
            this.LOG.warn(e.getMessage());
        }
        return src;
    }

    public FileSource add(Resource resource, File file, String fileName) throws ImportException, InvalidFilenameException {
        this.LOG.debug("ADDING SOURCE {} FROM {}", (Object)fileName, (Object)file.getAbsolutePath());
        if (this.acceptableFileName(fileName)) {
            String suffix = FilenameUtils.getExtension((String)fileName);
            Object src = suffix != null && (suffix.equalsIgnoreCase("xls") || suffix.equalsIgnoreCase("xlsx")) ? this.addExcelFile() : this.addTextFile(file);
            src.setName(fileName);
            src.setResource(resource);
            try {
                File ddFile = this.dataDir.sourceFile(resource, (FileSource)src);
                try {
                    FileUtils.copyFile((File)file, (File)ddFile);
                }
                catch (IOException e1) {
                    throw new ImportException((Throwable)e1);
                }
                src.setFile(ddFile);
                src.setLastModified(new Date());
                resource.addSource((Source)src, true);
            }
            catch (AlreadyExistingException e) {
                throw new ImportException((Throwable)e);
            }
            this.analyze((FileSource)src);
            return src;
        }
        throw new InvalidFilenameException("Filename contains illegal characters");
    }

    public UrlSource add(Resource resource, URI url, String sourceName) throws ImportException {
        String finalSourceName;
        this.LOG.debug("ADDING URL SOURCE {}", (Object)url);
        String filename = FilenameUtils.getName((String)url.toString());
        this.LOG.debug("File name: {}", (Object)filename);
        if (StringUtils.isEmpty((CharSequence)sourceName)) {
            finalSourceName = FilenameUtils.getBaseName((String)url.toString());
            this.LOG.debug("No source name provided, extract from URL: {}", (Object)finalSourceName);
        } else {
            finalSourceName = sourceName;
        }
        UrlSource src = new UrlSource();
        File file = this.dataDir.sourceFile(resource, filename);
        src.setFile(file);
        src.setProcessing(true);
        this.downloadDataFromUrlAsync(resource, url, sourceName);
        src.setName(finalSourceName);
        src.setUrl(url);
        src.setResource(resource);
        try {
            UrlMetadata urlMetadata = org.gbif.ipt.utils.FileUtils.fetchUrlMetadata((String)url.toString());
            src.setFileSize(urlMetadata.getContentLength());
        }
        catch (IOException e) {
            this.LOG.error("Failed to read URL metadata from {}: {}", (Object)url.toString(), (Object)e.getMessage());
        }
        try {
            src.setLastModified(new Date());
            resource.addSource((Source)src, true);
        }
        catch (AlreadyExistingException e) {
            throw new ImportException((Throwable)e);
        }
        return src;
    }

    private void downloadDataFromUrlAsync(Resource resource, URI url, String sourceName) {
        this.LOG.info("Staring asynchronous download data from the URL {}", (Object)url);
        UUID key = UUID.randomUUID();
        try {
            String encodedFileURL = url.toString();
            Optional redirectedUrl = URLUtils.getRedirectedUrl((String)encodedFileURL);
            if (redirectedUrl.isPresent()) {
                encodedFileURL = (String)redirectedUrl.get();
            }
            FileStoreManager.AsyncDownloadResult downloadResult = this.fileStoreManager.downloadDataFile(encodedFileURL, this.dataDir.tmpFile(key.toString()).getAbsolutePath(), resultDataFile -> {
                this.LOG.info("File has been downloaded and decompressed from URL {}, key {}", (Object)url, (Object)key);
                this.processSuccessfulDownload(key, resource, sourceName, resultDataFile);
            }, err -> {
                this.LOG.error("Error processing file", err);
                this.processFailedDownload(key, resource, sourceName, err.getMessage());
            });
            this.LOG.info("Asynchronous download {}", (Object)downloadResult);
        }
        catch (Exception e) {
            this.LOG.error("Failed to download data from URL {}", (Object)url);
            this.processFailedDownload(key, resource, sourceName, e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSuccessfulDownload(UUID key, Resource resource, String sourceName, DataFile dataFile) {
        this.LOG.info("Processing successful download {}", (Object)key);
        this.LOG.info("Data file: {}", (Object)dataFile);
        UrlSource src = (UrlSource)resource.getSource(sourceName);
        File downloadDir = this.dataDir.tmpFile(key.toString());
        try (Stream<Path> paths = Files.list(downloadDir.toPath()).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0]));){
            Optional<Path> matchingOccurrence;
            List files = paths.collect(Collectors.toList());
            Optional<Path> targetFile = matchingOccurrence = files.stream().filter(path -> {
                String name = path.getFileName().toString().toLowerCase();
                return name.contains("occurrence");
            }).findFirst();
            if (matchingOccurrence.isEmpty()) {
                Optional<Path> matchingEvent = files.stream().filter(path -> {
                    String name = path.getFileName().toString().toLowerCase();
                    return name.contains("event");
                }).findFirst();
                targetFile = matchingEvent;
                if (matchingEvent.isEmpty()) {
                    targetFile = files.stream().max(Comparator.comparingLong(path -> {
                        try {
                            return Files.size(path);
                        }
                        catch (IOException e) {
                            return -1L;
                        }
                    }));
                }
            }
            if (targetFile.isPresent()) {
                this.processFile(resource, targetFile.get(), src);
                for (Path file : files) {
                    if (targetFile.get().equals(file)) continue;
                    this.LOG.info("Skipped: {}", (Object)file.getFileName());
                }
            } else {
                this.LOG.error("Failed to get file for processing. Resource {}, source {}", (Object)resource.getShortname(), (Object)sourceName);
            }
            FileUtils.deleteDirectory((File)downloadDir);
            this.notifyListeners(resource);
        }
        catch (IOException e) {
            this.LOG.error("Failed to process downloaded file(s) {}", (Object)key, (Object)e);
        }
        finally {
            src.setProcessing(false);
        }
    }

    private void processFile(Resource resource, Path targetFile, UrlSource src) throws IOException {
        this.LOG.info("Processing: {}", (Object)targetFile.getFileName());
        File sourceFile = this.dataDir.sourceFile(resource, targetFile.getFileName().toString());
        sourceFile.createNewFile();
        FileUtils.copyFile((File)targetFile.toFile(), (File)sourceFile);
        this.LOG.info("Filed {} copied to resource {} sources", (Object)targetFile.getFileName(), (Object)resource.getShortname());
        src.setFile(sourceFile);
        Archive arch = DwcFiles.fromLocation((Path)sourceFile.toPath());
        SourceManagerImpl.copyArchiveFileProperties((ArchiveFile)arch.getCore(), (UrlSource)src);
        this.LOG.info("Start analyzing source file {}", (Object)sourceFile);
        src.analyze();
    }

    private void processFailedDownload(UUID key, Resource resource, String sourceName, String errorMessage) {
        this.LOG.error("Error processing source {} with key {} for resource {}: {}", (Object)sourceName, (Object)key, (Object)resource.getShortname(), (Object)errorMessage);
        Source source = resource.getSource(sourceName);
        if (source != null) {
            source.setProcessing(false);
            source.setReadable(false);
        }
        this.notifyListeners(resource);
    }

    public String analyze(Source source) {
        if (source instanceof SqlSource) {
            return this.analyze((SqlSource)source);
        }
        if (source instanceof UrlSource) {
            return this.analyzeAsync((UrlSource)source);
        }
        return this.analyze((FileSource)source);
    }

    private String analyzeAsync(UrlSource src) {
        if (src.isProcessing()) {
            this.LOG.info("URL source {} is already processing", (Object)src.getName());
            return null;
        }
        src.setProcessing(true);
        this.downloadDataFromUrlAsync(src.getResource(), src.getUrl(), src.getName());
        return null;
    }

    private String analyze(UrlSource src) {
        File logFile = this.dataDir.sourceLogFile(src.getResource().getShortname(), src.getName());
        try {
            Set emptyLines;
            FileUtils.deleteQuietly((File)logFile);
            try {
                emptyLines = src.analyze();
            }
            catch (IOException e) {
                return e.getMessage();
            }
            try (BufferedWriter logWriter = Files.newBufferedWriter(logFile.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
                logWriter.write("Log for source name:" + src.getName() + " from resource: " + src.getResource().getShortname() + "\n");
                if (!emptyLines.isEmpty()) {
                    for (Integer i : emptyLines.stream().sorted().collect(Collectors.toList())) {
                        logWriter.write("Line: " + i + " [EMPTY LINE]\n");
                    }
                } else {
                    logWriter.write("No rows were skipped in this source");
                }
                logWriter.flush();
            }
        }
        catch (IOException e) {
            this.LOG.warn("Can't write source log file " + logFile.getAbsolutePath(), (Throwable)e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String analyze(SqlSource ss) {
        String problem = null;
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            con = this.getDbConnection(ss);
            if (StringUtils.trimToNull((String)ss.getSql()) != null) {
                stmt = con.createStatement(1003, 1007);
                if (ss.getJdbcDriver() != null && !ss.getJdbcDriver().contains("odbc")) {
                    stmt.setFetchSize(10);
                }
                this.LOG.debug("Executing SQL {}", (Object)ss.getSqlLimited(10));
                rs = stmt.executeQuery(ss.getSqlLimited(10));
                ResultSetMetaData meta = rs.getMetaData();
                ss.setColumns(meta.getColumnCount());
                ss.setReadable(true);
            }
        }
        catch (SQLException e) {
            this.LOG.warn("Can't read SQL source " + String.valueOf(ss), (Throwable)e);
            problem = e.getMessage();
            ss.setReadable(false);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    this.LOG.error("ResultSet could not be closed: " + e.getMessage(), (Throwable)e);
                }
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    this.LOG.error("Statement could not be closed: " + e.getMessage(), (Throwable)e);
                }
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException e) {
                    this.LOG.error("Connection could not be closed: " + e.getMessage(), (Throwable)e);
                }
            }
        }
        return problem;
    }

    private String analyze(FileSource src) {
        String problem = null;
        File logFile = this.dataDir.sourceLogFile(src.getResource().getShortname(), src.getName());
        try {
            Set emptyLines;
            FileUtils.deleteQuietly((File)logFile);
            try {
                emptyLines = src.analyze();
            }
            catch (IOException e) {
                return e.getMessage();
            }
            try (BufferedWriter logWriter = Files.newBufferedWriter(logFile.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
                logWriter.write("Log for source name:" + src.getName() + " from resource: " + src.getResource().getShortname() + "\n");
                if (!emptyLines.isEmpty()) {
                    for (Integer i : emptyLines.stream().sorted().collect(Collectors.toList())) {
                        logWriter.write("Line: " + i + " [EMPTY LINE]\n");
                    }
                } else {
                    logWriter.write("No rows were skipped in this source");
                }
                logWriter.flush();
            }
        }
        catch (IOException e) {
            this.LOG.warn("Can't write source log file " + logFile.getAbsolutePath(), (Throwable)e);
            problem = e.getMessage();
        }
        return problem;
    }

    public List<String> columns(Source source) {
        if (source == null) {
            return new ArrayList<String>();
        }
        if (source instanceof SqlSource) {
            return this.columns((SqlSource)source);
        }
        if (source instanceof UrlSource) {
            return ((UrlSource)source).columns();
        }
        return ((FileSource)source).columns();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> columns(SqlSource source) {
        ArrayList<String> columns = new ArrayList<String>();
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            con = this.getDbConnection(source);
            if (con != null) {
                stmt = con.createStatement(1003, 1007);
                if (source.getJdbcDriver() != null && !source.getJdbcDriver().contains("odbc")) {
                    stmt.setFetchSize(1);
                }
                this.LOG.debug("Executing SQL {}", (Object)source.getSqlLimited(1));
                rs = stmt.executeQuery(source.getSqlLimited(1));
                ResultSetMetaData meta = rs.getMetaData();
                int max = meta.getColumnCount();
                for (int idx = 1; idx <= max; ++idx) {
                    columns.add(meta.getColumnLabel(idx));
                }
            } else {
                String msg = "Can't read SQL source, the connection couldn't be created with the current parameters";
                columns.add(msg);
                this.LOG.warn(msg + " " + String.valueOf(source));
            }
        }
        catch (SQLException e) {
            this.LOG.warn("Can't read SQL source " + String.valueOf(source), (Throwable)e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    this.LOG.error("ResultSet could not be closed: " + e.getMessage(), (Throwable)e);
                }
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    this.LOG.error("Statement could not be closed: " + e.getMessage(), (Throwable)e);
                }
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException e) {
                    this.LOG.error("Connection could not be closed: " + e.getMessage(), (Throwable)e);
                }
            }
        }
        return columns;
    }

    public boolean delete(Resource resource, Source source) {
        TextFileSource fs;
        UrlSource us;
        boolean delete;
        if (source == null) {
            return false;
        }
        resource.deleteSource(source);
        if (source instanceof UrlSource && !(delete = (us = (UrlSource)source).getFile().delete())) {
            this.LOG.error("Failed to delete the local file {} for the URL source {} of the resource {}", (Object)us.getFile().getAbsolutePath(), (Object)source.getName(), (Object)resource.getShortname());
        }
        if (source instanceof TextFileSource && !(delete = (fs = (TextFileSource)source).getFile().delete())) {
            this.LOG.error("Failed to delete the file {} for the Text file source {} of the resource {}", (Object)fs.getFile().getAbsolutePath(), (Object)source.getName(), (Object)resource.getShortname());
        }
        if (source instanceof ExcelFileSource) {
            ExcelFileSource es = (ExcelFileSource)source;
            boolean del = true;
            for (Source src : resource.getSources()) {
                if (src.equals(es) || !src.isExcelSource() || !((ExcelFileSource)src).getFile().equals(es.getFile())) continue;
                del = false;
                break;
            }
            if (del && !(del = es.getFile().delete())) {
                this.LOG.error("Failed to delete the file {} for the Excel file source {} of the resource {}", (Object)es.getFile().getAbsolutePath(), (Object)source.getName(), (Object)resource.getShortname());
            }
        }
        return true;
    }

    private Connection getDbConnection(SqlSource source) throws SQLException {
        Connection conn = null;
        if (source.getHost() != null && source.getJdbcUrl() != null && source.getJdbcDriver() != null) {
            try {
                DriverManager.setLoginTimeout(5);
                Class.forName(source.getJdbcDriver());
                conn = DriverManager.getConnection(source.getJdbcUrl(), source.getUsername(), source.getPassword());
                conn.setAutoCommit(false);
                for (SQLWarning warn = conn.getWarnings(); warn != null; warn = warn.getNextWarning()) {
                    this.LOG.warn("SQLWarning: state=" + warn.getSQLState() + ", message=" + warn.getMessage() + ", vendor=" + warn.getErrorCode());
                }
            }
            catch (ClassNotFoundException e) {
                String msg = String.format("Couldn't load JDBC driver to create new external datasource connection with JDBC Class=%s and URL=%s. Error: %s", source.getJdbcDriver(), source.getJdbcUrl(), e.getMessage());
                this.LOG.warn(msg, (Throwable)e);
                throw new SQLException(msg, e);
            }
            catch (Exception e) {
                String msg = String.format("Couldn't create new external datasource connection with JDBC Class=%s, URL=%s, user=%s. Error: %s", source.getJdbcDriver(), source.getJdbcUrl(), source.getUsername(), e.getMessage());
                this.LOG.warn(msg, (Throwable)e);
                throw new SQLException(msg);
            }
        }
        return conn;
    }

    public Set<String> inspectColumn(Source source, int column, int maxValues, int maxRows) throws SourceException {
        HashSet<String> values = new HashSet<String>();
        try (ClosableIterator iter = this.iterSourceColumn(source, column, maxRows);){
            while (iter.hasNext() && (maxValues < 1 || values.size() < maxValues)) {
                Object obj = iter.next();
                if (obj == null) continue;
                String val = obj.toString();
                values.add(val);
            }
        }
        catch (Exception e) {
            this.LOG.error((Object)e);
            throw new SourceException("Error reading source " + source.getName() + ": " + e.getMessage());
        }
        return values;
    }

    private ClosableIterator<Object> iterSourceColumn(Source source, int column, int limit) throws Exception {
        if (source instanceof SqlSource) {
            SqlSource src = (SqlSource)source;
            if (limit > 0) {
                return new SqlColumnIterator(this, src, column, limit);
            }
            return new SqlColumnIterator(this, src, column);
        }
        return new ColumnIterator((RowIterable)source, column);
    }

    public List<String[]> peek(Source source, int rows) {
        if (source instanceof SqlSource) {
            return this.peek((SqlSource)source, rows);
        }
        return this.peek((RowIterable)source, rows);
    }

    private List<String[]> peek(RowIterable source, int rows) {
        ArrayList<String[]> preview = new ArrayList<String[]>();
        if (source != null) {
            try (ClosableReportingIterator iter = source.rowIterator();){
                while (rows > 0 && iter.hasNext()) {
                    --rows;
                    preview.add((String[])iter.next());
                }
            }
            catch (Exception e) {
                this.LOG.warn("Can't peek into source " + ((Source)source).getName(), (Throwable)e);
            }
        }
        return preview;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String[]> peek(SqlSource source, int rows) {
        ArrayList<String[]> preview = new ArrayList<String[]>();
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            con = this.getDbConnection(source);
            if (con != null) {
                stmt = con.createStatement(1003, 1007);
                if (source.getJdbcDriver() != null && !source.getJdbcDriver().contains("odbc")) {
                    stmt.setFetchSize(rows);
                }
                this.LOG.debug("Executing SQL {}", (Object)source.getSqlLimited(rows + 1));
                rs = stmt.executeQuery(source.getSqlLimited(rows + 1));
                while (rows > 0 && rs.next()) {
                    --rows;
                    String[] row = new String[source.getColumns()];
                    for (int idx = 0; idx < source.getColumns(); ++idx) {
                        row[idx] = rs.getString(idx + 1);
                    }
                    preview.add(row);
                }
            }
        }
        catch (SQLException e) {
            this.LOG.warn("Can't read SQL source " + String.valueOf(source), (Throwable)e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    this.LOG.error("ResultSet could not be closed: " + e.getMessage(), (Throwable)e);
                }
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    this.LOG.error("Statement could not be closed: " + e.getMessage(), (Throwable)e);
                }
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException e) {
                    this.LOG.error("Connection could not be closed: " + e.getMessage(), (Throwable)e);
                }
            }
        }
        return preview;
    }

    public ClosableReportingIterator<String[]> rowIterator(Source source) throws SourceException {
        if (source == null) {
            return null;
        }
        try {
            if (source instanceof SqlSource) {
                return new SqlRowIterator(this, (SqlSource)source);
            }
            return ((RowIterable)source).rowIterator();
        }
        catch (Exception e) {
            this.LOG.error("Exception while reading source " + source.getName(), (Throwable)e);
            throw new SourceException("Can't build iterator for source " + source.getName() + " :" + e.getMessage());
        }
    }

    public void addListener(ResourceUpdateListener listener) {
        this.listeners.add(listener);
    }

    private void notifyListeners(Resource resource) {
        for (ResourceUpdateListener listener : this.listeners) {
            listener.onSourceUpdated(resource);
        }
    }

    static /* synthetic */ Logger access$000(SourceManagerImpl x0) {
        return x0.LOG;
    }

    static /* synthetic */ Logger access$100(SourceManagerImpl x0) {
        return x0.LOG;
    }

    static /* synthetic */ Logger access$200(SourceManagerImpl x0) {
        return x0.LOG;
    }

    static /* synthetic */ Logger access$300(SourceManagerImpl x0) {
        return x0.LOG;
    }

    static /* synthetic */ Logger access$400(SourceManagerImpl x0) {
        return x0.LOG;
    }

    static /* synthetic */ Logger access$500(SourceManagerImpl x0) {
        return x0.LOG;
    }
}

