/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.service.manage.impl;

import java.text.ParseException;
import java.time.YearMonth;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.ChronoZonedDateTime;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.gbif.common.parsers.core.OccurrenceParseResult;
import org.gbif.common.parsers.core.ParseResult;
import org.gbif.common.parsers.date.DateParsers;
import org.gbif.common.parsers.date.TemporalParser;
import org.gbif.common.parsers.geospatial.CoordinateParseUtils;
import org.gbif.common.parsers.geospatial.LatLng;
import org.gbif.ipt.action.portal.OrganizedTaxonomicCoverage;
import org.gbif.ipt.action.portal.OrganizedTaxonomicKeywords;
import org.gbif.ipt.config.Constants;
import org.gbif.ipt.model.DataPackageFieldMapping;
import org.gbif.ipt.model.DataPackageMapping;
import org.gbif.ipt.model.DataPackageTableSchemaName;
import org.gbif.ipt.model.ExtensionMapping;
import org.gbif.ipt.model.InferredCamtrapGeographicScope;
import org.gbif.ipt.model.InferredCamtrapMetadata;
import org.gbif.ipt.model.InferredCamtrapTaxonomicScope;
import org.gbif.ipt.model.InferredCamtrapTemporalScope;
import org.gbif.ipt.model.InferredEmlGeographicCoverage;
import org.gbif.ipt.model.InferredEmlMetadata;
import org.gbif.ipt.model.InferredEmlTaxonomicCoverage;
import org.gbif.ipt.model.InferredEmlTemporalCoverage;
import org.gbif.ipt.model.InferredMetadata;
import org.gbif.ipt.model.PropertyMapping;
import org.gbif.ipt.model.Resource;
import org.gbif.ipt.model.datapackage.metadata.camtrap.Taxonomic;
import org.gbif.ipt.service.admin.VocabulariesManager;
import org.gbif.ipt.service.manage.ResourceMetadataInferringService;
import org.gbif.ipt.service.manage.SourceManager;
import org.gbif.ipt.service.manage.impl.ResourceMetadataInferringServiceImpl;
import org.gbif.metadata.eml.ipt.model.BBox;
import org.gbif.metadata.eml.ipt.model.GeospatialCoverage;
import org.gbif.metadata.eml.ipt.model.Point;
import org.gbif.metadata.eml.ipt.model.TaxonKeyword;
import org.gbif.metadata.eml.ipt.model.TaxonomicCoverage;
import org.gbif.metadata.eml.ipt.model.TemporalCoverage;
import org.gbif.metadata.eml.ipt.util.DateUtils;
import org.gbif.utils.file.ClosableReportingIterator;

public class ResourceMetadataInferringServiceImpl
implements ResourceMetadataInferringService {
    protected final Logger LOG = LogManager.getLogger(ResourceMetadataInferringServiceImpl.class);
    private static final String CAMTRAP_DEPLOYMENTS = "deployments";
    private static final String CAMTRAP_OBSERVATIONS = "observations";
    public static final String CAMTRAP_OBSERVATIONS_SCIENTIFIC_NAME = "scientificName";
    public static final String CAMTRAP_DEPLOYMENTS_LATITUDE = "latitude";
    public static final String CAMTRAP_DEPLOYMENTS_LONGITUDE = "longitude";
    public static final String CAMTRAP_DEPLOYMENTS_DEPLOYMENT_START = "deploymentStart";
    public static final String CAMTRAP_DEPLOYMENTS_DEPLOYMENT_END = "deploymentEnd";
    public static final int TAXON_LIMIT = 100;
    private final SourceManager sourceManager;
    private final VocabulariesManager vocabManager;

    public ResourceMetadataInferringServiceImpl(SourceManager sourceManager, VocabulariesManager vocabManager) {
        this.sourceManager = sourceManager;
        this.vocabManager = vocabManager;
    }

    public InferredMetadata inferMetadata(Resource resource) {
        if (resource.isDataPackage()) {
            if ("camtrap-dp".equals(resource.getCoreType())) {
                return this.inferCamtrapMetadata(resource);
            }
            this.LOG.error("Metadata inferring is not supported for the type {}", (Object)resource.getCoreType());
            return null;
        }
        return this.inferEmlMetadata(resource);
    }

    private InferredEmlMetadata inferEmlMetadata(Resource resource) {
        InferredEmlMetadata inferredMetadata = new InferredEmlMetadata();
        InferredEmlMetadataParams params = new InferredEmlMetadataParams();
        boolean mappingsExist = this.mappingsExist(resource, params);
        if (mappingsExist) {
            for (ExtensionMapping mapping : resource.getMappings()) {
                this.processMapping(mapping, params);
            }
        }
        this.finalizeInferredMetadata(inferredMetadata, params);
        inferredMetadata.setLastModified(new Date());
        return inferredMetadata;
    }

    private boolean mappingsExist(Resource resource, InferredEmlMetadataParams params) {
        boolean mappingsExist;
        params.geographic.mappingsExist = mappingsExist = !resource.getMappings().isEmpty();
        params.temporal.mappingsExist = mappingsExist;
        params.taxonomic.mappingsExist = mappingsExist;
        return mappingsExist;
    }

    private void finalizeInferredMetadata(InferredEmlMetadata metadata, InferredEmlMetadataParams params) {
        this.finalizeInferredMetadata(metadata, params.geographic);
        this.finalizeInferredMetadata(metadata, params.temporal);
        this.finalizeInferredMetadata(metadata, params.taxonomic);
    }

    private void finalizeInferredMetadata(InferredEmlMetadata metadata, InferredEmlGeographicMetadataParams params) {
        InferredEmlGeographicCoverage inferredGeographicMetadata = new InferredEmlGeographicCoverage();
        metadata.setInferredGeographicCoverage(inferredGeographicMetadata);
        boolean errorOccurredWhileProcessingGeographicMetadata = this.handleEmlGeographicMetadataErrors(inferredGeographicMetadata, params);
        if (!errorOccurredWhileProcessingGeographicMetadata) {
            inferredGeographicMetadata.setInferred(true);
            GeospatialCoverage geospatialCoverage = new GeospatialCoverage();
            geospatialCoverage.setBoundingCoordinates(new BBox(new Point(params.minDecimalLatitude, params.minDecimalLongitude), new Point(params.maxDecimalLatitude, params.maxDecimalLongitude)));
            inferredGeographicMetadata.setData(geospatialCoverage);
        }
    }

    private void finalizeInferredMetadata(InferredEmlMetadata metadata, InferredEmlTemporalMetadataParams params) {
        InferredEmlTemporalCoverage inferredTemporalMetadata = new InferredEmlTemporalCoverage();
        metadata.setInferredTemporalCoverage(inferredTemporalMetadata);
        boolean errorOccurredWhileProcessingGeographicMetadata = this.handleEmlTemporalMetadataErrors(inferredTemporalMetadata, params);
        if (!errorOccurredWhileProcessingGeographicMetadata) {
            TemporalCoverage tempCoverage = new TemporalCoverage();
            try {
                tempCoverage.setStart(params.startDateTA.toString());
                tempCoverage.setEnd(params.endDateTA.toString());
                inferredTemporalMetadata.setInferred(true);
                inferredTemporalMetadata.setData(tempCoverage);
            }
            catch (ParseException e) {
                this.LOG.error("Failed to parse date for temporal coverage", (Throwable)e);
                inferredTemporalMetadata.addError("eml.temporalCoverages.error.dateParseException");
            }
        }
    }

    private void finalizeInferredMetadata(InferredEmlMetadata metadata, InferredEmlTaxonomicMetadataParams params) {
        InferredEmlTaxonomicCoverage inferredTaxonomicMetadata = new InferredEmlTaxonomicCoverage();
        metadata.setInferredTaxonomicCoverage(inferredTaxonomicMetadata);
        boolean errorOccurredWhileProcessingTaxonomicMetadata = this.handleEmlTaxonomicMetadataErrors(inferredTaxonomicMetadata, params);
        if (!errorOccurredWhileProcessingTaxonomicMetadata) {
            TaxonomicCoverage taxCoverage = new TaxonomicCoverage();
            taxCoverage.setTaxonKeywords(new ArrayList(params.taxa));
            OrganizedTaxonomicCoverage organizedTaxCoverage = this.constructOrganizedTaxonomicCoverage(taxCoverage);
            inferredTaxonomicMetadata.setInferred(true);
            inferredTaxonomicMetadata.setData(taxCoverage);
            inferredTaxonomicMetadata.setOrganizedData(organizedTaxCoverage);
        }
    }

    private boolean handleEmlGeographicMetadataErrors(InferredEmlGeographicCoverage inferredGeographicMetadata, InferredEmlGeographicMetadataParams params) {
        boolean errorsPresent = false;
        if (params.serverError) {
            inferredGeographicMetadata.addError("eml.error.serverError");
            errorsPresent = true;
        } else if (!params.mappingsExist) {
            inferredGeographicMetadata.addError("eml.error.noMappings");
            errorsPresent = true;
        } else if (!params.isDecimalLatitudeMappedForAtLeastOneMapping() || !params.isDecimalLongitudeMappedForAtLeastOneMapping()) {
            inferredGeographicMetadata.addError("eml.geospatialCoverages.error.fieldsNotMapped");
            errorsPresent = true;
        } else if (params.noValidDataGeo) {
            inferredGeographicMetadata.addError("eml.error.noValidData");
            errorsPresent = true;
        }
        return errorsPresent;
    }

    private boolean handleEmlTemporalMetadataErrors(InferredEmlTemporalCoverage inferredTemporalMetadata, InferredEmlTemporalMetadataParams params) {
        boolean errorsPresent = false;
        if (params.serverError) {
            inferredTemporalMetadata.addError("eml.error.serverError");
            errorsPresent = true;
        } else if (!params.mappingsExist) {
            inferredTemporalMetadata.addError("eml.error.noMappings");
            errorsPresent = true;
        } else if (!params.isEventDatePropertyMappedForAtLeastOneMapping()) {
            inferredTemporalMetadata.addError("eml.temporalCoverages.error.fieldsNotMapped");
            errorsPresent = true;
        } else if (params.noValidDataTemporal) {
            inferredTemporalMetadata.addError("eml.error.noValidData");
            errorsPresent = true;
        }
        return errorsPresent;
    }

    private boolean handleEmlTaxonomicMetadataErrors(InferredEmlTaxonomicCoverage inferredTaxonomicMetadata, InferredEmlTaxonomicMetadataParams params) {
        boolean errorsPresent = false;
        if (params.serverError) {
            inferredTaxonomicMetadata.addError("eml.error.serverError");
            errorsPresent = true;
        } else if (!params.mappingsExist) {
            inferredTaxonomicMetadata.addError("eml.error.noMappings");
            errorsPresent = true;
        } else if (!params.isDataMapped()) {
            inferredTaxonomicMetadata.addError("eml.taxonomicCoverages.error.fieldsNotMapped");
            errorsPresent = true;
        } else if (params.taxonItemsAdded == 0) {
            inferredTaxonomicMetadata.addError("eml.error.noValidData");
            errorsPresent = true;
        }
        if (params.kingdomsLimitExceeded) {
            inferredTaxonomicMetadata.addRankWarning("kingdom", "eml.warning.limitExceeded");
        }
        if (params.phylumsLimitExceeded) {
            inferredTaxonomicMetadata.addRankWarning("phylum", "eml.warning.limitExceeded");
        }
        if (params.classesLimitExceeded) {
            inferredTaxonomicMetadata.addRankWarning("class", "eml.warning.limitExceeded");
        }
        if (params.ordersLimitExceeded) {
            inferredTaxonomicMetadata.addRankWarning("order", "eml.warning.limitExceeded");
        }
        if (params.familiesLimitExceeded) {
            inferredTaxonomicMetadata.addRankWarning("family", "eml.warning.limitExceeded");
        }
        return errorsPresent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processMapping(ExtensionMapping mapping, InferredEmlMetadataParams params) {
        BiConsumer<String[], InferredEmlMetadataParams> lineProcessor;
        if (Constants.DWC_ROWTYPE_OCCURRENCE.equals(mapping.getExtension().getRowType())) {
            this.findGeoAndTemporalFieldsIndexes(mapping, params);
            this.findTaxaFieldsIndexes(mapping, params);
            lineProcessor = (arg_0, arg_1) -> this.occurrenceMappingLineProcessor(arg_0, arg_1);
        } else if (Constants.DWC_ROWTYPE_EVENT.equals(mapping.getExtension().getRowType())) {
            this.findGeoAndTemporalFieldsIndexes(mapping, params);
            lineProcessor = (arg_0, arg_1) -> this.eventMappingLineProcessor(arg_0, arg_1);
        } else if (Constants.DWC_ROWTYPE_TAXON.equals(mapping.getExtension().getRowType())) {
            this.findTaxaFieldsIndexes(mapping, params);
            lineProcessor = (arg_0, arg_1) -> this.taxonMappingLineProcessor(arg_0, arg_1);
        } else {
            return;
        }
        ClosableReportingIterator iter = null;
        try {
            iter = this.sourceManager.rowIterator(mapping.getSource());
            while (iter.hasNext()) {
                String[] in = (String[])iter.next();
                if (in == null || in.length == 0) continue;
                lineProcessor.accept(in, params);
            }
        }
        catch (com.github.pjfanning.xlsx.exceptions.ParseException e) {
            this.LOG.error("Error while trying to infer metadata: {}", (Object)e.getMessage());
        }
        catch (Exception e) {
            this.LOG.error("Error while trying to infer metadata from source data", (Throwable)e);
            params.geographic.serverError = true;
            params.temporal.serverError = true;
            params.taxonomic.serverError = true;
        }
        finally {
            if (iter != null) {
                try {
                    iter.close();
                }
                catch (Exception e) {
                    this.LOG.error("Error while closing iterator", (Throwable)e);
                    params.geographic.serverError = true;
                    params.temporal.serverError = true;
                    params.taxonomic.serverError = true;
                }
            }
        }
    }

    private void occurrenceMappingLineProcessor(String[] in, InferredEmlMetadataParams params) {
        this.processLine(in, params.geographic);
        this.processLine(in, params.temporal);
        this.processLine(in, params.taxonomic);
    }

    private void eventMappingLineProcessor(String[] in, InferredEmlMetadataParams params) {
        this.processLine(in, params.geographic);
        this.processLine(in, params.temporal);
    }

    private void taxonMappingLineProcessor(String[] in, InferredEmlMetadataParams params) {
        this.processLine(in, params.taxonomic);
    }

    private void findGeoAndTemporalFieldsIndexes(ExtensionMapping mapping, InferredEmlMetadataParams params) {
        params.geographic.resetIndexParams();
        params.temporal.resetIndexParams();
        for (PropertyMapping field : mapping.getFields()) {
            if ("http://rs.tdwg.org/dwc/terms/decimalLongitude".equals(field.getTerm().qualifiedName())) {
                if (field.getIndex() != null) {
                    params.geographic.decimalLongitudeSourceColumnIndex = field.getIndex();
                    params.geographic.decimalLatitudeSourceColumnPresentInOneOfMappings = true;
                    continue;
                }
                if (field.getDefaultValue() != null) {
                    params.geographic.decimalLongitudeSourceDefaultValue = field.getDefaultValue();
                    continue;
                }
                this.LOG.error("There is no index nor default value for decimalLongitude, something wrong with the mapping: {}", (Object)field);
                continue;
            }
            if ("http://rs.tdwg.org/dwc/terms/decimalLatitude".equals(field.getTerm().qualifiedName())) {
                if (field.getIndex() != null) {
                    params.geographic.decimalLatitudeSourceColumnIndex = field.getIndex();
                    params.geographic.decimalLongitudeSourceColumnPresentInOneOfMappings = true;
                    continue;
                }
                if (field.getDefaultValue() != null) {
                    params.geographic.decimalLatitudeSourceDefaultValue = field.getDefaultValue();
                    continue;
                }
                this.LOG.error("There is no index nor default value for decimalLatitude, something wrong with the mapping: {}", (Object)field);
                continue;
            }
            if (!"http://rs.tdwg.org/dwc/terms/eventDate".equals(field.getTerm().qualifiedName())) continue;
            if (field.getIndex() != null) {
                params.temporal.eventDateSourceColumnIndex = field.getIndex();
                params.temporal.eventDateSourceColumnPresentInOneOfMappings = true;
                continue;
            }
            if (field.getDefaultValue() != null) {
                params.temporal.eventDateSourceDefaultValue = field.getDefaultValue();
                continue;
            }
            this.LOG.error("There is no index or default value for eventDate, something is wrong with the mapping: {}", (Object)field);
        }
    }

    private void findTaxaFieldsIndexes(ExtensionMapping mapping, InferredEmlMetadataParams params) {
        params.taxonomic.resetIndexParams();
        for (PropertyMapping field : mapping.getFields()) {
            if ("http://rs.tdwg.org/dwc/terms/kingdom".equals(field.getTerm().qualifiedName())) {
                if (field.getIndex() != null) {
                    params.taxonomic.kingdomSourceColumnIndex = field.getIndex();
                    continue;
                }
                if (field.getDefaultValue() != null) {
                    params.taxonomic.kingdomSourceDefaultValue = field.getDefaultValue();
                    continue;
                }
                this.LOG.error("There is no index nor default value for kingdom, something wrong with the mapping: {}", (Object)field);
                continue;
            }
            if ("http://rs.tdwg.org/dwc/terms/phylum".equals(field.getTerm().qualifiedName())) {
                if (field.getIndex() != null) {
                    params.taxonomic.phylumSourceColumnIndex = field.getIndex();
                    continue;
                }
                if (field.getDefaultValue() != null) {
                    params.taxonomic.phylumSourceDefaultValue = field.getDefaultValue();
                    continue;
                }
                this.LOG.error("There is no index or default value for phylum, something is wrong with the mapping: {}", (Object)field);
                continue;
            }
            if ("http://rs.tdwg.org/dwc/terms/class".equals(field.getTerm().qualifiedName())) {
                if (field.getIndex() != null) {
                    params.taxonomic.classSourceColumnIndex = field.getIndex();
                    continue;
                }
                if (field.getDefaultValue() != null) {
                    params.taxonomic.classSourceDefaultValue = field.getDefaultValue();
                    continue;
                }
                this.LOG.error("There is no index or default value for class, something is wrong with the mapping: {}", (Object)field);
                continue;
            }
            if ("http://rs.tdwg.org/dwc/terms/order".equals(field.getTerm().qualifiedName())) {
                if (field.getIndex() != null) {
                    params.taxonomic.orderSourceColumnIndex = field.getIndex();
                    continue;
                }
                if (field.getDefaultValue() != null) {
                    params.taxonomic.orderSourceDefaultValue = field.getDefaultValue();
                    continue;
                }
                this.LOG.error("There is no index or default value for order, something is wrong with the mapping: {}", (Object)field);
                continue;
            }
            if (!"http://rs.tdwg.org/dwc/terms/family".equals(field.getTerm().qualifiedName())) continue;
            if (field.getIndex() != null) {
                params.taxonomic.familySourceColumnIndex = field.getIndex();
                continue;
            }
            if (field.getDefaultValue() != null) {
                params.taxonomic.familySourceDefaultValue = field.getDefaultValue();
                continue;
            }
            this.LOG.error("There is no index or default value for family, something is wrong with the mapping: {}", (Object)field);
        }
    }

    private void processLine(String[] in, InferredEmlGeographicMetadataParams params) {
        String rawLongitudeValue;
        String rawLatitudeValue;
        OccurrenceParseResult latLngParseResult;
        LatLng latLng;
        if (params.isDecimalLongitudePropertyMapped() && params.isDecimalLatitudePropertyMapped() && params.isColumnIndexesWithingRanges(in.length) && (latLng = (LatLng)(latLngParseResult = CoordinateParseUtils.parseLatLng((String)(rawLatitudeValue = params.decimalLatitudeSourceDefaultValue != null ? params.decimalLatitudeSourceDefaultValue : in[params.decimalLatitudeSourceColumnIndex]), (String)(rawLongitudeValue = params.decimalLongitudeSourceDefaultValue != null ? params.decimalLongitudeSourceDefaultValue : in[params.decimalLongitudeSourceColumnIndex]))).getPayload()) != null && latLngParseResult.isSuccessful()) {
            params.noValidDataGeo = false;
            if (!params.coordinatesInitialized) {
                params.minDecimalLatitude = latLng.getLat();
                params.maxDecimalLatitude = latLng.getLat();
                params.minDecimalLongitude = latLng.getLng();
                params.maxDecimalLongitude = latLng.getLng();
                params.coordinatesInitialized = true;
            }
            if (latLng.getLat() > params.maxDecimalLatitude) {
                params.maxDecimalLatitude = latLng.getLat();
            }
            if (latLng.getLat() < params.minDecimalLatitude) {
                params.minDecimalLatitude = latLng.getLat();
            }
            if (latLng.getLng() > params.maxDecimalLongitude) {
                params.maxDecimalLongitude = latLng.getLng();
            }
            if (latLng.getLng() < params.minDecimalLongitude) {
                params.minDecimalLongitude = latLng.getLng();
            }
        }
    }

    private void processLine(String[] in, InferredEmlTemporalMetadataParams params) {
        if (params.isEventDatePropertyMapped() && params.isColumnIndexesWithingRanges(in.length)) {
            String rawEventDateValue = params.eventDateSourceDefaultValue != null ? params.eventDateSourceDefaultValue : in[params.eventDateSourceColumnIndex];
            TemporalParser temporalParser = DateParsers.defaultTemporalParser();
            ParseResult parsedEventDateResult = temporalParser.parse(rawEventDateValue);
            TemporalAccessor parsedEventDateTA = (TemporalAccessor)parsedEventDateResult.getPayload();
            if (!parsedEventDateResult.isSuccessful() || parsedEventDateTA == null || !parsedEventDateTA.isSupported(ChronoField.YEAR)) {
                return;
            }
            params.noValidDataTemporal = false;
            if (params.startDateTA == null) {
                params.startDateTA = parsedEventDateTA;
                params.startDateStr = rawEventDateValue;
            }
            if (params.endDateTA == null) {
                params.endDateTA = parsedEventDateTA;
                params.endDateStr = rawEventDateValue;
            }
            if (parsedEventDateTA instanceof YearMonth) {
                parsedEventDateTA = ((YearMonth)parsedEventDateTA).atEndOfMonth();
            }
            if (parsedEventDateTA instanceof ChronoLocalDate && params.startDateTA instanceof ChronoLocalDate && ((ChronoLocalDate)params.startDateTA).isAfter((ChronoLocalDate)parsedEventDateTA)) {
                params.startDateTA = parsedEventDateTA;
                params.startDateStr = rawEventDateValue;
            }
            if (parsedEventDateTA instanceof ChronoLocalDate && params.endDateTA instanceof ChronoLocalDate && ((ChronoLocalDate)params.endDateTA).isBefore((ChronoLocalDate)parsedEventDateTA)) {
                params.endDateTA = parsedEventDateTA;
                params.endDateStr = rawEventDateValue;
            }
        }
    }

    private void processLine(String[] in, InferredEmlTaxonomicMetadataParams params) {
        if (params.isDataMapped()) {
            if (params.kingdomSourceDefaultValue != null && !params.defaultKingdomValueAdded) {
                params.addNewKingdom(params.kingdomSourceDefaultValue);
                params.defaultKingdomValueAdded = true;
            } else if (params.isMaxNumberOfKingdomsExceeded()) {
                if (!params.kingdomsLimitExceeded) {
                    params.removeAllKingdoms();
                    params.kingdomsLimitExceeded = true;
                }
            } else if (params.isKingdomPropertyMapped() && params.isKingdomIndexWithingRange(in.length)) {
                params.addNewKingdom(in[params.kingdomSourceColumnIndex]);
            }
            if (params.phylumSourceDefaultValue != null && !params.defaultPhylumValueAdded) {
                params.addNewPhylum(params.phylumSourceDefaultValue);
                params.defaultPhylumValueAdded = true;
            } else if (params.isMaxNumberOfPhylumsExceeded()) {
                if (!params.phylumsLimitExceeded) {
                    params.removeAllPhylums();
                    params.phylumsLimitExceeded = true;
                }
            } else if (params.isPhylumPropertyMapped() && params.isPhylumIndexWithinRange(in.length)) {
                params.addNewPhylum(in[params.phylumSourceColumnIndex]);
            }
            if (params.classSourceDefaultValue != null && !params.defaultClassValueAdded) {
                params.addNewClass(params.classSourceDefaultValue);
                params.defaultClassValueAdded = true;
            } else if (params.isMaxNumberOfClassesExceeded()) {
                if (!params.classesLimitExceeded) {
                    params.removeAllClasses();
                    params.classesLimitExceeded = true;
                }
            } else if (params.isClassPropertyMapped() && params.isClassIndexWithinRange(in.length)) {
                params.addNewClass(in[params.classSourceColumnIndex]);
            }
            if (params.orderSourceDefaultValue != null && !params.defaultOrderValueAdded) {
                params.addNewOrder(params.orderSourceDefaultValue);
                params.defaultOrderValueAdded = true;
            } else if (params.isMaxNumberOfOrdersExceeded()) {
                if (!params.ordersLimitExceeded) {
                    params.removeAllOrders();
                    params.ordersLimitExceeded = true;
                }
            } else if (params.isOrderPropertyMapped() && params.isOrderIndexWithinRange(in.length)) {
                params.addNewOrder(in[params.orderSourceColumnIndex]);
            }
            if (params.familySourceDefaultValue != null && !params.defaultFamilyValueAdded) {
                params.addNewFamily(params.familySourceDefaultValue);
                params.defaultFamilyValueAdded = true;
            } else if (params.isMaxNumberOfFamiliesExceeded()) {
                if (!params.familiesLimitExceeded) {
                    params.removeAllFamilies();
                    params.familiesLimitExceeded = true;
                }
            } else if (params.isFamilyPropertyMapped() && params.isFamilyIndexWithingRange(in.length)) {
                params.addNewFamily(in[params.familySourceColumnIndex]);
            }
        }
    }

    public List<OrganizedTaxonomicCoverage> constructOrganizedTaxonomicCoverages(List<TaxonomicCoverage> coverages) {
        ArrayList<OrganizedTaxonomicCoverage> organizedTaxonomicCoverages = new ArrayList<OrganizedTaxonomicCoverage>();
        for (TaxonomicCoverage coverage : coverages) {
            OrganizedTaxonomicCoverage organizedCoverage = this.constructOrganizedTaxonomicCoverage(coverage);
            organizedTaxonomicCoverages.add(organizedCoverage);
        }
        return organizedTaxonomicCoverages;
    }

    public OrganizedTaxonomicCoverage constructOrganizedTaxonomicCoverage(TaxonomicCoverage coverage) {
        OrganizedTaxonomicCoverage organizedCoverage = new OrganizedTaxonomicCoverage();
        organizedCoverage.setDescription(coverage.getDescription());
        organizedCoverage.setKeywords(this.setOrganizedTaxonomicKeywords(coverage.getTaxonKeywords()));
        return organizedCoverage;
    }

    private List<OrganizedTaxonomicKeywords> setOrganizedTaxonomicKeywords(List<TaxonKeyword> keywords) {
        ArrayList<OrganizedTaxonomicKeywords> organizedTaxonomicKeywordsList = new ArrayList<OrganizedTaxonomicKeywords>();
        HashSet<String> uniqueNamesForEmptyRank = new HashSet<String>();
        LinkedHashMap ranks = new LinkedHashMap(this.vocabManager.getI18nVocab("http://rs.gbif.org/vocabulary/gbif/rank", Locale.ENGLISH.getLanguage(), false));
        for (String rank : ranks.keySet()) {
            OrganizedTaxonomicKeywords organizedKeywords = new OrganizedTaxonomicKeywords();
            organizedKeywords.setRank(rank);
            for (TaxonKeyword keyword : keywords) {
                String displayName = this.createKeywordDisplayName(keyword);
                if (displayName == null) continue;
                if (rank.equalsIgnoreCase(keyword.getRank())) {
                    organizedKeywords.getDisplayNames().add(displayName);
                    continue;
                }
                if (StringUtils.trimToNull((String)keyword.getRank()) != null) continue;
                uniqueNamesForEmptyRank.add(displayName);
            }
            organizedTaxonomicKeywordsList.add(organizedKeywords);
        }
        if (!uniqueNamesForEmptyRank.isEmpty()) {
            OrganizedTaxonomicKeywords emptyRankKeywords = new OrganizedTaxonomicKeywords();
            emptyRankKeywords.setRank("Unranked");
            emptyRankKeywords.setDisplayNames(new ArrayList(uniqueNamesForEmptyRank));
            organizedTaxonomicKeywordsList.add(emptyRankKeywords);
        }
        return organizedTaxonomicKeywordsList;
    }

    private String createKeywordDisplayName(TaxonKeyword keyword) {
        Object combined = null;
        if (keyword != null) {
            String scientificName = StringUtils.trimToNull((String)keyword.getScientificName());
            String commonName = StringUtils.trimToNull((String)keyword.getCommonName());
            if (scientificName != null && commonName != null) {
                combined = scientificName + " (" + commonName + ")";
            } else if (scientificName != null) {
                combined = scientificName;
            } else if (commonName != null) {
                combined = commonName;
            }
        }
        return combined;
    }

    private InferredCamtrapMetadata inferCamtrapMetadata(Resource resource) {
        InferredCamtrapMetadata inferredMetadata = new InferredCamtrapMetadata();
        InferredCamtrapMetadataParams params = new InferredCamtrapMetadataParams();
        boolean requiredSchemasMapped = this.isRequiredSchemasMapped(resource, params);
        if (requiredSchemasMapped) {
            for (DataPackageMapping mapping : resource.getDataPackageMappings()) {
                this.processMapping(mapping, params);
            }
        }
        this.finalizeInferredMetadata(inferredMetadata, params);
        inferredMetadata.setLastModified(new Date());
        return inferredMetadata;
    }

    private boolean isRequiredSchemasMapped(Resource resource, InferredCamtrapMetadataParams params) {
        boolean isDeploymentsMapped = this.isSchemaMapped(resource, CAMTRAP_DEPLOYMENTS);
        boolean isObservationsMapped = this.isSchemaMapped(resource, CAMTRAP_OBSERVATIONS);
        params.geographic.isDeploymentsMapped = isDeploymentsMapped;
        params.temporal.isDeploymentsMapped = isDeploymentsMapped;
        params.taxonomic.isObservationsMapped = isObservationsMapped;
        return isDeploymentsMapped || isObservationsMapped;
    }

    private void processMapping(DataPackageMapping mapping, InferredCamtrapMetadataParams params) {
        if (CAMTRAP_DEPLOYMENTS.equals(mapping.getDataPackageTableSchemaName().getName())) {
            this.processDeploymentsMapping(mapping, params);
        } else if (CAMTRAP_OBSERVATIONS.equals(mapping.getDataPackageTableSchemaName().getName())) {
            this.processObservationsMapping(mapping, params);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processObservationsMapping(DataPackageMapping mapping, InferredCamtrapMetadataParams params) {
        params.taxonomic.scientificNameSourceColumnIndex = this.getFieldIndexInMapping(mapping, CAMTRAP_OBSERVATIONS_SCIENTIFIC_NAME);
        ClosableReportingIterator iter = null;
        try {
            iter = this.sourceManager.rowIterator(mapping.getSource());
            while (iter.hasNext()) {
                String[] in = (String[])iter.next();
                if (in == null || in.length == 0) continue;
                this.processLine(in, params.taxonomic);
                if (!this.isMaxNumberOfTaxaReached(params.taxonomic)) continue;
                break;
            }
        }
        catch (com.github.pjfanning.xlsx.exceptions.ParseException e) {
            this.LOG.error("Error while trying to infer metadata: {}", (Object)e.getMessage());
        }
        catch (Exception e) {
            this.LOG.error("Error while trying to infer metadata from source data", (Throwable)e);
            params.taxonomic.serverError = true;
        }
        finally {
            if (iter != null) {
                try {
                    iter.close();
                }
                catch (Exception e) {
                    this.LOG.error("Error while closing iterator", (Throwable)e);
                    params.taxonomic.serverError = true;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processDeploymentsMapping(DataPackageMapping mapping, InferredCamtrapMetadataParams params) {
        params.geographic.latitudeSourceColumnIndex = this.getFieldIndexInMapping(mapping, CAMTRAP_DEPLOYMENTS_LATITUDE);
        params.geographic.longitudeSourceColumnIndex = this.getFieldIndexInMapping(mapping, CAMTRAP_DEPLOYMENTS_LONGITUDE);
        params.temporal.deploymentStartSourceColumnIndex = this.getFieldIndexInMapping(mapping, CAMTRAP_DEPLOYMENTS_DEPLOYMENT_START);
        params.temporal.deploymentEndSourceColumnIndex = this.getFieldIndexInMapping(mapping, CAMTRAP_DEPLOYMENTS_DEPLOYMENT_END);
        ClosableReportingIterator iter = null;
        try {
            iter = this.sourceManager.rowIterator(mapping.getSource());
            while (iter.hasNext()) {
                String[] in = (String[])iter.next();
                if (in == null || in.length == 0) continue;
                this.processLine(in, params.geographic);
                this.processLine(in, params.temporal);
            }
        }
        catch (com.github.pjfanning.xlsx.exceptions.ParseException e) {
            this.LOG.error("Error while trying to infer metadata: {}", (Object)e.getMessage());
        }
        catch (Exception e) {
            this.LOG.error("Error while trying to infer metadata from source data", (Throwable)e);
            params.geographic.serverError = true;
            params.temporal.serverError = true;
        }
        finally {
            if (iter != null) {
                try {
                    iter.close();
                }
                catch (Exception e) {
                    this.LOG.error("Error while closing iterator", (Throwable)e);
                    params.geographic.serverError = true;
                    params.temporal.serverError = true;
                }
            }
        }
    }

    private void processLine(String[] in, InferredCamtrapGeographicScopeParams params) {
        String rawLongitudeValue;
        String rawLatitudeValue;
        OccurrenceParseResult latLngParseResult;
        LatLng latLng;
        if (params.isLatitudeMapped() && params.isLongitudeMapped() && params.isColumnIndexesWithinRange(in.length) && (latLng = (LatLng)(latLngParseResult = CoordinateParseUtils.parseLatLng((String)(rawLatitudeValue = in[params.latitudeSourceColumnIndex]), (String)(rawLongitudeValue = in[params.longitudeSourceColumnIndex]))).getPayload()) != null && latLngParseResult.isSuccessful()) {
            params.noValidDataGeo = false;
            if (!params.coordinatesInitialized) {
                params.minDecimalLatitude = latLng.getLat();
                params.maxDecimalLatitude = latLng.getLat();
                params.minDecimalLongitude = latLng.getLng();
                params.maxDecimalLongitude = latLng.getLng();
                params.coordinatesInitialized = true;
            }
            if (latLng.getLat() > params.maxDecimalLatitude) {
                params.maxDecimalLatitude = latLng.getLat();
            }
            if (latLng.getLat() < params.minDecimalLatitude) {
                params.minDecimalLatitude = latLng.getLat();
            }
            if (latLng.getLng() > params.maxDecimalLongitude) {
                params.maxDecimalLongitude = latLng.getLng();
            }
            if (latLng.getLng() < params.minDecimalLongitude) {
                params.minDecimalLongitude = latLng.getLng();
            }
        }
    }

    private void processLine(String[] in, InferredCamtrapTemporalScopeParams params) {
        if (params.isDeploymentStartMapped() && params.isDeploymentEndMapped() && params.isColumnIndexesWithinRange(in.length)) {
            ChronoLocalDate parsedLocalDate;
            ChronoLocalDate existingLocalDate;
            String rawDeploymentStartValue = in[params.deploymentStartSourceColumnIndex];
            String rawDeploymentEndValue = in[params.deploymentEndSourceColumnIndex];
            TemporalParser temporalParser = DateParsers.defaultTemporalParser();
            ParseResult parsedDeploymentStartResult = temporalParser.parse(rawDeploymentStartValue);
            ParseResult parsedDeploymentEndResult = temporalParser.parse(rawDeploymentEndValue);
            TemporalAccessor parsedDeploymentStartTA = (TemporalAccessor)parsedDeploymentStartResult.getPayload();
            TemporalAccessor parsedDeploymentEndTA = (TemporalAccessor)parsedDeploymentEndResult.getPayload();
            if (!(parsedDeploymentStartResult.isSuccessful() && parsedDeploymentStartTA != null && parsedDeploymentStartTA.isSupported(ChronoField.YEAR) && parsedDeploymentEndResult.isSuccessful() && parsedDeploymentEndTA != null && parsedDeploymentEndTA.isSupported(ChronoField.YEAR))) {
                return;
            }
            params.noValidDataTemporal = false;
            if (parsedDeploymentStartTA instanceof YearMonth) {
                parsedDeploymentStartTA = ((YearMonth)parsedDeploymentStartTA).atEndOfMonth();
            }
            if (parsedDeploymentEndTA instanceof YearMonth) {
                parsedDeploymentEndTA = ((YearMonth)parsedDeploymentEndTA).atEndOfMonth();
            }
            if (params.startDateTA == null) {
                params.startDateTA = parsedDeploymentStartTA;
                params.startDateStr = rawDeploymentStartValue;
            }
            if (params.endDateTA == null) {
                params.endDateTA = parsedDeploymentEndTA;
                params.endDateStr = rawDeploymentEndValue;
            }
            if (parsedDeploymentStartTA instanceof ChronoLocalDate && params.startDateTA instanceof ChronoLocalDate) {
                existingLocalDate = (ChronoLocalDate)params.startDateTA;
                parsedLocalDate = (ChronoLocalDate)parsedDeploymentStartTA;
                if (existingLocalDate.isAfter(parsedLocalDate)) {
                    params.startDateTA = parsedDeploymentStartTA;
                    params.startDateStr = rawDeploymentStartValue;
                }
            } else if (parsedDeploymentStartTA instanceof ChronoZonedDateTime && params.startDateTA instanceof ChronoZonedDateTime) {
                parsedLocalDate = ((ChronoZonedDateTime)parsedDeploymentStartTA).toLocalDate();
                existingLocalDate = ((ChronoZonedDateTime)params.startDateTA).toLocalDate();
                if (existingLocalDate.isAfter(parsedLocalDate)) {
                    params.startDateTA = parsedDeploymentStartTA;
                    params.startDateStr = rawDeploymentStartValue;
                }
            }
            if (parsedDeploymentEndTA instanceof ChronoLocalDate && params.endDateTA instanceof ChronoLocalDate) {
                existingLocalDate = (ChronoLocalDate)params.endDateTA;
                parsedLocalDate = (ChronoLocalDate)parsedDeploymentEndTA;
                if (existingLocalDate.isBefore(parsedLocalDate)) {
                    params.endDateTA = parsedDeploymentEndTA;
                    params.endDateStr = rawDeploymentEndValue;
                }
            } else if (parsedDeploymentEndTA instanceof ChronoZonedDateTime && params.endDateTA instanceof ChronoZonedDateTime) {
                parsedLocalDate = ((ChronoZonedDateTime)parsedDeploymentEndTA).toLocalDate();
                existingLocalDate = ((ChronoZonedDateTime)params.endDateTA).toLocalDate();
                if (existingLocalDate.isBefore(parsedLocalDate)) {
                    params.endDateTA = parsedDeploymentEndTA;
                    params.endDateStr = rawDeploymentEndValue;
                }
            }
        }
    }

    private void processLine(String[] in, InferredCamtrapTaxonomicScopeParams params) {
        if (params.isScientificNameMapped() && params.isColumnIndexesWithinRange(in.length) && StringUtils.isNotEmpty((CharSequence)in[params.scientificNameSourceColumnIndex])) {
            params.taxa.add(in[params.scientificNameSourceColumnIndex]);
        }
    }

    private boolean isMaxNumberOfTaxaReached(InferredCamtrapTaxonomicScopeParams params) {
        int n = params.taxa.size();
        Objects.requireNonNull(params);
        return n >= 200;
    }

    private void finalizeInferredMetadata(InferredCamtrapMetadata metadata, InferredCamtrapMetadataParams params) {
        this.finalizeInferredMetadata(metadata, params.geographic);
        this.finalizeInferredMetadata(metadata, params.temporal);
        this.finalizeInferredMetadata(metadata, params.taxonomic);
    }

    private void finalizeInferredMetadata(InferredCamtrapMetadata metadata, InferredCamtrapGeographicScopeParams params) {
        InferredCamtrapGeographicScope inferredGeographicScope = new InferredCamtrapGeographicScope();
        metadata.setInferredGeographicScope(inferredGeographicScope);
        boolean errorOccurredWhileProcessingGeographicMetadata = this.handleCamtrapGeographicScopeErrors(inferredGeographicScope, params);
        if (!errorOccurredWhileProcessingGeographicMetadata) {
            inferredGeographicScope.setMinLatitude(params.minDecimalLatitude);
            inferredGeographicScope.setMinLongitude(params.minDecimalLongitude);
            inferredGeographicScope.setMaxLatitude(params.maxDecimalLatitude);
            inferredGeographicScope.setMaxLongitude(params.maxDecimalLongitude);
            inferredGeographicScope.setInferred(true);
        }
    }

    private void finalizeInferredMetadata(InferredCamtrapMetadata metadata, InferredCamtrapTemporalScopeParams params) {
        InferredCamtrapTemporalScope inferredTemporalScope = new InferredCamtrapTemporalScope();
        metadata.setInferredTemporalScope(inferredTemporalScope);
        boolean errorOccurredWhileProcessingTemporalMetadata = this.handleCamtrapTemporalScopeErrors(inferredTemporalScope, params);
        if (!errorOccurredWhileProcessingTemporalMetadata) {
            try {
                inferredTemporalScope.setStartDate(DateUtils.calendarDate((String)params.startDateTA.toString()));
                inferredTemporalScope.setEndDate(DateUtils.calendarDate((String)params.endDateTA.toString()));
                inferredTemporalScope.setInferred(true);
            }
            catch (ParseException e) {
                this.LOG.error("Failed to parse date for temporal coverage", (Throwable)e);
                inferredTemporalScope.addError("datapackagemetadata.temporal.error.dateParseException");
            }
        }
    }

    private void finalizeInferredMetadata(InferredCamtrapMetadata metadata, InferredCamtrapTaxonomicScopeParams params) {
        InferredCamtrapTaxonomicScope inferredTaxonomicScope = new InferredCamtrapTaxonomicScope();
        metadata.setInferredTaxonomicScope(inferredTaxonomicScope);
        boolean errorOccurredWhileProcessingTaxonomicMetadata = this.handleCamtrapTaxonomicScopeErrors(inferredTaxonomicScope, params);
        if (!errorOccurredWhileProcessingTaxonomicMetadata) {
            List taxCoverage = params.taxa.stream().map(val -> {
                Taxonomic t = new Taxonomic();
                t.setScientificName(val);
                return t;
            }).collect(Collectors.toList());
            inferredTaxonomicScope.setData(taxCoverage);
            inferredTaxonomicScope.setInferred(true);
        }
    }

    private boolean isSchemaMapped(Resource resource, String schemaName) {
        return resource.getDataPackageMappings().stream().map(DataPackageMapping::getDataPackageTableSchemaName).map(DataPackageTableSchemaName::getName).anyMatch(schemaName::equals);
    }

    private int getFieldIndexInMapping(DataPackageMapping mapping, String fieldName) {
        return Optional.ofNullable(mapping.getField(fieldName)).map(DataPackageFieldMapping::getIndex).orElse(-1);
    }

    private boolean handleCamtrapGeographicScopeErrors(InferredCamtrapGeographicScope metadata, InferredCamtrapGeographicScopeParams params) {
        boolean errorsPresent = false;
        if (params.serverError) {
            metadata.addError("datapackagemetadata.error.serverError");
            errorsPresent = true;
        } else if (!params.isDeploymentsMapped) {
            metadata.addError("datapackagemetadata.error.noDeploymentsMapped");
            errorsPresent = true;
        } else if (!params.isLatitudeMapped() && !params.isLongitudeMapped()) {
            metadata.addError("datapackagemetadata.geographic.error.fieldsNotMapped");
            errorsPresent = true;
        } else if (!params.isLatitudeMapped()) {
            metadata.addError("datapackagemetadata.geographic.error.latitudeNotMapped");
            errorsPresent = true;
        } else if (!params.isLongitudeMapped()) {
            metadata.addError("datapackagemetadata.geographic.error.longitudeNotMapped");
            errorsPresent = true;
        } else if (params.noValidDataGeo) {
            metadata.addError("datapackagemetadata.error.noValidData");
            errorsPresent = true;
        }
        return errorsPresent;
    }

    private boolean handleCamtrapTaxonomicScopeErrors(InferredCamtrapTaxonomicScope metadata, InferredCamtrapTaxonomicScopeParams params) {
        boolean errorOccurred = false;
        if (params.serverError) {
            metadata.addError("datapackagemetadata.error.serverError");
            errorOccurred = true;
        } else if (!params.isObservationsMapped) {
            metadata.addError("datapackagemetadata.error.noObservationsMapped");
            errorOccurred = true;
        } else if (!params.isScientificNameMapped()) {
            metadata.addError("datapackagemetadata.taxonomic.error.scientificNameNotMapped");
            errorOccurred = true;
        } else if (params.taxa.size() == 0) {
            metadata.addError("datapackagemetadata.error.noValidData");
            errorOccurred = true;
        }
        return errorOccurred;
    }

    private boolean handleCamtrapTemporalScopeErrors(InferredCamtrapTemporalScope metadata, InferredCamtrapTemporalScopeParams params) {
        boolean errorOccurred = false;
        if (params.serverError) {
            metadata.addError("datapackagemetadata.error.serverError");
            errorOccurred = true;
        } else if (!params.isDeploymentsMapped) {
            metadata.addError("datapackagemetadata.error.noDeploymentsMapped");
            errorOccurred = true;
        } else if (!params.isDeploymentStartMapped() && !params.isDeploymentEndMapped()) {
            metadata.addError("datapackagemetadata.temporal.error.fieldsNotMapped");
            errorOccurred = true;
        } else if (!params.isDeploymentStartMapped()) {
            metadata.addError("datapackagemetadata.temporal.error.deploymentStartNotMapped");
            errorOccurred = true;
        } else if (!params.isDeploymentEndMapped()) {
            metadata.addError("datapackagemetadata.temporal.error.deploymentEndNotMapped");
            errorOccurred = true;
        } else if (params.noValidDataTemporal) {
            metadata.addError("datapackagemetadata.error.noValidData");
            errorOccurred = true;
        }
        return errorOccurred;
    }
}

