/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.service.manage.impl;

import com.lowagie.text.DocumentException;
import com.lowagie.text.rtf.RtfWriter2;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.security.AnyTypePermission;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListValuedMap;
import org.apache.commons.collections4.multimap.ArrayListValuedHashMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Level;
import org.gbif.api.model.common.DOI;
import org.gbif.api.model.registry.Dataset;
import org.gbif.doi.metadata.datacite.DataCiteMetadata;
import org.gbif.doi.service.DoiException;
import org.gbif.doi.service.DoiExistsException;
import org.gbif.dwc.Archive;
import org.gbif.dwc.ArchiveField;
import org.gbif.dwc.ArchiveFile;
import org.gbif.dwc.DwcFiles;
import org.gbif.dwc.UnsupportedArchiveException;
import org.gbif.dwc.terms.DwcTerm;
import org.gbif.dwc.terms.Term;
import org.gbif.dwc.terms.TermFactory;
import org.gbif.ipt.action.BaseAction;
import org.gbif.ipt.action.portal.OrganizedTaxonomicKeywords;
import org.gbif.ipt.config.AppConfig;
import org.gbif.ipt.config.Constants;
import org.gbif.ipt.config.DataDir;
import org.gbif.ipt.model.DataPackageField;
import org.gbif.ipt.model.DataPackageFieldConstraints;
import org.gbif.ipt.model.DataPackageFieldMapping;
import org.gbif.ipt.model.DataPackageFieldReference;
import org.gbif.ipt.model.DataPackageMapping;
import org.gbif.ipt.model.DataPackageSchema;
import org.gbif.ipt.model.DataPackageTableSchema;
import org.gbif.ipt.model.DataPackageTableSchemaForeignKey;
import org.gbif.ipt.model.DataPackageTableSchemaName;
import org.gbif.ipt.model.ExcelFileSource;
import org.gbif.ipt.model.Extension;
import org.gbif.ipt.model.ExtensionMapping;
import org.gbif.ipt.model.ExtensionProperty;
import org.gbif.ipt.model.FileSource;
import org.gbif.ipt.model.InferredCamtrapGeographicScope;
import org.gbif.ipt.model.InferredCamtrapMetadata;
import org.gbif.ipt.model.InferredCamtrapTaxonomicScope;
import org.gbif.ipt.model.InferredCamtrapTemporalScope;
import org.gbif.ipt.model.InferredEmlGeographicCoverage;
import org.gbif.ipt.model.InferredEmlMetadata;
import org.gbif.ipt.model.InferredEmlTaxonomicCoverage;
import org.gbif.ipt.model.InferredEmlTemporalCoverage;
import org.gbif.ipt.model.InferredMetadata;
import org.gbif.ipt.model.Ipt;
import org.gbif.ipt.model.Organisation;
import org.gbif.ipt.model.PropertyMapping;
import org.gbif.ipt.model.PublicationOptions;
import org.gbif.ipt.model.Resource;
import org.gbif.ipt.model.SimplifiedResource;
import org.gbif.ipt.model.Source;
import org.gbif.ipt.model.SqlSource;
import org.gbif.ipt.model.TextFileSource;
import org.gbif.ipt.model.UrlSource;
import org.gbif.ipt.model.User;
import org.gbif.ipt.model.VersionHistory;
import org.gbif.ipt.model.converter.PasswordEncrypter;
import org.gbif.ipt.model.datapackage.metadata.DataPackageMetadata;
import org.gbif.ipt.model.datapackage.metadata.FrictionlessMetadata;
import org.gbif.ipt.model.datapackage.metadata.camtrap.CamtrapContributor;
import org.gbif.ipt.model.datapackage.metadata.camtrap.CamtrapMetadata;
import org.gbif.ipt.model.datapackage.metadata.camtrap.Geojson;
import org.gbif.ipt.model.datapackage.metadata.camtrap.RelatedIdentifier;
import org.gbif.ipt.model.datapackage.metadata.camtrap.Temporal;
import org.gbif.ipt.model.datapackage.metadata.col.ColMetadata;
import org.gbif.ipt.model.datapackage.metadata.col.FrictionlessColMetadata;
import org.gbif.ipt.model.datatable.DatatableRequest;
import org.gbif.ipt.model.datatable.DatatableResult;
import org.gbif.ipt.model.voc.IdentifierStatus;
import org.gbif.ipt.model.voc.PublicationMode;
import org.gbif.ipt.model.voc.PublicationStatus;
import org.gbif.ipt.service.AlreadyExistingException;
import org.gbif.ipt.service.BaseManager;
import org.gbif.ipt.service.DeletionNotAllowedException;
import org.gbif.ipt.service.ImportException;
import org.gbif.ipt.service.InvalidConfigException;
import org.gbif.ipt.service.InvalidFilenameException;
import org.gbif.ipt.service.InvalidMetadataException;
import org.gbif.ipt.service.PublicationException;
import org.gbif.ipt.service.RegistryException;
import org.gbif.ipt.service.admin.DataPackageSchemaManager;
import org.gbif.ipt.service.admin.ExtensionManager;
import org.gbif.ipt.service.admin.RegistrationManager;
import org.gbif.ipt.service.admin.VocabulariesManager;
import org.gbif.ipt.service.manage.MetadataReader;
import org.gbif.ipt.service.manage.ResourceManager;
import org.gbif.ipt.service.manage.ResourceMetadataInferringService;
import org.gbif.ipt.service.manage.SourceManager;
import org.gbif.ipt.service.manage.impl.ResourceConvertersManager;
import org.gbif.ipt.service.manage.impl.ResourceManagerImpl;
import org.gbif.ipt.service.manage.impl.SourceManagerImpl;
import org.gbif.ipt.service.registry.RegistryManager;
import org.gbif.ipt.struts2.RequireManagerInterceptor;
import org.gbif.ipt.struts2.SimpleTextProvider;
import org.gbif.ipt.task.Eml2Rtf;
import org.gbif.ipt.task.GenerateDataPackage;
import org.gbif.ipt.task.GenerateDataPackageFactory;
import org.gbif.ipt.task.GenerateDwca;
import org.gbif.ipt.task.GenerateDwcaFactory;
import org.gbif.ipt.task.ReportHandler;
import org.gbif.ipt.task.StatusReport;
import org.gbif.ipt.task.TaskMessage;
import org.gbif.ipt.utils.ActionLogger;
import org.gbif.ipt.utils.DataCiteMetadataBuilder;
import org.gbif.ipt.utils.EmlUtils;
import org.gbif.ipt.utils.MapUtils;
import org.gbif.ipt.utils.MetadataUtils;
import org.gbif.ipt.utils.ResourceUtils;
import org.gbif.ipt.validation.DataPackageMetadataValidator;
import org.gbif.metadata.eml.EMLProfileVersion;
import org.gbif.metadata.eml.EmlValidator;
import org.gbif.metadata.eml.InvalidEmlException;
import org.gbif.metadata.eml.ipt.EmlFactory;
import org.gbif.metadata.eml.ipt.model.Citation;
import org.gbif.metadata.eml.ipt.model.Eml;
import org.gbif.metadata.eml.ipt.model.GeospatialCoverage;
import org.gbif.metadata.eml.ipt.model.MaintenanceUpdateFrequency;
import org.gbif.metadata.eml.ipt.model.TaxonKeyword;
import org.gbif.metadata.eml.ipt.model.TaxonomicCoverage;
import org.gbif.metadata.eml.ipt.model.TemporalCoverage;
import org.gbif.metadata.eml.parse.DatasetEmlParser;
import org.gbif.utils.file.CompressionUtil;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class ResourceManagerImpl
extends BaseManager
implements ResourceManager,
ReportHandler {
    private Map<String, Resource> resources = new HashMap();
    private Map<String, SimplifiedResource> publishedPublicVersionsSimplified = new HashMap();
    private static final int MAX_PROCESS_FAILURES = 3;
    private static final TermFactory TERM_FACTORY = TermFactory.instance();
    private final XStream xstream = new XStream();
    private SourceManager sourceManager;
    private ExtensionManager extensionManager;
    private DataPackageSchemaManager schemaManager;
    private RegistryManager registryManager;
    private ResourceMetadataInferringService resourceMetadataInferringService;
    private ThreadPoolExecutor executor;
    private GenerateDwcaFactory dwcaFactory;
    private GenerateDataPackageFactory dataPackageFactory;
    private Map<String, Future<Map<String, Integer>>> processFutures = new HashMap();
    private ListValuedMap<String, Date> processFailures = new ArrayListValuedHashMap();
    private Map<String, LocalDate> lastLoggedFailures = new ConcurrentHashMap();
    private Map<String, StatusReport> processReports = new ConcurrentHashMap();
    private List<String> resourcesToSkip = new CopyOnWriteArrayList();
    private Eml2Rtf eml2Rtf;
    private VocabulariesManager vocabManager;
    private SimpleTextProvider textProvider;
    private RegistrationManager registrationManager;
    private final MetadataReader metadataReader;
    private static final Comparator<String> nullSafeStringComparator = Comparator.nullsFirst(String::compareToIgnoreCase);
    private static final Comparator<Date> nullSafeDateComparator = Comparator.nullsFirst(Date::compareTo);
    private static final SimpleDateFormat DATETIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    public static final SimpleDateFormat CAMTRAP_TEMPORAL_METADATA_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");

    public ResourceManagerImpl(AppConfig cfg, DataDir dataDir, ResourceConvertersManager resourceConvertersManager, SourceManager sourceManager, ExtensionManager extensionManager, DataPackageSchemaManager schemaManager, RegistryManager registryManager, GenerateDwcaFactory dwcaFactory, GenerateDataPackageFactory dataPackageFactory, PasswordEncrypter passwordEncrypter, Eml2Rtf eml2Rtf, VocabulariesManager vocabManager, SimpleTextProvider textProvider, RegistrationManager registrationManager, MetadataReader metadataReader, ResourceMetadataInferringService resourceMetadataInferringService) {
        super(cfg, dataDir);
        this.sourceManager = sourceManager;
        this.extensionManager = extensionManager;
        this.schemaManager = schemaManager;
        this.registryManager = registryManager;
        this.dwcaFactory = dwcaFactory;
        this.dataPackageFactory = dataPackageFactory;
        this.eml2Rtf = eml2Rtf;
        this.vocabManager = vocabManager;
        this.executor = (ThreadPoolExecutor)Executors.newFixedThreadPool(cfg.getMaxThreads());
        this.defineXstreamMapping(resourceConvertersManager, passwordEncrypter);
        this.textProvider = textProvider;
        this.registrationManager = registrationManager;
        this.metadataReader = metadataReader;
        this.resourceMetadataInferringService = resourceMetadataInferringService;
    }

    private void addResource(Resource res) {
        this.resources.put(res.getShortname().toLowerCase(), res);
        try {
            VersionHistory latestVersion;
            if (!(res.getVersionHistory().isEmpty() || (latestVersion = (VersionHistory)res.getVersionHistory().get(0)).getPublicationStatus().equals((Object)PublicationStatus.DELETED) || latestVersion.getPublicationStatus().equals((Object)PublicationStatus.PRIVATE) || latestVersion.getReleased() == null)) {
                this.publishedPublicVersionsSimplified.put(res.getShortname(), this.toSimplifiedResourceReconstructedVersion(res));
            }
        }
        catch (Exception e) {
            this.LOG.error("Failed to reconstruct resource's last published version", (Throwable)e);
        }
    }

    public void updateOrganisationNameForResources(Organisation organisation) {
        this.updateOrganisationNameForResources(organisation.getKey(), organisation.getName(), organisation.getAlias());
    }

    public void updateOrganisationNameForResources(UUID organisationKey, String organisationName, String organisationAlias) {
        this.resources.values().stream().filter(r -> r.getOrganisation() != null).filter(r -> r.getOrganisation().getKey() != null).filter(r -> r.getOrganisation().getKey().equals(organisationKey)).forEach(r -> {
            r.getOrganisation().setAlias(organisationAlias);
            r.getOrganisation().setName(organisationName);
        });
        this.publishedPublicVersionsSimplified.values().stream().filter(r -> r.getOrganisationKey() != null).filter(r -> r.getOrganisationKey().equals(organisationKey)).forEach(r -> {
            r.setOrganisationName(organisationName);
            r.setOrganisationAlias(organisationAlias);
        });
    }

    protected SimplifiedResource toSimplifiedResourceReconstructedVersion(Resource resource) {
        BigDecimal v = resource.getLastPublishedVersionsVersion();
        String shortname = resource.getShortname();
        File versionMetadataFile = resource.isDataPackage() ? this.cfg.getDataDir().resourceDatapackageMetadataFile(shortname, resource.getCoreType(), v) : this.cfg.getDataDir().resourceEmlFile(shortname, v);
        Resource publishedPublicVersion = ResourceUtils.reconstructVersion((BigDecimal)v, (String)resource.getShortname(), (String)resource.getCoreType(), (String)resource.getDataPackageIdentifier(), (DOI)resource.getAssignedDoi(), (Organisation)resource.getOrganisation(), (VersionHistory)resource.findVersionHistory(v), (File)versionMetadataFile, (UUID)resource.getKey());
        SimplifiedResource result = new SimplifiedResource();
        result.setShortname(publishedPublicVersion.getShortname());
        result.setTitle(publishedPublicVersion.getTitle());
        result.setStatus(publishedPublicVersion.getStatus());
        result.setRecordsPublished(publishedPublicVersion.getRecordsPublished());
        result.setLogoUrl(publishedPublicVersion.getLogoUrl());
        result.setSubject(publishedPublicVersion.getSubject());
        if (publishedPublicVersion.getOrganisation() != null) {
            result.setOrganisationKey(publishedPublicVersion.getOrganisation().getKey());
            result.setOrganisationName(publishedPublicVersion.getOrganisationName());
            result.setOrganisationAlias(publishedPublicVersion.getOrganisationAlias());
        }
        result.setCoreType(resource.getCoreType());
        result.setSubtype(resource.getSubtype());
        result.setModified(resource.getModified());
        result.setPublished(true);
        result.setLastPublished(publishedPublicVersion.getLastPublished());
        result.setNextPublished(resource.getNextPublished());
        result.setCreatorName(resource.getCreatorName());
        result.setDataPackage(resource.isDataPackage());
        if (!publishedPublicVersion.isRegistered() && resource.isRegistered() && resource.getOrganisation() != null) {
            result.setStatus(PublicationStatus.REGISTERED);
            result.setOrganisationAlias(resource.getOrganisationAlias());
            result.setOrganisationName(resource.getOrganisationName());
        }
        return result;
    }

    private SimplifiedResource toSimplifiedResource(Resource resource) {
        SimplifiedResource result = new SimplifiedResource();
        result.setShortname(resource.getShortname());
        result.setTitle(resource.getTitle());
        result.setStatus(resource.getStatus());
        result.setRecordsPublished(resource.getRecordsPublished());
        result.setLogoUrl(resource.getLogoUrl());
        result.setSubject(resource.getSubject());
        if (resource.getOrganisation() != null) {
            result.setOrganisationKey(resource.getOrganisation().getKey());
            result.setOrganisationName(resource.getOrganisationName());
            result.setOrganisationAlias(resource.getOrganisationAlias());
        }
        result.setCoreType(resource.getCoreType());
        result.setSubtype(resource.getSubtype());
        result.setModified(resource.getModified());
        result.setPublished(resource.getLastPublished() != null);
        result.setLastPublished(resource.getLastPublished());
        result.setNextPublished(resource.getNextPublished());
        result.setCreatorName(resource.getCreatorName());
        result.setDataPackage(resource.isDataPackage());
        return result;
    }

    public boolean cancelPublishing(String shortname, BaseAction action) {
        boolean canceled = false;
        Future f = (Future)this.processFutures.get(shortname);
        if (f != null) {
            canceled = f.cancel(true);
            if (canceled) {
                this.processFutures.remove(shortname);
            } else {
                this.LOG.warn("Canceling publication of resource " + shortname + " failed");
            }
        }
        this.resourcesToSkip.remove(shortname);
        return canceled;
    }

    private void closeWriter(Writer writer) {
        if (writer != null) {
            try {
                writer.close();
            }
            catch (IOException e) {
                this.LOG.error((Object)e);
            }
        }
    }

    private Eml convertMetadataToEml(Dataset metadata) {
        Eml eml = new Eml();
        if (metadata != null) {
            eml.setTitle(metadata.getTitle());
            if (metadata.getDescription() != null) {
                eml.setDescription(metadata.getDescription());
            }
            if (metadata.getHomepage() != null) {
                eml.setDistributionUrl(metadata.getHomepage().toString());
            }
            if (metadata.getLogoUrl() != null) {
                eml.setLogoUrl(metadata.getLogoUrl().toString());
            }
            if (metadata.getPubDate() != null) {
                eml.setPubDate(metadata.getPubDate());
            } else {
                eml.setPubDate(new Date());
                this.LOG.debug("pubDate set to today, because incoming pubDate was null");
            }
        }
        return eml;
    }

    private void validateEmlFile(File emlFile) throws SAXException, ParserConfigurationException, IOException, InvalidEmlException {
        EMLProfileVersion emlProfileVersion = this.getEmlProfileVersion(emlFile);
        EmlValidator emlValidator = EmlValidator.newValidator((EMLProfileVersion)emlProfileVersion);
        String emlString = FileUtils.readFileToString((File)emlFile, (Charset)StandardCharsets.UTF_8);
        emlValidator.validate(emlString);
    }

    private EMLProfileVersion getEmlProfileVersion(File emlFile) throws SAXException, ParserConfigurationException, IOException, InvalidEmlException {
        EMLProfileVersion emlProfileVersion;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(emlFile);
        String emlNamespace = document.getDocumentElement().getNamespaceURI();
        if ("eml://ecoinformatics.org/eml-2.1.1".equals(emlNamespace)) {
            this.LOG.debug("Use GBIF metadata profile 1.2 for validation");
            emlProfileVersion = EMLProfileVersion.GBIF_1_2;
        } else if ("https://eml.ecoinformatics.org/eml-2.2.0".equals(emlNamespace)) {
            this.LOG.debug("Use GBIF metadata profile 1.3 for validation");
            emlProfileVersion = EMLProfileVersion.GBIF_1_3;
        } else {
            this.LOG.error("Unsupported EML version or unrecognized namespace.");
            throw new InvalidEmlException("Unsupported EML version or unrecognized namespace.");
        }
        return emlProfileVersion;
    }

    private void validateDatapackageMetadataFile(BaseAction action, File metadataFile, Class<? extends DataPackageMetadata> metadataClass) throws IOException, InvalidMetadataException {
        DataPackageMetadataValidator validator = new DataPackageMetadataValidator();
        DataPackageMetadata metadata = (DataPackageMetadata)this.metadataReader.readValue(metadataFile, metadataClass);
        validator.validate(action, metadata);
        if (FrictionlessColMetadata.class.equals(metadataClass)) {
            ColMetadata colMetadata = (ColMetadata)this.metadataReader.readValue(metadataFile, ColMetadata.class);
            validator.validateColMetadata(action, colMetadata);
        }
    }

    private Eml copyMetadata(String shortname, File emlFile) throws ImportException {
        Eml eml;
        File emlFile2 = this.dataDir.resourceEmlFile(shortname);
        try {
            FileUtils.copyFile((File)emlFile, (File)emlFile2);
        }
        catch (Exception e1) {
            this.LOG.error("Unable to copy EML File", (Throwable)e1);
        }
        try (FileInputStream in = new FileInputStream(emlFile2);){
            eml = EmlFactory.build((InputStream)in);
        }
        catch (FileNotFoundException e) {
            eml = new Eml();
        }
        catch (Exception e) {
            this.deleteDirectoryContainingSingleFile(emlFile2);
            throw new ImportException("Invalid EML document", (Throwable)e);
        }
        return eml;
    }

    private DataPackageMetadata copyDatapackageMetadata(String shortname, File metadataFile, String datapackageType) throws ImportException {
        DataPackageMetadata metadata;
        File dataDirMetadataFile = this.dataDir.resourceDatapackageMetadataFile(shortname, datapackageType);
        try {
            FileUtils.copyFile((File)metadataFile, (File)dataDirMetadataFile);
        }
        catch (IOException e) {
            this.LOG.error("Unable to copy datapackage metadata file");
        }
        try {
            metadata = (DataPackageMetadata)this.metadataReader.readValue(dataDirMetadataFile, MetadataUtils.metadataClassForType((String)datapackageType));
        }
        catch (Exception e) {
            this.deleteDirectoryContainingSingleFile(dataDirMetadataFile);
            throw new ImportException("Invalid metadata document", (Throwable)e);
        }
        return metadata;
    }

    protected void deleteDirectoryContainingSingleFile(File file) {
        File parent = file.getParentFile();
        File[] files = parent.listFiles();
        if (files != null && files.length == 1 && files[0].equals(file)) {
            try {
                FileUtils.deleteDirectory((File)parent);
                this.LOG.info("Deleted directory: " + parent.getAbsolutePath());
            }
            catch (IOException e) {
                this.LOG.error("Failed to delete directory " + parent.getAbsolutePath() + ": " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public Resource create(String shortname, String type, File archiveOrSingleFile, User creator, BaseAction action) throws AlreadyExistingException, ImportException, InvalidFilenameException {
        Resource resource;
        Objects.requireNonNull(shortname);
        if (this.get(shortname) != null) {
            throw new AlreadyExistingException();
        }
        ActionLogger alog = new ActionLogger(this.LOG, action);
        List decompressed = null;
        File archiveDir = this.dataDir.tmpDir();
        try {
            decompressed = CompressionUtil.decompressFile((File)archiveDir, (File)archiveOrSingleFile, (boolean)true);
        }
        catch (CompressionUtil.UnsupportedCompressionType e) {
            this.LOG.debug("1st attempt to decompress file failed: " + e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            this.LOG.debug("Decompression failed: " + e.getMessage(), (Throwable)e);
        }
        if (CollectionUtils.isEmpty((Collection)decompressed)) {
            try {
                decompressed = CompressionUtil.ungzipFile((File)archiveDir, (File)archiveOrSingleFile, (boolean)false);
            }
            catch (Exception e2) {
                this.LOG.debug("2nd attempt to decompress file failed: " + e2.getMessage(), (Throwable)e2);
            }
        }
        if (CollectionUtils.isEmpty((Collection)decompressed)) {
            String fileExtension;
            switch (fileExtension = org.gbif.ipt.utils.FileUtils.getFileExtension((File)archiveOrSingleFile)) {
                case "xml": {
                    resource = this.createFromEml(shortname, archiveOrSingleFile, creator, alog);
                    break;
                }
                case "json": {
                    resource = this.createFromPackageDescriptor(shortname, type, archiveOrSingleFile, creator, alog);
                    break;
                }
                case "yml": {
                    resource = this.createFromColDpMetadata(shortname, archiveOrSingleFile, creator, alog);
                    break;
                }
                default: {
                    throw new ImportException("Invalid file extension: " + fileExtension);
                }
            }
        } else {
            resource = this.isIPTResourceFolder(archiveDir) ? this.createFromIPTResourceFolder(shortname, archiveDir, creator, alog) : (MetadataUtils.isDataPackageType((String)type) ? this.createFromFrictionlessDataPackage(shortname, type, decompressed, creator, alog) : this.createFromDwcArchive(shortname, archiveDir, creator, alog));
        }
        if (type != null && StringUtils.isBlank((CharSequence)resource.getCoreType())) {
            resource.setCoreType(type);
        }
        return resource;
    }

    private Resource createFromIPTResourceFolder(String shortname, File folder, User creator, ActionLogger alog) throws AlreadyExistingException, ImportException {
        Resource res;
        try {
            if (this.resources.containsKey(shortname)) {
                throw new AlreadyExistingException();
            }
            File dest = new File(this.dataDir.dataFile("resources"), shortname);
            FileUtils.copyDirectory((File)folder, (File)dest);
            res = this.loadFromDir(dest, creator, alog);
            if (res != null) {
                res.getManagers().clear();
                res.setCreator(creator);
                res.setModifier(creator);
                res.setCreated(new Date());
                res.setLastPublished(null);
                res.setOrganisation(null);
                res.setKey(null);
                res.setStatus(PublicationStatus.PRIVATE);
                res.setRecordsPublished(0);
                res.setMetadataVersion(Constants.INITIAL_RESOURCE_VERSION);
                res.setDoi(null);
                res.setIdentifierStatus(IdentifierStatus.UNRESERVED);
                res.setDoiOrganisationKey(null);
                res.setChangeSummary(null);
                res.getVersionHistory().clear();
                res.setPublicationMode(PublicationMode.AUTO_PUBLISH_OFF);
                res.setUpdateFrequency(null);
                res.setNextPublished(null);
                Date lastModifiedDate = new Date();
                res.setMetadataModified(lastModifiedDate);
                res.setMappingsModified(lastModifiedDate);
                res.setSourcesModified(lastModifiedDate);
                res.getSources().forEach(s -> s.setLastModified(lastModifiedDate));
                res.getMappings().forEach(m -> m.setLastModified(lastModifiedDate));
                res.getDataPackageMappings().forEach(m -> m.setLastModified(lastModifiedDate));
                if (!res.isDataPackage()) {
                    res.getEml().setDateStamp((Date)null);
                    res.getEml().setPubDate(null);
                }
                this.save(res);
            }
        }
        catch (InvalidConfigException e) {
            alog.error(e.getMessage(), (Throwable)e);
            throw new ImportException((Throwable)e);
        }
        catch (IOException e) {
            alog.error("Could not copy resource folder into data directory: " + e.getMessage(), (Throwable)e);
            throw new ImportException((Throwable)e);
        }
        return res;
    }

    private boolean isIPTResourceFolder(File dir) {
        if (dir.exists() && dir.isDirectory()) {
            File persistenceFile = new File(dir, "resource.xml");
            File emlFile = new File(dir, "eml.xml");
            File datapackageDescriptorFile = new File(dir, "datapackage.json");
            File colDpMetadataFile = new File(dir, "metadata.yaml");
            return persistenceFile.isFile() && (emlFile.isFile() || datapackageDescriptorFile.isFile() || colDpMetadataFile.isFile());
        }
        return false;
    }

    public Resource create(String shortname, String type, User creator) throws AlreadyExistingException {
        Objects.requireNonNull(shortname);
        if (this.get(shortname) != null) {
            throw new AlreadyExistingException();
        }
        Resource res = new Resource();
        res.setShortname(shortname.toLowerCase());
        res.setCreated(new Date());
        res.setCreator(creator);
        if ("camtrap-dp".equals(type)) {
            res.setDataPackageMetadata((DataPackageMetadata)new CamtrapMetadata());
            res.inferCoverageMetadataAutomatically(true);
        } else if ("coldp".equals(type)) {
            res.setDataPackageMetadata((DataPackageMetadata)new FrictionlessColMetadata());
        }
        String schemaIdentifier = this.schemaManager.getSchemaIdentifier(type);
        if (schemaIdentifier != null) {
            res.setDataPackageIdentifier(schemaIdentifier);
        }
        res.setCoreType(type);
        res.getEml().setDateStamp((Date)null);
        res.getEml().setPubDate(null);
        try {
            this.save(res);
            this.LOG.info("Created resource " + res.getShortname());
        }
        catch (InvalidConfigException e) {
            this.LOG.error("Error creating resource", (Throwable)e);
            return null;
        }
        return res;
    }

    private Resource createFromFrictionlessDataPackage(String shortname, String packageType, List<File> packageFiles, User creator, ActionLogger alog) throws AlreadyExistingException, ImportException, InvalidFilenameException {
        Resource resource;
        Objects.requireNonNull(shortname);
        if (this.get(shortname) != null) {
            throw new AlreadyExistingException();
        }
        try {
            HashMap<String, TextFileSource> sources = new HashMap<String, TextFileSource>();
            resource = this.create(shortname, packageType, creator);
            Date lastModifiedDate = new Date();
            File metadataFile = null;
            for (File packageFile : packageFiles) {
                if ("csv".equals(org.gbif.ipt.utils.FileUtils.getFileExtension((File)packageFile))) {
                    TextFileSource s = this.importSource(resource, packageFile);
                    s.setFieldsEnclosedBy("\"");
                    String filenameWithoutExtension = FilenameUtils.removeExtension((String)packageFile.getName());
                    sources.put(filenameWithoutExtension, s);
                    DataPackageMapping map = this.importDataPackageMappings(alog, packageType, packageFile, (Source)s);
                    map.setLastModified(lastModifiedDate);
                    resource.addDataPackageMapping(map);
                    continue;
                }
                if (packageFile.getName().equals("datapackage.json") && metadataFile == null) {
                    metadataFile = packageFile;
                    continue;
                }
                if (!packageFile.getName().equals("metadata.yaml")) continue;
                metadataFile = packageFile;
            }
            resource.setSourcesModified(lastModifiedDate);
            resource.setMappingsModified(lastModifiedDate);
            if (metadataFile != null) {
                DataPackageMetadata metadata = this.readDataPackageMetadata(resource.getShortname(), packageType, metadataFile, alog);
                if (metadata instanceof FrictionlessMetadata) {
                    FrictionlessMetadata frictionlessMetadata = (FrictionlessMetadata)metadata;
                    frictionlessMetadata.setName(resource.getShortname());
                    frictionlessMetadata.setId(null);
                    frictionlessMetadata.setCreated(null);
                    frictionlessMetadata.getAdditionalProperties().clear();
                }
                if (metadata instanceof CamtrapMetadata) {
                    CamtrapMetadata camtrapMetadata = (CamtrapMetadata)metadata;
                    camtrapMetadata.getContributors().stream().filter(Objects::nonNull).map(contributor -> (CamtrapContributor)contributor).filter(contributor -> CamtrapContributor.Role.CITATION_ROLES.contains(contributor.getRole())).forEach(arg_0 -> this.inferNameFieldsForCamtrapContributor(arg_0));
                }
                resource.setDataPackageMetadata(metadata);
                resource.setMetadataModified(lastModifiedDate);
                resource.setInferGeocoverageAutomatically(false);
                resource.setInferTaxonomicCoverageAutomatically(false);
                resource.setInferTemporalCoverageAutomatically(false);
            }
            this.save(resource);
            this.saveDatapackageMetadata(resource);
            alog.info("manage.resource.dp.create.success", new String[]{String.valueOf(resource.getSources().size()), String.valueOf(resource.getDataPackageMappings().size())});
        }
        catch (UnsupportedArchiveException | InvalidConfigException e) {
            alog.warn(e.getMessage(), e);
            throw new ImportException(e);
        }
        return resource;
    }

    private Resource createFromDwcArchive(String shortname, File dwca, User creator, ActionLogger alog) throws AlreadyExistingException, ImportException, InvalidFilenameException {
        Resource resource;
        Objects.requireNonNull(shortname);
        if (this.get(shortname) != null) {
            throw new AlreadyExistingException();
        }
        try {
            Eml eml;
            Archive arch = DwcFiles.fromLocation((Path)dwca.toPath());
            if (arch.getCore() == null) {
                alog.error("manage.resource.create.core.invalid");
                throw new ImportException("Darwin Core Archive is invalid and does not have a core mapping");
            }
            if (arch.getCore().getRowType() == null) {
                alog.error("manage.resource.create.core.invalid.rowType");
                throw new ImportException("Darwin Core Archive is invalid, core mapping has no rowType");
            }
            Set installedExtensionRowTypes = this.extensionManager.list().stream().map(Extension::getRowType).collect(Collectors.toSet());
            List missingExtensionRowTypes = arch.getExtensions().stream().map(e -> e.getRowType().qualifiedName()).filter(qName -> !installedExtensionRowTypes.contains(qName)).collect(Collectors.toList());
            if (!missingExtensionRowTypes.isEmpty()) {
                alog.error("manage.resource.create.rowTypes.null", new String[]{String.join((CharSequence)"<br>", missingExtensionRowTypes)});
                throw new ImportException("Resource references non-installed extension(s)");
            }
            HashMap<String, TextFileSource> sources = new HashMap<String, TextFileSource>();
            Term coreRowType = arch.getCore().getRowType();
            Resource.CoreRowType resourceType = coreRowType.equals(DwcTerm.Taxon) ? Resource.CoreRowType.CHECKLIST : (coreRowType.equals(DwcTerm.Occurrence) ? Resource.CoreRowType.OCCURRENCE : (coreRowType.equals(DwcTerm.Event) ? Resource.CoreRowType.SAMPLINGEVENT : Resource.CoreRowType.OTHER));
            resource = this.create(shortname, resourceType.toString().toUpperCase(Locale.ENGLISH), creator);
            Date lastModifiedDate = new Date();
            TextFileSource s = this.importSource(resource, arch.getCore());
            sources.put((String)arch.getCore().getLocations().get(0), s);
            ExtensionMapping map = this.importMappings(alog, arch.getCore(), (Source)s);
            map.setLastModified(lastModifiedDate);
            resource.addMapping(map);
            resource.setSourcesModified(lastModifiedDate);
            resource.setMappingsModified(lastModifiedDate);
            if (!arch.getExtensions().isEmpty()) {
                if (map.getIdColumn() == null) {
                    alog.error("manage.resource.create.core.invalid.id");
                    throw new ImportException("Darwin Core Archive is invalid, core mapping has no id element");
                }
                for (ArchiveFile ext : arch.getExtensions()) {
                    if (sources.containsKey(ext.getLocations().get(0))) {
                        s = (TextFileSource)sources.get(ext.getLocations().get(0));
                        this.LOG.debug("SourceBase " + s.getName() + " shared by multiple extensions");
                    } else {
                        s = this.importSource(resource, ext);
                        sources.put((String)ext.getLocations().get(0), s);
                    }
                    map = this.importMappings(alog, ext, (Source)s);
                    map.setLastModified(lastModifiedDate);
                    if (map.getIdColumn() == null) {
                        alog.error("manage.resource.create.core.invalid.coreid");
                        throw new ImportException("Darwin Core Archive is invalid, extension mapping has no coreId element");
                    }
                    if (resource.getCoreRowType() != null) {
                        this.updateExtensionCoreIdMapping(map, resource.getCoreRowType());
                    }
                    resource.addMapping(map);
                }
            }
            if ((eml = this.readMetadata(resource.getShortname(), arch, alog)) != null) {
                resource.setEml(eml);
                resource.setMetadataModified(lastModifiedDate);
            }
            this.save(resource);
            alog.info("manage.resource.create.success", new String[]{StringUtils.trimToEmpty((String)resource.getCoreRowType()), String.valueOf(resource.getSources().size()), String.valueOf(resource.getMappings().size())});
        }
        catch (IOException | UnsupportedArchiveException | InvalidConfigException e2) {
            alog.warn(e2.getMessage(), e2);
            throw new ImportException(e2);
        }
        return resource;
    }

    public void replaceEml(Resource resource, File emlFile, boolean validate) throws SAXException, ParserConfigurationException, IOException, InvalidEmlException, ImportException {
        if (validate) {
            this.validateEmlFile(emlFile);
        }
        Eml eml = this.copyMetadata(resource.getShortname(), emlFile);
        resource.setEml(eml);
        resource.setMetadataModified(new Date());
        this.save(resource);
        this.saveEml(resource, true);
    }

    public void replaceDatapackageMetadata(BaseAction action, Resource resource, File metadataFile, boolean validate) throws IOException, ImportException, InvalidMetadataException {
        DataPackageMetadata metadata;
        if (validate) {
            this.validateDatapackageMetadataFile(action, metadataFile, MetadataUtils.metadataClassForType((String)resource.getCoreType()));
        }
        if ((metadata = this.copyDatapackageMetadata(resource.getShortname(), metadataFile, resource.getCoreType())) instanceof ColMetadata) {
            ColMetadata colMetadata = (ColMetadata)metadata;
            colMetadata.setVersion(resource.getDataPackageMetadata().getVersion());
        }
        if (metadata instanceof FrictionlessMetadata) {
            FrictionlessMetadata frictionlessMetadata = (FrictionlessMetadata)metadata;
            frictionlessMetadata.setName(resource.getShortname());
            frictionlessMetadata.setId(null);
            frictionlessMetadata.setCreated(null);
            frictionlessMetadata.getAdditionalProperties().clear();
            frictionlessMetadata.setVersion(resource.getDataPackageMetadata().getVersion());
        }
        if (metadata instanceof CamtrapMetadata) {
            CamtrapMetadata camtrapMetadata = (CamtrapMetadata)metadata;
            camtrapMetadata.getContributors().stream().map(contributor -> (CamtrapContributor)contributor).filter(contributor -> CamtrapContributor.Role.CITATION_ROLES.contains(contributor.getRole())).forEach(arg_0 -> this.inferNameFieldsForCamtrapContributor(arg_0));
        }
        resource.setDataPackageMetadata(metadata);
        resource.setInferGeocoverageAutomatically(false);
        resource.setInferTaxonomicCoverageAutomatically(false);
        resource.setInferTemporalCoverageAutomatically(false);
        resource.setMetadataModified(new Date());
        this.save(resource);
        this.saveDatapackageMetadata(resource);
    }

    protected void inferNameFieldsForCamtrapContributor(CamtrapContributor contributor) {
        String[] names;
        String title = StringUtils.trimToNull((String)contributor.getTitle());
        if (StringUtils.isNotEmpty((CharSequence)title) && (names = title.split("\\s+")).length > 0) {
            if (names.length == 1) {
                contributor.setLastName(names[0]);
            } else {
                String firstName = names[0];
                String lastName = String.join((CharSequence)" ", Arrays.copyOfRange(names, 1, names.length));
                contributor.setFirstName(firstName);
                contributor.setLastName(lastName);
            }
        }
    }

    private void updateExtensionCoreIdMapping(ExtensionMapping mapping, String resourceCoreRowType) {
        Objects.requireNonNull(mapping.getIdColumn(), "The extension must contain a coreId element");
        String coreIdTermQName = AppConfig.coreIdTerm((String)resourceCoreRowType);
        PropertyMapping coreIdTermPropertyMapping = mapping.getField(coreIdTermQName);
        if (coreIdTermPropertyMapping == null) {
            Term coreIdTerm = TERM_FACTORY.findTerm(coreIdTermQName);
            PropertyMapping coreIdTermMapping = new PropertyMapping(new ArchiveField(mapping.getIdColumn(), coreIdTerm));
            mapping.getFields().add(coreIdTermMapping);
        } else if (coreIdTermPropertyMapping.getIndex() != null && !coreIdTermPropertyMapping.getIndex().equals(mapping.getIdColumn())) {
            mapping.setIdColumn(coreIdTermPropertyMapping.getIndex());
        }
    }

    private Resource createFromEml(String shortname, File emlFile, User creator, ActionLogger alog) throws AlreadyExistingException, ImportException {
        Eml eml;
        Objects.requireNonNull(shortname);
        if (this.get(shortname) != null) {
            throw new AlreadyExistingException();
        }
        try {
            eml = this.copyMetadata(shortname, emlFile);
        }
        catch (ImportException e) {
            alog.error("manage.resource.create.failed");
            throw e;
        }
        Resource resource = this.create(shortname, "metadata", creator);
        resource.setMetadataModified(new Date());
        resource.setEml(eml);
        return resource;
    }

    private Resource createFromPackageDescriptor(String shortname, String type, File metadataFile, User creator, ActionLogger alog) throws AlreadyExistingException, ImportException {
        DataPackageMetadata metadata;
        Objects.requireNonNull(shortname);
        if (this.get(shortname) != null) {
            throw new AlreadyExistingException();
        }
        try {
            metadata = this.copyDatapackageMetadata(shortname, metadataFile, type);
            if (metadata instanceof FrictionlessMetadata) {
                FrictionlessMetadata frictionlessMetadata = (FrictionlessMetadata)metadata;
                frictionlessMetadata.setName(shortname);
                frictionlessMetadata.setId(null);
                frictionlessMetadata.setCreated(null);
                frictionlessMetadata.getAdditionalProperties().clear();
            }
        }
        catch (ImportException e) {
            alog.error("manage.resource.create.failed");
            throw e;
        }
        Resource resource = this.create(shortname, type, creator);
        resource.setMetadataModified(new Date());
        resource.setDataPackageMetadata(metadata);
        return resource;
    }

    private Resource createFromColDpMetadata(String shortname, File metadataFile, User creator, ActionLogger alog) throws AlreadyExistingException, ImportException {
        DataPackageMetadata metadata;
        Objects.requireNonNull(shortname);
        if (this.get(shortname) != null) {
            throw new AlreadyExistingException();
        }
        try {
            metadata = this.copyDatapackageMetadata(shortname, metadataFile, "coldp");
        }
        catch (ImportException e) {
            alog.error("manage.resource.create.failed");
            throw e;
        }
        Resource resource = this.create(shortname, "coldp", creator);
        resource.setMetadataModified(new Date());
        resource.setDataPackageMetadata(metadata);
        return resource;
    }

    private void defineXstreamMapping(ResourceConvertersManager resourceConvertersManager, PasswordEncrypter passwordEncrypter) {
        this.xstream.addPermission(AnyTypePermission.ANY);
        this.xstream.ignoreUnknownElements();
        this.xstream.alias("resource", Resource.class);
        this.xstream.alias("user", User.class);
        this.xstream.alias("inferredMetadata", InferredEmlMetadata.class);
        this.xstream.alias("inferredMetadataCamtrap", InferredCamtrapMetadata.class);
        this.xstream.alias("inferredGeographicCoverage", InferredEmlGeographicCoverage.class);
        this.xstream.alias("inferredGeographicScope", InferredCamtrapGeographicScope.class);
        this.xstream.alias("inferredTaxonomicCoverage", InferredEmlTaxonomicCoverage.class);
        this.xstream.alias("inferredTaxonomicScope", InferredCamtrapTaxonomicScope.class);
        this.xstream.alias("inferredTemporalCoverage", InferredEmlTemporalCoverage.class);
        this.xstream.alias("inferredTemporalScope", InferredCamtrapTemporalScope.class);
        this.xstream.alias("taxonKeyword", TaxonKeyword.class);
        this.xstream.alias("organizedTaxonomicKeywords", OrganizedTaxonomicKeywords.class);
        this.xstream.alias("filesource", TextFileSource.class);
        this.xstream.alias("excelsource", ExcelFileSource.class);
        this.xstream.alias("sqlsource", SqlSource.class);
        this.xstream.alias("urlsource", UrlSource.class);
        this.xstream.alias("mapping", ExtensionMapping.class);
        this.xstream.alias("field", PropertyMapping.class);
        this.xstream.alias("dataPackageMapping", DataPackageMapping.class);
        this.xstream.alias("dataPackageFieldMapping", DataPackageFieldMapping.class);
        this.xstream.alias("tableSchema", DataPackageTableSchema.class);
        this.xstream.alias("dataPackageField", DataPackageField.class);
        this.xstream.alias("dataPackageForeignKey", DataPackageTableSchemaForeignKey.class);
        this.xstream.alias("dataPackageFieldReference", DataPackageFieldReference.class);
        this.xstream.alias("constraints", DataPackageFieldConstraints.class);
        this.xstream.alias("versionhistory", VersionHistory.class);
        this.xstream.alias("doi", DOI.class);
        this.xstream.omitField(Resource.class, "shortname");
        this.xstream.omitField(Resource.class, "eml");
        this.xstream.omitField(Resource.class, "dataPackageMetadata");
        this.xstream.omitField(Resource.class, "type");
        this.xstream.omitField(Resource.class, "inferredMetadata");
        this.xstream.omitField(TextFileSource.class, "file");
        this.xstream.registerConverter((Converter)resourceConvertersManager.getUserConverter());
        this.xstream.registerConverter((Converter)resourceConvertersManager.getExtensionMappingConverter());
        this.xstream.registerConverter((Converter)resourceConvertersManager.getExtensionConverter());
        this.xstream.registerConverter((Converter)resourceConvertersManager.getConceptTermConverter());
        this.xstream.registerConverter((Converter)resourceConvertersManager.getDataSchemaConverter());
        this.xstream.registerConverter((Converter)resourceConvertersManager.getTableSchemaNameConverter());
        this.xstream.registerConverter((Converter)resourceConvertersManager.getDataPackageFieldConverter());
        this.xstream.registerConverter((Converter)passwordEncrypter);
        this.xstream.addDefaultImplementation(ExtensionProperty.class, Term.class);
        this.xstream.registerConverter((Converter)resourceConvertersManager.getOrgConverter());
        this.xstream.registerConverter((Converter)resourceConvertersManager.getJdbcInfoConverter());
    }

    public void deleteResourceFromIpt(Resource resource) throws IOException {
        FileUtils.forceDelete((File)this.dataDir.resourceFile(resource, ""));
        this.resources.remove(resource.getShortname().toLowerCase());
        this.publishedPublicVersionsSimplified.remove(resource.getShortname().toLowerCase());
    }

    public void delete(Resource resource, boolean remove) throws IOException, DeletionNotAllowedException {
        if (resource.isRegistered()) {
            try {
                this.registryManager.deregister(resource);
            }
            catch (RegistryException e) {
                this.LOG.error("Failed to deregister resource: " + e.getMessage(), (Throwable)e);
                throw new DeletionNotAllowedException(DeletionNotAllowedException.Reason.REGISTRY_ERROR, e.getMessage());
            }
        }
        if (remove) {
            FileUtils.forceDelete((File)this.dataDir.resourceFile(resource, ""));
            this.resources.remove(resource.getShortname().toLowerCase());
            this.publishedPublicVersionsSimplified.remove(resource.getShortname().toLowerCase());
        }
    }

    private void generateArchive(Resource resource) {
        if (resource.isDataPackage()) {
            this.generateDataPackage(resource);
        } else {
            this.generateDwca(resource);
        }
    }

    private void generateDwca(Resource resource) {
        GenerateDwca worker = this.dwcaFactory.create(resource, (ReportHandler)this);
        Future f = this.executor.submit(worker);
        this.processFutures.put(resource.getShortname(), f);
        worker.report();
    }

    private void generateDataPackage(Resource resource) {
        GenerateDataPackage worker = this.dataPackageFactory.create(resource, (ReportHandler)this);
        Future f = this.executor.submit(worker);
        this.processFutures.put(resource.getShortname(), f);
        worker.report();
    }

    public Resource get(String shortname) {
        if (shortname == null) {
            return null;
        }
        return (Resource)this.resources.get(shortname.toLowerCase());
    }

    @NotNull
    private ExtensionMapping importMappings(ActionLogger alog, ArchiveFile af, Source source) {
        ExtensionMapping map = new ExtensionMapping();
        Extension ext = this.extensionManager.get(af.getRowType().qualifiedName());
        if (ext == null) {
            File file;
            boolean deleted;
            if (source.isFileSource() && !(deleted = FileUtils.deleteQuietly((File)(file = ((TextFileSource)source).getFile())))) {
                System.gc();
                FileUtils.deleteQuietly((File)file);
            }
            alog.warn("manage.resource.create.rowType.null", new String[]{af.getRowType().qualifiedName()});
            throw new InvalidConfigException(InvalidConfigException.TYPE.INVALID_EXTENSION, "Resource references non-installed extension");
        }
        map.setSource(source);
        map.setExtension(ext);
        if (af.getId() != null) {
            map.setIdColumn(af.getId().getIndex());
        }
        TreeSet<PropertyMapping> fields = new TreeSet<PropertyMapping>();
        for (ArchiveField f : af.getFields().values()) {
            if (f.getTerm() == null) {
                alog.warn("manage.resource.create.mapping.concept.skip", new String[]{"null", ext.getRowType()});
                continue;
            }
            if (ext.hasProperty(f.getTerm())) {
                fields.add(new PropertyMapping(f));
                continue;
            }
            alog.warn("manage.resource.create.mapping.concept.skip", new String[]{f.getTerm().qualifiedName(), ext.getRowType()});
        }
        map.setFields(fields);
        return map;
    }

    private DataPackageMapping importDataPackageMappings(ActionLogger alog, String packageType, File file, Source source) {
        String[] columnNames;
        DataPackageMapping map = new DataPackageMapping();
        DataPackageSchema dataPackageSchema = this.schemaManager.get(packageType);
        String filenameWithoutExtension = FilenameUtils.removeExtension((String)file.getName());
        if (dataPackageSchema == null) {
            boolean deleted;
            if (source.isFileSource() && !(deleted = FileUtils.deleteQuietly((File)file))) {
                System.gc();
                FileUtils.deleteQuietly((File)file);
            }
            alog.warn("manage.resource.create.schema.null", new String[]{packageType});
            throw new InvalidConfigException(InvalidConfigException.TYPE.INVALID_DATA_SCHEMA, "Resource references non-installed data schema");
        }
        DataPackageTableSchema tableSchema = dataPackageSchema.getTableSchemas().stream().filter(s -> s.getName().equals(filenameWithoutExtension)).findAny().orElse(null);
        if (tableSchema == null) {
            alog.warn("manage.resource.create.tableschema.null", new String[]{filenameWithoutExtension});
            throw new InvalidConfigException(InvalidConfigException.TYPE.INVALID_DATA_SCHEMA, "Resource references unknown schema");
        }
        map.setDataPackageSchema(dataPackageSchema);
        map.setDataPackageTableSchemaName(new DataPackageTableSchemaName(tableSchema.getName()));
        map.setSource(source);
        try (BufferedReader brTest = new BufferedReader(new FileReader(file));){
            String fileHeaderRow = brTest.readLine();
            columnNames = StringUtils.split((String)fileHeaderRow, (String)",");
        }
        catch (IOException e) {
            alog.warn("manage.resource.create.tableschema.null", new String[]{filenameWithoutExtension});
            throw new InvalidConfigException(InvalidConfigException.TYPE.INVALID_DATA_SCHEMA, "Resource references unknown schema");
        }
        ArrayList<DataPackageFieldMapping> fields = new ArrayList<DataPackageFieldMapping>();
        Map<String, DataPackageField> schemaFieldsMap = tableSchema.getFields().stream().collect(Collectors.toMap(DataPackageField::getName, p -> p));
        for (int i = 0; i < columnNames.length; ++i) {
            String unwrappedColumnName = StringUtils.unwrap((String)columnNames[i], (char)'\"');
            DataPackageField dataPackageField = schemaFieldsMap.get(unwrappedColumnName);
            if (dataPackageField != null) {
                fields.add(new DataPackageFieldMapping(Integer.valueOf(i), dataPackageField));
                continue;
            }
            alog.warn("manage.resource.create.mapping.field.skip", new String[]{columnNames[i], dataPackageSchema.getName() + "/" + tableSchema.getName()});
        }
        map.setFieldsMapped(columnNames.length);
        map.setLastModified(new Date());
        map.setFields(fields);
        return map;
    }

    private TextFileSource importSource(Resource config, ArchiveFile af) throws ImportException, InvalidFilenameException {
        File extFile = (File)af.getLocationFiles().get(0);
        TextFileSource s = (TextFileSource)this.sourceManager.add(config, extFile, (String)af.getLocations().get(0));
        SourceManagerImpl.copyArchiveFileProperties((ArchiveFile)af, (TextFileSource)s);
        if (s.getIgnoreHeaderLines() != 1) {
            this.LOG.info("Adjusting row count to " + (s.getRows() + 1 - s.getIgnoreHeaderLines()) + " from " + s.getRows() + " since header count is declared as " + s.getIgnoreHeaderLines());
        }
        s.setRows(s.getRows() + 1 - s.getIgnoreHeaderLines());
        return s;
    }

    private TextFileSource importSource(Resource config, File file) throws ImportException, InvalidFilenameException {
        TextFileSource s = (TextFileSource)this.sourceManager.add(config, file, FilenameUtils.removeExtension((String)file.getName()));
        SourceManagerImpl.copyArchiveFileProperties((File)file, (TextFileSource)s);
        if (s.getIgnoreHeaderLines() != 1) {
            this.LOG.info("Adjusting row count to " + (s.getRows() + 1 - s.getIgnoreHeaderLines()) + " from " + s.getRows() + " since header count is declared as " + s.getIgnoreHeaderLines());
        }
        s.setRows(s.getRows() + 1 - s.getIgnoreHeaderLines());
        return s;
    }

    public boolean isEmlExisting(String shortName) {
        File emlFile = this.dataDir.resourceEmlFile(shortName);
        return emlFile.exists();
    }

    /*
     * Exception decompiling
     */
    public boolean isLocked(String shortname, BaseAction action) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Integer getResourceRecordsCount(Resource resource) {
        Integer recordCount = resource.isDataPackage() ? ("camtrap-dp".equals(resource.getCoreType()) ? (Integer)resource.getRecordsByExtension().get("observations") : Integer.valueOf(resource.getRecordsByExtension().values().stream().mapToInt(Integer::intValue).sum())) : (Integer)resource.getRecordsByExtension().get(StringUtils.trimToEmpty((String)resource.getCoreRowType()));
        return recordCount != null ? recordCount : 0;
    }

    private Integer getResourceRecordsCount(Resource resource, Map<String, Integer> publishedRecordsByExtension) {
        Integer recordCount = resource.isDataPackage() ? ("camtrap-dp".equals(resource.getCoreType()) ? publishedRecordsByExtension.get("observations") : Integer.valueOf(publishedRecordsByExtension.values().stream().mapToInt(Integer::intValue).sum())) : publishedRecordsByExtension.get(StringUtils.trimToEmpty((String)resource.getCoreRowType()));
        return recordCount != null ? recordCount : 0;
    }

    public boolean isLocked(String shortname) {
        return this.isLocked(shortname, new BaseAction(this.textProvider, this.cfg, this.registrationManager));
    }

    public List<Resource> latest(int startPage, int pageSize) {
        ArrayList<Resource> resourceList = new ArrayList<Resource>();
        for (Resource r : this.resources.values()) {
            VersionHistory latestVersion = r.getLastPublishedVersion();
            if (latestVersion == null || latestVersion.getPublicationStatus().equals((Object)PublicationStatus.DELETED) || latestVersion.getPublicationStatus().equals((Object)PublicationStatus.PRIVATE)) continue;
            resourceList.add(r);
        }
        resourceList.sort((r1, r2) -> {
            if (r1 == null || r1.getModified() == null) {
                return 1;
            }
            if (r2 == null || r2.getModified() == null) {
                return -1;
            }
            if (r1.getModified().before(r2.getModified())) {
                return 1;
            }
            return -1;
        });
        return resourceList;
    }

    public List<Resource> list() {
        return new ArrayList<Resource>(this.resources.values());
    }

    public List<Resource> list(String type) {
        return this.resources.values().stream().filter(res -> type.equals(res.getCoreType())).collect(Collectors.toList());
    }

    public List<Resource> list(PublicationStatus status) {
        ArrayList<Resource> result = new ArrayList<Resource>();
        for (Resource r : this.resources.values()) {
            if (r.getStatus() != status) continue;
            result.add(r);
        }
        return result;
    }

    public List<Resource> listPublishedPublicVersions() {
        ArrayList<Resource> result = new ArrayList<Resource>();
        for (Resource r : this.resources.values()) {
            List history = r.getVersionHistory();
            if (!history.isEmpty()) {
                VersionHistory latestVersion = (VersionHistory)history.get(0);
                if (latestVersion.getPublicationStatus().equals((Object)PublicationStatus.DELETED) || latestVersion.getPublicationStatus().equals((Object)PublicationStatus.PRIVATE) || latestVersion.getReleased() == null) continue;
                result.add(r);
                continue;
            }
            if (!r.isRegistered()) continue;
            result.add(r);
        }
        return result;
    }

    public DatatableResult listPublishedPublicVersionsSimplified(DatatableRequest request) {
        List filteredResources = this.publishedPublicVersionsSimplified.values().stream().filter(p -> this.matchesSearchString(p, request.getSearch())).collect(Collectors.toList());
        Locale currentLocale = Locale.forLanguageTag(request.getLocale());
        Map datasetTypes = MapUtils.getMapWithLowercaseKeys((Map)this.vocabManager.getI18nDatasetTypesVocab(request.getLocale(), false));
        List installedSchemas = this.schemaManager.list();
        for (DataPackageSchema installedSchema : installedSchemas) {
            datasetTypes.put(installedSchema.getName(), Optional.ofNullable(installedSchema.getShortTitle()).orElse(installedSchema.getName()));
        }
        Map datasetSubtypes = MapUtils.getMapWithLowercaseKeys((Map)this.vocabManager.getI18nDatasetSubtypesVocab(request.getLocale(), false));
        List data = filteredResources.stream().sorted(this.resourceComparator(request.getSortFieldIndex(), request.getSortOrder())).skip(request.getOffset()).limit(request.getLimit()).map(res -> this.toDatatableResourcePortalView(res, currentLocale, datasetTypes, datasetSubtypes)).collect(Collectors.toList());
        DatatableResult result = new DatatableResult();
        result.setTotalRecords(this.publishedPublicVersionsSimplified.values().size());
        result.setTotalDisplayRecords(filteredResources.size());
        result.setData(data);
        return result;
    }

    private Comparator<SimplifiedResource> resourceComparator(int index, String order) {
        boolean isDescendingOrder = this.isDescendingOrder(order);
        if (index == 1) {
            return isDescendingOrder ? Comparator.comparing(SimplifiedResource::getTitleOrShortname, nullSafeStringComparator).reversed() : Comparator.comparing(SimplifiedResource::getTitleOrShortname, nullSafeStringComparator);
        }
        if (index == 2) {
            return isDescendingOrder ? Comparator.comparing(SimplifiedResource::getOrganizationAliasOrName, nullSafeStringComparator).reversed() : Comparator.comparing(SimplifiedResource::getOrganizationAliasOrName, nullSafeStringComparator);
        }
        if (index == 3) {
            return isDescendingOrder ? Comparator.comparing(SimplifiedResource::getCoreType, nullSafeStringComparator).reversed() : Comparator.comparing(SimplifiedResource::getCoreType, nullSafeStringComparator);
        }
        if (index == 4) {
            return isDescendingOrder ? Comparator.comparing(SimplifiedResource::getSubtype, nullSafeStringComparator).reversed() : Comparator.comparing(SimplifiedResource::getSubtype, nullSafeStringComparator);
        }
        if (index == 5) {
            return isDescendingOrder ? Comparator.comparingInt(SimplifiedResource::getRecordsPublished).reversed() : Comparator.comparingInt(SimplifiedResource::getRecordsPublished);
        }
        if (index == 6) {
            return isDescendingOrder ? Comparator.comparing(SimplifiedResource::getModified, nullSafeDateComparator).reversed() : Comparator.comparing(SimplifiedResource::getModified, nullSafeDateComparator);
        }
        if (index == 7) {
            return isDescendingOrder ? Comparator.comparing(SimplifiedResource::getLastPublished, nullSafeDateComparator).reversed() : Comparator.comparing(SimplifiedResource::getLastPublished, nullSafeDateComparator);
        }
        if (index == 8) {
            return isDescendingOrder ? Comparator.comparing(SimplifiedResource::getNextPublished, nullSafeDateComparator).reversed() : Comparator.comparing(SimplifiedResource::getNextPublished, nullSafeDateComparator);
        }
        if (index == 9) {
            return isDescendingOrder ? Comparator.comparing(SimplifiedResource::getStatus, Comparator.nullsFirst(Enum::compareTo)).reversed() : Comparator.comparing(SimplifiedResource::getStatus, Comparator.nullsFirst(Enum::compareTo));
        }
        if (index == 10) {
            return isDescendingOrder ? Comparator.comparing(SimplifiedResource::getCreatorName, nullSafeStringComparator).reversed() : Comparator.comparing(SimplifiedResource::getCreatorName, nullSafeStringComparator);
        }
        return isDescendingOrder ? Comparator.comparing(SimplifiedResource::getShortname, nullSafeStringComparator).reversed() : Comparator.comparing(SimplifiedResource::getShortname, nullSafeStringComparator);
    }

    private boolean isDescendingOrder(String order) {
        return StringUtils.equalsIgnoreCase((CharSequence)StringUtils.trimToEmpty((String)order), (CharSequence)"desc");
    }

    private boolean matchesSearchString(SimplifiedResource resource, String search) {
        if (StringUtils.isEmpty((CharSequence)search)) {
            return true;
        }
        return StringUtils.containsIgnoreCase((CharSequence)resource.getShortname(), (CharSequence)search) || StringUtils.containsIgnoreCase((CharSequence)resource.getTitle(), (CharSequence)search) || StringUtils.containsIgnoreCase((CharSequence)resource.getOrganisationAlias(), (CharSequence)search) || StringUtils.containsIgnoreCase((CharSequence)resource.getOrganisationName(), (CharSequence)search) || StringUtils.containsIgnoreCase((CharSequence)resource.getCoreType(), (CharSequence)search) || StringUtils.containsIgnoreCase((CharSequence)resource.getSubtype(), (CharSequence)search) || StringUtils.containsIgnoreCase((CharSequence)resource.getCreatorName(), (CharSequence)search) || StringUtils.containsIgnoreCase((CharSequence)resource.getSubject(), (CharSequence)search);
    }

    private List<String> toDatatableResourcePortalView(SimplifiedResource resource, Locale locale, Map<String, String> datasetTypes, Map<String, String> datasetSubtypes) {
        ArrayList<String> result = new ArrayList<String>();
        result.add(this.toUiLogoUrl(resource.getLogoUrl()));
        result.add(this.toResourceHomeLink(resource));
        result.add(this.toUiOrganization(resource));
        result.add(this.toTypeBadge(resource.getCoreType(), datasetTypes));
        result.add(this.toTypeBadge(resource.getSubtype(), datasetSubtypes));
        result.add(this.toUiRecordsPublished(resource, locale));
        result.add(this.toUiDateTime(resource.getModified()));
        result.add(this.toUiDateTime(resource.getLastPublished()));
        result.add(this.toUiNextPublished(resource.getNextPublished()));
        result.add(this.toUiStatus(resource.getStatus(), locale));
        result.add(resource.getCreatorName());
        result.add(resource.getShortname());
        result.add(resource.getSubject() != null ? resource.getSubject() : "");
        return result;
    }

    private List<String> toDatatableResourceManageView(SimplifiedResource resource, Locale locale, Map<String, String> datasetTypes, Map<String, String> datasetSubtypes) {
        ArrayList<String> result = new ArrayList<String>();
        result.add(this.toUiLogoUrl(resource.getLogoUrl()));
        result.add(this.toResourceManageLink(resource));
        result.add(this.toUiOrganization(resource));
        result.add(this.toTypeBadge(resource.getCoreType(), datasetTypes));
        result.add(this.toTypeBadge(resource.getSubtype(), datasetSubtypes));
        result.add(this.toUiRecordsPublished(resource, locale));
        result.add(this.toUiDateTime(resource.getModified()));
        result.add(this.toUiDateTime(resource.getLastPublished()));
        result.add(this.toUiNextPublished(resource.getNextPublished()));
        result.add(this.toUiStatus(resource.getStatus(), locale));
        result.add(resource.getCreatorName());
        result.add(resource.getShortname());
        result.add(resource.getSubject() != null ? resource.getSubject() : "");
        return result;
    }

    private String toUiDateTime(Date date) {
        if (date == null) {
            return "<span>--</span>";
        }
        return DATETIME_FORMAT.format(date);
    }

    private String toUiNextPublished(Date date) {
        if (date == null) {
            return "<span>--</span>";
        }
        Date now = new Date();
        return date.before(now) ? "<span class=\"text-gbif-danger\">" + DATETIME_FORMAT.format(date) + "</span>" : DATETIME_FORMAT.format(date);
    }

    private String toUiLogoUrl(String logoUrl) {
        if (logoUrl == null) {
            return "<span>--</span>";
        }
        return "<img class=\"resourceminilogo\" src=\"" + logoUrl + "\"/>";
    }

    private String toUiOrganization(SimplifiedResource resource) {
        String result = resource.getOrganizationAliasOrName();
        return result != null && !"No organization".equals(result) ? result : "--";
    }

    private String toUiRecordsPublished(SimplifiedResource resource, Locale locale) {
        NumberFormat format = NumberFormat.getInstance(locale);
        return "<a class=\"resource-table-link\" href='" + this.cfg.getBaseUrl() + "/resource?r=" + resource.getShortname() + "#anchor-dataRecords'>" + format.format(resource.getRecordsPublished()) + "</a>";
    }

    private String toTypeBadge(String type, Map<String, String> vocab) {
        if (type == null) {
            return "<span>--</span>";
        }
        return "<span class=\"fs-smaller-2 text-nowrap dt-content-link dt-content-pill type-" + type.toLowerCase() + "\">" + vocab.getOrDefault(type.toLowerCase(), "--") + "</span>";
    }

    private String toResourceHomeLink(SimplifiedResource resource) {
        String resourceName = (String)StringUtils.defaultIfEmpty((CharSequence)resource.getTitle(), (CharSequence)resource.getShortname());
        return "<a class=\"resource-table-link\" href='" + this.cfg.getBaseUrl() + "/resource?r=" + resource.getShortname() + "'>" + resourceName + "</a>";
    }

    private String toResourceManageLink(SimplifiedResource resource) {
        String resourceName = (String)StringUtils.defaultIfEmpty((CharSequence)resource.getTitle(), (CharSequence)resource.getShortname());
        return "<a class=\"resource-table-link\" href='" + this.cfg.getBaseUrl() + "/manage/resource?r=" + resource.getShortname() + "'>" + resourceName + "</a>";
    }

    private String toUiStatus(PublicationStatus status, Locale locale) {
        String localizedStatus = this.textProvider.getTexts(locale).getString("manage.home.visible." + status.name().toLowerCase());
        String icon = status == PublicationStatus.PUBLIC || status == PublicationStatus.PRIVATE ? "<i class=\"bi bi-circle fs-smaller-2 me-1\"></i>" : "<i class=\"bi bi-circle-fill fs-smaller-2 me-1\"></i>";
        return "<span class=\"text-nowrap status-pill fs-smaller-2 status-" + status.name().toLowerCase() + "\">" + icon + "<span>" + localizedStatus + "</span></span>";
    }

    public DatatableResult list(User user, DatatableRequest request) {
        List filteredResources = this.resources.values().stream().filter(res -> RequireManagerInterceptor.isAuthorized((User)user, (Resource)res)).map(arg_0 -> this.toSimplifiedResource(arg_0)).filter(res -> this.matchesSearchString(res, request.getSearch())).collect(Collectors.toList());
        Locale currentLocale = Locale.forLanguageTag(request.getLocale());
        Map datasetTypes = MapUtils.getMapWithLowercaseKeys((Map)this.vocabManager.getI18nDatasetTypesVocab(request.getLocale(), false));
        List installedSchemas = this.schemaManager.list();
        for (DataPackageSchema installedSchema : installedSchemas) {
            datasetTypes.put(installedSchema.getName(), Optional.ofNullable(installedSchema.getShortTitle()).orElse(installedSchema.getName()));
        }
        Map datasetSubtypes = MapUtils.getMapWithLowercaseKeys((Map)this.vocabManager.getI18nDatasetSubtypesVocab(request.getLocale(), false));
        List data = filteredResources.stream().sorted(this.resourceComparator(request.getSortFieldIndex(), request.getSortOrder())).skip(request.getOffset()).limit(request.getLimit()).map(res -> this.toDatatableResourceManageView(res, currentLocale, datasetTypes, datasetSubtypes)).collect(Collectors.toList());
        DatatableResult result = new DatatableResult();
        result.setTotalRecords(this.resources.values().size());
        result.setTotalDisplayRecords(filteredResources.size());
        result.setData(data);
        return result;
    }

    public List<Resource> list(User user) {
        ArrayList<Resource> result = new ArrayList<Resource>();
        for (Resource res : this.resources.values()) {
            if (!RequireManagerInterceptor.isAuthorized((User)user, (Resource)res)) continue;
            result.add(res);
        }
        return result;
    }

    public int load(File resourcesDir, User creator) {
        this.resources.clear();
        int counter = 0;
        int counterDeleted = 0;
        File[] files = resourcesDir.listFiles();
        if (files != null) {
            for (File resourceDir : files) {
                if (!resourceDir.isDirectory()) continue;
                File[] resourceDirFiles = resourceDir.listFiles((dir, name) -> !name.equalsIgnoreCase(".DS_Store"));
                if (resourceDirFiles == null) {
                    this.LOG.error("Resource directory " + resourceDir.getName() + " could not be read. Please verify its content");
                    continue;
                }
                if (resourceDirFiles.length == 0) {
                    this.LOG.warn("Cleaning up empty resource directory " + resourceDir.getName());
                    FileUtils.deleteQuietly((File)resourceDir);
                    ++counterDeleted;
                    continue;
                }
                try {
                    this.LOG.debug("Loading resource from directory " + resourceDir.getName());
                    this.addResource(this.loadFromDir(resourceDir, creator));
                    ++counter;
                }
                catch (InvalidConfigException e) {
                    this.LOG.error("Can't load resource " + resourceDir.getName(), (Throwable)e);
                }
            }
            this.LOG.info("Loaded " + counter + " resources into memory altogether.");
            this.LOG.info("Cleaned up " + counterDeleted + " resources altogether.");
        } else {
            this.LOG.error("Data directory does not hold a resources directory: " + String.valueOf(this.dataDir.dataFile("")));
        }
        return counter;
    }

    private void loadEml(Resource resource) {
        File emlFile = this.dataDir.resourceEmlFile(resource.getShortname());
        Eml eml = EmlUtils.loadWithLocale((File)emlFile, (Locale)Locale.US);
        resource.setEml(eml);
    }

    private void loadDatapackageMetadata(Resource resource) {
        Object metadata = "camtrap-dp".equals(resource.getCoreType()) ? new CamtrapMetadata() : ("coldp".equals(resource.getCoreType()) ? new ColMetadata() : new FrictionlessMetadata());
        File metadataFile = this.dataDir.resourceDatapackageMetadataFile(resource.getShortname(), resource.getCoreType());
        if (metadataFile.exists() && !metadataFile.isDirectory()) {
            try {
                metadata = (DataPackageMetadata)this.metadataReader.readValue(metadataFile, MetadataUtils.metadataClassForType((String)resource.getCoreType()));
            }
            catch (IOException e) {
                this.LOG.error("Failed to read resource metadata {}", (Object)resource.getShortname());
                this.LOG.error((Object)e);
                throw new RuntimeException(e);
            }
        } else if (metadata instanceof FrictionlessMetadata) {
            ((FrictionlessMetadata)metadata).setName(resource.getShortname());
        }
        resource.setDataPackageMetadata((DataPackageMetadata)metadata);
    }

    private void loadMetadata(Resource resource) {
        if (resource.isDataPackage()) {
            this.loadDatapackageMetadata(resource);
        } else {
            this.loadEml(resource);
        }
    }

    private void loadInferredMetadata(Resource resource) {
        File inferredMetadataFile = this.dataDir.resourceInferredMetadataFile(resource.getShortname());
        if (resource.isDataPackage()) {
            if ("camtrap-dp".equals(resource.getCoreType())) {
                return;
            }
            if (!inferredMetadataFile.exists()) {
                resource.setInferredMetadata((InferredMetadata)new InferredCamtrapMetadata());
                return;
            }
            try {
                InputStream input = Files.newInputStream(inferredMetadataFile.toPath(), new OpenOption[0]);
                InferredCamtrapMetadata inferredMetadata = (InferredCamtrapMetadata)this.xstream.fromXML(input);
                resource.setInferredMetadata((InferredMetadata)inferredMetadata);
            }
            catch (Exception e) {
                this.LOG.error("Cannot read inferred metadata file (Camtrap) for resource " + resource.getShortname(), (Throwable)e);
                resource.setInferredMetadata((InferredMetadata)new InferredCamtrapMetadata());
            }
        } else {
            if (inferredMetadataFile == null || !inferredMetadataFile.exists()) {
                resource.setInferredMetadata((InferredMetadata)new InferredEmlMetadata());
                return;
            }
            try {
                InputStream input = Files.newInputStream(inferredMetadataFile.toPath(), new OpenOption[0]);
                InferredEmlMetadata inferredMetadata = (InferredEmlMetadata)this.xstream.fromXML(input);
                resource.setInferredMetadata((InferredMetadata)inferredMetadata);
            }
            catch (Exception e) {
                this.LOG.error("Cannot read inferred metadata file (EML) for resource " + resource.getShortname(), (Throwable)e);
                resource.setInferredMetadata((InferredMetadata)new InferredEmlMetadata());
            }
        }
    }

    protected Resource loadFromDir(File resourceDir, @Nullable User creator) {
        return this.loadFromDir(resourceDir, creator, new ActionLogger(this.LOG, new BaseAction(this.textProvider, this.cfg, this.registrationManager)));
    }

    private Resource loadFromDir(File resourceDir, @Nullable User creator, ActionLogger alog) throws InvalidConfigException {
        if (resourceDir.exists()) {
            String shortname = resourceDir.getName();
            try {
                VersionHistory history;
                File cfgFile = this.dataDir.resourceFile(shortname);
                FileInputStream input = new FileInputStream(cfgFile);
                Resource resource = (Resource)this.xstream.fromXML((InputStream)input);
                if (creator != null && resource.getCreator() == null) {
                    resource.setCreator(creator);
                    this.LOG.warn("On load, populated missing creator for resource: " + shortname);
                }
                resource.getManagers().remove(null);
                for (ExtensionMapping ext : resource.getMappings()) {
                    Extension x = ext.getExtension();
                    if (x == null) {
                        alog.warn("manage.resource.create.extension.null", new String[]{ext.getExtensionVerbatim()});
                        throw new InvalidConfigException(InvalidConfigException.TYPE.INVALID_EXTENSION, "Resource references non-existent extension");
                    }
                    if (this.extensionManager.get(x.getRowType()) == null) {
                        alog.warn("manage.resource.create.rowType.null", new String[]{x.getRowType()});
                        throw new InvalidConfigException(InvalidConfigException.TYPE.INVALID_EXTENSION, "Resource references non-installed extension");
                    }
                    if (!ext.isCore() || ext.isTaxonCore() || ext.getIdColumn() == null || !ext.getIdColumn().equals(ExtensionMapping.IDGEN_LINE_NUMBER) && !ext.getIdColumn().equals(ExtensionMapping.IDGEN_UUID)) continue;
                    ext.setIdColumn(ExtensionMapping.NO_ID);
                }
                resource.setShortname(shortname);
                if (resource.getCoreType() == null) {
                    this.inferCoreType(resource);
                }
                if (resource.getSubtype() != null) {
                    this.standardizeSubtype(resource);
                }
                for (Source src : resource.getSources()) {
                    src.setResource(resource);
                    src.setProcessing(false);
                    if (!(src instanceof FileSource)) continue;
                    FileSource frSrc = (FileSource)src;
                    frSrc.setFile(this.dataDir.sourceFile(resource, frSrc));
                }
                if (resource.getIdentifierStatus() == null) {
                    resource.setIdentifierStatus(IdentifierStatus.UNRESERVED);
                }
                this.loadMetadata(resource);
                this.loadInferredMetadata(resource);
                BigDecimal converted = this.convertVersion(resource);
                if (converted != null) {
                    this.updateResourceVersion(resource, resource.getMetadataVersion(), converted);
                }
                if ((history = this.constructVersionHistoryForLastPublishedVersion(resource)) != null) {
                    resource.addVersionHistory(history);
                }
                if (resource.getDataPackageIdentifier() == null) {
                    if (resource.getLastPublishedVersionsVersion() != null) {
                        this.renameDwcaToIncludeVersion(resource, resource.getLastPublishedVersionsVersion());
                    }
                    this.syncEmlWithResource(resource);
                }
                this.LOG.debug("Read resource configuration for " + shortname);
                return resource;
            }
            catch (Exception e) {
                this.LOG.error("Cannot read resource configuration for " + shortname, (Throwable)e);
                throw new InvalidConfigException(InvalidConfigException.TYPE.RESOURCE_CONFIG, "Cannot read resource configuration for " + shortname + ": " + e.getMessage());
            }
        }
        return null;
    }

    protected BigDecimal convertVersion(Resource resource) {
        if (resource.getMetadataVersion() != null) {
            BigDecimal version = resource.getMetadataVersion();
            if (version.equals(BigDecimal.ZERO)) {
                return Constants.INITIAL_RESOURCE_VERSION;
            }
            if (version.scale() == 0) {
                BigDecimal majorMinorVersion = version.setScale(1, RoundingMode.CEILING);
                this.LOG.debug("Converted version [" + version.toPlainString() + "] to [" + majorMinorVersion.toPlainString() + "]");
                return majorMinorVersion;
            }
        }
        return null;
    }

    protected Resource updateResourceVersion(Resource resource, BigDecimal oldVersion, BigDecimal newVersion) {
        Objects.requireNonNull(resource);
        Objects.requireNonNull(oldVersion);
        Objects.requireNonNull(newVersion);
        if (!oldVersion.equals(newVersion)) {
            try {
                File oldEml = this.dataDir.resourceEmlFile(resource.getShortname(), oldVersion);
                File newEml = this.dataDir.resourceEmlFile(resource.getShortname(), newVersion);
                if (oldEml.exists() && !newEml.exists()) {
                    FileUtils.moveFile((File)oldEml, (File)newEml);
                }
                File oldRtf = this.dataDir.resourceRtfFile(resource.getShortname(), oldVersion);
                File newRtf = this.dataDir.resourceRtfFile(resource.getShortname(), newVersion);
                if (oldRtf.exists() && !newRtf.exists()) {
                    FileUtils.moveFile((File)oldRtf, (File)newRtf);
                }
                File oldDwca = this.dataDir.resourceDwcaFile(resource.getShortname(), oldVersion);
                File newDwca = this.dataDir.resourceDwcaFile(resource.getShortname(), newVersion);
                if (oldDwca.exists() && !newDwca.exists()) {
                    FileUtils.moveFile((File)oldDwca, (File)newDwca);
                }
                resource.setMetadataVersion(newVersion);
            }
            catch (IOException e) {
                this.LOG.error("Failed to update version number for " + resource.getShortname(), (Throwable)e);
                throw new InvalidConfigException(InvalidConfigException.TYPE.CONFIG_WRITE, "Failed to update version number for " + resource.getShortname() + ": " + e.getMessage());
            }
        }
        return resource;
    }

    protected void renameDwcaToIncludeVersion(Resource resource, BigDecimal version) {
        Objects.requireNonNull(resource);
        Objects.requireNonNull(version);
        File unversionedDwca = this.dataDir.resourceDwcaFile(resource.getShortname());
        File versionedDwca = this.dataDir.resourceDwcaFile(resource.getShortname(), version);
        if (unversionedDwca.exists() && !versionedDwca.exists()) {
            try {
                FileUtils.moveFile((File)unversionedDwca, (File)versionedDwca);
                this.LOG.debug("Renamed dwca.zip to " + versionedDwca.getName());
            }
            catch (IOException e) {
                this.LOG.error("Failed to rename dwca.zip file name with version number for " + resource.getShortname(), (Throwable)e);
                throw new InvalidConfigException(InvalidConfigException.TYPE.CONFIG_WRITE, "Failed to update version number for " + resource.getShortname() + ": " + e.getMessage());
            }
        }
    }

    protected VersionHistory constructVersionHistoryForLastPublishedVersion(Resource resource) {
        if (resource.isPublished() && resource.getVersionHistory().isEmpty()) {
            VersionHistory vh = new VersionHistory(resource.getMetadataVersion(), resource.getLastPublished(), resource.getStatus());
            vh.setRecordsPublished(resource.getRecordsPublished());
            return vh;
        }
        return null;
    }

    Resource inferCoreType(Resource resource) {
        if (resource != null && resource.getCoreRowType() != null) {
            if (Constants.DWC_ROWTYPE_OCCURRENCE.equalsIgnoreCase(resource.getCoreRowType())) {
                resource.setCoreType(Resource.CoreRowType.OCCURRENCE.toString().toLowerCase());
            } else if (Constants.DWC_ROWTYPE_TAXON.equalsIgnoreCase(resource.getCoreRowType())) {
                resource.setCoreType(Resource.CoreRowType.CHECKLIST.toString().toLowerCase());
            } else if (Constants.DWC_ROWTYPE_EVENT.equalsIgnoreCase(resource.getCoreRowType())) {
                resource.setCoreType(Resource.CoreRowType.SAMPLINGEVENT.toString().toLowerCase());
            }
        }
        return resource;
    }

    Resource standardizeSubtype(Resource resource) {
        if (resource != null && resource.getSubtype() != null) {
            Map subtypes = this.vocabManager.getI18nVocab("http://rs.gbif.org/vocabulary/gbif/datasetSubtype", Locale.ENGLISH.getLanguage(), false);
            boolean usesVocab = false;
            for (Map.Entry entry : subtypes.entrySet()) {
                if (!resource.getSubtype().equalsIgnoreCase((String)entry.getKey())) continue;
                usesVocab = true;
                break;
            }
            if (!usesVocab) {
                resource.setSubtype(null);
            }
        }
        return resource;
    }

    public boolean publish(Resource resource, BigDecimal version, BaseAction action) throws PublicationException, InvalidConfigException {
        return this.publish(resource, version, action, false);
    }

    public boolean publish(Resource resource, BigDecimal version, BaseAction action, boolean skipIfNotChanged) throws PublicationException, InvalidConfigException {
        PublicationOptions options = PublicationOptions.builder().skipPublicationIfNotChanged(skipIfNotChanged).build();
        return this.publish(resource, version, action, options);
    }

    public boolean publish(Resource resource, BigDecimal version, BaseAction action, PublicationOptions options) throws PublicationException, InvalidConfigException {
        String shortname = resource.getShortname();
        if (action == null) {
            action = new BaseAction(this.textProvider, this.cfg, this.registrationManager);
        }
        this.addOrUpdateVersionHistory(resource, version, false, action);
        StatusReport report = this.status(shortname);
        if (report != null) {
            this.processReports.remove(shortname);
        }
        if (!options.isSkipPublicationIfNotChanged()) {
            this.resourcesToSkip.remove(shortname);
        }
        if (resource.isMetadataOnly() && options.isSkipPublicationIfNotChanged()) {
            boolean metadataChanged;
            Date lastPublished = resource.getLastPublished();
            Date metadataLastModified = resource.getMetadataModified();
            boolean bl = metadataChanged = metadataLastModified == null || metadataLastModified.after(lastPublished);
            if (!metadataChanged) {
                String metadataNotChangedStatus = action.getText("publishing.metadataNotChanged");
                StatusReport updated = new StatusReport(true, metadataNotChangedStatus, this.getTaskMessages(shortname));
                this.processReports.put(shortname, updated);
                return false;
            }
        }
        this.preventPublicationForSourcesInProcessingState(resource);
        this.publishMetadata(resource, version, action);
        this.publishRtf(resource, version);
        boolean archive = false;
        if (resource.hasAnyMappedData()) {
            if (options.isSkipPublicationIfNotChanged()) {
                this.resourcesToSkip.add(shortname);
            }
            this.generateArchive(resource);
            archive = true;
        } else {
            resource.setRecordsPublished(0);
            this.publishEnd(resource, action, version);
        }
        return archive;
    }

    private void preventPublicationForSourcesInProcessingState(Resource resource) {
        Optional<Source> sourceBeingProcessed = resource.getMappings().stream().map(ExtensionMapping::getSource).filter(Source::isProcessing).findAny();
        if (sourceBeingProcessed.isPresent()) {
            PublicationException e = new PublicationException(PublicationException.TYPE.LOCKED, "Resource's " + resource.getShortname() + " source " + String.valueOf(sourceBeingProcessed.get()) + " is currently being processed");
            e.addAdditionalParameter("source", (Object)sourceBeingProcessed.get().getName());
            throw e;
        }
    }

    private void publishEnd(Resource resource, BaseAction action, BigDecimal version) throws PublicationException, InvalidConfigException {
        if (action == null) {
            action = new BaseAction(this.textProvider, this.cfg, this.registrationManager);
        }
        BigDecimal replacedMetadataVersion = resource.getReplacedMetadataVersion();
        this.updateRegistration(resource, action);
        resource.setLastPublished(new Date());
        this.updateNextPublishedDate(new Date(), resource);
        this.executeDoiWorkflow(resource, version, replacedMetadataVersion, action);
        this.addOrUpdateVersionHistory(resource, version, true, action);
        if (resource.getStatus() == PublicationStatus.PRIVATE) {
            this.publishedPublicVersionsSimplified.remove(resource.getShortname());
        }
        this.save(resource);
        if (!this.cfg.isArchivalMode() && version.compareTo(replacedMetadataVersion) != 0) {
            this.removeArchiveVersion(resource.getShortname(), replacedMetadataVersion);
        }
        if (this.cfg.isArchivalMode() && this.cfg.getArchivalLimit() != null && this.cfg.getArchivalLimit() > 0) {
            this.cleanArchiveVersions(resource);
        }
        String msg = action.getText("publishing.success", new String[]{String.valueOf(resource.getMetadataVersion()), resource.getShortname()});
        action.addActionMessage(msg);
        this.LOG.info(msg);
    }

    private void executeDoiWorkflow(Resource resource, BigDecimal version, BigDecimal versionReplaced, BaseAction action) throws PublicationException {
        if (resource.getDoi() != null && resource.isPubliclyAvailable() && (resource.getIdentifierStatus().equals((Object)IdentifierStatus.PUBLIC_PENDING_PUBLICATION) || resource.getIdentifierStatus().equals((Object)IdentifierStatus.PUBLIC))) {
            if (resource.getIdentifierStatus().equals((Object)IdentifierStatus.PUBLIC_PENDING_PUBLICATION)) {
                if (resource.isAlreadyAssignedDoi()) {
                    this.doReplaceDoi(resource, version, versionReplaced);
                    String msg = action.getText("manage.overview.publishing.doi.publish.newMajorVersion.replaces", new String[]{resource.getDoi().toString()});
                    this.LOG.info(msg);
                    action.addActionMessage(msg);
                } else {
                    this.doRegisterDoi(resource, null);
                    String msg = action.getText("manage.overview.publishing.doi.publish.newMajorVersion", new String[]{resource.getDoi().toString()});
                    this.LOG.info(msg);
                    action.addActionMessage(msg);
                }
            } else {
                this.doUpdateDoi(resource);
                String msg = action.getText("manage.overview.publishing.doi.publish.newMinorVersion", new String[]{resource.getDoi().toString()});
                this.LOG.info(msg);
                action.addActionMessage(msg);
            }
        }
    }

    protected void doRegisterDoi(Resource resource, @Nullable DOI replaced) {
        Objects.requireNonNull(resource);
        if (resource.getDoi() != null && resource.isPubliclyAvailable()) {
            DataCiteMetadata dataCiteMetadata = null;
            DOI doi = resource.getDoi();
            try {
                URI uri = this.cfg.getResourceUri(resource.getShortname());
                dataCiteMetadata = DataCiteMetadataBuilder.createDataCiteMetadata((DOI)doi, (Resource)resource);
                if (replaced != null) {
                    DataCiteMetadataBuilder.addIsNewVersionOfDOIRelatedIdentifier((DataCiteMetadata)dataCiteMetadata, (DOI)replaced);
                }
                this.registrationManager.getDoiService().register(doi, uri, dataCiteMetadata);
                resource.setIdentifierStatus(IdentifierStatus.PUBLIC);
                resource.updateAlternateIdentifierForDOI();
                resource.updateCitationIdentifierForDOI();
            }
            catch (DoiExistsException e) {
                this.LOG.warn("Received DoiExistsException registering resource meaning this is an existing DOI that should be updated instead", (Throwable)e);
                try {
                    this.registrationManager.getDoiService().update(doi, dataCiteMetadata);
                    resource.setIdentifierStatus(IdentifierStatus.PUBLIC);
                    resource.updateAlternateIdentifierForDOI();
                    resource.updateCitationIdentifierForDOI();
                }
                catch (DoiException e2) {
                    String errorMsg = "Failed to update existing DOI  " + doi.toString() + ": " + e2.getMessage();
                    this.LOG.error(errorMsg, (Throwable)e2);
                    throw new PublicationException(PublicationException.TYPE.DOI, errorMsg, (Exception)((Object)e2));
                }
            }
            catch (org.gbif.doi.service.InvalidMetadataException e) {
                String errorMsg = "Failed to register " + doi.toString() + " because DOI metadata was invalid: " + e.getMessage();
                this.LOG.error(errorMsg);
                throw new PublicationException(PublicationException.TYPE.DOI, errorMsg, (Exception)((Object)e));
            }
            catch (DoiException e) {
                String errorMsg = "Failed to register " + doi.toString() + ": " + e.getMessage();
                this.LOG.error(errorMsg);
                throw new PublicationException(PublicationException.TYPE.DOI, errorMsg, (Exception)((Object)e));
            }
        } else {
            throw new InvalidConfigException(InvalidConfigException.TYPE.INVALID_DOI_REGISTRATION, "Resource not in required state to register DOI!");
        }
    }

    protected void doUpdateDoi(Resource resource) {
        Objects.requireNonNull(resource);
        if (resource.getDoi() != null && resource.isPubliclyAvailable()) {
            DOI doi = resource.getDoi();
            try {
                DataCiteMetadata dataCiteMetadata = DataCiteMetadataBuilder.createDataCiteMetadata((DOI)doi, (Resource)resource);
                this.registrationManager.getDoiService().update(doi, dataCiteMetadata);
            }
            catch (DoiException e) {
                String errorMsg = "Failed to update " + doi.toString() + " metadata: " + e.getMessage();
                this.LOG.error(errorMsg);
                throw new PublicationException(PublicationException.TYPE.DOI, errorMsg, (Exception)((Object)e));
            }
        } else {
            throw new InvalidConfigException(InvalidConfigException.TYPE.INVALID_DOI_REGISTRATION, "Resource not in required state to update DOI!");
        }
    }

    protected void doReplaceDoi(Resource resource, BigDecimal version, BigDecimal replacedVersion) {
        Objects.requireNonNull(resource);
        DOI doiToRegister = resource.getDoi();
        DOI doiToReplace = resource.getAssignedDoi();
        if (doiToRegister != null && resource.isPubliclyAvailable() && doiToReplace != null && resource.getMetadataVersion() != null && resource.getMetadataVersion().compareTo(version) == 0 && replacedVersion != null && resource.findVersionHistory(replacedVersion) != null) {
            this.doRegisterDoi(resource, doiToReplace);
            try {
                File replacedVersionEmlFile = this.dataDir.resourceEmlFile(resource.getShortname(), replacedVersion);
                Resource lastPublishedVersion = ResourceUtils.reconstructVersion((BigDecimal)replacedVersion, (String)resource.getShortname(), (String)resource.getCoreType(), (String)resource.getDataPackageIdentifier(), (DOI)doiToReplace, (Organisation)resource.getOrganisation(), (VersionHistory)resource.findVersionHistory(replacedVersion), (File)replacedVersionEmlFile, (UUID)resource.getKey());
                DataCiteMetadata assignedDoiMetadata = DataCiteMetadataBuilder.createDataCiteMetadata((DOI)doiToReplace, (Resource)lastPublishedVersion);
                DataCiteMetadataBuilder.addIsPreviousVersionOfDOIRelatedIdentifier((DataCiteMetadata)assignedDoiMetadata, (DOI)doiToRegister);
                URI resourceVersionUri = this.cfg.getResourceVersionUri(resource.getShortname(), replacedVersion);
                this.registrationManager.getDoiService().update(doiToReplace, resourceVersionUri);
                this.registrationManager.getDoiService().update(doiToReplace, assignedDoiMetadata);
            }
            catch (org.gbif.doi.service.InvalidMetadataException e) {
                String errorMsg = "Failed to update " + String.valueOf(doiToReplace) + " metadata: " + e.getMessage();
                this.LOG.error(errorMsg);
                throw new PublicationException(PublicationException.TYPE.DOI, errorMsg, (Exception)((Object)e));
            }
            catch (DoiException e) {
                String errorMsg = "Failed to update " + String.valueOf(doiToReplace) + ": " + e.getMessage();
                this.LOG.error(errorMsg);
                throw new PublicationException(PublicationException.TYPE.DOI, errorMsg, (Exception)((Object)e));
            }
            catch (IllegalArgumentException e) {
                String errorMsg = "Failed to update " + String.valueOf(doiToReplace) + ": " + e.getMessage();
                this.LOG.error(errorMsg, (Throwable)e);
                throw new PublicationException(PublicationException.TYPE.DOI, errorMsg, (Exception)e);
            }
        } else {
            throw new InvalidConfigException(InvalidConfigException.TYPE.INVALID_DOI_REGISTRATION, "Resource not in required state to replace DOI!");
        }
    }

    private BigDecimal getVersionToRestore(@NotNull Resource resource, @NotNull BigDecimal toRollBack) {
        BigDecimal lastVersion = resource.getLastVersionHistoryVersion();
        BigDecimal penultimateVersion = resource.getLastPublishedVersionsVersion();
        if (penultimateVersion != null && penultimateVersion.compareTo(Constants.INITIAL_RESOURCE_VERSION) >= 0 && lastVersion != null && lastVersion.compareTo(toRollBack) == 0 && penultimateVersion.compareTo(lastVersion) != 0) {
            return penultimateVersion;
        }
        return null;
    }

    public void restoreVersion(Resource resource, BigDecimal rollingBack, BaseAction action) {
        if (action == null) {
            action = new BaseAction(this.textProvider, this.cfg, this.registrationManager);
        }
        if (resource.isDataPackage()) {
            this.restoreDataPackageResourceVersion(resource, rollingBack, action);
        } else {
            this.restoreDarwinCoreResourceVersion(resource, rollingBack, action);
        }
    }

    private void restoreDarwinCoreResourceVersion(Resource resource, BigDecimal rollingBack, BaseAction action) {
        BigDecimal toRestore = this.getVersionToRestore(resource, rollingBack);
        if (toRestore != null) {
            String shortname = resource.getShortname();
            this.LOG.info("Rolling back version #" + rollingBack.toPlainString() + ". Restoring version #" + toRestore.toPlainString() + " of resource " + shortname);
            try {
                File versionedDwcaFile;
                File versionedRTFFile;
                File versionedEMLFile = this.dataDir.resourceEmlFile(shortname, rollingBack);
                if (versionedEMLFile.exists()) {
                    FileUtils.forceDelete((File)versionedEMLFile);
                }
                if ((versionedRTFFile = this.dataDir.resourceRtfFile(shortname, rollingBack)).exists()) {
                    FileUtils.forceDelete((File)versionedRTFFile);
                }
                if ((versionedDwcaFile = this.dataDir.resourceDwcaFile(shortname, rollingBack)).exists()) {
                    FileUtils.forceDelete((File)versionedDwcaFile);
                }
                resource.removeVersionHistory(rollingBack);
                VersionHistory restoredVersionVersionHistory = resource.findVersionHistory(toRestore);
                if (restoredVersionVersionHistory != null) {
                    resource.setRecordsPublished(restoredVersionVersionHistory.getRecordsPublished());
                }
                resource.setMetadataVersion(toRestore);
                if (resource.getVersionHistory().size() > 1) {
                    BigDecimal replacedVersion = new BigDecimal(((VersionHistory)resource.getVersionHistory().get(1)).getVersion());
                    resource.setReplacedEmlVersion(replacedVersion);
                }
                this.save(resource);
                if (resource.getLastPublished() != null) {
                    resource.getEml().setPubDate(resource.getLastPublished());
                }
                this.saveEml(resource);
            }
            catch (IOException e) {
                String msg = action.getText("restore.resource.failed", new String[]{toRestore.toPlainString(), shortname, e.getMessage()});
                this.LOG.error(msg, (Throwable)e);
                action.addActionError(msg);
            }
            String msg = action.getText("restore.resource.success", new String[]{toRestore.toPlainString(), shortname});
            this.LOG.info(msg);
            action.addActionMessage(msg);
            StatusReport report = (StatusReport)this.processReports.get(shortname);
            if (report != null) {
                report.getMessages().add(new TaskMessage(Level.INFO, msg));
            }
        } else {
            String msg = action.getText("restore.resource.failed.version.notFound", new String[]{rollingBack.toPlainString()});
            this.LOG.error(msg);
            action.addActionError(msg);
        }
    }

    private void restoreDataPackageResourceVersion(Resource resource, BigDecimal rollingBack, BaseAction action) {
        BigDecimal toRestore = this.getVersionToRestore(resource, rollingBack);
        if (toRestore != null) {
            String shortname = resource.getShortname();
            this.LOG.info("Rolling back version #" + rollingBack.toPlainString() + ". Restoring version #" + toRestore.toPlainString() + " of resource " + shortname);
            try {
                File versionedDataPackageFile;
                File versionedColMetadataFile;
                File versionedCamtrapMetadataFile = this.dataDir.resourceDatapackageMetadataFile(shortname, "camtrap-dp", rollingBack);
                if (versionedCamtrapMetadataFile.exists()) {
                    FileUtils.forceDelete((File)versionedCamtrapMetadataFile);
                }
                if ((versionedColMetadataFile = this.dataDir.resourceDatapackageMetadataFile(shortname, "coldp", rollingBack)).exists()) {
                    FileUtils.forceDelete((File)versionedColMetadataFile);
                }
                if ((versionedDataPackageFile = this.dataDir.resourceDataPackageFile(shortname, rollingBack)).exists()) {
                    FileUtils.forceDelete((File)versionedDataPackageFile);
                }
                resource.removeVersionHistory(rollingBack);
                resource.setMetadataVersion(toRestore);
                if (resource.getVersionHistory().size() > 1) {
                    BigDecimal replacedVersion = new BigDecimal(((VersionHistory)resource.getVersionHistory().get(1)).getVersion());
                    resource.setReplacedDataPackageMetadataVersion(replacedVersion);
                }
                this.save(resource);
                this.saveDatapackageMetadata(resource);
            }
            catch (IOException e) {
                String msg = action.getText("restore.resource.failed", new String[]{toRestore.toPlainString(), shortname, e.getMessage()});
                this.LOG.error(msg, (Throwable)e);
                action.addActionError(msg);
            }
            String msg = action.getText("restore.resource.success", new String[]{toRestore.toPlainString(), shortname});
            this.LOG.info(msg);
            action.addActionMessage(msg);
            StatusReport report = (StatusReport)this.processReports.get(shortname);
            if (report != null) {
                report.getMessages().add(new TaskMessage(Level.INFO, msg));
            }
        } else {
            String msg = action.getText("restore.resource.failed.version.notFound", new String[]{rollingBack.toPlainString()});
            this.LOG.error(msg);
            action.addActionError(msg);
        }
    }

    public Resource updateAlternateIdentifierForRegistry(Resource resource) {
        Eml eml = resource.getEml();
        if (eml != null) {
            List currentIds = eml.getAlternateIdentifiers();
            if (currentIds != null) {
                UUID key;
                ArrayList<String> ids = new ArrayList<String>();
                for (String id : currentIds) {
                    ids.add(id.toLowerCase());
                }
                if (resource.isRegistered() && (key = resource.getKey()) != null && !ids.contains(key.toString().toLowerCase())) {
                    currentIds.add(key.toString());
                    this.saveEml(resource);
                    if (this.cfg.debug()) {
                        this.LOG.info("GBIF Registry UUID added to Resource's list of alternate identifiers");
                    }
                }
            }
        } else {
            resource.setEml(new Eml());
        }
        return resource;
    }

    public Resource updateAlternateIdentifierForIPTURLToResource(Resource resource) {
        List ids = null;
        if (resource.getEml() != null) {
            ids = resource.getEml().getAlternateIdentifiers();
        } else {
            resource.setEml(new Eml());
        }
        if (ids != null) {
            boolean exists = false;
            String existingId = null;
            for (String id : ids) {
                if (!id.contains("resource")) continue;
                exists = true;
                existingId = id;
            }
            if (resource.getStatus().compareTo((Enum)PublicationStatus.PRIVATE) != 0) {
                String url = this.cfg.getResourceUrl(resource.getShortname());
                if (exists) {
                    ids.remove(existingId);
                }
                ids.add(url);
                this.saveEml(resource);
                if (this.cfg.debug()) {
                    this.LOG.info("IPT URL to resource added to (or updated in) Resource's list of alt ids");
                }
            } else if (resource.getStatus().compareTo((Enum)PublicationStatus.PRIVATE) == 0 && exists) {
                ids.remove(existingId);
                this.saveEml(resource);
                if (this.cfg.debug()) {
                    this.LOG.info("Following visibility change, IPT URL to resource was removed from Resource's list of alt ids");
                }
            }
        }
        return resource;
    }

    private void publishMetadata(Resource resource, BigDecimal version, BaseAction action) throws PublicationException {
        if (resource.isDataPackage()) {
            this.publishDataPackageMetadata(resource, version);
        } else {
            this.publishEml(resource, version, action);
        }
    }

    private void publishEml(Resource resource, BigDecimal version, BaseAction action) throws PublicationException {
        String shortname = resource.getShortname();
        if (this.isLocked(shortname)) {
            throw new PublicationException(PublicationException.TYPE.LOCKED, "Resource " + shortname + " is currently locked by another process");
        }
        if (resource.isMetadataOnly()) {
            StatusReport report = new StatusReport("Started publishing EML #" + String.valueOf(version), new ArrayList());
            this.processReports.put(shortname, report);
            this.getTaskMessages(shortname).add(new TaskMessage(Level.INFO, "EML generation started for version #" + String.valueOf(version)));
        }
        this.updateAlternateIdentifierForRegistry(resource);
        this.updateAlternateIdentifierForIPTURLToResource(resource);
        resource.setMetadataVersion(version);
        resource.getEml().setPubDate(new Date());
        if (resource.getEml().getDateStamp() == null) {
            resource.getEml().setDateStamp(new Date());
        }
        if (resource.isCitationAutoGenerated()) {
            URI homepage = this.cfg.getResourceVersionUri(shortname, version);
            String citation = resource.generateResourceCitation(version, homepage);
            if (resource.getEml().getCitation() != null) {
                resource.getEml().getCitation().setCitation(citation);
            } else {
                Citation c = new Citation();
                c.setCitation(citation);
                resource.getEml().setCitation(c);
            }
        }
        if (resource.isInferGeocoverageAutomatically() || resource.isInferTaxonomicCoverageAutomatically() || resource.isInferTemporalCoverageAutomatically()) {
            InferredEmlMetadata inferredMetadata = (InferredEmlMetadata)this.resourceMetadataInferringService.inferMetadata(resource);
            resource.setInferredMetadata((InferredMetadata)inferredMetadata);
            this.saveInferredMetadata(resource);
            if (resource.isInferGeocoverageAutomatically()) {
                this.updateEmlGeocoverageWithInferredFromSourceData(resource, inferredMetadata);
            }
            if (resource.isInferTaxonomicCoverageAutomatically()) {
                this.updateEmlTaxonomicCoverageWithInferredFromSourceData(resource, inferredMetadata);
            }
            if (resource.isInferTemporalCoverageAutomatically()) {
                this.updateEmlTemporalCoverageWithInferredFromSourceData(resource, inferredMetadata);
            }
        }
        this.saveEml(resource);
        File trunkFile = this.dataDir.resourceEmlFile(shortname);
        if (Resource.CoreRowType.METADATA.toString().equalsIgnoreCase(resource.getCoreType())) {
            PublicationException exception;
            try {
                EmlValidator emlValidator = EmlValidator.newValidator((EMLProfileVersion)EMLProfileVersion.GBIF_1_3);
                String emlString = FileUtils.readFileToString((File)trunkFile, (Charset)StandardCharsets.UTF_8);
                this.getTaskMessages(shortname).add(new TaskMessage(Level.INFO, "? Validating EML file"));
                emlValidator.validate(emlString);
                this.getTaskMessages(shortname).add(new TaskMessage(Level.INFO, "\u2713 Validated EML file"));
                StatusReport report = new StatusReport(true, action.getText("publishing.success", new String[]{version.toPlainString(), shortname}), this.getTaskMessages(shortname));
                this.processReports.put(shortname, report);
            }
            catch (IOException | SAXException e) {
                this.getTaskMessages(shortname).add(new TaskMessage(Level.ERROR, "Failed to validate EML"));
                exception = new PublicationException(PublicationException.TYPE.EML, "Can't publish eml file for resource " + shortname + ". Failed to validate EML", e);
                StatusReport errorReport = new StatusReport((Exception)((Object)exception), action.getText("publishing.failed", new String[]{version.toPlainString(), shortname, "Failed to validate EML"}), this.getTaskMessages(shortname));
                this.processReports.put(shortname, errorReport);
                throw exception;
            }
            catch (InvalidEmlException e) {
                this.getTaskMessages(shortname).add(new TaskMessage(Level.ERROR, "Invalid EML:  " + e.getMessage()));
                exception = new PublicationException(PublicationException.TYPE.EML, "Can't publish eml file for resource " + resource.getShortname() + ". Invalid EML", (Exception)((Object)e));
                StatusReport errorReport = new StatusReport((Exception)((Object)exception), action.getText("publishing.failed", new String[]{version.toPlainString(), shortname, "Invalid EML"}), this.getTaskMessages(shortname));
                this.processReports.put(shortname, errorReport);
                throw exception;
            }
        }
        File versionedFile = this.dataDir.resourceEmlFile(resource.getShortname(), version);
        try {
            FileUtils.copyFile((File)trunkFile, (File)versionedFile);
        }
        catch (IOException e) {
            throw new PublicationException(PublicationException.TYPE.EML, "Can't publish eml file for resource " + resource.getShortname(), (Exception)e);
        }
    }

    public void publishDataPackageMetadata(Resource resource, BigDecimal version) {
        if (this.isLocked(resource.getShortname())) {
            throw new PublicationException(PublicationException.TYPE.LOCKED, "Resource " + resource.getShortname() + " is currently locked by another process");
        }
        resource.setMetadataVersion(version);
        if (resource.getDataPackageMetadata() instanceof FrictionlessMetadata) {
            FrictionlessMetadata frictionlessMetadata = (FrictionlessMetadata)resource.getDataPackageMetadata();
            frictionlessMetadata.setCreated(new Date());
        }
        resource.getDataPackageMetadata().setVersion(version.toPlainString());
        if ("camtrap-dp".equals(resource.getCoreType()) && (resource.isInferGeocoverageAutomatically() || resource.isInferTaxonomicCoverageAutomatically() || resource.isInferTemporalCoverageAutomatically())) {
            InferredCamtrapMetadata inferredMetadata = (InferredCamtrapMetadata)this.resourceMetadataInferringService.inferMetadata(resource);
            resource.setInferredMetadata((InferredMetadata)inferredMetadata);
            this.saveInferredMetadata(resource);
            if (resource.isInferGeocoverageAutomatically()) {
                this.updateCamtrapGeographicScopeWithInferredFromSourceData(resource, inferredMetadata);
            }
            if (resource.isInferTaxonomicCoverageAutomatically()) {
                this.updateCamtrapTaxonomicScopeWithInferredFromSourceData(resource, inferredMetadata);
            }
            if (resource.isInferTemporalCoverageAutomatically()) {
                this.updateCamtrapTemporalScopeWithInferredFromSourceData(resource, inferredMetadata);
            }
        }
        this.saveDatapackageMetadata(resource);
        File trunkFile = this.dataDir.resourceDatapackageMetadataFile(resource.getShortname(), resource.getCoreType());
        File versionedFile = this.dataDir.resourceDatapackageMetadataFile(resource.getShortname(), resource.getCoreType(), version);
        try {
            FileUtils.copyFile((File)trunkFile, (File)versionedFile);
        }
        catch (IOException e) {
            throw new PublicationException(PublicationException.TYPE.EML, "Can't publish metadata file for resource " + resource.getShortname(), (Exception)e);
        }
    }

    private void updateEmlGeocoverageWithInferredFromSourceData(Resource resource, InferredEmlMetadata inferredMetadata) {
        if (!resource.getMappings().isEmpty() && inferredMetadata.getInferredGeographicCoverage() != null && inferredMetadata.getInferredGeographicCoverage().getData() != null) {
            GeospatialCoverage inferredGeocoverage = inferredMetadata.getInferredGeographicCoverage().getData();
            if (!resource.getEml().getGeospatialCoverages().isEmpty()) {
                inferredGeocoverage.setDescription(((GeospatialCoverage)resource.getEml().getGeospatialCoverages().get(0)).getDescription());
            } else {
                inferredGeocoverage.setDescription("N/A");
            }
            resource.getEml().getGeospatialCoverages().clear();
            resource.getEml().addGeospatialCoverage(inferredGeocoverage);
        }
    }

    private void updateCamtrapGeographicScopeWithInferredFromSourceData(Resource resource, InferredCamtrapMetadata inferredMetadata) {
        if (!resource.getDataPackageMappings().isEmpty() && inferredMetadata.getInferredGeographicScope() != null && inferredMetadata.getInferredGeographicScope().isInferred()) {
            Geojson geojson = new Geojson();
            geojson.setType(Geojson.Type.POLYGON);
            ArrayList<List<List>> coordinates = new ArrayList<List<List>>();
            InferredCamtrapGeographicScope inferredScope = inferredMetadata.getInferredGeographicScope();
            coordinates.add(Arrays.asList(Arrays.asList(inferredScope.getMinLongitude(), inferredScope.getMinLatitude()), Arrays.asList(inferredScope.getMaxLongitude(), inferredScope.getMinLatitude()), Arrays.asList(inferredScope.getMaxLongitude(), inferredScope.getMaxLatitude()), Arrays.asList(inferredScope.getMinLongitude(), inferredScope.getMaxLatitude()), Arrays.asList(inferredScope.getMinLongitude(), inferredScope.getMinLatitude())));
            geojson.setCoordinates(coordinates);
            ((CamtrapMetadata)resource.getDataPackageMetadata()).setSpatial(geojson);
        }
    }

    private void updateEmlTaxonomicCoverageWithInferredFromSourceData(Resource resource, InferredEmlMetadata inferredMetadata) {
        if (!resource.getMappings().isEmpty() && inferredMetadata.getInferredTaxonomicCoverage() != null && inferredMetadata.getInferredTaxonomicCoverage().getData() != null) {
            TaxonomicCoverage inferredTaxonomicCoverage = inferredMetadata.getInferredTaxonomicCoverage().getData();
            if (!resource.getEml().getTaxonomicCoverages().isEmpty()) {
                inferredTaxonomicCoverage.setDescription(((TaxonomicCoverage)resource.getEml().getTaxonomicCoverages().get(0)).getDescription());
            } else {
                inferredTaxonomicCoverage.setDescription("N/A");
            }
            resource.getEml().getTaxonomicCoverages().clear();
            resource.getEml().addTaxonomicCoverage(inferredTaxonomicCoverage);
        }
    }

    private void updateCamtrapTaxonomicScopeWithInferredFromSourceData(Resource resource, InferredCamtrapMetadata inferredMetadata) {
        if (!resource.getDataPackageMappings().isEmpty() && inferredMetadata.getInferredTaxonomicScope() != null && inferredMetadata.getInferredTaxonomicScope().isInferred()) {
            InferredCamtrapTaxonomicScope inferredTaxonomicScope = inferredMetadata.getInferredTaxonomicScope();
            ((CamtrapMetadata)resource.getDataPackageMetadata()).setTaxonomic(inferredTaxonomicScope.getData());
        }
    }

    private void updateEmlTemporalCoverageWithInferredFromSourceData(Resource resource, InferredEmlMetadata inferredMetadata) {
        if (!resource.getMappings().isEmpty() && inferredMetadata.getInferredTemporalCoverage() != null && inferredMetadata.getInferredTemporalCoverage().getData() != null) {
            TemporalCoverage inferredTemporalCoverage = inferredMetadata.getInferredTemporalCoverage().getData();
            resource.getEml().getTemporalCoverages().clear();
            resource.getEml().addTemporalCoverage(inferredTemporalCoverage);
        }
    }

    private void updateCamtrapTemporalScopeWithInferredFromSourceData(Resource resource, InferredCamtrapMetadata inferredMetadata) {
        if (!resource.getDataPackageMappings().isEmpty() && inferredMetadata.getInferredTemporalScope() != null && inferredMetadata.getInferredTemporalScope().isInferred()) {
            InferredCamtrapTemporalScope inferredTemporalScope = inferredMetadata.getInferredTemporalScope();
            Temporal temporal = new Temporal();
            temporal.setStart(CAMTRAP_TEMPORAL_METADATA_DATE_FORMAT.format(inferredTemporalScope.getStartDate()));
            temporal.setEnd(CAMTRAP_TEMPORAL_METADATA_DATE_FORMAT.format(inferredTemporalScope.getEndDate()));
            ((CamtrapMetadata)resource.getDataPackageMetadata()).setTemporal(temporal);
        }
    }

    private void publishRtf(Resource resource, BigDecimal version) throws PublicationException {
        if (resource.isDataPackage()) {
            return;
        }
        if (this.isLocked(resource.getShortname())) {
            throw new PublicationException(PublicationException.TYPE.LOCKED, "Resource " + resource.getShortname() + " is currently locked by another process");
        }
        com.lowagie.text.Document doc = new com.lowagie.text.Document();
        File rtfFile = this.dataDir.resourceRtfFile(resource.getShortname(), version);
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(rtfFile);
            RtfWriter2.getInstance((com.lowagie.text.Document)doc, (OutputStream)out);
            this.eml2Rtf.writeEmlIntoRtf(doc, resource);
        }
        catch (FileNotFoundException e) {
            throw new PublicationException(PublicationException.TYPE.RTF, "Can't find rtf file to write metadata to: " + rtfFile.getAbsolutePath(), (Exception)e);
        }
        catch (DocumentException e) {
            throw new PublicationException(PublicationException.TYPE.RTF, "RTF DocumentException while writing to file: " + rtfFile.getAbsolutePath(), (Exception)((Object)e));
        }
        catch (Exception e) {
            throw new PublicationException(PublicationException.TYPE.RTF, "An unexpected error occurred while writing RTF file: " + e.getMessage(), e);
        }
        finally {
            if (out != null) {
                try {
                    ((OutputStream)out).close();
                }
                catch (IOException e) {
                    this.LOG.warn("FileOutputStream to RTF file could not be closed");
                }
            }
        }
    }

    @Nullable
    private Eml readMetadata(String shortname, Archive archive, ActionLogger alog) {
        File emlFile = archive.getMetadataLocationFile();
        try {
            if (emlFile == null || !emlFile.exists()) {
                emlFile = new File(archive.getLocation(), "eml.xml");
            }
            if (emlFile.exists() && emlFile.getName().endsWith("eml.xml")) {
                Eml eml = this.copyMetadata(shortname, emlFile);
                alog.info("manage.resource.read.eml.metadata");
                return eml;
            }
            this.LOG.warn("Cant find any eml metadata to import");
        }
        catch (ImportException e) {
            String msg = "Cant read basic archive metadata: " + e.getMessage();
            this.LOG.warn(msg);
            alog.warn(msg);
            return null;
        }
        catch (Exception e) {
            this.LOG.warn("Cant read archive eml metadata", (Throwable)e);
        }
        try {
            this.LOG.debug("try to read other metadata formats");
            Dataset dataset = DatasetEmlParser.build((byte[])archive.getMetadata().getBytes(StandardCharsets.UTF_8));
            Eml eml = this.convertMetadataToEml(dataset);
            alog.info("manage.resource.read.basic.metadata");
            return eml;
        }
        catch (Exception e) {
            this.LOG.warn("Cant read basic archive metadata: " + e.getMessage());
            alog.warn("manage.resource.read.problem");
            return null;
        }
    }

    private DataPackageMetadata readDataPackageMetadata(String shortname, String dataPackageType, File file, ActionLogger alog) {
        try {
            DataPackageMetadata metadata = this.copyDatapackageMetadata(shortname, file, dataPackageType);
            alog.info("manage.resource.read.datapackage.metadata");
            return metadata;
        }
        catch (ImportException e) {
            String msg = "Cant read data package metadata: " + e.getMessage();
            this.LOG.warn(msg);
            alog.warn(msg);
            return null;
        }
        catch (Exception e) {
            this.LOG.warn("Cant read data package metadata", (Throwable)e);
            alog.warn("manage.resource.read.problem");
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void register(Resource resource, Organisation organisation, Ipt ipt, BaseAction action) throws RegistryException {
        ActionLogger alog = new ActionLogger(this.LOG, action);
        if (PublicationStatus.REGISTERED != resource.getStatus() && PublicationStatus.PUBLIC == resource.getStatus()) {
            Set candidateResourceUUIDs = this.collectCandidateResourceUUIDsFromAlternateIds(resource);
            if (candidateResourceUUIDs.size() > 1) {
                String reason = action.getText("manage.resource.migrate.failed.multipleUUIDs", new String[]{organisation.getName()});
                String help = action.getText("manage.resource.migrate.failed.help");
                throw new InvalidConfigException(InvalidConfigException.TYPE.INVALID_RESOURCE_MIGRATION, reason + " " + help);
            }
            if (candidateResourceUUIDs.size() == 1) {
                UUID candidate = (UUID)candidateResourceUUIDs.iterator().next();
                List duplicateUses = this.detectDuplicateUsesOfUUID(candidate, resource.getShortname());
                if (!duplicateUses.isEmpty()) {
                    String reason = action.getText("manage.resource.migrate.failed.duplicate", new String[]{candidate.toString(), duplicateUses.toString()});
                    String help1 = action.getText("manage.resource.migrate.failed.help");
                    String help2 = action.getText("manage.resource.migrate.failed.duplicate.help");
                    throw new InvalidConfigException(InvalidConfigException.TYPE.INVALID_RESOURCE_MIGRATION, reason + " " + help1 + " " + help2);
                }
                if (organisation.getKey() != null && organisation.getName() != null) {
                    boolean matched = this.registryManager.isResourceBelongsToOrganisation(candidate.toString(), organisation.getKey().toString());
                    if (!matched) {
                        String reason = action.getText("manage.resource.migrate.failed.badUUID", new String[]{organisation.getName()});
                        String help = action.getText("manage.resource.migrate.failed.help");
                        throw new InvalidConfigException(InvalidConfigException.TYPE.INVALID_RESOURCE_MIGRATION, reason + " " + help);
                    }
                    this.LOG.debug("Resource matched to existing registered resource, UUID=" + String.valueOf(organisation.getKey()));
                    resource.setStatus(PublicationStatus.REGISTERED);
                    resource.setKey(candidate);
                    resource.setOrganisation(organisation);
                    alog.info("manage.resource.migrate", new String[]{organisation.getKey().toString(), organisation.getName()});
                    this.updateRegistration(resource, action);
                }
            } else {
                UUID key = this.registryManager.register(resource, organisation, ipt);
                if (key == null) {
                    throw new RegistryException(RegistryException.Type.MISSING_METADATA, null, "No key returned for registered resource");
                }
                alog.info("manage.overview.resource.registered", new String[]{organisation.getName()});
                resource.setStatus(PublicationStatus.REGISTERED);
                this.updateAlternateIdentifierForRegistry(resource);
                this.updateStoredResources(resource);
            }
            this.save(resource);
            return;
        }
        this.LOG.error("Registration request failed: the resource must be public. Status=" + resource.getStatus().toString());
    }

    private void updateStoredResources(Resource resource) {
        SimplifiedResource simplifiedResource = (SimplifiedResource)this.publishedPublicVersionsSimplified.get(resource.getShortname());
        if (simplifiedResource != null) {
            simplifiedResource.setStatus(PublicationStatus.REGISTERED);
            simplifiedResource.setOrganisationAlias(resource.getOrganisationAlias());
            simplifiedResource.setOrganisationName(resource.getOrganisationName());
        }
    }

    protected List<String> detectDuplicateUsesOfUUID(UUID candidate, String shortname) {
        ArrayListValuedHashMap duplicateUses = new ArrayListValuedHashMap();
        for (Resource other : this.resources.values()) {
            if (other.getShortname().equalsIgnoreCase(shortname)) continue;
            if (other.getStatus().equals((Object)PublicationStatus.PUBLIC)) {
                Set otherCandidateUUIDs = this.collectCandidateResourceUUIDsFromAlternateIds(other);
                if (otherCandidateUUIDs.isEmpty()) continue;
                for (UUID otherCandidate : otherCandidateUUIDs) {
                    if (!otherCandidate.equals(candidate)) continue;
                    duplicateUses.put((Object)candidate, (Object)other.getTitleAndShortname());
                }
                continue;
            }
            if (!other.getStatus().equals((Object)PublicationStatus.REGISTERED) || !other.getKey().equals(candidate)) continue;
            duplicateUses.put((Object)candidate, (Object)other.getTitleAndShortname());
        }
        return duplicateUses.get((Object)candidate);
    }

    private Set<UUID> collectCandidateResourceUUIDsFromAlternateIds(Resource resource) {
        HashSet<UUID> ls;
        block7: {
            block6: {
                ls = new HashSet<UUID>();
                if (resource.getEml() == null || resource.isDataPackage()) break block6;
                List ids = resource.getEml().getAlternateIdentifiers();
                for (String id : ids) {
                    try {
                        UUID uuid = UUID.fromString(id);
                        ls.add(uuid);
                    }
                    catch (IllegalArgumentException uuid) {}
                }
                break block7;
            }
            if (resource.getDataPackageMetadata() == null || !(resource.getDataPackageMetadata() instanceof CamtrapMetadata) || !"camtrap-dp".equals(resource.getCoreType())) break block7;
            CamtrapMetadata metadata = (CamtrapMetadata)resource.getDataPackageMetadata();
            List relatedIdentifiers = metadata.getRelatedIdentifiers();
            for (RelatedIdentifier identifier : relatedIdentifiers) {
                String[] urlParts;
                if (identifier == null || identifier.getRelatedIdentifier() == null || !identifier.getRelatedIdentifier().contains("gbif") || identifier.getRelatedIdentifierType() != RelatedIdentifier.RelatedIdentifierType.URL || (urlParts = identifier.getRelatedIdentifier().split("/")).length <= 0) continue;
                String lastSegment = urlParts[urlParts.length - 1];
                try {
                    UUID uuid = UUID.fromString(lastSegment);
                    ls.add(uuid);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
        return ls;
    }

    public synchronized void report(String shortname, StatusReport report) {
        this.processReports.put(shortname, report);
    }

    protected synchronized void addOrUpdateVersionHistory(Resource resource, BigDecimal version, boolean published, BaseAction action) {
        VersionHistory versionHistory;
        this.LOG.info("Adding or updating version: " + version.toPlainString());
        VersionHistory existingVersionHistory = resource.findVersionHistory(version);
        if (existingVersionHistory == null) {
            versionHistory = new VersionHistory(version, resource.getStatus());
            resource.addVersionHistory(versionHistory);
            this.LOG.info("Adding VersionHistory for version " + version.toPlainString());
        } else {
            versionHistory = existingVersionHistory;
            this.LOG.info("Updating VersionHistory for version " + version.toPlainString());
        }
        versionHistory.setDoi(resource.getDoi());
        versionHistory.setStatus(resource.getIdentifierStatus());
        versionHistory.setChangeSummary(resource.getChangeSummary());
        versionHistory.setRecordsPublished(resource.getRecordsPublished());
        versionHistory.setRecordsByExtension(resource.getRecordsByExtension());
        User modifiedBy = action.getCurrentUser();
        if (modifiedBy != null) {
            versionHistory.setModifiedBy(modifiedBy);
        }
        if (published) {
            versionHistory.setReleased(new Date());
        }
    }

    public synchronized void cleanArchiveVersions(Resource resource) {
        if (this.cfg.isArchivalMode() && this.cfg.getArchivalLimit() != null && this.cfg.getArchivalLimit() > 0) {
            this.LOG.info("Archival mode is ON with a limit of {} elements)", (Object)this.cfg.getArchivalLimit());
            this.LOG.info("Clean archive versions, if needed, for resource: {}", (Object)resource.getShortname());
            List history = resource.getVersionHistory();
            if (history.size() > this.cfg.getArchivalLimit()) {
                for (int i = this.cfg.getArchivalLimit().intValue(); i < history.size(); ++i) {
                    VersionHistory oldVersion = (VersionHistory)history.get(i);
                    try {
                        BigDecimal version = new BigDecimal(oldVersion.getVersion());
                        this.LOG.info("Deleting archive version {} for resource: {}", (Object)version, (Object)resource.getShortname());
                        this.removeArchiveVersion(resource.getShortname(), version);
                        continue;
                    }
                    catch (Exception e) {
                        this.LOG.error("Cannot delete old archive versions for resource: " + resource.getShortname(), (Throwable)e);
                        return;
                    }
                }
            }
        }
    }

    public synchronized void save(Resource resource) throws InvalidConfigException {
        File cfgFile = this.dataDir.resourceFile(resource);
        try {
            FileUtils.forceMkdir((File)cfgFile.getParentFile());
            try (Writer writer = org.gbif.ipt.utils.FileUtils.startNewUtf8File((File)cfgFile);){
                this.xstream.toXML((Object)resource, writer);
                this.addResource(resource);
            }
        }
        catch (IllegalArgumentException e) {
            this.LOG.error((Object)e);
            throw new InvalidConfigException(InvalidConfigException.TYPE.CONFIG_WRITE, e.getMessage());
        }
        catch (Exception e) {
            this.LOG.error((Object)e);
            throw new InvalidConfigException(InvalidConfigException.TYPE.CONFIG_WRITE, "Can't write mapping configuration");
        }
    }

    public synchronized void saveInferredMetadata(Resource resource) throws InvalidConfigException {
        File cfgFile = this.dataDir.resourceInferredMetadataFile(resource.getShortname());
        Writer writer = null;
        try {
            FileUtils.forceMkdir((File)cfgFile.getParentFile());
            writer = org.gbif.ipt.utils.FileUtils.startNewUtf8File((File)cfgFile);
            this.xstream.toXML((Object)resource.getInferredMetadata(), writer);
        }
        catch (IOException e) {
            this.LOG.error((Object)e);
            throw new InvalidConfigException(InvalidConfigException.TYPE.CONFIG_WRITE, "Can't write inferred metadata file");
        }
        finally {
            if (writer != null) {
                this.closeWriter(writer);
            }
        }
    }

    public synchronized void saveEml(Resource resource) throws InvalidConfigException {
        this.saveEml(resource, false);
    }

    private synchronized void saveEml(Resource resource, boolean preserveKeywords) throws InvalidConfigException {
        this.syncEmlWithResource(resource, preserveKeywords);
        resource.setModified(new Date());
        File emlFile = this.dataDir.resourceEmlFile(resource.getShortname());
        EmlUtils.writeWithLocale((File)emlFile, (Resource)resource, (Locale)Locale.US);
        this.LOG.debug("Updated EML file for " + String.valueOf(resource));
    }

    public synchronized void saveDatapackageMetadata(Resource resource) {
        resource.setModified(new Date());
        File metadataFile = this.dataDir.resourceDatapackageMetadataFile(resource.getShortname(), resource.getCoreType());
        try {
            this.metadataReader.writeValue(metadataFile, (Object)resource.getDataPackageMetadata());
        }
        catch (IOException e) {
            this.LOG.error("Failed to save datapackage metadata!", (Throwable)e);
            throw new RuntimeException(e);
        }
        this.LOG.debug("Updated metadata file for " + String.valueOf(resource));
    }

    public StatusReport status(String shortname) {
        this.isLocked(shortname);
        return (StatusReport)this.processReports.get(shortname);
    }

    private void syncEmlWithResource(Resource resource, boolean preserveKeywords) {
        resource.getEml().setEmlVersion(resource.getEmlVersion());
        if (resource.getKey() != null) {
            resource.getEml().setGuid(resource.getKey().toString());
        } else {
            resource.getEml().setGuid(this.cfg.getResourceGuid(resource.getShortname()));
        }
        if (!preserveKeywords) {
            this.updateKeywordsWithDatasetTypeAndSubtype(resource);
        }
    }

    private void syncEmlWithResource(Resource resource) {
        this.syncEmlWithResource(resource, false);
    }

    public void updateRegistration(Resource resource, BaseAction action) throws PublicationException {
        if (resource.isRegistered()) {
            if (action == null) {
                action = new BaseAction(this.textProvider, this.cfg, this.registrationManager);
            }
            try {
                this.LOG.debug("Updating registration of resource with key: " + resource.getKey().toString());
                String iptKey = null;
                if (this.registrationManager.getIpt() != null) {
                    iptKey = this.registrationManager.getIpt().getKey() == null ? null : this.registrationManager.getIpt().getKey().toString();
                }
                this.registryManager.updateResource(resource, iptKey);
            }
            catch (RegistryException e) {
                String msg = RegistryException.logRegistryException((RegistryException)e, (BaseAction)action);
                action.addActionError(msg);
                this.LOG.error(msg);
                msg = action.getText("admin.config.updateMetadata.resource.fail.registry", new String[]{e.getMessage()});
                action.addActionError(msg);
                this.LOG.error(msg);
                throw new PublicationException(PublicationException.TYPE.REGISTRY, msg, (Exception)((Object)e));
            }
            catch (InvalidConfigException e) {
                String msg = action.getText("manage.overview.failed.resource.update", new String[]{e.getMessage()});
                action.addActionError(msg);
                this.LOG.error(msg);
                throw new PublicationException(PublicationException.TYPE.REGISTRY, msg, (Exception)((Object)e));
            }
        }
    }

    public void visibilityToPrivate(Resource resource, BaseAction action) throws InvalidConfigException {
        if (PublicationStatus.REGISTERED == resource.getStatus()) {
            throw new InvalidConfigException(InvalidConfigException.TYPE.RESOURCE_ALREADY_REGISTERED, "The resource is already registered with GBIF");
        }
        if (PublicationStatus.PUBLIC == resource.getStatus()) {
            resource.setStatus(PublicationStatus.PRIVATE);
            if (resource.getDataPackageIdentifier() == null) {
                this.updateAlternateIdentifierForIPTURLToResource(resource);
            }
            this.save(resource);
        }
    }

    public void visibilityToPublic(Resource resource, BaseAction action) throws InvalidConfigException {
        if (PublicationStatus.REGISTERED == resource.getStatus()) {
            throw new InvalidConfigException(InvalidConfigException.TYPE.RESOURCE_ALREADY_REGISTERED, "The resource is already registered with GBIF");
        }
        if (PublicationStatus.PRIVATE == resource.getStatus()) {
            resource.setStatus(PublicationStatus.PUBLIC);
            resource.setMakePublicDate(null);
            if (resource.getDataPackageIdentifier() == null) {
                this.updateAlternateIdentifierForIPTURLToResource(resource);
            }
            this.save(resource);
        }
    }

    private List<TaskMessage> getTaskMessages(String shortname) {
        return this.processReports.get(shortname) == null ? new ArrayList<TaskMessage>() : ((StatusReport)this.processReports.get(shortname)).getMessages();
    }

    public void updatePublicationMode(Resource resource) {
        if (resource.usesAutoPublishing()) {
            this.updateNextPublishedDate(new Date(), resource);
        } else {
            resource.setNextPublished(null);
        }
    }

    protected void updateNextPublishedDate(Date currentDate, Resource resource) throws PublicationException {
        if (resource.usesAutoPublishing()) {
            try {
                this.LOG.debug("Updating next published date of resource: {}", (Object)resource.getShortname());
                Date nextPublished = null;
                MaintenanceUpdateFrequency frequency = resource.getUpdateFrequency();
                Calendar cal = Calendar.getInstance();
                cal.setTime(currentDate);
                if (resource.isDeprecatedAutoPublishingConfiguration()) {
                    int days = frequency.getPeriodInDays();
                    cal.add(5, days);
                    nextPublished = cal.getTime();
                } else {
                    cal.set(13, 0);
                    cal.set(14, 0);
                    switch (1.$SwitchMap$org$gbif$metadata$eml$ipt$model$MaintenanceUpdateFrequency[frequency.ordinal()]) {
                        case 1: {
                            cal.set(2, resource.getUpdateFrequencyMonth().getMonthId());
                            cal.set(5, resource.getUpdateFrequencyDay());
                            cal.set(11, resource.getUpdateFrequencyHour());
                            cal.set(12, resource.getUpdateFrequencyMinute());
                            nextPublished = cal.getTime();
                            if (!nextPublished.before(currentDate)) break;
                            cal.add(1, 1);
                            nextPublished = cal.getTime();
                            break;
                        }
                        case 2: {
                            cal.set(2, resource.getUpdateFrequencyBiMonth().getBiMonthId());
                            cal.set(5, resource.getUpdateFrequencyDay());
                            cal.set(11, resource.getUpdateFrequencyHour());
                            cal.set(12, resource.getUpdateFrequencyMinute());
                            nextPublished = cal.getTime();
                            if (!nextPublished.before(currentDate)) break;
                            cal.add(2, 6);
                            nextPublished = cal.getTime();
                            if (!nextPublished.before(currentDate)) break;
                            cal.add(2, 6);
                            nextPublished = cal.getTime();
                            break;
                        }
                        case 3: {
                            cal.set(5, resource.getUpdateFrequencyDay());
                            cal.set(11, resource.getUpdateFrequencyHour());
                            cal.set(12, resource.getUpdateFrequencyMinute());
                            nextPublished = cal.getTime();
                            if (!nextPublished.before(currentDate)) break;
                            cal.add(2, 1);
                            nextPublished = cal.getTime();
                            break;
                        }
                        case 4: {
                            cal.set(7, resource.getUpdateFrequencyDayOfWeek().getDayId());
                            cal.set(11, resource.getUpdateFrequencyHour());
                            cal.set(12, resource.getUpdateFrequencyMinute());
                            nextPublished = cal.getTime();
                            if (!nextPublished.before(currentDate)) break;
                            cal.add(3, 1);
                            nextPublished = cal.getTime();
                            break;
                        }
                        case 5: {
                            cal.set(11, resource.getUpdateFrequencyHour());
                            cal.set(12, resource.getUpdateFrequencyMinute());
                            nextPublished = cal.getTime();
                            if (!nextPublished.before(currentDate)) break;
                            cal.add(6, 1);
                            nextPublished = cal.getTime();
                            break;
                        }
                    }
                }
                if (resource.getNextPublished() == null) {
                    this.LOG.debug("Auto-publishing turned on");
                }
                if (nextPublished == null) {
                    String msg = "Error to compute the next publication date";
                    this.LOG.error(msg);
                    throw new PublicationException(PublicationException.TYPE.SCHEDULING, msg);
                }
                resource.setNextPublished(nextPublished);
                this.LOG.debug("The next publication date is: {}", (Object)nextPublished);
            }
            catch (Exception e) {
                resource.setNextPublished(null);
                String msg = "Auto-publishing failed: " + e.getMessage();
                this.LOG.error(msg, (Throwable)e);
                throw new PublicationException(PublicationException.TYPE.SCHEDULING, msg, e);
            }
        } else {
            resource.setNextPublished(null);
            this.LOG.debug("Resource: {} has not been configured to use auto-publishing", (Object)resource.getShortname());
        }
    }

    protected Resource updateKeywordsWithDatasetTypeAndSubtype(Resource resource) {
        List keywords;
        Eml eml = resource.getEml();
        if (eml != null && (keywords = eml.getKeywords()) != null) {
            String type = resource.getCoreType();
            if (StringUtils.isNotBlank((CharSequence)type)) {
                EmlUtils.addOrUpdateKeywordSet((List)keywords, (String)type, (String)"GBIF Dataset Type Vocabulary: http://rs.gbif.org/vocabulary/gbif/dataset_type_2015-07-10.xml");
                this.LOG.debug("GBIF Dataset Type Vocabulary added/updated to Resource's list of keywords");
            } else {
                EmlUtils.removeKeywordSet((List)keywords, (String)"GBIF Dataset Type Vocabulary: http://rs.gbif.org/vocabulary/gbif/dataset_type_2015-07-10.xml");
                this.LOG.debug("GBIF Dataset Type Vocabulary removed from Resource's list of keywords");
            }
            String subtype = resource.getSubtype();
            if (StringUtils.isNotBlank((CharSequence)subtype)) {
                EmlUtils.addOrUpdateKeywordSet((List)keywords, (String)subtype, (String)"GBIF Dataset Subtype Vocabulary: http://rs.gbif.org/vocabulary/gbif/dataset_subtype.xml");
                this.LOG.debug("GBIF Dataset Subtype Vocabulary added/updated to Resource's list of keywords");
            } else {
                EmlUtils.removeKeywordSet((List)keywords, (String)"GBIF Dataset Subtype Vocabulary: http://rs.gbif.org/vocabulary/gbif/dataset_subtype.xml");
                this.LOG.debug("GBIF Dataset Type Vocabulary removed from Resource's list of keywords");
            }
        }
        return resource;
    }

    public ThreadPoolExecutor getExecutor() {
        return this.executor;
    }

    public Map<String, Future<Map<String, Integer>>> getProcessFutures() {
        return this.processFutures;
    }

    public ListValuedMap<String, Date> getProcessFailures() {
        return this.processFailures;
    }

    public Map<String, StatusReport> getProcessReports() {
        return this.processReports;
    }

    public void clearProcessReports() {
        this.processReports.clear();
    }

    public boolean hasMaxProcessFailures(Resource resource) {
        String resourceShortname = resource.getShortname();
        if (this.processFailures.containsKey((Object)resourceShortname)) {
            List failures = this.processFailures.get((Object)resourceShortname);
            int count = failures.size();
            LocalDate today = LocalDate.now();
            LocalDate last = (LocalDate)this.lastLoggedFailures.get(resourceShortname);
            if (count < 3) {
                this.LOG.debug("Publication has failed {} time(s) for resource: {}", (Object)count, (Object)resource.getTitleAndShortname());
            } else if (last == null || !last.equals(today)) {
                this.LOG.debug("Publication has failed {} time(s) for resource: {} (max amount of failures)", (Object)count, (Object)resource.getTitleAndShortname());
                this.lastLoggedFailures.put(resourceShortname, today);
            }
            return count >= 3;
        }
        return false;
    }

    public GenerateDwcaFactory getDwcaFactory() {
        return this.dwcaFactory;
    }

    public void removeVersion(Resource resource, BigDecimal version) {
        if (version != null && !version.equals(resource.getMetadataVersion())) {
            this.LOG.debug("Removing version {} for resource: {}", (Object)version, (Object)resource.getShortname());
            try {
                this.removeVersionInternal(resource, version);
                resource.removeVersionHistory(version);
                this.save(resource);
                this.LOG.debug("Version {} has been removed for resource: {}", (Object)version, (Object)resource.getShortname());
            }
            catch (IOException e) {
                this.LOG.error("Cannot remove version {} for resource: {}", (Object)version, (Object)resource.getShortname(), (Object)e);
            }
        }
    }

    public void removeArchiveVersion(String shortname, BigDecimal version) {
        boolean deleted;
        File dpArchiveFile;
        boolean deleted2;
        File dwcaFile = this.dataDir.resourceDwcaFile(shortname, version);
        if (dwcaFile != null && dwcaFile.exists() && (deleted2 = FileUtils.deleteQuietly((File)dwcaFile))) {
            this.LOG.debug("{} has been successfully deleted.", (Object)dwcaFile.getAbsolutePath());
        }
        if ((dpArchiveFile = this.dataDir.resourceDataPackageFile(shortname, version)) != null && dpArchiveFile.exists() && (deleted = FileUtils.deleteQuietly((File)dpArchiveFile))) {
            this.LOG.debug("{} has been successfully deleted.", (Object)dpArchiveFile.getAbsolutePath());
        }
    }

    public void removeVersionInternal(Resource resource, BigDecimal version) throws IOException {
        File versionedDataPackageArchiveFile;
        File versionedDwcaFile;
        File versionedRTFFile;
        File versionedDataPackageMetadataFile;
        String shortname = resource.getShortname();
        File versionedEMLFile = this.dataDir.resourceEmlFile(shortname, version);
        if (versionedEMLFile.exists()) {
            FileUtils.forceDelete((File)versionedEMLFile);
        }
        if ((versionedDataPackageMetadataFile = this.dataDir.resourceDatapackageMetadataFile(shortname, resource.getCoreType(), version)).exists()) {
            FileUtils.forceDelete((File)versionedDataPackageMetadataFile);
        }
        if ((versionedRTFFile = this.dataDir.resourceRtfFile(shortname, version)).exists()) {
            FileUtils.forceDelete((File)versionedRTFFile);
        }
        if ((versionedDwcaFile = this.dataDir.resourceDwcaFile(shortname, version)).exists()) {
            FileUtils.forceDelete((File)versionedDwcaFile);
        }
        if ((versionedDataPackageArchiveFile = this.dataDir.resourceDataPackageFile(shortname, version)).exists()) {
            FileUtils.forceDelete((File)versionedDataPackageArchiveFile);
        }
    }

    public String calculateChecksum(File file) throws Exception {
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        FileInputStream fis = new FileInputStream(file);
        byte[] byteArray = new byte[1024];
        int bytesCount = 0;
        while ((bytesCount = ((InputStream)fis).read(byteArray)) != -1) {
            digest.update(byteArray, 0, bytesCount);
        }
        ((InputStream)fis).close();
        byte[] bytes = digest.digest();
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }

    public String calculateArchiveChecksum(File archive) throws Exception {
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        try (ZipFile zipFile = new ZipFile(archive);){
            zipFile.stream().forEach(entry -> {
                if (entry.getName().endsWith(".xml") && entry.getName().toLowerCase().contains("eml")) {
                    return;
                }
                if (entry.getName().endsWith(".json") && entry.getName().toLowerCase().contains("datapackage")) {
                    return;
                }
                try (InputStream is = zipFile.getInputStream((ZipEntry)entry);){
                    int bytesRead;
                    byte[] buffer = new byte[4096];
                    while ((bytesRead = is.read(buffer)) != -1) {
                        digest.update(buffer, 0, bytesRead);
                    }
                }
                catch (IOException e) {
                    this.LOG.error("Failed to read data", (Throwable)e);
                }
            });
        }
        byte[] hashBytes = digest.digest();
        StringBuilder hexString = new StringBuilder();
        for (byte b : hashBytes) {
            hexString.append(String.format("%02x", b));
        }
        return hexString.toString();
    }

    private boolean isOnlyFileSources(@NotNull Resource resource) {
        return resource.getSources().stream().allMatch(s -> s.isFileSource() || s.isExcelSource());
    }

    private boolean isMetadataModifiedSinceLastPublication(@NotNull Resource resource) {
        Date lastPublished = resource.getLastPublished();
        Date metadataModified = resource.getMetadataModified();
        return metadataModified == null || lastPublished == null || metadataModified.after(lastPublished);
    }

    private boolean isSourcesModifiedSinceLastPublication(@NotNull Resource resource) {
        Date lastPublished = resource.getLastPublished();
        Date sourcesModified = resource.getSourcesModified();
        return sourcesModified != null && (lastPublished == null || sourcesModified.after(lastPublished));
    }
}

