/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.service.manage.impl;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import org.gbif.ipt.model.datapackage.metadata.col.ColMetadata;
import org.gbif.ipt.model.datapackage.metadata.col.FrictionlessColMetadata;
import org.gbif.ipt.service.manage.JsonService;
import org.gbif.ipt.service.manage.MetadataReader;
import org.gbif.ipt.service.manage.YamlService;

public class MetadataReaderImpl
implements MetadataReader {
    private final JsonService jsonService;
    private final YamlService yamlService;

    public MetadataReaderImpl(JsonService jsonService, YamlService yamlService) {
        this.jsonService = jsonService;
        this.yamlService = yamlService;
    }

    public <T> T readValue(File src, Class<T> valueType) throws IOException {
        if (valueType == ColMetadata.class || valueType == FrictionlessColMetadata.class) {
            return (T)this.yamlService.readValue(src, valueType);
        }
        return (T)this.jsonService.readValue(src, valueType);
    }

    public void writeValue(File resultFile, Object value) throws IOException {
        if (value instanceof ColMetadata || value instanceof FrictionlessColMetadata) {
            this.yamlService.writeValue(resultFile, value);
        } else {
            this.jsonService.writeValue(resultFile, value);
        }
    }

    public void writeValue(Writer writer, Object value) throws IOException {
        if (value instanceof ColMetadata || value instanceof FrictionlessColMetadata) {
            this.yamlService.writeValue(writer, value);
        } else {
            this.jsonService.writeValue(writer, value);
        }
    }
}

