/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.service.file;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.tika.Tika;
import org.gbif.ipt.service.file.FileFormat;
import org.gbif.ipt.service.file.MediaTypeAndFormatDetector;

/*
 * Exception performing whole class analysis ignored.
 */
public class MediaTypeAndFormatDetector {
    public static final String TEXT_PLAIN = "text/plain";
    public static final String TEXT_CSV = "text/csv";
    public static final String TEXT_TSV = "text/tab-separated-values";
    public static final String APPLICATION_EXCEL = "application/vnd.ms-excel";
    public static final String APPLICATION_OFFICE_SPREADSHEET = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
    public static final String APPLICATION_OPEN_DOC_SPREADSHEET = "application/vnd.oasis.opendocument.spreadsheet";
    public static final String APPLICATION_XML = "application/xml";
    public static final String APPLICATION_ZIP = "application/zip";
    public static final String APPLICATION_GZIP = "application/gzip";
    public static final List<String> COMPRESS_CONTENT_TYPE = ImmutableList.of((Object)"application/zip", (Object)"application/gzip");
    public static final List<String> TABULAR_CONTENT_TYPES = ImmutableList.of((Object)"text/plain", (Object)"text/csv", (Object)"text/tab-separated-values");
    public static final List<String> SPREADSHEET_CONTENT_TYPES = ImmutableList.of((Object)"application/vnd.ms-excel", (Object)"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", (Object)"application/vnd.oasis.opendocument.spreadsheet");
    public static final List<String> XML_CONTENT_TYPES = ImmutableList.of((Object)"application/xml");
    private static final Tika TIKA = new Tika();

    public static String detectMediaType(Path filePath) throws IOException {
        return TIKA.detect(filePath);
    }

    public static Optional<MediaTypeAndFormat> evaluateMediaTypeAndFormat(Path dataFilePath, String detectedContentType) throws IOException {
        Objects.requireNonNull(dataFilePath, "dataFilePath must be provided");
        String contentType = detectedContentType;
        if (COMPRESS_CONTENT_TYPE.contains(detectedContentType)) {
            List content;
            try (Stream<Path> list = Files.list(dataFilePath);){
                content = list.collect(Collectors.toList());
            }
            if (content.size() == 1) {
                contentType = MediaTypeAndFormatDetector.detectMediaType((Path)((Path)content.get(0)));
            } else {
                return Optional.of(MediaTypeAndFormat.create((String)contentType, (FileFormat)FileFormat.DWCA));
            }
        }
        if (TABULAR_CONTENT_TYPES.contains(contentType)) {
            return Optional.of(MediaTypeAndFormat.create((String)contentType, (FileFormat)FileFormat.TABULAR));
        }
        if (SPREADSHEET_CONTENT_TYPES.contains(contentType)) {
            return Optional.of(MediaTypeAndFormat.create((String)contentType, (FileFormat)FileFormat.SPREADSHEET));
        }
        return Optional.empty();
    }
}

