/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.service.file;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Consumer;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.gbif.ipt.service.file.DataFile;
import org.gbif.ipt.service.file.DownloadFileManager;
import org.gbif.ipt.service.file.FileFormat;
import org.gbif.ipt.service.file.FileStoreManager;
import org.gbif.ipt.service.file.MediaTypeAndFormatDetector;
import org.gbif.ipt.service.file.UnsupportedMediaTypeException;
import org.gbif.utils.file.CompressionUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class FileStoreManager {
    private static final Logger LOG = LogManager.getLogger(FileStoreManager.class);
    private final DownloadFileManager downloadFileManager;

    public FileStoreManager(DownloadFileManager downloadFileManager) throws IOException {
        this.downloadFileManager = downloadFileManager;
    }

    public DataFile extractAndGetFileInfo(Path dataFilePath, Path destinationFolder, String fileName) {
        try {
            String detectedMediaType = MediaTypeAndFormatDetector.detectMediaType((Path)dataFilePath);
            if (MediaTypeAndFormatDetector.COMPRESS_CONTENT_TYPE.contains(detectedMediaType)) {
                CompressionUtil.decompressFile((File)destinationFolder.toFile(), (File)dataFilePath.toFile());
                FileUtils.deleteQuietly((File)dataFilePath.toFile());
            }
            return this.fromMediaTypeAndFormat(dataFilePath, fileName, detectedMediaType, destinationFolder);
        }
        catch (Exception ex) {
            LOG.warn("Deleting temporary content of {} after IOException.", (Object)fileName);
            FileUtils.deleteDirectory((File)destinationFolder.toFile());
            throw ex;
        }
    }

    private DataFile fromMediaTypeAndFormat(Path dataFilePath, String fileName, String detectedMediaType, Path finalPath) throws UnsupportedMediaTypeException, IOException {
        return MediaTypeAndFormatDetector.evaluateMediaTypeAndFormat((Path)finalPath, (String)detectedMediaType).map(mtf -> DataFile.create((Path)dataFilePath, (String)fileName, (FileFormat)mtf.getFileFormat(), (String)detectedMediaType, (String)mtf.getMediaType())).orElseThrow(() -> new UnsupportedMediaTypeException("Unsupported file type: " + detectedMediaType));
    }

    public AsyncDownloadResult downloadDataFile(String url, String targetDirectory, Consumer<DataFile> resultCallback, Consumer<Throwable> errorCallback) {
        if (!DownloadFileManager.isAvailable((String)url)) {
            throw new IllegalArgumentException("Failed to download file from " + url + ". The resource is not reachable. Please check that the URL is correct");
        }
        String fileName = FileStoreManager.getFileName((String)url);
        Path destinationFolder = Paths.get(targetDirectory, new String[0]);
        FileStoreManager.createIfNotExists((Path)destinationFolder);
        Path dataFilePath = destinationFolder.resolve(fileName);
        return AsyncDownloadResult.builder().dataFile(DataFile.builder().sourceFileName(fileName).filePath(dataFilePath).build()).downloadTask(this.downloadFileManager.downloadAsync(url, dataFilePath, file -> resultCallback.accept(this.extractAndGetFileInfo(dataFilePath, destinationFolder, fileName)), errorCallback)).build();
    }

    private static String getFileName(String url) {
        return Paths.get(new URI(url).getPath(), new String[0]).getFileName().toString();
    }

    private static void createIfNotExists(Path path) throws IOException {
        if (!path.toFile().exists()) {
            Files.createDirectories(path, new FileAttribute[0]);
        }
    }
}

