/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.service.file;

import java.io.File;
import java.io.FileOutputStream;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.gbif.ipt.model.UrlMetadata;
import org.gbif.ipt.utils.FileUtils;

public class DownloadFileManager {
    private static final Logger LOG = LogManager.getLogger(DownloadFileManager.class);

    public static boolean isAvailable(String url) {
        try {
            UrlMetadata urlMetadata = FileUtils.fetchUrlMetadata((String)url);
            return urlMetadata.getStatus() == 200;
        }
        catch (Exception e) {
            LOG.warn("Error getting file information", (Throwable)e);
            return false;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public File download(String url, Path targetFilePath) {
        Files.createDirectories(targetFilePath.getParent(), new FileAttribute[0]);
        File targetFile = targetFilePath.toFile();
        try (ReadableByteChannel in = Channels.newChannel(new URL(url).openStream());){
            File file;
            try (FileOutputStream fileOutputStream = new FileOutputStream(targetFile);){
                fileOutputStream.getChannel().transferFrom(in, 0L, Long.MAX_VALUE);
                file = targetFile;
            }
            return file;
        }
    }

    public CompletableFuture<File> downloadAsync(String url, Path targetFilePath, Consumer<File> successCallback, Consumer<Throwable> errorCallback) {
        return CompletableFuture.supplyAsync(() -> this.download(url, targetFilePath)).whenComplete((result, error) -> {
            if (error != null) {
                LOG.error("Error downloading file from url " + url, error);
                errorCallback.accept((Throwable)error);
            } else {
                successCallback.accept((File)result);
            }
        });
    }
}

