/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.service.admin.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.http.StatusLine;
import org.gbif.ipt.action.BaseAction;
import org.gbif.ipt.config.AppConfig;
import org.gbif.ipt.config.ConfigWarnings;
import org.gbif.ipt.config.DataDir;
import org.gbif.ipt.model.Vocabulary;
import org.gbif.ipt.model.VocabularyConcept;
import org.gbif.ipt.model.VocabularyTerm;
import org.gbif.ipt.model.factory.VocabularyFactory;
import org.gbif.ipt.service.BaseManager;
import org.gbif.ipt.service.InvalidConfigException;
import org.gbif.ipt.service.RegistryException;
import org.gbif.ipt.service.admin.RegistrationManager;
import org.gbif.ipt.service.admin.VocabulariesManager;
import org.gbif.ipt.service.registry.RegistryManager;
import org.gbif.ipt.struts2.SimpleTextProvider;
import org.gbif.utils.HttpClient;
import org.gbif.utils.HttpUtil;
import org.xml.sax.SAXException;

public class VocabulariesManagerImpl
extends BaseManager
implements VocabulariesManager {
    private Map<String, Vocabulary> vocabulariesById = new HashMap();
    public static final String CONFIG_FOLDER = ".vocabularies";
    public static final String VOCAB_FILE_SUFFIX = ".vocab";
    private VocabularyFactory vocabFactory;
    private final HttpClient downloader;
    private final RegistryManager registryManager;
    private static final List<String> DEFAULT_VOCABS = Arrays.asList("http://iso.org/639-2", "http://iso.org/iso3166-1/alpha2", "http://rs.gbif.org/vocabulary/gbif/datasetType", "http://rs.gbif.org/vocabulary/gbif/rank", "http://rs.gbif.org/vocabulary/gbif/agentRole", "http://rs.gbif.org/vocabulary/gbif/preservation_method", "http://rs.gbif.org/vocabulary/gbif/datasetSubtype", "http://rs.gbif.org/vocabulary/eml/updateFrequency");
    private ConfigWarnings warnings;
    private BaseAction baseAction;

    @Inject
    public VocabulariesManagerImpl(AppConfig cfg, DataDir dataDir, VocabularyFactory vocabFactory, HttpClient client, RegistryManager registryManager, ConfigWarnings warnings, SimpleTextProvider textProvider, RegistrationManager registrationManager) {
        super(cfg, dataDir);
        this.vocabFactory = vocabFactory;
        this.downloader = client;
        this.registryManager = registryManager;
        this.warnings = warnings;
        this.baseAction = new BaseAction(textProvider, cfg, registrationManager);
    }

    private void uninstall(String identifier) {
        if (this.vocabulariesById.containsKey(identifier)) {
            Vocabulary toUninstall = (Vocabulary)this.vocabulariesById.get(identifier);
            File f = this.getVocabFile(toUninstall.getUriResolvable());
            if (f.exists()) {
                f.delete();
                this.LOG.debug("Successfully deleted (uninstalled) vocabulary file: " + f.getAbsolutePath());
            } else {
                this.LOG.warn("Vocabulary file doesn't exist locally - can't delete: " + f.getAbsolutePath());
            }
            this.vocabulariesById.remove(identifier);
        } else {
            this.LOG.warn("Vocabulary not installed locally, can't uninstall: " + identifier);
        }
    }

    public Vocabulary get(String identifier) {
        Objects.requireNonNull(identifier);
        return (Vocabulary)this.vocabulariesById.get(identifier);
    }

    public Vocabulary get(URL url) {
        Objects.requireNonNull(url);
        for (Vocabulary v : this.list()) {
            if (v.getUriResolvable() == null) continue;
            try {
                if (v.getUriResolvable().compareTo(url.toURI()) != 0) continue;
                return v;
            }
            catch (URISyntaxException e) {
                this.LOG.error("Getting vocabulary by URL failed", (Throwable)e);
            }
        }
        return null;
    }

    public Map<String, String> getI18nVocab(String identifier, String lang, boolean sortAlphabetically) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        Vocabulary v = this.get(identifier);
        if (v != null) {
            ArrayList<VocabularyConcept> concepts;
            if (sortAlphabetically) {
                concepts = new ArrayList<VocabularyConcept>(v.getConcepts());
                String s = lang;
                concepts.sort(Comparator.comparing(o -> o.getPreferredTerm(s) == null ? o.getIdentifier() : o.getPreferredTerm(s).getTitle()));
            } else {
                concepts = v.getConcepts();
            }
            for (VocabularyConcept c : concepts) {
                VocabularyTerm t = c.getPreferredTerm(lang);
                map.put(c.getIdentifier(), t == null ? c.getIdentifier() : t.getTitle());
            }
        }
        if (map.isEmpty()) {
            this.LOG.error("Empty i18n map for vocabulary " + identifier + " and language " + lang);
        }
        return map;
    }

    public Map<String, String> getI18nDatasetTypesVocab(String lang, boolean sortAlphabetically) {
        return this.getI18nVocab("http://rs.gbif.org/vocabulary/gbif/datasetType", lang, sortAlphabetically);
    }

    public Map<String, String> getI18nDatasetSubtypesVocab(String lang, boolean sortAlphabetically) {
        return this.getI18nVocab("http://rs.gbif.org/vocabulary/gbif/datasetSubtype", lang, sortAlphabetically);
    }

    private File getVocabFile(URI uri) {
        String filename = org.gbif.ipt.utils.FileUtils.getSuffixedFileName((String)uri.toString(), (String)VOCAB_FILE_SUFFIX);
        return this.dataDir.configFile(".vocabularies/" + filename);
    }

    public synchronized Vocabulary install(URL url) throws InvalidConfigException {
        Objects.requireNonNull(url);
        try {
            File tmpFile = this.download(url);
            Vocabulary vocabulary = this.loadFromFile(tmpFile);
            vocabulary.setUriResolvable(url.toURI());
            this.finishInstall(tmpFile, vocabulary);
            return vocabulary;
        }
        catch (InvalidConfigException e) {
            throw e;
        }
        catch (Exception e) {
            String msg = this.baseAction.getText("admin.vocabulary.install.error", new String[]{url.toString()});
            this.LOG.error(msg, (Throwable)e);
            throw new InvalidConfigException(InvalidConfigException.TYPE.INVALID_EXTENSION, msg, e);
        }
    }

    public synchronized Vocabulary installIfAbsentOrOutdated(URL url) throws InvalidConfigException {
        Objects.requireNonNull(url);
        try {
            File tmpFile = this.download(url);
            Vocabulary vocabulary = this.loadFromFile(tmpFile);
            vocabulary.setUriResolvable(url.toURI());
            Vocabulary alreadyInstalled = this.get(vocabulary.getUriString());
            if (alreadyInstalled == null) {
                this.finishInstall(tmpFile, vocabulary);
            } else if (this.isLoadedVocabularyNewerThanInstalled(alreadyInstalled.getIssued(), vocabulary.getIssued()) || alreadyInstalled.getIssued() == null || !alreadyInstalled.isLatest()) {
                try {
                    this.updateToLatest(alreadyInstalled, vocabulary);
                }
                catch (IOException e) {
                    throw new InvalidConfigException(InvalidConfigException.TYPE.INVALID_DATA_DIR, "Can't update installed vocabulary: " + alreadyInstalled.getUriString(), (Exception)e);
                }
            } else {
                this.LOG.info("Vocabulary {} already installed (id {}), skipping", (Object)url, (Object)vocabulary.getUriString());
                FileUtils.deleteQuietly((File)tmpFile);
                vocabulary = alreadyInstalled;
            }
            return vocabulary;
        }
        catch (InvalidConfigException e) {
            throw e;
        }
        catch (Exception e) {
            String msg = this.baseAction.getText("admin.vocabulary.install.error", new String[]{url.toString()});
            this.LOG.error(msg, (Throwable)e);
            throw new InvalidConfigException(InvalidConfigException.TYPE.INVALID_EXTENSION, msg, e);
        }
    }

    private boolean isLoadedVocabularyNewerThanInstalled(Date installedVocabularyIssuedDate, Date loadedVocabularyIssuedDate) {
        return installedVocabularyIssuedDate != null && loadedVocabularyIssuedDate != null && loadedVocabularyIssuedDate.after(installedVocabularyIssuedDate);
    }

    private void finishInstall(File tmpFile, Vocabulary vocabulary) throws IOException {
        Objects.requireNonNull(tmpFile);
        Objects.requireNonNull(vocabulary);
        Objects.requireNonNull(vocabulary.getUriString());
        try {
            File installedFile = this.getVocabFile(vocabulary.getUriResolvable());
            if (!installedFile.exists()) {
                FileUtils.moveFile((File)tmpFile, (File)installedFile);
            }
            Vocabulary fromFile = this.loadFromFile(installedFile);
            fromFile.setUriResolvable(vocabulary.getUriResolvable());
            fromFile.setLatest(true);
            this.vocabulariesById.put(vocabulary.getUriString(), fromFile);
        }
        catch (IOException e) {
            this.LOG.error("Installing vocabulary failed, while trying to move and rename vocabulary file: " + e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    private File download(URL url) throws IOException {
        Objects.requireNonNull(url);
        String filename = url.toString().replaceAll("[/:.]+", "_") + ".xml";
        File tmpFile = this.dataDir.tmpFile(filename);
        StatusLine statusLine = this.downloader.download(url, tmpFile);
        if (HttpUtil.success((StatusLine)statusLine)) {
            this.LOG.info("Successfully downloaded vocabulary: " + String.valueOf(url));
            return tmpFile;
        }
        String msg = "Failed to download vocabulary: " + String.valueOf(url) + ". Response=" + statusLine.getStatusCode();
        this.LOG.error(msg);
        throw new IOException(msg);
    }

    public List<Vocabulary> list() {
        return new ArrayList<Vocabulary>(this.vocabulariesById.values());
    }

    public int load() {
        File dir;
        Map fileNameToVocabulary = this.getFileNameToVocabularyMap();
        int counter = 0;
        if (!fileNameToVocabulary.isEmpty() && (dir = this.dataDir.configFile(CONFIG_FOLDER)).isDirectory()) {
            SuffixFileFilter ff = new SuffixFileFilter(VOCAB_FILE_SUFFIX, IOCase.INSENSITIVE);
            ArrayList<File> files = new ArrayList<File>(Arrays.asList(dir.listFiles((FilenameFilter)ff)));
            for (File vf : files) {
                try {
                    Vocabulary v = this.loadFromFile(vf);
                    if (fileNameToVocabulary.containsKey(vf.getName())) {
                        v.setUriResolvable(((Vocabulary)fileNameToVocabulary.get(vf.getName())).getUriResolvable());
                        Vocabulary already = (Vocabulary)this.vocabulariesById.get(v.getUriString());
                        if (already == null) {
                            this.vocabulariesById.put(v.getUriString(), v);
                            ++counter;
                            continue;
                        }
                        boolean keepNew = false;
                        Date issuedExisting = already.getIssued();
                        Date issuedNew = v.getIssued();
                        if (issuedExisting == null && issuedNew != null) {
                            keepNew = true;
                        } else if (issuedExisting != null && issuedNew != null) {
                            keepNew = issuedNew.after(issuedExisting);
                        } else if (issuedExisting == null && issuedNew == null) {
                            boolean bl = keepNew = v.getModified() != null && already.getModified() != null && v.getModified().after(already.getModified());
                        }
                        if (keepNew) {
                            File oldFile = this.getVocabFile(already.getUriResolvable());
                            this.vocabulariesById.put(v.getUriString(), v);
                            this.LOG.warn("Duplicate vocabulary {} detected; keeping newer file {} and deleting {}", (Object)v.getUriString(), (Object)vf.getName(), (Object)oldFile.getName());
                            FileUtils.deleteQuietly((File)oldFile);
                        } else {
                            this.LOG.warn("Duplicate vocabulary {} detected; keeping existing and deleting {}", (Object)v.getUriString(), (Object)vf.getName());
                            FileUtils.deleteQuietly((File)vf);
                        }
                        ++counter;
                        continue;
                    }
                    this.LOG.warn("An invalid vocabulary has been encountered and will be deleted: " + vf.getAbsolutePath());
                    FileUtils.deleteQuietly((File)vf);
                }
                catch (InvalidConfigException e) {
                    this.warnings.addStartupError("Failed to load vocabulary definition file: " + vf.getAbsolutePath(), (Exception)((Object)e));
                }
            }
        }
        return counter;
    }

    private Map<String, Vocabulary> getFileNameToVocabularyMap() {
        HashMap<String, Vocabulary> map = new HashMap<String, Vocabulary>();
        try {
            for (Vocabulary v : this.registryManager.getVocabularies()) {
                if (v.getUriString() == null || v.getUriResolvable() == null) continue;
                String filename = org.gbif.ipt.utils.FileUtils.getSuffixedFileName((String)v.getUriResolvable().toString(), (String)VOCAB_FILE_SUFFIX);
                map.put(filename, v);
            }
        }
        catch (RegistryException e) {
            String msg = RegistryException.logRegistryException((RegistryException)e, (BaseAction)this.baseAction);
            this.warnings.addStartupError(msg);
            this.LOG.error(msg, (Throwable)e);
            msg = this.baseAction.getText("admin.extensions.vocabularies.couldnt.load", new String[]{this.cfg.getRegistryUrl()});
            this.warnings.addStartupError(msg);
            this.LOG.error(msg);
        }
        return map;
    }

    public synchronized void installOrUpdateDefaults() throws InvalidConfigException, RegistryException {
        List vocabularies = this.registryManager.getVocabularies();
        for (Vocabulary latest : this.getLatestDefaults(vocabularies)) {
            Vocabulary installed = null;
            for (Vocabulary vocabulary : this.list()) {
                if (!latest.getUriString().equalsIgnoreCase(vocabulary.getUriString())) continue;
                installed = vocabulary;
                break;
            }
            if (installed == null) {
                try {
                    URL url = latest.getUriResolvable().toURL();
                    try {
                        this.install(url);
                        continue;
                    }
                    catch (Exception e) {
                        throw new RegistryException(url.toString(), e);
                    }
                }
                catch (MalformedURLException e) {
                    throw new InvalidConfigException(InvalidConfigException.TYPE.INVALID_VOCABULARY, "Vocabulary has an invalid URL: " + latest.getUriResolvable().toString());
                }
            }
            try {
                this.updateToLatest(installed, latest);
            }
            catch (IOException e) {
                throw new InvalidConfigException(InvalidConfigException.TYPE.INVALID_DATA_DIR, "Can't update default vocabulary: " + installed.getUriString(), (Exception)e);
            }
        }
        this.updateIsLatest(this.list(), vocabularies);
    }

    private List<Vocabulary> getLatestDefaults(List<Vocabulary> registered) {
        ArrayList<Vocabulary> defaults = new ArrayList<Vocabulary>();
        for (Vocabulary v : registered) {
            if (v.getUriString() == null || !DEFAULT_VOCABS.contains(v.getUriString()) || !v.isLatest()) continue;
            defaults.add(v);
        }
        if (DEFAULT_VOCABS.size() != defaults.size()) {
            String msg = "Not all default vocabularies were loaded!";
            this.LOG.error(msg);
            throw new InvalidConfigException(InvalidConfigException.TYPE.INVALID_DATA_DIR, msg);
        }
        return defaults;
    }

    private Vocabulary loadFromFile(File localFile) throws InvalidConfigException {
        Vocabulary vocabulary;
        Objects.requireNonNull(localFile);
        if (!localFile.exists()) {
            throw new IllegalStateException();
        }
        FileInputStream fileIn = new FileInputStream(localFile);
        try {
            Vocabulary v = this.vocabFactory.build((InputStream)fileIn);
            v.setModified(new Date(localFile.lastModified()));
            this.LOG.info("Successfully loaded vocabulary: " + v.getUriString());
            vocabulary = v;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)fileIn).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                this.LOG.error("Can't access local vocabulary file (" + localFile.getAbsolutePath() + ")", (Throwable)e);
                throw new InvalidConfigException(InvalidConfigException.TYPE.INVALID_VOCABULARY, "Can't access local vocabulary file");
            }
            catch (SAXException e) {
                this.LOG.error("Can't parse local extension file (" + localFile.getAbsolutePath() + ")", (Throwable)e);
                throw new InvalidConfigException(InvalidConfigException.TYPE.INVALID_VOCABULARY, "Can't parse local vocabulary file");
            }
            catch (ParserConfigurationException e) {
                this.LOG.error("Can't create sax parser", (Throwable)e);
                throw new InvalidConfigException(InvalidConfigException.TYPE.INVALID_VOCABULARY, "Can't create sax parser");
            }
        }
        ((InputStream)fileIn).close();
        return vocabulary;
    }

    protected void updateIsLatest(List<Vocabulary> vocabularies, List<Vocabulary> registered) {
        if (!vocabularies.isEmpty() && !registered.isEmpty()) {
            for (Vocabulary iptVocabulary : vocabularies) {
                for (Vocabulary registryVocabulary : registered) {
                    String registryVocabularyId;
                    String iptVocabularyId;
                    if (iptVocabulary.getUriString() == null || registryVocabulary.getUriString() == null || !(iptVocabularyId = iptVocabulary.getUriString()).equalsIgnoreCase(registryVocabularyId = registryVocabulary.getUriString())) continue;
                    Date iptVocabularyIssuedDate = iptVocabulary.getIssued();
                    Date registryVocabularyIssuedDate = registryVocabulary.getIssued();
                    if ((iptVocabularyIssuedDate != null || registryVocabularyIssuedDate != null) && (iptVocabularyIssuedDate == null || registryVocabularyIssuedDate == null || iptVocabularyIssuedDate.compareTo(registryVocabularyIssuedDate) != 0)) continue;
                    iptVocabulary.setLatest(registryVocabulary.isLatest());
                }
                this.LOG.debug("Installed vocabulary with identifier {} latest={}", (Object)iptVocabulary.getUriString(), (Object)iptVocabulary.isLatest());
            }
        }
    }

    private void updateToLatest(Vocabulary installed, Vocabulary latestVersion) throws IOException, InvalidConfigException {
        if (installed != null && latestVersion != null) {
            boolean isNewVersion = false;
            Date issued = installed.getIssued();
            Date issuedLatest = latestVersion.getIssued();
            if (issued == null && issuedLatest != null) {
                isNewVersion = true;
            } else if (issued != null && issuedLatest != null) {
                boolean bl = isNewVersion = issuedLatest.compareTo(issued) > 0;
            }
            if (isNewVersion && latestVersion.getUriResolvable() != null) {
                File tmpFile = this.download(latestVersion.getUriResolvable().toURL());
                this.uninstall(installed.getUriString());
                this.finishInstall(tmpFile, latestVersion);
            }
        }
    }

    public synchronized void updateIfChanged() throws IOException, RegistryException {
        List installedVocabularies = this.list();
        List registryVocabularies = this.registryManager.getVocabularies();
        for (Vocabulary installed : installedVocabularies) {
            if (installed == null || installed.getUriString() == null) {
                this.LOG.error("Installed vocabulary is null ot does not have an ID");
                continue;
            }
            this.LOG.debug("Updating vocabulary {}", (Object)installed.getUriString());
            Vocabulary matched = null;
            boolean isMatched = false;
            for (Vocabulary rVocab : registryVocabularies) {
                if (rVocab.getUriString() == null || !rVocab.getUriString().equalsIgnoreCase(installed.getUriString())) continue;
                isMatched = true;
                if (installed.getIssued() != null && (installed.getIssued() == null || rVocab.getIssued() == null || installed.getIssued().compareTo(rVocab.getIssued()) >= 0)) continue;
                matched = rVocab;
                break;
            }
            if (!isMatched) {
                this.LOG.error("No matching vocabulary found for {}", (Object)installed.getUriString());
                continue;
            }
            if (matched == null) {
                this.LOG.debug("Vocabulary {} is already up-to-date", (Object)installed.getUriString());
                continue;
            }
            if (matched.getUriResolvable() == null) {
                this.LOG.error("Matched vocabulary {} doesn't have a URI", (Object)installed.getUriString());
                continue;
            }
            this.LOG.debug("Found matching vocabulary {}", (Object)matched.getUriString());
            File vocabFile = this.getVocabFile(matched.getUriResolvable());
            boolean downloadResult = this.downloader.downloadIfChanged(matched.getUriResolvable().toURL(), vocabFile);
            if (downloadResult) {
                this.LOG.debug("Downloaded vocabulary {}", (Object)matched.getUriString());
                Vocabulary result = this.loadFromFile(vocabFile);
                this.vocabulariesById.replace(result.getUriString(), result);
                continue;
            }
            this.LOG.error("Failed to download vocabulary {} from {}", (Object)matched.getUriString(), (Object)matched.getUriResolvable());
        }
    }
}

