/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.service.admin.impl;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.security.AnyTypePermission;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.gbif.doi.service.DoiService;
import org.gbif.doi.service.datacite.RestJsonApiDataCiteService;
import org.gbif.ipt.config.AppConfig;
import org.gbif.ipt.config.DataDir;
import org.gbif.ipt.model.Ipt;
import org.gbif.ipt.model.Network;
import org.gbif.ipt.model.Organisation;
import org.gbif.ipt.model.Registration;
import org.gbif.ipt.model.Resource;
import org.gbif.ipt.model.converter.PasswordEncrypter;
import org.gbif.ipt.model.legacy.LegacyIpt;
import org.gbif.ipt.model.legacy.LegacyOrganisation;
import org.gbif.ipt.model.legacy.LegacyRegistration;
import org.gbif.ipt.model.voc.DOIRegistrationAgency;
import org.gbif.ipt.service.AlreadyExistingException;
import org.gbif.ipt.service.BaseManager;
import org.gbif.ipt.service.DeletionNotAllowedException;
import org.gbif.ipt.service.InvalidConfigException;
import org.gbif.ipt.service.admin.RegistrationManager;
import org.gbif.ipt.service.registry.RegistryManager;

public class RegistrationManagerImpl
extends BaseManager
implements RegistrationManager {
    private static final Logger LOG = LogManager.getLogger(RegistrationManagerImpl.class);
    private static final Comparator<Organisation> ORG_BY_NAME_ORD = (left, right) -> StringUtils.compare((String)left.getName(), (String)right.getName());
    public static final String PERSISTENCE_FILE_V1 = "registration.xml";
    public static final String PERSISTENCE_FILE_V2 = "registration2.xml";
    private Registration registration = new Registration();
    private final XStream xstreamV1 = new XStream();
    private final XStream xstreamV2 = new XStream();
    private RegistryManager registryManager;

    public RegistrationManagerImpl(AppConfig cfg, DataDir dataDir, RegistryManager registryManager, PasswordEncrypter passwordEncrypter) {
        super(cfg, dataDir);
        this.defineXstreamMappingV1();
        this.defineXstreamMappingV2(passwordEncrypter);
        this.registryManager = registryManager;
    }

    public Organisation addAssociatedOrganisation(Organisation organisation) throws AlreadyExistingException, InvalidConfigException {
        if (organisation != null) {
            if (organisation.isAgencyAccountPrimary() && this.findPrimaryDoiAgencyAccount() != null && !organisation.getKey().equals(this.findPrimaryDoiAgencyAccount().getKey())) {
                throw new InvalidConfigException(InvalidConfigException.TYPE.REGISTRATION_BAD_CONFIG, "Multiple DOI accounts activated in registration information - only one is allowed.");
            }
            LOG.debug("Adding/updating associated organisation {} - {}", (Object)organisation.getKey(), (Object)organisation.getName());
            this.registration.getAssociatedOrganisations().put(organisation.getKey().toString(), organisation);
        }
        return organisation;
    }

    public Organisation findPrimaryDoiAgencyAccount() {
        for (Organisation organisation : this.registration.getAssociatedOrganisations().values()) {
            if (!organisation.isAgencyAccountPrimary()) continue;
            return organisation;
        }
        return null;
    }

    public DoiService getDoiService() throws InvalidConfigException {
        Organisation organisation = this.findPrimaryDoiAgencyAccount();
        if (organisation != null) {
            String username = organisation.getAgencyAccountUsername();
            String password = organisation.getAgencyAccountPassword();
            DOIRegistrationAgency agency = organisation.getDoiRegistrationAgency();
            if (StringUtils.isNotBlank((CharSequence)username) && StringUtils.isNotBlank((CharSequence)password) && agency != null) {
                return new RestJsonApiDataCiteService(this.cfg.getDataCiteUrl(), username, password);
            }
            throw new InvalidConfigException(InvalidConfigException.TYPE.REGISTRATION_BAD_CONFIG, "DOI agency account for " + organisation.getName() + " is missing information!");
        }
        LOG.debug("No DOI agency account has been added and activated yet to this IPT.");
        return null;
    }

    public Organisation addHostingOrganisation(Organisation organisation) {
        if (organisation != null) {
            LOG.debug("Adding hosting organisation " + String.valueOf(organisation.getKey()) + " - " + organisation.getName());
            this.registration.setHostingOrganisation(organisation);
        }
        return organisation;
    }

    public void addIptInstance(Ipt ipt) {
        if (ipt != null) {
            if (ipt.getCreated() == null) {
                ipt.setCreated(new Date());
            }
            this.registration.setIpt(ipt);
        }
    }

    private Ipt createIptFromLegacyIpt(LegacyIpt ipt) {
        Ipt i = null;
        if (ipt != null) {
            String key;
            i = new Ipt();
            String string = key = ipt.getKey() == null ? null : ipt.getKey().toString();
            if (key != null) {
                i.setKey(key);
            }
            i.setDescription(StringUtils.trimToNull((String)ipt.getDescription()));
            i.setWsPassword(StringUtils.trimToNull((String)ipt.getWsPassword()));
            i.setName(StringUtils.trimToNull((String)ipt.getName()));
            i.setCreated(ipt.getCreated());
            i.setLanguage(StringUtils.trimToNull((String)ipt.getLanguage()));
            i.setLogoUrl(StringUtils.trimToNull((String)ipt.getLogoUrl()));
            i.setHomepageURL(StringUtils.trimToNull((String)ipt.getHomepageURL()));
            i.setOrganisationKey(StringUtils.trimToNull((String)ipt.getOrganisationKey().toString()));
            i.setPrimaryContactType(StringUtils.trimToNull((String)ipt.getPrimaryContactType()));
            i.setPrimaryContactPhone(StringUtils.trimToNull((String)ipt.getPrimaryContactPhone()));
            i.setPrimaryContactLastName(StringUtils.trimToNull((String)ipt.getPrimaryContactLastName()));
            i.setPrimaryContactFirstName(StringUtils.trimToNull((String)ipt.getPrimaryContactFirstName()));
            i.setPrimaryContactAddress(StringUtils.trimToNull((String)ipt.getPrimaryContactAddress()));
            i.setPrimaryContactEmail(StringUtils.trimToNull((String)ipt.getPrimaryContactEmail()));
            i.setPrimaryContactDescription(StringUtils.trimToNull((String)ipt.getPrimaryContactDescription()));
            i.setPrimaryContactName(StringUtils.trimToNull((String)ipt.getPrimaryContactName()));
        }
        return i;
    }

    private Organisation createOrganisationFromLegacyOrganisation(LegacyOrganisation organisation) {
        Organisation o = null;
        if (organisation != null) {
            String key;
            o = new Organisation();
            String string = key = organisation.getKey() == null ? null : organisation.getKey().toString();
            if (key != null) {
                o.setKey(key);
            }
            o.setName(organisation.getName());
            o.setAlias(organisation.getAlias());
            o.setCanHost(organisation.isCanHost());
            o.setPassword(organisation.getPassword());
        }
        return o;
    }

    private void defineXstreamMappingV1() {
        this.xstreamV1.addPermission(AnyTypePermission.ANY);
        this.xstreamV1.ignoreUnknownElements();
        this.xstreamV1.omitField(LegacyRegistration.class, "associatedOrganisations");
        this.xstreamV1.alias("organisation", LegacyOrganisation.class);
        this.xstreamV1.alias("registry", LegacyRegistration.class);
    }

    private void defineXstreamMappingV2(PasswordEncrypter passwordEncrypter) {
        this.xstreamV2.addPermission(AnyTypePermission.ANY);
        this.xstreamV2.ignoreUnknownElements();
        this.xstreamV2.omitField(Registration.class, "associatedOrganisations");
        this.xstreamV2.alias("organisation", Organisation.class);
        this.xstreamV2.alias("registry", Registration.class);
        this.xstreamV2.registerConverter((Converter)passwordEncrypter);
    }

    public Organisation delete(String key, List<Resource> resources) throws DeletionNotAllowedException {
        Organisation org = this.get(key);
        if (org != null) {
            for (Resource resource : resources) {
                if (resource.getOrganisation() != null && resource.getOrganisation().equals((Object)org)) {
                    throw new DeletionNotAllowedException(DeletionNotAllowedException.Reason.RESOURCE_REGISTERED_WITH_ORGANISATION, "Resource " + resource.getShortname() + " associated with organisation");
                }
                if (resource.getDoiOrganisationKey() == null || !resource.getDoiOrganisationKey().equals(org.getKey())) continue;
                throw new DeletionNotAllowedException(DeletionNotAllowedException.Reason.RESOURCE_DOI_REGISTERED_WITH_ORGANISATION, "Resource " + resource.getShortname() + " has DOI associated with organisation");
            }
            Organisation host = this.registration.getHostingOrganisation();
            if (host != null && host.getKey() != null && host.getKey().toString().equals(key)) {
                throw new DeletionNotAllowedException(DeletionNotAllowedException.Reason.IPT_REGISTERED_WITH_ORGANISATION, "The IPT instance is associated with this organisation");
            }
            this.registration.getAssociatedOrganisations().remove(key);
        }
        return org;
    }

    public Organisation get(String key) {
        if (key == null) {
            return null;
        }
        return (Organisation)this.registration.getAssociatedOrganisations().get(key);
    }

    public Organisation get(UUID key) {
        if (key == null) {
            return null;
        }
        return (Organisation)this.registration.getAssociatedOrganisations().get(key.toString());
    }

    public Organisation getHostingOrganisation() {
        return this.registration.getHostingOrganisation();
    }

    public Network getNetwork() {
        return this.registration.getNetwork();
    }

    public Ipt getIpt() {
        return this.registration.getIpt();
    }

    public List<Organisation> list() {
        return this.registration.getAssociatedOrganisations().values().stream().filter(Organisation::isCanHost).sorted(ORG_BY_NAME_ORD).collect(Collectors.toList());
    }

    public List<Organisation> listAll() {
        return this.registration.getAssociatedOrganisations().values().stream().sorted(ORG_BY_NAME_ORD).collect(Collectors.toList());
    }

    public void load() throws InvalidConfigException {
        try (Reader registrationReader = org.gbif.ipt.utils.FileUtils.getUtf8Reader((File)this.dataDir.configFile(PERSISTENCE_FILE_V2));
             ObjectInputStream in = this.xstreamV2.createObjectInputStream(registrationReader);){
            this.registration.getAssociatedOrganisations().clear();
            try {
                Registration reg = (Registration)in.readObject();
                this.addHostingOrganisation(reg.getHostingOrganisation());
                this.addIptInstance(reg.getIpt());
                while (true) {
                    try {
                        while (true) {
                            Organisation org = (Organisation)in.readObject();
                            this.addAssociatedOrganisation(org);
                        }
                    }
                    catch (EOFException e) {
                    }
                    catch (ClassNotFoundException e) {
                        LOG.error(e.getMessage(), (Throwable)e);
                        continue;
                    }
                    break;
                }
            }
            catch (EOFException reg) {
            }
            catch (AlreadyExistingException e) {
                LOG.error((Object)e);
            }
        }
        catch (FileNotFoundException e) {
            LOG.warn("Registration information not existing, registration2.xml file missing  (This is normal when IPT is not registered yet)");
        }
        catch (ClassNotFoundException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new InvalidConfigException(InvalidConfigException.TYPE.REGISTRATION_CONFIG, "Couldnt read the registration information: " + e.getMessage());
        }
        try {
            this.updateAssociatedOrganisationsMetadata();
        }
        catch (IOException e) {
            LOG.error("Failed to update associated organisations", (Throwable)e);
        }
    }

    public Organisation getFromDisk(String key) {
        TreeMap<String, Organisation> associatedOrganisations = new TreeMap<String, Organisation>();
        try (Reader registrationReader = org.gbif.ipt.utils.FileUtils.getUtf8Reader((File)this.dataDir.configFile(PERSISTENCE_FILE_V2));){
            ObjectInputStream in = this.xstreamV2.createObjectInputStream(registrationReader);
            try {
                in.readObject();
                try {
                    while (true) {
                        Organisation org = (Organisation)in.readObject();
                        associatedOrganisations.put(org.getKey().toString(), org);
                    }
                }
                catch (EOFException e) {
                    if (in != null) {
                        in.close();
                    }
                }
            }
            catch (Throwable throwable) {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        catch (ClassNotFoundException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new InvalidConfigException(InvalidConfigException.TYPE.REGISTRATION_CONFIG, "Couldnt read registration info: " + e.getMessage());
        }
        return (Organisation)associatedOrganisations.get(key);
    }

    public void encryptRegistration() throws InvalidConfigException {
        File registrationV1 = this.dataDir.configFile(PERSISTENCE_FILE_V1);
        if (registrationV1.exists()) {
            try (Reader registrationReader = org.gbif.ipt.utils.FileUtils.getUtf8Reader((File)registrationV1);
                 ObjectInputStream in = this.xstreamV1.createObjectInputStream(registrationReader);){
                this.registration.getAssociatedOrganisations().clear();
                try {
                    LegacyIpt legacyIpt;
                    LegacyRegistration reg = (LegacyRegistration)in.readObject();
                    LegacyOrganisation legacyHostingOrganisation = reg.getHostingOrganisation();
                    if (legacyHostingOrganisation != null) {
                        Organisation hostingOrganisation = this.createOrganisationFromLegacyOrganisation(legacyHostingOrganisation);
                        this.addHostingOrganisation(hostingOrganisation);
                    }
                    if ((legacyIpt = reg.getIpt()) != null) {
                        Ipt ipt = this.createIptFromLegacyIpt(legacyIpt);
                        this.addIptInstance(ipt);
                    }
                    while (true) {
                        try {
                            while (true) {
                                LegacyOrganisation legacyOrganisation;
                                if ((legacyOrganisation = (LegacyOrganisation)in.readObject()) == null) {
                                    continue;
                                }
                                Organisation organisation = this.createOrganisationFromLegacyOrganisation(legacyOrganisation);
                                this.addAssociatedOrganisation(organisation);
                            }
                        }
                        catch (EOFException e) {
                        }
                        catch (ClassNotFoundException e) {
                            LOG.error(e.getMessage(), (Throwable)e);
                            continue;
                        }
                        break;
                    }
                }
                catch (EOFException reg) {
                }
                catch (AlreadyExistingException e) {
                    LOG.error((Object)e);
                }
                this.save();
            }
            catch (ClassNotFoundException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                throw new InvalidConfigException(InvalidConfigException.TYPE.REGISTRATION_CONFIG, "Problem reading the registration information: " + e.getMessage());
            }
            catch (IOException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                throw new InvalidConfigException(InvalidConfigException.TYPE.REGISTRATION_CONFIG, "Couldnt read the registration information: " + e.getMessage());
            }
            finally {
                FileUtils.deleteQuietly((File)registrationV1);
            }
        }
    }

    public void updateAssociatedOrganisationsMetadata() throws IOException {
        for (Map.Entry entry : this.registration.getAssociatedOrganisations().entrySet()) {
            Organisation o = (Organisation)entry.getValue();
            this.updateOrganisationMetadata(o);
            this.registration.getAssociatedOrganisations().put((String)entry.getKey(), o);
        }
        Organisation hostingOrganisation = this.registration.getHostingOrganisation();
        if (hostingOrganisation != null) {
            this.updateOrganisationMetadata(hostingOrganisation);
        }
        this.save();
    }

    private void updateOrganisationMetadata(Organisation organisation) {
        if (organisation != null) {
            String key = organisation.getKey() == null ? null : organisation.getKey().toString();
            Organisation o = this.registryManager.getRegisteredOrganisation(key);
            if (o != null) {
                String oKey = o.getKey() == null ? null : o.getKey().toString();
                String oName = StringUtils.trimToNull((String)o.getName());
                if (oKey != null && oKey.equalsIgnoreCase(key) && oName != null) {
                    organisation.setName(oName);
                    organisation.setDescription(StringUtils.trimToNull((String)o.getDescription()));
                    organisation.setHomepageURL(StringUtils.trimToNull((String)o.getHomepageURL()));
                    organisation.setNodeKey(StringUtils.trimToNull((String)o.getNodeKey()));
                    organisation.setNodeName(StringUtils.trimToNull((String)o.getNodeName()));
                    organisation.setNodeContactEmail(StringUtils.trimToNull((String)o.getNodeContactEmail()));
                    organisation.setPrimaryContactName(StringUtils.trimToNull((String)o.getPrimaryContactName()));
                    organisation.setPrimaryContactFirstName(StringUtils.trimToNull((String)o.getPrimaryContactFirstName()));
                    organisation.setPrimaryContactLastName(StringUtils.trimToNull((String)o.getPrimaryContactLastName()));
                    organisation.setPrimaryContactAddress(StringUtils.trimToNull((String)o.getPrimaryContactAddress()));
                    organisation.setPrimaryContactDescription(StringUtils.trimToNull((String)o.getPrimaryContactDescription()));
                    organisation.setPrimaryContactEmail(StringUtils.trimToNull((String)o.getPrimaryContactEmail()));
                    organisation.setPrimaryContactPhone(StringUtils.trimToNull((String)o.getPrimaryContactPhone()));
                    organisation.setPrimaryContactType(StringUtils.trimToNull((String)o.getPrimaryContactType()));
                    LOG.debug("Organisation (" + key + ") updated with latest metadata from Registry");
                } else {
                    LOG.debug("Update of organisation failed: organisation retrieved from Registry was missing name");
                }
            } else {
                LOG.debug("Update of organisation failed: organisation retrieved from Registry was null");
            }
        } else {
            LOG.debug("Update of organisation failed: organisation was null");
        }
    }

    public void associateWithNetwork(String networkKey, String networkName) {
        try {
            Network network = this.registration.getNetwork();
            if (network != null) {
                network.setKey(networkKey);
                network.setName(networkName);
            } else {
                Network n = new Network();
                n.setName(networkName);
                n.setKey(networkKey);
                this.registration.setNetwork(n);
            }
            this.save();
        }
        catch (IOException e) {
            LOG.error("Failed to associate with the network");
        }
    }

    public void removeAssociationWithNetwork() {
        try {
            this.registration.setNetwork(null);
            this.save();
        }
        catch (IOException e) {
            LOG.error("Failed to remove association with the network");
        }
    }

    public synchronized void save() throws IOException {
        LOG.debug("Saving all user organisations associated to this IPT...");
        Writer organisationWriter = org.gbif.ipt.utils.FileUtils.startNewUtf8File((File)this.dataDir.configFile(PERSISTENCE_FILE_V2));
        ObjectOutputStream out = this.xstreamV2.createObjectOutputStream(organisationWriter, "registration");
        out.writeObject(this.registration);
        for (Organisation organisation : this.registration.getAssociatedOrganisations().values()) {
            out.writeObject(organisation);
        }
        out.close();
    }
}

