/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.model.factory;

import java.io.IOException;
import java.io.InputStream;
import javax.inject.Inject;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.Rule;
import org.gbif.ipt.model.Vocabulary;
import org.gbif.ipt.model.VocabularyConcept;
import org.gbif.ipt.model.VocabularyTerm;
import org.gbif.ipt.model.factory.CallParamNoNSRule;
import org.xml.sax.SAXException;

public class VocabularyFactory {
    public static final String VOCABULARY_NAMESPACE = "http://rs.gbif.org/thesaurus/";
    private final SAXParserFactory saxf;

    @Inject
    public VocabularyFactory(SAXParserFactory saxf) {
        this.saxf = saxf;
    }

    public Vocabulary build(InputStream is) throws IOException, SAXException, ParserConfigurationException {
        Digester digester = new Digester(this.saxf.newSAXParser());
        digester.setNamespaceAware(true);
        digester.setXIncludeAware(false);
        digester.setRuleNamespaceURI(VOCABULARY_NAMESPACE);
        Vocabulary tv = new Vocabulary();
        digester.push((Object)tv);
        digester.addCallMethod("*/thesaurus", "setTitle", 1);
        digester.addRule("*/thesaurus", (Rule)new CallParamNoNSRule(0, "title"));
        digester.addCallMethod("*/thesaurus", "setIssuedDateAsString", 1);
        digester.addRule("*/thesaurus", (Rule)new CallParamNoNSRule(0, "issued"));
        digester.addCallMethod("*/thesaurus", "setDescription", 1);
        digester.addRule("*/thesaurus", (Rule)new CallParamNoNSRule(0, "description"));
        digester.addCallMethod("*/thesaurus", "setLink", 1);
        digester.addRule("*/thesaurus", (Rule)new CallParamNoNSRule(0, "relation"));
        digester.addCallMethod("*/thesaurus", "setUriString", 1);
        digester.addRule("*/thesaurus", (Rule)new CallParamNoNSRule(0, "URI"));
        digester.addObjectCreate("*/concept", VocabularyConcept.class);
        digester.addCallMethod("*/concept", "setLink", 1);
        digester.addRule("*/concept", (Rule)new CallParamNoNSRule(0, "relation"));
        digester.addCallMethod("*/concept", "setDescription", 1);
        digester.addRule("*/concept", (Rule)new CallParamNoNSRule(0, "description"));
        digester.addCallMethod("*/concept", "setUri", 1);
        digester.addRule("*/concept", (Rule)new CallParamNoNSRule(0, "URI"));
        digester.addCallMethod("*/concept", "setIdentifier", 1);
        digester.addRule("*/concept", (Rule)new CallParamNoNSRule(0, "identifier"));
        digester.addObjectCreate("*/preferred/term", VocabularyTerm.class);
        digester.addCallMethod("*/preferred/term", "setLang", 1);
        digester.addRule("*/preferred/term", (Rule)new CallParamNoNSRule(0, "lang"));
        digester.addCallMethod("*/preferred/term", "setTitle", 1);
        digester.addRule("*/preferred/term", (Rule)new CallParamNoNSRule(0, "title"));
        digester.addSetNext("*/preferred/term", "addPreferredTerm");
        digester.addObjectCreate("*/alternative/term", VocabularyTerm.class);
        digester.addCallMethod("*/alternative/term", "setLang", 1);
        digester.addRule("*/alternative/term", (Rule)new CallParamNoNSRule(0, "lang"));
        digester.addCallMethod("*/alternative/term", "setTitle", 1);
        digester.addRule("*/alternative/term", (Rule)new CallParamNoNSRule(0, "title"));
        digester.addSetNext("*/alternative/term", "addAlternativeTerm");
        digester.addSetNext("*/concept", "addConcept");
        digester.parse(is);
        return tv;
    }
}

