/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.model.datapackage.metadata.col;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.regex.Pattern;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.gbif.ipt.model.datapackage.metadata.DataPackageMetadata;
import org.gbif.ipt.model.datapackage.metadata.col.Agent;
import org.gbif.ipt.model.datapackage.metadata.col.Citation;
import org.gbif.ipt.model.datapackage.metadata.col.Identifier;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonPropertyOrder(value={"doi", "identifier", "title", "alias", "version", "issued", "creator", "editor", "publisher", "contact", "contributor", "description", "keyword", "taxonomicScope", "taxonomicScopeInEnglish", "temporalScope", "geographicScope", "completeness", "confidence", "url", "issn", "license", "logo", "source", "notes"})
public class ColMetadata
implements DataPackageMetadata {
    @JsonProperty(value="doi")
    private Pattern doi;
    @JsonProperty(value="identifier")
    @Valid
    private Identifier identifier;
    @JsonProperty(value="title")
    @NotNull
    private String title;
    @JsonProperty(value="alias")
    private String alias;
    @JsonProperty(value="version")
    private String version;
    @JsonProperty(value="issued")
    @NotNull
    private Pattern issued;
    @JsonProperty(value="creator")
    @Valid
    @NotNull
    private List<Agent> creator = new ArrayList();
    @JsonProperty(value="editor")
    @Valid
    private List<Agent> editor = new ArrayList();
    @JsonProperty(value="publisher")
    @Valid
    private Agent publisher;
    @JsonProperty(value="contact")
    @Valid
    private Agent contact;
    @JsonProperty(value="contributor")
    @Valid
    private List<Agent> contributor = new ArrayList();
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="keyword")
    @Valid
    private List<String> keyword;
    @JsonProperty(value="taxonomicScope")
    private String taxonomicScope;
    @JsonProperty(value="taxonomicScopeInEnglish")
    private String taxonomicScopeInEnglish;
    @JsonProperty(value="temporalScope")
    private String temporalScope;
    @JsonProperty(value="geographicScope")
    private String geographicScope;
    @JsonProperty(value="completeness")
    private Integer completeness;
    @JsonProperty(value="confidence")
    private Integer confidence;
    @JsonProperty(value="url")
    private URI url;
    @JsonProperty(value="issn")
    private String issn;
    @JsonProperty(value="license")
    @NotNull
    private String license;
    @JsonProperty(value="logo")
    private URI logo;
    @JsonProperty(value="source")
    @Valid
    private List<Citation> source = new ArrayList();
    @JsonProperty(value="notes")
    private String notes;
    @JsonIgnore
    @Valid
    private final Map<String, Object> additionalProperties = new LinkedHashMap();

    @JsonProperty(value="doi")
    public Pattern getDoi() {
        return this.doi;
    }

    @JsonProperty(value="doi")
    public void setDoi(Pattern doi) {
        this.doi = doi;
    }

    @JsonProperty(value="identifier")
    public Identifier getIdentifier() {
        return this.identifier;
    }

    @JsonProperty(value="identifier")
    public void setIdentifier(Identifier identifier) {
        this.identifier = identifier;
    }

    @JsonProperty(value="title")
    public String getTitle() {
        return this.title;
    }

    @JsonProperty(value="title")
    public void setTitle(String title) {
        this.title = title;
    }

    @JsonProperty(value="alias")
    public String getAlias() {
        return this.alias;
    }

    @JsonProperty(value="alias")
    public void setAlias(String alias) {
        this.alias = alias;
    }

    @JsonProperty(value="version")
    public String getVersion() {
        return this.version;
    }

    @JsonProperty(value="version")
    public void setVersion(String version) {
        this.version = version;
    }

    @JsonProperty(value="issued")
    public Pattern getIssued() {
        return this.issued;
    }

    @JsonProperty(value="issued")
    public void setIssued(Pattern issued) {
        this.issued = issued;
    }

    @JsonProperty(value="creator")
    public List<Agent> getCreator() {
        return this.creator;
    }

    @JsonProperty(value="creator")
    public void setCreator(List<Agent> creator) {
        this.creator = creator;
    }

    @JsonProperty(value="editor")
    public List<Agent> getEditor() {
        return this.editor;
    }

    @JsonProperty(value="editor")
    public void setEditor(List<Agent> editor) {
        this.editor = editor;
    }

    @JsonProperty(value="publisher")
    public Agent getPublisher() {
        return this.publisher;
    }

    @JsonProperty(value="publisher")
    public void setPublisher(Agent publisher) {
        this.publisher = publisher;
    }

    @JsonProperty(value="contact")
    public Agent getContact() {
        return this.contact;
    }

    @JsonProperty(value="contact")
    public void setContact(Agent contact) {
        this.contact = contact;
    }

    @JsonProperty(value="contributor")
    public List<Agent> getContributor() {
        return this.contributor;
    }

    @JsonProperty(value="contributor")
    public void setContributor(List<Agent> contributor) {
        this.contributor = contributor;
    }

    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    @JsonProperty(value="keyword")
    public List<String> getKeyword() {
        return this.keyword;
    }

    @JsonProperty(value="keyword")
    public void setKeyword(List<String> keyword) {
        this.keyword = keyword;
    }

    @JsonProperty(value="taxonomicScope")
    public String getTaxonomicScope() {
        return this.taxonomicScope;
    }

    @JsonProperty(value="taxonomicScope")
    public void setTaxonomicScope(String taxonomicScope) {
        this.taxonomicScope = taxonomicScope;
    }

    @JsonProperty(value="taxonomicScopeInEnglish")
    public String getTaxonomicScopeInEnglish() {
        return this.taxonomicScopeInEnglish;
    }

    @JsonProperty(value="taxonomicScopeInEnglish")
    public void setTaxonomicScopeInEnglish(String taxonomicScopeInEnglish) {
        this.taxonomicScopeInEnglish = taxonomicScopeInEnglish;
    }

    @JsonProperty(value="temporalScope")
    public String getTemporalScope() {
        return this.temporalScope;
    }

    @JsonProperty(value="temporalScope")
    public void setTemporalScope(String temporalScope) {
        this.temporalScope = temporalScope;
    }

    @JsonProperty(value="geographicScope")
    public String getGeographicScope() {
        return this.geographicScope;
    }

    @JsonProperty(value="geographicScope")
    public void setGeographicScope(String geographicScope) {
        this.geographicScope = geographicScope;
    }

    @JsonProperty(value="completeness")
    public Integer getCompleteness() {
        return this.completeness;
    }

    @JsonProperty(value="completeness")
    public void setCompleteness(Integer completeness) {
        this.completeness = completeness;
    }

    @JsonProperty(value="confidence")
    public Integer getConfidence() {
        return this.confidence;
    }

    @JsonProperty(value="confidence")
    public void setConfidence(Integer confidence) {
        this.confidence = confidence;
    }

    @JsonProperty(value="url")
    public URI getUrl() {
        return this.url;
    }

    @JsonProperty(value="url")
    public void setUrl(URI url) {
        this.url = url;
    }

    @JsonProperty(value="issn")
    public String getIssn() {
        return this.issn;
    }

    @JsonProperty(value="issn")
    public void setIssn(String issn) {
        this.issn = issn;
    }

    @JsonProperty(value="license")
    public String getLicense() {
        return this.license;
    }

    @JsonProperty(value="license")
    public void setLicense(String license) {
        this.license = license;
    }

    @JsonProperty(value="logo")
    public URI getLogo() {
        return this.logo;
    }

    @JsonProperty(value="logo")
    public void setLogo(URI logo) {
        this.logo = logo;
    }

    public String getImage() {
        return this.logo != null ? this.logo.toString() : null;
    }

    @JsonProperty(value="source")
    public List<Citation> getSource() {
        return this.source;
    }

    @JsonProperty(value="source")
    public void setSource(List<Citation> source) {
        this.source = source;
    }

    @JsonProperty(value="notes")
    public String getNotes() {
        return this.notes;
    }

    @JsonProperty(value="notes")
    public void setNotes(String notes) {
        this.notes = notes;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColMetadata that = (ColMetadata)o;
        return Objects.equals(this.doi, that.doi) && Objects.equals(this.identifier, that.identifier) && Objects.equals(this.title, that.title) && Objects.equals(this.alias, that.alias) && Objects.equals(this.version, that.version) && Objects.equals(this.issued, that.issued) && Objects.equals(this.creator, that.creator) && Objects.equals(this.editor, that.editor) && Objects.equals(this.publisher, that.publisher) && Objects.equals(this.contact, that.contact) && Objects.equals(this.contributor, that.contributor) && Objects.equals(this.description, that.description) && Objects.equals(this.keyword, that.keyword) && Objects.equals(this.taxonomicScope, that.taxonomicScope) && Objects.equals(this.taxonomicScopeInEnglish, that.taxonomicScopeInEnglish) && Objects.equals(this.temporalScope, that.temporalScope) && Objects.equals(this.geographicScope, that.geographicScope) && Objects.equals(this.completeness, that.completeness) && Objects.equals(this.confidence, that.confidence) && Objects.equals(this.url, that.url) && Objects.equals(this.issn, that.issn) && Objects.equals(this.license, that.license) && Objects.equals(this.logo, that.logo) && Objects.equals(this.source, that.source) && Objects.equals(this.notes, that.notes) && Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.doi, this.identifier, this.title, this.alias, this.version, this.issued, this.creator, this.editor, this.publisher, this.contact, this.contributor, this.description, this.keyword, this.taxonomicScope, this.taxonomicScopeInEnglish, this.temporalScope, this.geographicScope, this.completeness, this.confidence, this.url, this.issn, this.license, this.logo, this.source, this.notes, this.additionalProperties);
    }

    public String toString() {
        return new StringJoiner(", ", ColMetadata.class.getSimpleName() + "[", "]").add("doi=" + String.valueOf(this.doi)).add("identifier=" + String.valueOf(this.identifier)).add("title='" + this.title + "'").add("alias='" + this.alias + "'").add("version='" + this.version + "'").add("issued=" + String.valueOf(this.issued)).add("creator=" + String.valueOf(this.creator)).add("editor=" + String.valueOf(this.editor)).add("publisher=" + String.valueOf(this.publisher)).add("contact=" + String.valueOf(this.contact)).add("contributor=" + String.valueOf(this.contributor)).add("description='" + this.description + "'").add("keyword=" + String.valueOf(this.keyword)).add("taxonomicScope='" + this.taxonomicScope + "'").add("taxonomicScopeInEnglish='" + this.taxonomicScopeInEnglish + "'").add("temporalScope='" + this.temporalScope + "'").add("geographicScope='" + this.geographicScope + "'").add("completeness=" + this.completeness).add("confidence=" + this.confidence).add("url=" + String.valueOf(this.url)).add("issn='" + this.issn + "'").add("license='" + this.license + "'").add("logo=" + String.valueOf(this.logo)).add("source=" + String.valueOf(this.source)).add("notes='" + this.notes + "'").add("additionalProperties=" + String.valueOf(this.additionalProperties)).toString();
    }
}

