/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.model.datapackage.metadata.camtrap;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.opensymphony.xwork2.util.Element;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.StringJoiner;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.gbif.ipt.model.datapackage.metadata.Contributor;
import org.gbif.ipt.model.datapackage.metadata.FrictionlessMetadata;
import org.gbif.ipt.model.datapackage.metadata.License;
import org.gbif.ipt.model.datapackage.metadata.Source;
import org.gbif.ipt.model.datapackage.metadata.camtrap.CamtrapContributor;
import org.gbif.ipt.model.datapackage.metadata.camtrap.CamtrapLicense;
import org.gbif.ipt.model.datapackage.metadata.camtrap.CamtrapMetadata;
import org.gbif.ipt.model.datapackage.metadata.camtrap.CamtrapSource;
import org.gbif.ipt.model.datapackage.metadata.camtrap.GbifIngestion;
import org.gbif.ipt.model.datapackage.metadata.camtrap.Geojson;
import org.gbif.ipt.model.datapackage.metadata.camtrap.Project;
import org.gbif.ipt.model.datapackage.metadata.camtrap.RelatedIdentifier;
import org.gbif.ipt.model.datapackage.metadata.camtrap.Taxonomic;
import org.gbif.ipt.model.datapackage.metadata.camtrap.Temporal;
import org.gbif.ipt.validation.BasicMetadata;
import org.gbif.ipt.validation.GeographicScopeMetadata;
import org.gbif.ipt.validation.HasGbifCompatibleLicense;
import org.gbif.ipt.validation.HasOpenDefinitionCompatibleLicense;
import org.gbif.ipt.validation.ProjectMetadata;
import org.gbif.ipt.validation.TaxonomicScopeMetadata;
import org.gbif.ipt.validation.TemporalScopeMetadata;
import org.gbif.ipt.validation.ValidGeojson;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class CamtrapMetadata
extends FrictionlessMetadata {
    private static final long serialVersionUID = 7011607601336714408L;
    @JsonProperty(value="bibliographicCitation")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private String bibliographicCitation;
    @JsonProperty(value="project")
    @NotNull(message="validation.input.required", groups={ProjectMetadata.class})
    @Valid
    private @NotNull(message="validation.input.required", groups={ProjectMetadata.class}) @Valid Project project;
    @JsonProperty(value="coordinatePrecision")
    private Double coordinatePrecision;
    @JsonProperty(value="spatial")
    @NotNull(message="validation.input.required", groups={GeographicScopeMetadata.class})
    @ValidGeojson(message="validation.camtrap.metadata.spatial.geojson", groups={GeographicScopeMetadata.class})
    @Valid
    private @NotNull(message="validation.input.required", groups={GeographicScopeMetadata.class}) @Valid Geojson spatial;
    @JsonProperty(value="temporal")
    @NotNull(message="validation.input.required", groups={TemporalScopeMetadata.class})
    @Valid
    private @NotNull(message="validation.input.required", groups={TemporalScopeMetadata.class}) @Valid Temporal temporal;
    @JsonProperty(value="taxonomic")
    @NotNull(message="validation.input.required", groups={TaxonomicScopeMetadata.class})
    @Valid
    private @NotNull(message="validation.input.required", groups={TaxonomicScopeMetadata.class}) @Valid List<Taxonomic> taxonomic = new ArrayList();
    @JsonProperty(value="relatedIdentifiers")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @NotNull(message="validation.input.required")
    @Valid
    private @NotNull(message="validation.input.required") @Valid List<RelatedIdentifier> relatedIdentifiers = new ArrayList();
    @JsonProperty(value="references")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @NotNull(message="validation.input.required")
    @Valid
    private @NotNull(message="validation.input.required") @Valid List<String> references = new ArrayList();
    @JsonProperty(value="gbifIngestion")
    private GbifIngestion gbifIngestion = new GbifIngestion();

    @JsonProperty(value="profile")
    public String getProfile() {
        return super.getProfile();
    }

    @JsonProperty(value="profile")
    public void setProfile(String profile) {
        super.setProfile(profile);
    }

    @JsonProperty(value="name")
    public String getName() {
        return super.getName();
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        super.setName(name);
    }

    @JsonProperty(value="id")
    public String getId() {
        return super.getId();
    }

    @JsonProperty(value="id")
    public void setId(String id) {
        super.setId(id);
    }

    @JsonProperty(value="created")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss'Z'")
    public Date getCreated() {
        return super.getCreated();
    }

    @JsonProperty(value="created")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss'Z'")
    public void setCreated(Date created) {
        super.setCreated(created);
    }

    @JsonProperty(value="title")
    public String getTitle() {
        return super.getTitle();
    }

    @JsonProperty(value="title")
    public void setTitle(String title) {
        super.setTitle(title);
    }

    @JsonProperty(value="contributors")
    @JsonDeserialize(contentUsing=CamtrapContributor.CamtrapContributorDeserializer.class)
    @JsonSetter(contentNulls=Nulls.SKIP)
    @Element(value=CamtrapContributor.class)
    @NotNull(message="validation.input.required", groups={BasicMetadata.class})
    @Valid
    @Size(min=1, message="validation.datapackage.metadata.contributors.size", groups={BasicMetadata.class})
    public @NotNull(message="validation.input.required", groups={BasicMetadata.class}) @Valid @Size(min=1, message="validation.datapackage.metadata.contributors.size", groups={BasicMetadata.class}) List<Contributor> getContributors() {
        return super.getContributors();
    }

    @JsonProperty(value="contributors")
    public void setContributors(List<Contributor> contributors) {
        super.setContributors(contributors);
    }

    @JsonDeserialize(using=DescriptionDeserializer.class)
    @JsonProperty(value="description")
    public String getDescription() {
        return super.getDescription();
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        super.setDescription(description);
    }

    @JsonProperty(value="version")
    public String getVersion() {
        return super.getVersion();
    }

    @JsonProperty(value="version")
    public void setVersion(String version) {
        super.setVersion(version);
    }

    @JsonProperty(value="keywords")
    public List<String> getKeywords() {
        return super.getKeywords();
    }

    @JsonProperty(value="keywords")
    public void setKeywords(List<String> keywords) {
        super.setKeywords(keywords);
    }

    @JsonProperty(value="image")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public String getImage() {
        return super.getImage();
    }

    @JsonProperty(value="image")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public void setImage(String image) {
        super.setImage(image);
    }

    @JsonProperty(value="homepage")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public URI getHomepage() {
        return super.getHomepage();
    }

    @JsonProperty(value="homepage")
    public void setHomepage(URI homepage) {
        super.setHomepage(homepage);
    }

    @JsonProperty(value="sources")
    @JsonDeserialize(contentUsing=CamtrapSource.CamtrapSourceDeserializer.class)
    @JsonSetter(contentNulls=Nulls.SKIP)
    @Element(value=CamtrapSource.class)
    @Valid
    public List<Source> getSources() {
        return super.getSources();
    }

    @JsonProperty(value="sources")
    public void setSources(List<Source> sources) {
        super.setSources(sources);
    }

    @JsonProperty(value="licenses")
    @JsonDeserialize(contentUsing=CamtrapLicense.CamtrapLicenseDeserializer.class)
    @JsonSetter(contentNulls=Nulls.SKIP)
    @Element(value=CamtrapLicense.class)
    @Size(min=2, message="validation.camtrap.metadata.licenses.size", groups={BasicMetadata.class})
    @HasGbifCompatibleLicense(message="validation.camtrap.metadata.licenses.gbifCompatible.required", groups={BasicMetadata.class})
    @HasOpenDefinitionCompatibleLicense(message="validation.camtrap.metadata.licenses.openDefinitionCompatible.required", groups={BasicMetadata.class})
    public @Size(min=2, message="validation.camtrap.metadata.licenses.size", groups={BasicMetadata.class}) List<License> getLicenses() {
        return super.getLicenses();
    }

    @JsonProperty(value="licenses")
    public void setLicenses(List<License> licenses) {
        super.setLicenses(licenses);
    }

    @JsonProperty(value="bibliographicCitation")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public String getBibliographicCitation() {
        return this.bibliographicCitation;
    }

    @JsonProperty(value="bibliographicCitation")
    public void setBibliographicCitation(String bibliographicCitation) {
        this.bibliographicCitation = bibliographicCitation;
    }

    @JsonProperty(value="project")
    public Project getProject() {
        return this.project;
    }

    @JsonProperty(value="project")
    public void setProject(Project project) {
        this.project = project;
    }

    @JsonProperty(value="coordinatePrecision")
    public Double getCoordinatePrecision() {
        return this.coordinatePrecision;
    }

    @JsonProperty(value="coordinatePrecision")
    public void setCoordinatePrecision(Double coordinatePrecision) {
        this.coordinatePrecision = coordinatePrecision;
    }

    @JsonProperty(value="spatial")
    public Geojson getSpatial() {
        return this.spatial;
    }

    @JsonProperty(value="spatial")
    public void setSpatial(Geojson spatial) {
        this.spatial = spatial;
    }

    @JsonProperty(value="temporal")
    public Temporal getTemporal() {
        return this.temporal;
    }

    @JsonProperty(value="temporal")
    public void setTemporal(Temporal temporal) {
        this.temporal = temporal;
    }

    @JsonProperty(value="taxonomic")
    public List<Taxonomic> getTaxonomic() {
        return this.taxonomic;
    }

    @JsonProperty(value="taxonomic")
    public void setTaxonomic(List<Taxonomic> taxonomic) {
        this.taxonomic = taxonomic;
    }

    @JsonProperty(value="relatedIdentifiers")
    public List<RelatedIdentifier> getRelatedIdentifiers() {
        return this.relatedIdentifiers;
    }

    @JsonProperty(value="relatedIdentifiers")
    public void setRelatedIdentifiers(List<RelatedIdentifier> relatedIdentifiers) {
        this.relatedIdentifiers = relatedIdentifiers;
    }

    @JsonProperty(value="references")
    public List<String> getReferences() {
        return this.references;
    }

    @JsonProperty(value="references")
    public void setReferences(List<String> references) {
        this.references = references;
    }

    @JsonProperty(value="gbifIngestion")
    public GbifIngestion getGbifIngestion() {
        return this.gbifIngestion;
    }

    @JsonProperty(value="gbifIngestion")
    public void setGbifIngestion(GbifIngestion gbifIngestion) {
        this.gbifIngestion = gbifIngestion;
    }

    public String toString() {
        return new StringJoiner(", ", CamtrapMetadata.class.getSimpleName() + "[", "]").add("bibliographicCitation='" + this.bibliographicCitation + "'").add("project=" + String.valueOf(this.project)).add("coordinatePrecision=" + this.coordinatePrecision).add("spatial=" + String.valueOf(this.spatial)).add("temporal=" + String.valueOf(this.temporal)).add("taxonomic=" + String.valueOf(this.taxonomic)).add("relatedIdentifiers=" + String.valueOf(this.relatedIdentifiers)).add("references=" + String.valueOf(this.references)).add("gbifIngestion=" + String.valueOf(this.gbifIngestion)).toString();
    }
}

