/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.model.datapackage.metadata;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.opensymphony.xwork2.util.Element;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.gbif.ipt.model.datapackage.metadata.Contributor;
import org.gbif.ipt.model.datapackage.metadata.DataPackageMetadata;
import org.gbif.ipt.model.datapackage.metadata.FrictionlessContributor;
import org.gbif.ipt.model.datapackage.metadata.FrictionlessLicense;
import org.gbif.ipt.model.datapackage.metadata.FrictionlessSource;
import org.gbif.ipt.model.datapackage.metadata.License;
import org.gbif.ipt.model.datapackage.metadata.Source;
import org.gbif.ipt.validation.BasicMetadata;
import org.gbif.ipt.validation.KeywordsMetadata;
import org.gbif.ipt.validation.ValidURI;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class FrictionlessMetadata
implements DataPackageMetadata,
Serializable {
    private static final long serialVersionUID = 5948080618683312611L;
    @JsonProperty(value="title")
    @NotNull(message="validation.input.required", groups={BasicMetadata.class})
    private @NotNull(message="validation.input.required", groups={BasicMetadata.class}) String title;
    @JsonProperty(value="version")
    private String version = "1.0";
    @JsonProperty(value="profile")
    private String profile = "data-package";
    @JsonProperty(value="name")
    @Pattern(regexp="^([-a-z0-9._/])+$", groups={BasicMetadata.class})
    private @Pattern(regexp="^([-a-z0-9._/])+$", groups={BasicMetadata.class}) String name;
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="description")
    @NotNull(message="validation.input.required", groups={BasicMetadata.class})
    private @NotNull(message="validation.input.required", groups={BasicMetadata.class}) String description;
    @ValidURI(message="validation.url.fullyQualified", groups={BasicMetadata.class})
    @JsonProperty(value="homepage")
    private URI homepage;
    @JsonProperty(value="created")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss'Z'")
    private Date created;
    @JsonProperty(value="contributors")
    @NotNull(message="validation.input.required", groups={BasicMetadata.class})
    @Valid
    private @NotNull(message="validation.input.required", groups={BasicMetadata.class}) @Valid List<Contributor> contributors = new ArrayList();
    @JsonProperty(value="keywords")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @NotNull(message="validation.input.notNull", groups={KeywordsMetadata.class})
    @Valid
    private @NotNull(message="validation.input.notNull", groups={KeywordsMetadata.class}) @Valid List<String> keywords = new ArrayList();
    @JsonProperty(value="image")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private String image;
    @JsonProperty(value="licenses")
    @NotNull(message="validation.input.required", groups={BasicMetadata.class})
    @Valid
    private @NotNull(message="validation.input.required", groups={BasicMetadata.class}) @Valid List<License> licenses = new ArrayList();
    @JsonProperty(value="sources")
    @NotNull(message="validation.input.notNull", groups={BasicMetadata.class})
    @Valid
    private @NotNull(message="validation.input.notNull", groups={BasicMetadata.class}) @Valid List<Source> sources = new ArrayList();
    @JsonIgnore
    @Valid
    private Map<String, Object> additionalProperties = new HashMap();

    @JsonProperty(value="title")
    public String getTitle() {
        return this.title;
    }

    @JsonProperty(value="title")
    public void setTitle(String title) {
        this.title = title;
    }

    @JsonProperty(value="version")
    public String getVersion() {
        return this.version;
    }

    @JsonProperty(value="version")
    public void setVersion(String version) {
        this.version = version;
    }

    @JsonProperty(value="profile")
    public String getProfile() {
        return this.profile;
    }

    @JsonProperty(value="profile")
    public void setProfile(String profile) {
        this.profile = profile;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    public void setId(String id) {
        this.id = id;
    }

    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    @JsonProperty(value="homepage")
    public URI getHomepage() {
        return this.homepage;
    }

    @JsonProperty(value="homepage")
    public void setHomepage(URI homepage) {
        this.homepage = homepage;
    }

    @JsonProperty(value="created")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss'Z'")
    public Date getCreated() {
        return this.created;
    }

    @JsonProperty(value="created")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss'Z'")
    public void setCreated(Date created) {
        this.created = created;
    }

    @JsonProperty(value="contributors")
    @Element(value=FrictionlessContributor.class)
    public List<Contributor> getContributors() {
        return this.contributors;
    }

    @JsonProperty(value="contributors")
    public void setContributors(List<Contributor> contributors) {
        this.contributors = contributors;
    }

    @JsonProperty(value="keywords")
    public List<String> getKeywords() {
        return this.keywords;
    }

    @JsonProperty(value="keywords")
    public void setKeywords(List<String> keywords) {
        this.keywords = keywords;
    }

    @JsonProperty(value="image")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public String getImage() {
        return this.image;
    }

    @JsonProperty(value="image")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public void setImage(String image) {
        this.image = image;
    }

    @JsonProperty(value="licenses")
    @JsonDeserialize(contentUsing=FrictionlessLicense.DataPackageLicenseDeserializer.class)
    @Element(value=FrictionlessLicense.class)
    public List<License> getLicenses() {
        return this.licenses;
    }

    @JsonProperty(value="licenses")
    public void setLicenses(List<License> licenses) {
        this.licenses = licenses;
    }

    @JsonProperty(value="sources")
    @JsonDeserialize(contentUsing=FrictionlessSource.DataPackageSourceDeserializer.class)
    @Element(value=FrictionlessSource.class)
    public List<Source> getSources() {
        return this.sources;
    }

    @JsonProperty(value="sources")
    public void setSources(List<Source> sources) {
        this.sources = sources;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FrictionlessMetadata that = (FrictionlessMetadata)o;
        return Objects.equals(this.title, that.title) && Objects.equals(this.version, that.version) && Objects.equals(this.profile, that.profile) && Objects.equals(this.name, that.name) && Objects.equals(this.id, that.id) && Objects.equals(this.description, that.description) && Objects.equals(this.homepage, that.homepage) && Objects.equals(this.created, that.created) && Objects.equals(this.contributors, that.contributors) && Objects.equals(this.keywords, that.keywords) && Objects.equals(this.image, that.image) && Objects.equals(this.licenses, that.licenses) && Objects.equals(this.sources, that.sources) && Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.title, this.version, this.profile, this.name, this.id, this.description, this.homepage, this.created, this.contributors, this.keywords, this.image, this.licenses, this.sources, this.additionalProperties);
    }

    public String toString() {
        return new StringJoiner(", ", DataPackageMetadata.class.getSimpleName() + "[", "]").add("profile='" + this.profile + "'").add("name='" + this.name + "'").add("id='" + this.id + "'").add("title='" + this.title + "'").add("description='" + this.description + "'").add("homepage=" + String.valueOf(this.homepage)).add("version=" + this.version).add("created=" + String.valueOf(this.created)).add("contributors=" + String.valueOf(this.contributors)).add("keywords=" + String.valueOf(this.keywords)).add("image='" + this.image + "'").add("licenses=" + String.valueOf(this.licenses)).add("sources=" + String.valueOf(this.sources)).add("additionalProperties=" + String.valueOf(this.additionalProperties)).toString();
    }
}

