/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.model.converter;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.gbif.ipt.model.Password;
import org.gbif.ipt.utils.PBEEncrypt;

public class PasswordEncrypter
implements Converter {
    private static final Logger LOG = LogManager.getLogger(PasswordEncrypter.class);
    private final PBEEncrypt encrypter;

    public PasswordEncrypter(PBEEncrypt cipher) {
        this.encrypter = cipher;
    }

    public boolean canConvert(Class clazz) {
        return clazz.equals(Password.class);
    }

    public void marshal(Object value, HierarchicalStreamWriter writer, MarshallingContext context) {
        Password pass = (Password)value;
        try {
            if (pass.password != null) {
                writer.setValue(this.encrypter.encrypt(pass.password));
            }
        }
        catch (PBEEncrypt.EncryptionException e) {
            LOG.error("Cannot encrypt password", (Throwable)e);
        }
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        Password pass = new Password();
        String val = reader.getValue();
        try {
            pass.password = val == null ? null : this.encrypter.decrypt(val);
        }
        catch (PBEEncrypt.EncryptionException e) {
            LOG.error("Cannot decrypt password", (Throwable)e);
        }
        return pass;
    }
}

