/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.model.converter;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import org.gbif.ipt.config.JdbcSupport;

public class JdbcInfoConverter
implements Converter {
    private final JdbcSupport jdbcs;

    public JdbcInfoConverter(JdbcSupport jdbcs) {
        this.jdbcs = jdbcs;
    }

    public boolean canConvert(Class clazz) {
        return clazz.equals(JdbcSupport.JdbcInfo.class);
    }

    public void marshal(Object value, HierarchicalStreamWriter writer, MarshallingContext context) {
        JdbcSupport.JdbcInfo info = (JdbcSupport.JdbcInfo)value;
        writer.setValue(info.getName());
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        return this.jdbcs.get(reader.getValue());
    }
}

