/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.model.converter;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.gbif.ipt.model.DataPackageField;
import org.gbif.ipt.model.DataPackageSchema;
import org.gbif.ipt.model.DataPackageTableSchema;
import org.gbif.ipt.model.converter.DataPackageIdentifierConverter;
import org.gbif.ipt.model.converter.TableSchemaNameConverter;

public class DataPackageFieldConverter
implements Converter {
    private static final Logger LOG = LogManager.getLogger(DataPackageFieldConverter.class);
    private final DataPackageIdentifierConverter schemaConverter;
    private final TableSchemaNameConverter schemaNameConverter;

    public DataPackageFieldConverter(DataPackageIdentifierConverter schemaConverter, TableSchemaNameConverter schemaNameConverter) {
        this.schemaConverter = schemaConverter;
        this.schemaNameConverter = schemaNameConverter;
    }

    public boolean canConvert(Class clazz) {
        return DataPackageField.class.isAssignableFrom(clazz);
    }

    public void marshal(Object value, HierarchicalStreamWriter writer, MarshallingContext context) {
        DataPackageField field = (DataPackageField)value;
        writer.setValue(field.getName());
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        DataPackageSchema schema = this.schemaConverter.getLastDataPackageConverted();
        String tableSchemaName = this.schemaNameConverter.getLastTableSchemaConverted();
        DataPackageField field = null;
        if (schema != null) {
            DataPackageTableSchema tableSchema = null;
            for (DataPackageTableSchema dss : schema.getTableSchemas()) {
                if (!dss.getName().equals(tableSchemaName)) continue;
                tableSchema = dss;
                break;
            }
            if (tableSchema != null) {
                for (DataPackageField dsf : tableSchema.getFields()) {
                    if (!dsf.getName().equals(reader.getValue())) continue;
                    field = dsf;
                }
            }
        }
        if (field == null) {
            LOG.warn("Cant unmarshall field " + reader.getValue());
        }
        return field;
    }
}

