/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.model;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.gbif.ipt.model.Vocabulary;
import org.gbif.ipt.model.VocabularyTerm;

public class VocabularyConcept
implements Comparable,
Serializable {
    private static final long serialVersionUID = 900099923L;
    private Vocabulary vocabulary;
    private String identifier;
    private String description;
    private String uri;
    private URL link;
    private int order = -1;
    private Set<VocabularyTerm> alternativeTerms = new HashSet();
    private Set<VocabularyTerm> preferredTerms = new HashSet();

    public void addAlternativeTerm(VocabularyTerm term) {
        this.alternativeTerms.add(term);
    }

    public void addPreferredTerm(VocabularyTerm term) {
        this.preferredTerms.add(term);
    }

    public int compareTo(Object object) {
        VocabularyConcept myClass = (VocabularyConcept)object;
        return new CompareToBuilder().append((Object)this.vocabulary, (Object)myClass.vocabulary).append(this.order, myClass.order).append((Object)this.uri, (Object)myClass.uri).toComparison();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof VocabularyConcept)) {
            return false;
        }
        VocabularyConcept o = (VocabularyConcept)other;
        return Objects.equals(this.vocabulary, o.vocabulary) && Objects.equals(this.identifier, o.identifier) && Objects.equals(this.uri, o.uri);
    }

    public Set<VocabularyTerm> getAlternativeTerms() {
        return this.alternativeTerms;
    }

    public String getDescription() {
        return this.description;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public URL getLink() {
        return this.link;
    }

    public int getOrder() {
        return this.order;
    }

    public VocabularyTerm getPreferredTerm(String lang) {
        if (lang == null || lang.length() != 2) {
            throw new IllegalArgumentException("lang argument needs to be a 2 letter language code");
        }
        VocabularyTerm tEN = null;
        for (VocabularyTerm t : this.preferredTerms) {
            if (t.getLang().equalsIgnoreCase(lang)) {
                return t;
            }
            if (!t.getLang().equalsIgnoreCase("en")) continue;
            tEN = t;
        }
        return tEN;
    }

    public Set<VocabularyTerm> getPreferredTerms() {
        return this.preferredTerms;
    }

    public Set<VocabularyTerm> getTerms() {
        HashSet<VocabularyTerm> t = new HashSet<VocabularyTerm>(this.preferredTerms);
        t.addAll(this.alternativeTerms);
        return t;
    }

    public String getUri() {
        return this.uri;
    }

    public Vocabulary getVocabulary() {
        return this.vocabulary;
    }

    public int hashCode() {
        return Objects.hash(this.vocabulary, this.identifier, this.uri);
    }

    public void setAlternativeTerms(Set<VocabularyTerm> alternativeTerms) {
        this.alternativeTerms = alternativeTerms;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public void setLink(String link) {
        try {
            this.link = new URL(link);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    public void setLink(URL link) {
        this.link = link;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public void setPreferredTerms(Set<VocabularyTerm> preferredTerms) {
        this.preferredTerms = preferredTerms;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public void setVocabulary(Vocabulary vocabulary) {
        this.vocabulary = vocabulary;
    }

    public String toString() {
        return this.identifier;
    }
}

