/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.model;

import com.google.gson.annotations.SerializedName;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.gbif.ipt.model.VocabularyConcept;
import org.gbif.ipt.model.VocabularyTerm;
import org.gbif.metadata.eml.ipt.util.DateUtils;
import org.jetbrains.annotations.NotNull;

public class Vocabulary
implements Comparable<Object>,
Serializable {
    private static final long serialVersionUID = 22000013267L;
    @SerializedName(value="identifier")
    private String uriString;
    @SerializedName(value="url")
    private URI uriResolvable;
    private String title;
    private String description;
    private String subject;
    private boolean isLatest;
    private Date issued;
    private URL link;
    private List<VocabularyConcept> concepts = new ArrayList();
    private Date modified = new Date();

    public void addConcept(VocabularyConcept concept) {
        if (this.concepts == null) {
            this.concepts = new ArrayList();
        }
        concept.setVocabulary(this);
        if (concept.getOrder() == -1) {
            int maxOrder = 0;
            for (VocabularyConcept tc : this.concepts) {
                if (tc.getOrder() < 0 || maxOrder >= tc.getOrder()) continue;
                maxOrder = tc.getOrder();
            }
            concept.setOrder(maxOrder + 1);
        }
        this.concepts.add(concept);
    }

    @Override
    public int compareTo(@NotNull Object object) {
        Vocabulary myClass = (Vocabulary)object;
        return new CompareToBuilder().append((Object)this.uriString, (Object)myClass.uriString).toComparison();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Vocabulary)) {
            return false;
        }
        Vocabulary o = (Vocabulary)other;
        return Objects.equals(this.uriString, o.uriString);
    }

    public VocabularyConcept findConcept(String term) {
        for (VocabularyConcept c : this.concepts) {
            if (!c.getIdentifier().equalsIgnoreCase(term)) continue;
            return c;
        }
        for (VocabularyConcept c : this.concepts) {
            for (VocabularyTerm t : c.getPreferredTerms()) {
                if (!t.getTitle().equalsIgnoreCase(term)) continue;
                return c;
            }
        }
        for (VocabularyConcept c : this.concepts) {
            for (VocabularyTerm t : c.getAlternativeTerms()) {
                if (!t.getTitle().equalsIgnoreCase(term)) continue;
                return c;
            }
        }
        return null;
    }

    public List<VocabularyConcept> getConcepts() {
        return this.concepts;
    }

    public String getDescription() {
        return this.description;
    }

    public URL getLink() {
        return this.link;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getTitle() {
        return this.title;
    }

    public Date getModified() {
        return this.modified;
    }

    public int hashCode() {
        return Objects.hashCode(this.uriString);
    }

    public void setConcepts(List<VocabularyConcept> concepts) {
        this.concepts = concepts;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setLink(String link) {
        try {
            this.link = new URL(link);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    public void setLink(URL link) {
        this.link = link;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setModified(Date modified) {
        this.modified = modified;
    }

    public String getUriString() {
        return this.uriString;
    }

    public void setUriString(String uriString) {
        this.uriString = uriString;
    }

    public URI getUriResolvable() {
        return this.uriResolvable;
    }

    public void setUriResolvable(URI uriResolvable) {
        this.uriResolvable = uriResolvable;
    }

    public boolean isLatest() {
        return this.isLatest;
    }

    public void setLatest(boolean isLatest) {
        this.isLatest = isLatest;
    }

    public Date getIssued() {
        return this.issued;
    }

    public void setIssued(Date issued) {
        this.issued = issued;
    }

    public void setIssuedDateAsString(String dateString) throws ParseException {
        this.issued = DateUtils.calendarDate((String)dateString);
    }

    public String toString() {
        return "Vocabulary{uriString='" + this.uriString + "', uriResolvable=" + String.valueOf(this.uriResolvable) + ", title='" + this.title + "', description='" + this.description + "', subject='" + this.subject + "', isLatest=" + this.isLatest + ", issued=" + String.valueOf(this.issued) + ", link=" + String.valueOf(this.link) + ", concepts=" + String.valueOf(this.concepts) + ", modified=" + String.valueOf(this.modified) + "}";
    }
}

