/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.model;

import java.util.Date;
import org.gbif.ipt.config.JdbcSupport;
import org.gbif.ipt.model.Password;
import org.gbif.ipt.model.SourceBase;
import org.gbif.ipt.model.SourceType;

public class SqlSource
extends SourceBase {
    private String sql;
    private JdbcSupport.JdbcInfo rdbms;
    private String host;
    private String database;
    private String username;
    private Date lastModified;
    private Password password = new Password();

    public String getDatabase() {
        return this.database;
    }

    public String getHost() {
        return this.host;
    }

    public String getJdbcDriver() {
        return this.rdbms.getDriver();
    }

    public String getJdbcUrl() {
        return this.rdbms.getJdbcUrl(this);
    }

    public String getPassword() {
        return this.password.password;
    }

    public JdbcSupport.JdbcInfo getRdbms() {
        return this.rdbms;
    }

    public String getSql() {
        return this.sql;
    }

    public String getSqlLimited(int limit) {
        return this.rdbms.addLimit(this.sql, limit);
    }

    public String getUsername() {
        return this.username;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPassword(String password) {
        this.password.password = password;
    }

    public void setRdbms(JdbcSupport.JdbcInfo rdbms) {
        this.rdbms = rdbms;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public SourceType getSourceType() {
        return SourceType.SQL;
    }

    public Date getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(Date lastModified) {
        this.lastModified = lastModified;
    }
}

