/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.model;

import java.util.Objects;
import java.util.Properties;
import java.util.StringJoiner;

public class IptColorScheme {
    public static final String PRIMARY_COLOR_PROPERTY = "primaryColor";
    public static final String PRIMARY_COLOR_DEFAULT_VALUE = "#61a861";
    public static final String NAVBAR_COLOR_PROPERTY = "navbarColor";
    public static final String NAVBAR_COLOR_DEFAULT_VALUE = "#78b578";
    public static final String NAVBAR_LINK_COLOR_PROPERTY = "navbarLinkColor";
    public static final String NAVBAR_LINK_COLOR_DEFAULT_VALUE = "#ffffff";
    public static final String NAVBAR_GBIF_LOGO_COLOR_PROPERTY = "navbarGbifLogoColor";
    public static final String NAVBAR_GBIF_LOGO_COLOR_DEFAULT_VALUE = "#ffffff";
    public static final String NAVBAR_ACTIVE_TAB_COLOR_PROPERTY = "navbarActiveTabColor";
    public static final String NAVBAR_ACTIVE_TAB_COLOR_DEFAULT_VALUE = "#ffffff";
    public static final String LINK_COLOR_PROPERTY = "linkColor";
    public static final String LINK_COLOR_DEFAULT_VALUE = "#4ba2ce";
    private String primaryColor = "#61a861";
    private String navbarColor = "#78b578";
    private String navbarLinkColor = "#ffffff";
    private String navbarGbifLogoColor = "#ffffff";
    private String navbarActiveTabColor = "#ffffff";
    private String linkColor = "#4ba2ce";

    public IptColorScheme() {
    }

    public IptColorScheme(Properties props) {
        this.setPrimaryColor(props.getProperty(PRIMARY_COLOR_PROPERTY));
        this.setNavbarColor(props.getProperty(NAVBAR_COLOR_PROPERTY));
        this.setNavbarLinkColor(props.getProperty(NAVBAR_LINK_COLOR_PROPERTY));
        this.setNavbarGbifLogoColor(props.getProperty(NAVBAR_GBIF_LOGO_COLOR_PROPERTY, "#ffffff"));
        this.setNavbarActiveTabColor(props.getProperty(NAVBAR_ACTIVE_TAB_COLOR_PROPERTY, "#ffffff"));
        this.setLinkColor(props.getProperty(LINK_COLOR_PROPERTY));
    }

    public Properties toProperties() {
        Properties props = new Properties();
        props.setProperty(PRIMARY_COLOR_PROPERTY, this.primaryColor);
        props.setProperty(NAVBAR_COLOR_PROPERTY, this.navbarColor);
        props.setProperty(NAVBAR_LINK_COLOR_PROPERTY, this.navbarLinkColor);
        props.setProperty(NAVBAR_GBIF_LOGO_COLOR_PROPERTY, this.navbarGbifLogoColor);
        props.setProperty(NAVBAR_ACTIVE_TAB_COLOR_PROPERTY, this.navbarActiveTabColor);
        props.setProperty(LINK_COLOR_PROPERTY, this.linkColor);
        return props;
    }

    public String getPrimaryColor() {
        return this.primaryColor;
    }

    public void setPrimaryColor(String primaryColor) {
        this.primaryColor = primaryColor;
    }

    public String getNavbarColor() {
        return this.navbarColor;
    }

    public void setNavbarColor(String navbarColor) {
        this.navbarColor = navbarColor;
    }

    public String getNavbarLinkColor() {
        return this.navbarLinkColor;
    }

    public void setNavbarLinkColor(String navbarLinkColor) {
        this.navbarLinkColor = navbarLinkColor;
    }

    public String getNavbarGbifLogoColor() {
        return this.navbarGbifLogoColor;
    }

    public void setNavbarGbifLogoColor(String navbarGbifLogoColor) {
        this.navbarGbifLogoColor = navbarGbifLogoColor;
    }

    public String getNavbarActiveTabColor() {
        return this.navbarActiveTabColor;
    }

    public void setNavbarActiveTabColor(String navbarActiveTabColor) {
        this.navbarActiveTabColor = navbarActiveTabColor;
    }

    public String getLinkColor() {
        return this.linkColor;
    }

    public void setLinkColor(String linkColor) {
        this.linkColor = linkColor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IptColorScheme that = (IptColorScheme)o;
        return Objects.equals(this.primaryColor, that.primaryColor) && Objects.equals(this.navbarColor, that.navbarColor) && Objects.equals(this.navbarLinkColor, that.navbarLinkColor) && Objects.equals(this.navbarGbifLogoColor, that.navbarGbifLogoColor) && Objects.equals(this.navbarActiveTabColor, that.navbarActiveTabColor) && Objects.equals(this.linkColor, that.linkColor);
    }

    public int hashCode() {
        return Objects.hash(this.primaryColor, this.navbarColor, this.navbarGbifLogoColor, this.navbarActiveTabColor, this.navbarLinkColor, this.linkColor);
    }

    public String toString() {
        return new StringJoiner(", ", IptColorScheme.class.getSimpleName() + "[", "]").add("primaryColor='" + this.primaryColor + "'").add("navbarColor='" + this.navbarColor + "'").add("navbarLinkColor='" + this.navbarLinkColor + "'").add("navbarGbifLogoColor='" + this.navbarGbifLogoColor + "'").add("navbarActiveTabColor='" + this.navbarActiveTabColor + "'").add("linkColor='" + this.linkColor + "'").toString();
    }
}

