/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.model;

import java.io.Serializable;
import java.util.Date;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.gbif.ipt.model.AgentBase;
import org.gbif.ipt.model.Password;

public class Ipt
extends AgentBase
implements Serializable {
    private static final long serialVersionUID = 78945123624747L;
    private UUID organisationKey;
    private String language;
    private String logoUrl;
    private Date created;
    private Password wsPassword = new Password();

    @Nullable
    public Date getCreated() {
        return this.created;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Nullable
    public String getLanguage() {
        return this.language;
    }

    @Nullable
    public String getLogoUrl() {
        return this.logoUrl;
    }

    @NotNull
    public UUID getOrganisationKey() {
        return this.organisationKey;
    }

    @Nullable
    public String getWsPassword() {
        if (this.wsPassword != null) {
            return this.wsPassword.password;
        }
        return null;
    }

    public void setCreated(@Nullable Date created) {
        this.created = created;
    }

    public void setDescription(@Nullable String description) {
        this.description = StringUtils.trimToNull((String)description);
    }

    public void setLanguage(@Nullable String language) {
        this.language = StringUtils.trimToNull((String)language);
    }

    public void setLogoUrl(@Nullable String logoUrl) {
        this.logoUrl = StringUtils.trimToNull((String)logoUrl);
    }

    public void setOrganisationKey(@NotNull String organisationKey) {
        this.organisationKey = UUID.fromString(organisationKey);
    }

    public void setWsPassword(@Nullable String wsPassword) {
        if (wsPassword == null) {
            this.wsPassword = new Password();
        }
        this.wsPassword.password = wsPassword;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

