/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.model;

import java.io.Serializable;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.gbif.dwc.ArchiveField;
import org.gbif.dwc.terms.Term;
import org.gbif.ipt.model.Extension;
import org.gbif.ipt.model.ExtensionPropertyTranslation;
import org.gbif.ipt.model.Vocabulary;

public class ExtensionProperty
implements Comparable<ExtensionProperty>,
Term,
Serializable {
    private static final long serialVersionUID = 698996553L;
    private Extension extension;
    private String name;
    private String namespace;
    private String qualname;
    private String group;
    private ArchiveField.DataType type = ArchiveField.DataType.string;
    private String link;
    private String examples;
    private String comments;
    private String label;
    private String description;
    private boolean required;
    private Vocabulary vocabulary;
    private Map<String, ExtensionPropertyTranslation> translations = new HashMap();

    public ExtensionProperty() {
    }

    public ExtensionProperty(String qualname) {
        this.setQualname(qualname);
    }

    @Override
    public int compareTo(ExtensionProperty prop) {
        int x;
        if (this.group != null && (x = this.group.compareTo(prop.group)) != 0) {
            return x;
        }
        return this.qualname.compareTo(prop.qualname);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ExtensionProperty)) {
            return false;
        }
        ExtensionProperty o = (ExtensionProperty)other;
        return Objects.equals(this.extension, o.extension) && Objects.equals(this.qualname, o.qualname);
    }

    public String getLabel() {
        return this.label;
    }

    public String getDescription() {
        return this.description;
    }

    public String getExamples() {
        return this.examples;
    }

    public String getComments() {
        return this.comments;
    }

    public Extension getExtension() {
        return this.extension;
    }

    public String getGroup() {
        return this.group;
    }

    public String getLink() {
        return this.link;
    }

    public String getName() {
        return this.name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getQualname() {
        return this.qualname;
    }

    public ArchiveField.DataType getType() {
        return this.type;
    }

    public Vocabulary getVocabulary() {
        return this.vocabulary;
    }

    public int hashCode() {
        return Objects.hash(this.extension, this.qualname);
    }

    public boolean hasTerms() {
        return this.vocabulary != null;
    }

    public boolean isRequired() {
        return this.required;
    }

    public String qualifiedName() {
        return this.qualname;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setExamples(String examples) {
        this.examples = examples;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public void setExtension(Extension extension) {
        this.extension = extension;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setQualname(String qualname) {
        this.qualname = qualname;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public void setRequired(String required) {
        if ("TRUE".equalsIgnoreCase(required) || "T".equalsIgnoreCase(required) || "1".equalsIgnoreCase(required)) {
            this.required = true;
        } else if ("FALSE".equalsIgnoreCase(required) || "F".equalsIgnoreCase(required) || "0".equalsIgnoreCase(required)) {
            this.required = false;
        }
    }

    public void setType(ArchiveField.DataType type) {
        this.type = type;
    }

    public void setType(String type) {
        this.type = ArchiveField.DataType.findByExtensionEnumTypeName((String)type);
        if (this.type == null) {
            this.type = ArchiveField.DataType.string;
        }
    }

    public void setVocabulary(Vocabulary vocabulary) {
        this.vocabulary = vocabulary;
    }

    public String simpleName() {
        return this.name;
    }

    public String toString() {
        return this.qualname;
    }

    public String prefix() {
        return "";
    }

    public URI namespace() {
        return URI.create(this.namespace);
    }

    public boolean isClass() {
        return false;
    }

    public Map<String, ExtensionPropertyTranslation> getTranslations() {
        return this.translations;
    }

    public void setTranslations(Map<String, ExtensionPropertyTranslation> translations) {
        this.translations = translations;
    }

    public void addTranslation(ExtensionPropertyTranslation translation) {
        if (StringUtils.isNotEmpty((CharSequence)translation.getLanguage())) {
            this.translations.put(translation.getLanguage(), translation);
        }
    }
}

