/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.model;

import com.github.pjfanning.xlsx.SharedStringsImplementationType;
import com.github.pjfanning.xlsx.StreamingReader;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.gbif.ipt.model.ExcelFileSource;
import org.gbif.ipt.model.FileSource;
import org.gbif.ipt.model.SourceBase;
import org.gbif.ipt.model.SourceType;
import org.gbif.ipt.utils.FileUtils;
import org.gbif.utils.file.ClosableReportingIterator;

public class ExcelFileSource
extends SourceBase
implements FileSource {
    private static final long serialVersionUID = 1457018220676830122L;
    private static final Logger LOG = LogManager.getLogger(ExcelFileSource.class);
    private static final String SUFFIX = ".xls";
    private int sheetIdx = 0;
    private int ignoreHeaderLines = 1;
    private File file;
    private long fileSize;
    private int rows;
    protected Date lastModified;

    public String formattedFileSize(String locale) {
        return FileUtils.formatSize((long)this.fileSize, (int)1, (String)locale, (boolean)false);
    }

    private Workbook openBook() {
        LOG.info("Opening excel workbook [" + this.file.getName() + "]");
        return StreamingReader.builder().rowCacheSize(100).bufferSize(4096).setSharedStringsImplementationType(SharedStringsImplementationType.TEMP_FILE_BACKED).setReadSharedFormulas(true).setEncryptSstTempFile(true).open(this.file);
    }

    private Sheet getSheet(Workbook book) {
        return book.getSheetAt(this.sheetIdx);
    }

    public ClosableReportingIterator<String[]> rowIterator() {
        try {
            return new RowIterator(this, this, this.ignoreHeaderLines);
        }
        catch (Exception e) {
            LOG.error("Exception while reading excel source " + this.name, (Throwable)e);
            return null;
        }
    }

    public Map<Integer, String> sheets() {
        HashMap<Integer, String> sheets = new HashMap<Integer, String>();
        try (Workbook book = this.openBook();){
            int cnt = book.getNumberOfSheets();
            for (int x = 0; x < cnt; ++x) {
                sheets.put(x, book.getSheetName(x));
            }
        }
        catch (Exception e) {
            LOG.error("Exception while reading excel source " + this.name, (Throwable)e);
        }
        return sheets;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<String> columns() {
        if (this.rows <= 0) return new ArrayList<String>();
        try (RowIterator iter = new RowIterator(this, this, this.ignoreHeaderLines - 1);){
            if (this.ignoreHeaderLines > 0) {
                ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(iter.next()));
                return arrayList;
            }
            ArrayList<String> columnList = new ArrayList<String>();
            for (int x = 1; x <= this.columns; ++x) {
                columnList.add("Column #" + x);
            }
            ArrayList<String> arrayList = columnList;
            return arrayList;
        }
        catch (Exception e) {
            LOG.error("Exception while reading excel source " + this.name, (Throwable)e);
        }
        return new ArrayList<String>();
    }

    public Set<Integer> analyze() throws IOException {
        this.setFileSize(this.getFile().length());
        try (Workbook book = this.openBook();){
            Sheet sheet = this.getSheet(book);
            int physicalNumberOfRows = 0;
            Iterator iter = sheet.rowIterator();
            if (iter.hasNext()) {
                ++physicalNumberOfRows;
                this.setColumns((int)((Row)iter.next()).getLastCellNum());
                this.setReadable(true);
            } else {
                this.setColumns(0);
                this.setReadable(false);
            }
            while (iter.hasNext()) {
                ++physicalNumberOfRows;
                iter.next();
            }
            this.setRows(physicalNumberOfRows);
        }
        return new HashSet<Integer>();
    }

    public SourceType getSourceType() {
        return SourceType.EXCEL_FILE;
    }

    public String getPreferredFileSuffix() {
        return SUFFIX;
    }

    public File getFile() {
        return this.file;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setLastModified(Date lastModified) {
        this.lastModified = lastModified;
    }

    public int getRows() {
        return this.rows;
    }

    public int getIgnoreHeaderLines() {
        return this.ignoreHeaderLines;
    }

    public Date getLastModified() {
        return this.lastModified;
    }

    public void setSheetIdx(int sheetIdx) {
        this.sheetIdx = sheetIdx;
    }

    public int getSheetIdx() {
        return this.sheetIdx;
    }

    public void setIgnoreHeaderLines(int ignoreHeaderLines) {
        this.ignoreHeaderLines = ignoreHeaderLines;
    }

    public void setFileSize(long fileSize) {
        this.fileSize = fileSize;
    }

    public void setRows(int rows) {
        this.rows = rows;
    }
}

