/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.gbif.ipt.model.DataPackageTableSchemaRequirement;

public class DataPackageTableSchemaRequirement {
    private String description;
    private List<String> applicableIfPresentAny = new ArrayList();
    private List<DataPackageTableSchemaRequirement> allOf = new ArrayList();
    private List<DataPackageTableSchemaRequirement> anyOf = new ArrayList();
    private List<DataPackageTableSchemaRequirement> oneOf = new ArrayList();
    private List<String> required = new ArrayList();
    private List<String> requiredAny = new ArrayList();
    private List<String> prohibited = new ArrayList();

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<String> getApplicableIfPresentAny() {
        return this.applicableIfPresentAny;
    }

    public void setApplicableIfPresentAny(List<String> applicableIfPresentAny) {
        this.applicableIfPresentAny = applicableIfPresentAny;
    }

    public List<DataPackageTableSchemaRequirement> getAllOf() {
        return this.allOf;
    }

    public void setAllOf(List<DataPackageTableSchemaRequirement> required) {
        this.allOf = required;
    }

    public List<DataPackageTableSchemaRequirement> getAnyOf() {
        return this.anyOf;
    }

    public void setAnyOf(List<DataPackageTableSchemaRequirement> anyOf) {
        this.anyOf = anyOf;
    }

    public List<DataPackageTableSchemaRequirement> getOneOf() {
        return this.oneOf;
    }

    public void setOneOf(List<DataPackageTableSchemaRequirement> oneOf) {
        this.oneOf = oneOf;
    }

    public List<String> getRequired() {
        return this.required;
    }

    public void setRequired(List<String> required) {
        this.required = required;
    }

    public List<String> getRequiredAny() {
        return this.requiredAny;
    }

    public void setRequiredAny(List<String> requiredAny) {
        this.requiredAny = requiredAny;
    }

    public List<String> getProhibited() {
        return this.prohibited;
    }

    public void setProhibited(List<String> prohibited) {
        this.prohibited = prohibited;
    }

    public ValidationResult validate(Set<String> schemas) {
        boolean allRequiredSchemasPresent;
        Iterator intersection;
        ValidationResult result = new ValidationResult();
        if (this.allOf.isEmpty() && this.anyOf.isEmpty() && this.oneOf.isEmpty() && this.required.isEmpty() && this.requiredAny.isEmpty() && this.prohibited.isEmpty()) {
            result.setValid(true);
            return result;
        }
        Collection applicableSchemas = CollectionUtils.intersection(schemas, (Iterable)this.applicableIfPresentAny);
        if (!this.applicableIfPresentAny.isEmpty() && applicableSchemas.isEmpty()) {
            return result;
        }
        if (!this.prohibited.isEmpty() && !(intersection = CollectionUtils.intersection(schemas, (Iterable)this.prohibited)).isEmpty()) {
            result.setValid(false);
            result.setReason(String.format("Prohibited schemas found: %s. The following schemas are prohibited: %s", intersection, this.prohibited));
            return result;
        }
        if (!this.required.isEmpty() && !(allRequiredSchemasPresent = CollectionUtils.containsAll(schemas, (Collection)this.required))) {
            result.setValid(false);
            result.setReason(String.format("All required schemas must be present: %s", this.required));
            return result;
        }
        if (!this.requiredAny.isEmpty() && (intersection = CollectionUtils.intersection(schemas, (Iterable)this.requiredAny)).size() == 0) {
            result.setValid(false);
            result.setReason(String.format("At least one of required schemas must be present: %s", this.requiredAny));
            return result;
        }
        if (!this.allOf.isEmpty()) {
            for (DataPackageTableSchemaRequirement subRequirement : this.allOf) {
                ValidationResult subResult = subRequirement.validate(schemas);
                if (subResult.isValid()) continue;
                result.setValid(false);
                result.setReason(subResult.getReason());
            }
        } else if (!this.anyOf.isEmpty()) {
            result.setValid(false);
            result.setReason(String.format("At least one valid required, none found: %s", this.anyOf));
            for (DataPackageTableSchemaRequirement subRequirement : this.anyOf) {
                ValidationResult subResult = subRequirement.validate(schemas);
                if (!subResult.isValid()) continue;
                result.setValid(true);
                result.setReason("");
                break;
            }
        } else if (!this.oneOf.isEmpty()) {
            int numberOfValid = 0;
            for (DataPackageTableSchemaRequirement subRequirement : this.oneOf) {
                ValidationResult subResult = subRequirement.validate(schemas);
                if (!subResult.isValid()) continue;
                ++numberOfValid;
                System.out.println("valid: " + subRequirement.description);
            }
            if (numberOfValid != 1) {
                result.setValid(false);
                result.setReason(String.format("Only one required: %s", this.oneOf));
            }
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataPackageTableSchemaRequirement that = (DataPackageTableSchemaRequirement)o;
        return Objects.equals(this.description, that.description) && Objects.equals(this.allOf, that.allOf) && Objects.equals(this.anyOf, that.anyOf) && Objects.equals(this.oneOf, that.oneOf) && Objects.equals(this.required, that.required) && Objects.equals(this.requiredAny, that.requiredAny) && Objects.equals(this.prohibited, that.prohibited);
    }

    public int hashCode() {
        return Objects.hash(this.description, this.allOf, this.anyOf, this.oneOf, this.required, this.requiredAny, this.prohibited);
    }

    public String toString() {
        StringJoiner sj = new StringJoiner(", ");
        if (StringUtils.isNotEmpty((CharSequence)this.description)) {
            sj.add("\"" + this.description + "\"");
        } else {
            if (!this.allOf.isEmpty()) {
                sj.add("allOf=" + String.valueOf(this.allOf));
            }
            if (!this.anyOf.isEmpty()) {
                sj.add("anyOf=" + String.valueOf(this.anyOf));
            }
            if (!this.oneOf.isEmpty()) {
                sj.add("oneOf=" + String.valueOf(this.oneOf));
            }
            if (!this.required.isEmpty()) {
                sj.add("required=" + String.valueOf(this.required));
            }
            if (!this.requiredAny.isEmpty()) {
                sj.add("requiredAny=" + String.valueOf(this.requiredAny));
            }
            if (!this.prohibited.isEmpty()) {
                sj.add("prohibited=" + String.valueOf(this.prohibited));
            }
        }
        return sj.toString();
    }
}

