/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.model;

import java.io.Serializable;
import java.net.URL;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gbif.ipt.model.DataPackageSchema;
import org.gbif.ipt.model.DataPackageTableSchema;
import org.gbif.ipt.model.DataPackageTableSchemaRequirement;

public class DataPackageSchema
implements Serializable {
    private static final long serialVersionUID = -3130006092545816514L;
    private String identifier;
    private String title;
    private String shortTitle;
    private String name;
    private String version;
    private URL url;
    private String profile;
    private Set<DataPackageTableSchema> tableSchemas = new LinkedHashSet();
    private DataPackageTableSchemaRequirement tableSchemasRequirements = new DataPackageTableSchemaRequirement();
    private String description;
    private boolean isLatest;
    public boolean isUpdatable;
    private Date issued;

    public DataPackageTableSchema tableSchemaByName(String tableSchemaName) {
        return this.tableSchemas.stream().filter(ds -> ds.getName().equals(tableSchemaName)).findFirst().orElse(null);
    }

    public void addTableSchema(DataPackageTableSchema tableSchema) {
        this.tableSchemas.add(tableSchema);
    }

    DataPackageSchema(String identifier, String title, String shortTitle, String name, String version, URL url, String profile, Set<DataPackageTableSchema> tableSchemas, DataPackageTableSchemaRequirement tableSchemasRequirements, String description, boolean isLatest, boolean isUpdatable, Date issued) {
        this.identifier = identifier;
        this.title = title;
        this.shortTitle = shortTitle;
        this.name = name;
        this.version = version;
        this.url = url;
        this.profile = profile;
        this.tableSchemas = tableSchemas;
        this.tableSchemasRequirements = tableSchemasRequirements;
        this.description = description;
        this.isLatest = isLatest;
        this.isUpdatable = isUpdatable;
        this.issued = issued;
    }

    public static DataPackageSchemaBuilder builder() {
        return new DataPackageSchemaBuilder();
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getTitle() {
        return this.title;
    }

    public String getShortTitle() {
        return this.shortTitle;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public URL getUrl() {
        return this.url;
    }

    public String getProfile() {
        return this.profile;
    }

    public Set<DataPackageTableSchema> getTableSchemas() {
        return this.tableSchemas;
    }

    public DataPackageTableSchemaRequirement getTableSchemasRequirements() {
        return this.tableSchemasRequirements;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isLatest() {
        return this.isLatest;
    }

    public boolean isUpdatable() {
        return this.isUpdatable;
    }

    public Date getIssued() {
        return this.issued;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setShortTitle(String shortTitle) {
        this.shortTitle = shortTitle;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setUrl(URL url) {
        this.url = url;
    }

    public void setProfile(String profile) {
        this.profile = profile;
    }

    public void setTableSchemas(Set<DataPackageTableSchema> tableSchemas) {
        this.tableSchemas = tableSchemas;
    }

    public void setTableSchemasRequirements(DataPackageTableSchemaRequirement tableSchemasRequirements) {
        this.tableSchemasRequirements = tableSchemasRequirements;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setLatest(boolean isLatest) {
        this.isLatest = isLatest;
    }

    public void setUpdatable(boolean isUpdatable) {
        this.isUpdatable = isUpdatable;
    }

    public void setIssued(Date issued) {
        this.issued = issued;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataPackageSchema)) {
            return false;
        }
        DataPackageSchema other = (DataPackageSchema)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isLatest() != other.isLatest()) {
            return false;
        }
        if (this.isUpdatable() != other.isUpdatable()) {
            return false;
        }
        String this$identifier = this.getIdentifier();
        String other$identifier = other.getIdentifier();
        if (this$identifier == null ? other$identifier != null : !this$identifier.equals(other$identifier)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$shortTitle = this.getShortTitle();
        String other$shortTitle = other.getShortTitle();
        if (this$shortTitle == null ? other$shortTitle != null : !this$shortTitle.equals(other$shortTitle)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        URL this$url = this.getUrl();
        URL other$url = other.getUrl();
        if (this$url == null ? other$url != null : !((Object)this$url).equals(other$url)) {
            return false;
        }
        String this$profile = this.getProfile();
        String other$profile = other.getProfile();
        if (this$profile == null ? other$profile != null : !this$profile.equals(other$profile)) {
            return false;
        }
        Set this$tableSchemas = this.getTableSchemas();
        Set other$tableSchemas = other.getTableSchemas();
        if (this$tableSchemas == null ? other$tableSchemas != null : !((Object)this$tableSchemas).equals(other$tableSchemas)) {
            return false;
        }
        DataPackageTableSchemaRequirement this$tableSchemasRequirements = this.getTableSchemasRequirements();
        DataPackageTableSchemaRequirement other$tableSchemasRequirements = other.getTableSchemasRequirements();
        if (this$tableSchemasRequirements == null ? other$tableSchemasRequirements != null : !this$tableSchemasRequirements.equals(other$tableSchemasRequirements)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Date this$issued = this.getIssued();
        Date other$issued = other.getIssued();
        return !(this$issued == null ? other$issued != null : !((Object)this$issued).equals(other$issued));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DataPackageSchema;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isLatest() ? 79 : 97);
        result = result * 59 + (this.isUpdatable() ? 79 : 97);
        String $identifier = this.getIdentifier();
        result = result * 59 + ($identifier == null ? 43 : $identifier.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $shortTitle = this.getShortTitle();
        result = result * 59 + ($shortTitle == null ? 43 : $shortTitle.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        URL $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : ((Object)$url).hashCode());
        String $profile = this.getProfile();
        result = result * 59 + ($profile == null ? 43 : $profile.hashCode());
        Set $tableSchemas = this.getTableSchemas();
        result = result * 59 + ($tableSchemas == null ? 43 : ((Object)$tableSchemas).hashCode());
        DataPackageTableSchemaRequirement $tableSchemasRequirements = this.getTableSchemasRequirements();
        result = result * 59 + ($tableSchemasRequirements == null ? 43 : $tableSchemasRequirements.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Date $issued = this.getIssued();
        result = result * 59 + ($issued == null ? 43 : ((Object)$issued).hashCode());
        return result;
    }

    public String toString() {
        return "DataPackageSchema(identifier=" + this.getIdentifier() + ", title=" + this.getTitle() + ", shortTitle=" + this.getShortTitle() + ", name=" + this.getName() + ", version=" + this.getVersion() + ", url=" + String.valueOf(this.getUrl()) + ", profile=" + this.getProfile() + ", tableSchemas=" + String.valueOf(this.getTableSchemas()) + ", tableSchemasRequirements=" + String.valueOf(this.getTableSchemasRequirements()) + ", description=" + this.getDescription() + ", isLatest=" + this.isLatest() + ", isUpdatable=" + this.isUpdatable() + ", issued=" + String.valueOf(this.getIssued()) + ")";
    }
}

