/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.gbif.ipt.model.DataPackageFieldMapping;
import org.gbif.ipt.model.DataPackageMapping;
import org.gbif.ipt.model.DataPackageSchema;
import org.gbif.ipt.model.DataPackageTableSchemaName;
import org.gbif.ipt.model.RecordFilter;
import org.gbif.ipt.model.Source;

public class DataPackageMapping
implements Serializable {
    private static final long serialVersionUID = -8441887797416795559L;
    private Source source;
    private DataPackageSchema dataPackageSchema;
    private DataPackageTableSchemaName dataPackageTableSchemaName;
    private List<DataPackageFieldMapping> fields = new ArrayList();
    private int fieldsMapped;
    private RecordFilter filter;
    private Date lastModified;

    public List<String> getColumns(List<String[]> peek) {
        if (!peek.isEmpty()) {
            int columnsCount = peek.get(0).length;
            ArrayList<String> columns = new ArrayList<String>(columnsCount);
            for (int count = 0; count < columnsCount; ++count) {
                String value = null;
                for (String[] row : peek) {
                    if (row[count] == null || row[count].length() == 0) continue;
                    value = row[count].length() > 10 ? row[count].substring(0, 10) + "..." : row[count];
                    break;
                }
                if (value == null) {
                    columns.add("Column #" + (count + 1));
                    continue;
                }
                columns.add("Column #" + (count + 1) + " - " + value);
            }
            return columns;
        }
        return new ArrayList<String>();
    }

    public DataPackageFieldMapping getField(String name) {
        if (this.fields != null) {
            for (DataPackageFieldMapping dsfm : this.fields) {
                if (!dsfm.getField().getName().equals(name)) continue;
                return dsfm;
            }
        }
        return null;
    }

    public static DataPackageMappingBuilder builder() {
        return new DataPackageMappingBuilder();
    }

    public Source getSource() {
        return this.source;
    }

    public DataPackageSchema getDataPackageSchema() {
        return this.dataPackageSchema;
    }

    public DataPackageTableSchemaName getDataPackageTableSchemaName() {
        return this.dataPackageTableSchemaName;
    }

    public List<DataPackageFieldMapping> getFields() {
        return this.fields;
    }

    public int getFieldsMapped() {
        return this.fieldsMapped;
    }

    public RecordFilter getFilter() {
        return this.filter;
    }

    public Date getLastModified() {
        return this.lastModified;
    }

    public void setSource(Source source) {
        this.source = source;
    }

    public void setDataPackageSchema(DataPackageSchema dataPackageSchema) {
        this.dataPackageSchema = dataPackageSchema;
    }

    public void setDataPackageTableSchemaName(DataPackageTableSchemaName dataPackageTableSchemaName) {
        this.dataPackageTableSchemaName = dataPackageTableSchemaName;
    }

    public void setFields(List<DataPackageFieldMapping> fields) {
        this.fields = fields;
    }

    public void setFieldsMapped(int fieldsMapped) {
        this.fieldsMapped = fieldsMapped;
    }

    public void setFilter(RecordFilter filter) {
        this.filter = filter;
    }

    public void setLastModified(Date lastModified) {
        this.lastModified = lastModified;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataPackageMapping)) {
            return false;
        }
        DataPackageMapping other = (DataPackageMapping)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getFieldsMapped() != other.getFieldsMapped()) {
            return false;
        }
        Source this$source = this.getSource();
        Source other$source = other.getSource();
        if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
            return false;
        }
        DataPackageSchema this$dataPackageSchema = this.getDataPackageSchema();
        DataPackageSchema other$dataPackageSchema = other.getDataPackageSchema();
        if (this$dataPackageSchema == null ? other$dataPackageSchema != null : !this$dataPackageSchema.equals(other$dataPackageSchema)) {
            return false;
        }
        DataPackageTableSchemaName this$dataPackageTableSchemaName = this.getDataPackageTableSchemaName();
        DataPackageTableSchemaName other$dataPackageTableSchemaName = other.getDataPackageTableSchemaName();
        if (this$dataPackageTableSchemaName == null ? other$dataPackageTableSchemaName != null : !this$dataPackageTableSchemaName.equals(other$dataPackageTableSchemaName)) {
            return false;
        }
        List this$fields = this.getFields();
        List other$fields = other.getFields();
        if (this$fields == null ? other$fields != null : !((Object)this$fields).equals(other$fields)) {
            return false;
        }
        RecordFilter this$filter = this.getFilter();
        RecordFilter other$filter = other.getFilter();
        if (this$filter == null ? other$filter != null : !this$filter.equals(other$filter)) {
            return false;
        }
        Date this$lastModified = this.getLastModified();
        Date other$lastModified = other.getLastModified();
        return !(this$lastModified == null ? other$lastModified != null : !((Object)this$lastModified).equals(other$lastModified));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DataPackageMapping;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getFieldsMapped();
        Source $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : $source.hashCode());
        DataPackageSchema $dataPackageSchema = this.getDataPackageSchema();
        result = result * 59 + ($dataPackageSchema == null ? 43 : $dataPackageSchema.hashCode());
        DataPackageTableSchemaName $dataPackageTableSchemaName = this.getDataPackageTableSchemaName();
        result = result * 59 + ($dataPackageTableSchemaName == null ? 43 : $dataPackageTableSchemaName.hashCode());
        List $fields = this.getFields();
        result = result * 59 + ($fields == null ? 43 : ((Object)$fields).hashCode());
        RecordFilter $filter = this.getFilter();
        result = result * 59 + ($filter == null ? 43 : $filter.hashCode());
        Date $lastModified = this.getLastModified();
        result = result * 59 + ($lastModified == null ? 43 : ((Object)$lastModified).hashCode());
        return result;
    }

    public String toString() {
        return "DataPackageMapping(source=" + String.valueOf(this.getSource()) + ", dataPackageSchema=" + String.valueOf(this.getDataPackageSchema()) + ", dataPackageTableSchemaName=" + String.valueOf(this.getDataPackageTableSchemaName()) + ", fields=" + String.valueOf(this.getFields()) + ", fieldsMapped=" + this.getFieldsMapped() + ", filter=" + String.valueOf(this.getFilter()) + ", lastModified=" + String.valueOf(this.getLastModified()) + ")";
    }

    public DataPackageMapping() {
    }

    public DataPackageMapping(Source source, DataPackageSchema dataPackageSchema, DataPackageTableSchemaName dataPackageTableSchemaName, List<DataPackageFieldMapping> fields, int fieldsMapped, RecordFilter filter, Date lastModified) {
        this.source = source;
        this.dataPackageSchema = dataPackageSchema;
        this.dataPackageTableSchemaName = dataPackageTableSchemaName;
        this.fields = fields;
        this.fieldsMapped = fieldsMapped;
        this.filter = filter;
        this.lastModified = lastModified;
    }
}

