/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.config;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.gbif.ipt.action.BaseAction;
import org.gbif.ipt.config.AppConfig;
import org.gbif.ipt.config.Constants;
import org.gbif.ipt.config.DataDir;
import org.gbif.ipt.model.Organisation;
import org.gbif.ipt.model.User;
import org.gbif.ipt.service.AlreadyExistingException;
import org.gbif.ipt.service.InvalidConfigException;
import org.gbif.ipt.service.RegistryException;
import org.gbif.ipt.service.admin.ConfigManager;
import org.gbif.ipt.service.admin.DataPackageSchemaManager;
import org.gbif.ipt.service.admin.ExtensionManager;
import org.gbif.ipt.service.admin.RegistrationManager;
import org.gbif.ipt.service.admin.UserAccountManager;
import org.gbif.ipt.struts2.SimpleTextProvider;
import org.gbif.ipt.utils.URLUtils;
import org.gbif.ipt.validation.UserValidator;
import org.gbif.utils.HttpClient;

public class SetupAction
extends BaseAction {
    private static final Logger LOG = LogManager.getLogger(SetupAction.class);
    private static final long serialVersionUID = 4726973323043063968L;
    private final ConfigManager configManager;
    private final AppConfig cfg;
    private final UserAccountManager userManager;
    private final DataDir dataDir;
    private final ExtensionManager extensionManager;
    private final DataPackageSchemaManager schemaManager;
    private final HttpClient client;
    private final UserValidator userValidation = new UserValidator();
    protected String dataDirPath;
    protected User user = new User();
    private String password2;
    protected String modeSelected;
    protected String baseURL;
    protected String proxy;
    protected Integer ignoreUserValidation = 0;
    private boolean setupDefaultAdministrator = false;
    private boolean setupPublicUrl = false;
    private static final String MODE_DEVELOPMENT = "Test";
    private static final String MODE_PRODUCTION = "Production";
    private static final List<String> MODES = Arrays.asList("Test", "Production");

    @Inject
    public SetupAction(SimpleTextProvider textProvider, AppConfig cfg, RegistrationManager regManager, ConfigManager configManager, UserAccountManager userManager, DataDir dataDir, ExtensionManager extensionManager, DataPackageSchemaManager schemaManager, HttpClient client) {
        super(textProvider, cfg, regManager);
        this.cfg = cfg;
        this.configManager = configManager;
        this.userManager = userManager;
        this.dataDir = dataDir;
        this.extensionManager = extensionManager;
        this.schemaManager = schemaManager;
        this.client = client;
    }

    public List<String> getModes() {
        return MODES;
    }

    public String continueHome() {
        return "success";
    }

    public String getBaseURL() {
        if (StringUtils.isBlank((CharSequence)this.baseURL)) {
            if (StringUtils.trimToNull((String)this.cfg.getBaseUrl()) == null) {
                Enumeration headerNames = this.req.getHeaderNames();
                if (headerNames != null) {
                    LOG.debug("Dumping request headers used to detect initial baseURL");
                    while (headerNames.hasMoreElements()) {
                        String header = (String)headerNames.nextElement();
                        LOG.debug("\u00bb {}: {}", (Object)header, (Object)this.req.getHeader(header));
                    }
                }
                this.baseURL = this.req.getRequestURL().toString().replaceAll(this.req.getServletPath(), "");
                if ("https".equalsIgnoreCase(this.req.getHeader("X-Forwarded-Proto"))) {
                    this.baseURL = this.baseURL.replaceFirst("^http://", "https://");
                }
                LOG.info("Auto-Detected IPT BaseURL=" + this.baseURL);
            } else {
                this.baseURL = this.cfg.getBaseUrl();
            }
        }
        return this.baseURL;
    }

    public String getDataDirPath() {
        return this.dataDirPath;
    }

    public Integer getIgnoreUserValidation() {
        return this.ignoreUserValidation;
    }

    public String getPassword2() {
        return this.password2;
    }

    public String getProxy() {
        return this.proxy;
    }

    public User getUser() {
        return this.user;
    }

    public boolean isProductionSettingAllowed() {
        return !this.cfg.debug();
    }

    public void setBaseURL(String baseUrlVerbatim) {
        this.baseURL = baseUrlVerbatim;
    }

    public void setDataDirPath(String dataDirPath) {
        this.dataDirPath = dataDirPath;
    }

    public void setIgnoreUserValidation(Integer ignoreUserValidation) {
        this.ignoreUserValidation = ignoreUserValidation;
    }

    public void setPassword2(String password2) {
        this.password2 = password2;
    }

    public void setProxy(String proxy) {
        this.proxy = proxy;
    }

    public void setSetupDefaultAdministrator(boolean setupDefaultAdministrator) {
        this.setupDefaultAdministrator = setupDefaultAdministrator;
    }

    public void setSetupPublicUrl(boolean setupPublicUrl) {
        this.setupPublicUrl = setupPublicUrl;
    }

    public String setupDataDirectory() {
        if (this.dataDir.dataDir != null && (!this.dataDir.dataDir.exists() || this.dataDir.isConfiguredButEmpty()) || this.isHttpPost() && this.dataDirPath != null) {
            LOG.info("Set up data directory {}", (Object)this.dataDir.dataDir);
            File dd = this.dataDirPath != null ? new File(this.dataDirPath.trim()) : this.dataDir.dataDir;
            try {
                if (StringUtils.isEmpty((CharSequence)this.dataDirPath) && this.dataDir.dataDir == null) {
                    this.addFieldError("dataDirPath", this.getText("validation.required", new String[]{this.getText("admin.config.setup.datadir")}));
                } else if (dd.isAbsolute()) {
                    boolean created = this.configManager.setDataDir(dd);
                    if (created) {
                        this.addActionMessage(this.getText("admin.config.setup.datadir.created"));
                    } else {
                        this.addActionMessage(this.getText("admin.config.setup.datadir.reused"));
                    }
                } else {
                    this.addFieldError("dataDirPath", this.getText("admin.config.setup.datadir.absolute"));
                }
            }
            catch (InvalidConfigException e) {
                LOG.warn("Failed to setup datadir: " + e.getMessage(), (Throwable)e);
                if (e.getType() == InvalidConfigException.TYPE.NON_WRITABLE_DATA_DIR) {
                    this.addActionError(this.getText("admin.config.setup.datadir.writable", new String[]{this.dataDirPath}));
                } else {
                    this.addActionError(this.getText("admin.config.setup.datadir.error"));
                }
            }
            catch (RegistryException e) {
                String msg = RegistryException.logRegistryException((RegistryException)e, (BaseAction)this);
                LOG.warn("Failed to contact the GBIF Registry (" + msg + "): " + e.getMessage(), (Throwable)e);
                this.addActionError(msg);
            }
        }
        if (this.dataDir.isConfigured()) {
            LOG.info("Skipping setup data directory step");
            return "success";
        }
        return "input";
    }

    public String setupDefaultAdministrator() {
        if (this.configManager.setupComplete() && this.configManager.isBaseURLValid()) {
            this.addActionMessage(this.getText("admin.config.setup2.existingFound"));
            return "success";
        }
        if (!this.dataDir.isConfigured()) {
            this.addActionWarning(this.getText("admin.config.setup2.datadir.notExist"));
            return "error";
        }
        List admins = this.userManager.list(User.Role.Admin);
        if (!this.isHttpPost() && admins != null && !admins.isEmpty()) {
            return "success";
        }
        if (this.isHttpPost()) {
            this.user.setRole(User.Role.Admin);
            try {
                if (this.ignoreUserValidation == 0) {
                    this.userManager.create(this.user);
                    this.user.setLastLoginToNow();
                    this.userManager.save();
                    this.userManager.setSetupUser(this.user);
                    this.session.put("curr_user", this.user);
                    return "success";
                }
            }
            catch (IOException e) {
                LOG.error((Object)e);
                this.addActionError(this.getText("admin.config.setup2.failed", new String[]{e.getMessage()}));
            }
            catch (AlreadyExistingException e) {
                this.addFieldError("user.email", this.getText("admin.config.setup2.nonadmin"));
            }
        }
        return "input";
    }

    public String setupMode() {
        if (this.configManager.setupComplete() && this.configManager.isBaseURLValid()) {
            return "success";
        }
        List admins = this.userManager.list(User.Role.Admin);
        if (!this.isHttpPost() && admins.isEmpty()) {
            return "error";
        }
        if (this.isHttpPost()) {
            if (this.getModeSelected() == null) {
                this.addFieldError("modeSelected", this.getText("admin.config.setup2.nomode"));
                return "input";
            }
            if (this.getModeSelected().equalsIgnoreCase(MODE_PRODUCTION) && !this.cfg.devMode()) {
                this.cfg.setRegistryType(AppConfig.REGISTRY_TYPE.PRODUCTION);
                LOG.info("Production mode has been selected");
            } else {
                this.cfg.setRegistryType(AppConfig.REGISTRY_TYPE.DEVELOPMENT);
                LOG.info("Test mode has been selected");
            }
            return "success";
        }
        return "input";
    }

    public String setupPublicUrl() {
        if (this.configManager.setupComplete()) {
            if (this.configManager.isBaseURLValid()) {
                return "success";
            }
        } else {
            return "error";
        }
        AppConfig.REGISTRY_TYPE registryType = this.cfg.getRegistryType();
        if (registryType == null) {
            return "error";
        }
        if (this.isHttpPost()) {
            try {
                URL burl = null;
                if (this.ignoreUserValidation == 0) {
                    try {
                        burl = new URL(this.baseURL);
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                    if (registryType.name().equalsIgnoreCase(MODE_PRODUCTION) && !this.cfg.devMode()) {
                        if (URLUtils.isLocalhost((URL)burl)) {
                            this.addFieldError("baseURL", this.getText("admin.config.baseUrl.invalidBaseURL"));
                            this.baseURL = this.req.getRequestURL().toString().replaceAll(this.req.getServletPath(), "");
                            return "input";
                        }
                        if (URLUtils.isHostName((URL)burl)) {
                            LOG.info("Machine name used in base URL");
                            this.addActionWarning(this.getText("admin.config.baseUrl.sameHostName"));
                        }
                    }
                }
                this.configManager.setBaseUrl(burl);
                try {
                    this.configManager.setProxy(this.proxy);
                }
                catch (InvalidConfigException e) {
                    this.addFieldError("proxy", this.getText(e.getMessage()) + " " + this.proxy);
                    return "input";
                }
                this.configManager.saveConfig();
                this.addActionMessage(this.getText("admin.config.setup2.success"));
                this.addActionMessage(this.getText("admin.config.setup2.next"));
                return "success";
            }
            catch (InvalidConfigException e) {
                if (e.getType() == InvalidConfigException.TYPE.INACCESSIBLE_BASE_URL) {
                    this.addFieldError("baseURL", this.getText("admin.config.baseUrl.inaccessible") + " " + this.baseURL);
                } else {
                    LOG.error((Object)e);
                    this.addActionError(this.getTextWithDynamicArgs("admin.config.setup2.already.registered", new String[]{this.cfg.getRegistryType().toString()}));
                }
            }
            catch (RegistryException e) {
                String msg = RegistryException.logRegistryException((RegistryException)e, (BaseAction)this);
                LOG.warn("Failed to contact the GBIF Registry (" + msg + "): " + e.getMessage(), (Throwable)e);
                this.addActionError(msg);
            }
        }
        return "input";
    }

    public String setupInstallationComplete() {
        List schemas;
        String msg;
        if (!this.configManager.setupComplete() || !this.configManager.isBaseURLValid()) {
            return "error";
        }
        try {
            this.configManager.loadDataDirConfig();
            this.session.put("curr_user", this.userManager.getSetupUser());
        }
        catch (InvalidConfigException e) {
            msg = this.getText("admin.vocabulary.couldnt.install.defaults", new String[]{e.getMessage()});
            LOG.error(msg, (Throwable)e);
            this.addActionWarning(msg, (Exception)((Object)e));
        }
        catch (RegistryException e) {
            msg = RegistryException.logRegistryException((RegistryException)e, (BaseAction)this);
            LOG.warn("Failed to contact the GBIF Registry (" + msg + "): " + e.getMessage(), (Throwable)e);
            this.addActionError(msg);
            this.addActionExceptionWarning((Exception)((Object)e));
        }
        List extensions = this.extensionManager.listCore();
        if (extensions.isEmpty()) {
            try {
                this.extensionManager.installCoreTypes();
            }
            catch (InvalidConfigException e) {
                LOG.error((Object)e);
                this.addActionWarning(this.getText("admin.extension.couldnt.install.coreTypes"), (Exception)((Object)e));
            }
        }
        if ((schemas = this.schemaManager.list()).isEmpty()) {
            try {
                this.schemaManager.installSupportedDataPackageSchemas();
            }
            catch (InvalidConfigException e) {
                LOG.error((Object)e);
                this.addActionWarning(this.getText("admin.dataPackages.couldnt.install"), (Exception)((Object)e));
            }
        }
        if (this.registrationManager.getIpt() == null || this.getDefaultOrganisation() == null) {
            try {
                this.registrationManager.addAssociatedOrganisation(this.createDefaultOrganisation());
                this.registrationManager.save();
            }
            catch (Exception e) {
                LOG.error((Object)e);
                this.addActionWarning(this.getText("admin.error.invalidConfiguration", new String[]{e.getMessage()}), e);
            }
        }
        return "input";
    }

    public void setUser(User user) {
        this.user = user;
    }

    public void validate() {
        if (this.setupDefaultAdministrator) {
            if (this.ignoreUserValidation == 0 && this.user != null) {
                this.userValidation.validate((BaseAction)this, this.user);
                if (StringUtils.trimToNull((String)this.user.getPassword()) != null && !this.user.getPassword().equals(this.password2)) {
                    this.addFieldError("password2", this.getText("validation.password2.wrong"));
                }
            }
        } else if (this.setupPublicUrl) {
            if (StringUtils.trimToNull((String)this.baseURL) == null) {
                this.addFieldError("baseURL", this.getText("validation.baseURL.required"));
            } else if (!URLUtils.isURLValid((String)this.baseURL)) {
                this.addFieldError("baseURL", this.getText("validation.baseURL.invalid") + " " + this.baseURL);
            } else {
                try {
                    new URL(this.baseURL);
                }
                catch (MalformedURLException e) {
                    this.addFieldError("baseURL", this.getText("validation.baseURL.invalid") + " " + this.baseURL);
                }
            }
            if (StringUtils.trimToNull((String)this.proxy) != null) {
                if (!URLUtils.isURLValid((String)this.proxy)) {
                    this.addFieldError("proxy", this.getText("admin.config.proxy.error") + " " + this.proxy);
                } else {
                    try {
                        HttpHost host = URLUtils.getHost((String)this.proxy);
                        if (!this.client.verifyHost(host)) {
                            this.addFieldError("proxy", this.getText("admin.config.error.connectionRefused") + " " + this.proxy);
                        }
                    }
                    catch (MalformedURLException e) {
                        this.addFieldError("proxy", this.getText("admin.config.error.invalidProxyURL") + " " + this.proxy);
                    }
                }
            }
        }
    }

    public String getModeSelected() {
        if (this.cfg != null && this.cfg.devMode()) {
            return MODE_DEVELOPMENT;
        }
        return this.modeSelected;
    }

    public void setModeSelected(String modeSelected) {
        this.modeSelected = modeSelected;
    }

    private Organisation createDefaultOrganisation() {
        Organisation organisation = new Organisation();
        String name = this.getText("eml.publishingOrganisation.none");
        organisation.setName(name);
        organisation.setAlias(name);
        organisation.setCanHost(true);
        organisation.setDescription("Installed by default, used to indicate resource is not published by any organisation");
        organisation.setKey(Constants.DEFAULT_ORG_KEY.toString());
        organisation.setPassword("password");
        return organisation;
    }
}

