/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.config;

import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationFactory;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.Order;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.util.LoaderUtil;
import org.gbif.ipt.config.LoggingConfiguration;

@Plugin(name="LoggingConfigFactory", category="ConfigurationFactory")
@Order(value=5)
public class LoggingConfigFactory
extends ConfigurationFactory {
    public static boolean useDebug = true;
    public static final String[] SUFFIXES = new String[]{".xml", "*"};

    public Configuration getConfiguration(LoggerContext loggerContext, ConfigurationSource configFile) {
        String configName = useDebug ? "log4j2.xml" : "log4j2-production.xml";
        ClassLoader loader = LoaderUtil.getThreadContextClassLoader();
        ConfigurationSource source = ConfigurationSource.fromResource((String)configName, (ClassLoader)loader);
        return new LoggingConfiguration(loggerContext, source);
    }

    public String[] getSupportedTypes() {
        return SUFFIXES;
    }
}

