/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.config;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.math.BigDecimal;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.RegExUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.gbif.ipt.config.AppConfig;
import org.gbif.ipt.config.Constants;
import org.gbif.ipt.config.DataDir;
import org.gbif.ipt.config.SupportedDataPackageType;
import org.gbif.ipt.model.IptColorScheme;
import org.gbif.ipt.service.InvalidConfigException;
import org.gbif.ipt.utils.InputStreamUtils;
import org.gbif.utils.text.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class AppConfig {
    private static final String UI_SETTINGS_FOLDER = ".uiSettings";
    private static final String COLOR_SCHEME_PROPFILE = "ipt-color-scheme.properties";
    protected static final String DATADIR_PROPFILE = "ipt.properties";
    static final String CLASSPATH_PROPFILE = "application.properties";
    public static final String BASEURL = "ipt.baseURL";
    public static final String CORE_ROW_TYPES = "ipt.core_rowTypes";
    public static final String CORE_ROW_ID_TERMS = "ipt.core_idTerms";
    public static final String PROXY = "proxy";
    public static final String DEBUG = "debug";
    public static final String ARCHIVAL_MODE = "archivalMode";
    public static final String ARCHIVAL_LIMIT = "archivalLimit";
    public static final String ANALYTICS_KEY = "analytics.key";
    public static final String IPT_LATITUDE = "location.lat";
    public static final String IPT_LONGITUDE = "location.lon";
    public static final String DEV_VERSION = "dev.version";
    public static final String ADMIN_EMAIL = "admin.email";
    public static final String DEFAULT_LOCALE = "defaultLocale";
    public static final String LOGO_REDIRECT_URL = "logoRedirectUrl";
    public static final String SESSION_TIMEOUT_PROPERTY = "session.timeout";
    public static final String DATAPACKAGE_FOREIGN_KEYS_VALIDATION = "datapackage.fk.validation";
    private static final String PRODUCTION_TYPE_LOCKFILE = ".gbifreg";
    public static final String BUILD_NUMBER_VARIABLE_SUFFIX = "-r${buildNumber}";
    public static final String BUILD_NUMBER_REGEX = "-r\\$\\{buildNumber\\}$|-r\\w{7}$";
    private Properties properties = new Properties();
    private IptColorScheme colorScheme;
    private static final Logger LOG = LogManager.getLogger(AppConfig.class);
    private DataDir dataDir;
    private REGISTRY_TYPE type;
    private static final int SESSION_TIMEOUT = 3600;
    private static final int CSRF_TOKEN_EXPIRATION = 900;
    private static final int CSRF_PAGE_REFRESH_DELAY = 600000;
    private static final List<String> DEFAULT_CORE_ROW_TYPES = Arrays.asList(Constants.DWC_ROWTYPE_OCCURRENCE, Constants.DWC_ROWTYPE_TAXON, Constants.DWC_ROWTYPE_EVENT);
    private static final Map<String, String> DEFAULT_CORE_ROW_TYPES_ID_TERMS = new HashMap();
    private static final Set<Locale> IPT_SUPPORTED_LOCALES;
    private static final Set<String> IPT_SUPPORTED_LANGUAGES;
    private static List<String> coreRowTypes;
    private static Map<String, String> coreRowTypeIdTerms;

    private AppConfig() {
    }

    public AppConfig(DataDir dataDir) throws InvalidConfigException {
        this.dataDir = dataDir;
        this.loadConfig();
    }

    public static String coreIdTerm(String rowType) {
        if (coreRowTypeIdTerms.containsKey(rowType)) {
            return (String)coreRowTypeIdTerms.get(rowType);
        }
        throw new IllegalArgumentException("IPT is not configured correctly to support rowType[" + rowType + "].  Hint: are you missing mappings for the row type and id term in the properties?");
    }

    public static List<String> getCoreRowTypes() {
        return coreRowTypes;
    }

    public Map<String, String> getSupportedDataSchemaNamesWithVersions() {
        return Arrays.stream(SupportedDataPackageType.values()).filter(dp -> this.type != REGISTRY_TYPE.PRODUCTION || dp.isProductionType()).collect(Collectors.toMap(SupportedDataPackageType::getName, SupportedDataPackageType::getSupportedVersion));
    }

    public static boolean isCore(String rowType) {
        return coreRowTypes.contains(rowType);
    }

    public boolean debug() {
        return "true".equalsIgnoreCase(this.properties.getProperty("debug"));
    }

    public boolean devMode() {
        return !"false".equalsIgnoreCase(this.properties.getProperty("dev.devmode"));
    }

    public String getAnalyticsKey() {
        return this.properties.getProperty("analytics.key");
    }

    public String getBaseUrl() {
        String base;
        for (base = this.properties.getProperty("ipt.baseURL"); base != null && base.endsWith("/"); base = base.substring(0, base.length() - 1)) {
        }
        return base;
    }

    public String getAdminEmail() {
        return this.properties.getProperty("admin.email");
    }

    public String getDefaultLocale() {
        return this.properties.getProperty("defaultLocale");
    }

    public DataDir getDataDir() {
        return this.dataDir;
    }

    public Double getLatitude() {
        try {
            String val = this.properties.getProperty("location.lat");
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)val)) {
                return Double.valueOf(val);
            }
        }
        catch (NumberFormatException e) {
            LOG.warn("IPT latitude was invalid: " + e.getMessage());
        }
        return null;
    }

    public Double getLongitude() {
        try {
            String val = this.properties.getProperty("location.lon");
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)val)) {
                return Double.valueOf(val);
            }
        }
        catch (NumberFormatException e) {
            LOG.warn("IPT longitude was invalid: " + e.getMessage());
        }
        return null;
    }

    public int getMaxThreads() {
        try {
            return Integer.parseInt(this.getProperty("dev.maxthreads"));
        }
        catch (NumberFormatException e) {
            return 3;
        }
    }

    public int getSessionTimeout() {
        String sessionTimeout = this.properties.getProperty("session.timeout");
        if (sessionTimeout != null) {
            return Integer.parseInt(sessionTimeout) * 60;
        }
        return 3600;
    }

    public int getCsrfTokenExpiration() {
        return 900;
    }

    public int getCsrfPageRefreshDelay() {
        return 600000;
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public String getProxy() {
        return this.properties.getProperty("proxy");
    }

    public REGISTRY_TYPE getRegistryType() {
        return this.type;
    }

    private File getRegistryTypeLockFile() {
        return this.dataDir.configFile(".gbifreg");
    }

    public String getRegistryUrl() {
        if (REGISTRY_TYPE.PRODUCTION == this.type) {
            return this.getProperty("dev.registry.url");
        }
        return this.getProperty("dev.registrydev.url");
    }

    public String getPortalUrl() {
        if (REGISTRY_TYPE.PRODUCTION == this.type) {
            return this.getProperty("dev.portal.url");
        }
        return this.getProperty("dev.portaldev.url");
    }

    public String getDataCiteUrl() {
        if (REGISTRY_TYPE.PRODUCTION == this.type) {
            return this.getProperty("dev.datacite.url");
        }
        return this.getProperty("dev.datacitedev.url");
    }

    @NotNull
    public String getResourceArchiveUrl(@NotNull String shortname) {
        String baseUrl = this.getBaseUrl();
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)baseUrl)) {
            LOG.error("IPT's base URL must not be null or empty");
            throw new RuntimeException("IPT's base URL must not be null or empty");
        }
        return UriBuilder.fromPath((String)baseUrl).path("archive.do").queryParam("r", new Object[]{shortname}).build(new Object[0]).toString();
    }

    @NotNull
    public String getResourceEmlUrl(@NotNull String shortname) {
        String baseUrl = this.getBaseUrl();
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)baseUrl)) {
            LOG.error("IPT's base URL must not be null or empty");
            throw new RuntimeException("IPT's base URL must not be null or empty");
        }
        return UriBuilder.fromPath((String)baseUrl).path("eml.do").queryParam("r", new Object[]{shortname}).build(new Object[0]).toString();
    }

    @NotNull
    public String getResourceDataPackageMetadataUrl(@NotNull String shortname) {
        String baseUrl = this.getBaseUrl();
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)baseUrl)) {
            LOG.error("IPT's base URL must not be null or empty");
            throw new RuntimeException("IPT's base URL must not be null or empty");
        }
        return UriBuilder.fromPath((String)baseUrl).path("metadata.do").queryParam("r", new Object[]{shortname}).build(new Object[0]).toString();
    }

    @NotNull
    public String getResourceLogoUrl(@NotNull String shortname) {
        String baseUrl = this.getBaseUrl();
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)baseUrl)) {
            LOG.error("IPT's base URL must not be null or empty");
            throw new RuntimeException("IPT's base URL must not be null or empty");
        }
        return UriBuilder.fromPath((String)baseUrl).path("logo.do").queryParam("r", new Object[]{shortname}).build(new Object[0]).toString();
    }

    @NotNull
    public String getResourceUrl(@NotNull String shortname) {
        return this.getResourceUri(shortname).toString();
    }

    @NotNull
    public URI getResourceUri(@NotNull String shortname) {
        String baseUrl = this.getBaseUrl();
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)baseUrl)) {
            LOG.error("IPT's base URL must not be null or empty");
            throw new RuntimeException("IPT's base URL must not be null or empty");
        }
        return UriBuilder.fromPath((String)baseUrl).path("resource").queryParam("r", new Object[]{shortname}).build(new Object[0]);
    }

    @NotNull
    public String getResourceGuid(@NotNull String shortname) {
        String baseUrl = this.getBaseUrl();
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)baseUrl)) {
            LOG.error("IPT's base URL must not be null or empty");
            throw new RuntimeException("IPT's base URL must not be null or empty");
        }
        return UriBuilder.fromPath((String)baseUrl).path("resource").queryParam("id", new Object[]{shortname}).build(new Object[0]).toString();
    }

    @NotNull
    public URI getResourceVersionUri(@NotNull String shortname, @NotNull BigDecimal version) {
        String baseUrl = this.getBaseUrl();
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)baseUrl)) {
            LOG.error("IPT's base URL must not be null or empty");
            throw new RuntimeException("IPT's base URL must not be null or empty");
        }
        return UriBuilder.fromPath((String)baseUrl).path("resource").queryParam("r", new Object[]{shortname}).queryParam("v", new Object[]{version.toPlainString()}).build(new Object[0]);
    }

    @NotNull
    public String getResourceVersionUri(@NotNull String shortname, @NotNull String version) {
        return this.getResourceVersionUri(shortname, new BigDecimal(version)).toString();
    }

    public String getVersion() {
        String version = this.properties.getProperty("dev.version");
        return org.apache.commons.lang3.StringUtils.removeEnd((String)version, (String)"-r${buildNumber}");
    }

    public String getShortVersion() {
        String version = this.properties.getProperty("dev.version");
        return RegExUtils.removePattern((String)version, (String)"-r\\$\\{buildNumber\\}$|-r\\w{7}$");
    }

    public boolean hasLocation() {
        return this.getLongitude() != null && this.getLatitude() != null;
    }

    public boolean isArchivalMode() {
        return "true".equalsIgnoreCase(this.properties.getProperty("archivalMode"));
    }

    public Integer getArchivalLimit() {
        try {
            String val = this.properties.getProperty("archivalLimit");
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)val)) {
                return Integer.valueOf(val);
            }
        }
        catch (NumberFormatException e) {
            LOG.warn("Archival limit was invalid: " + e.getMessage());
        }
        return null;
    }

    public boolean isTestInstallation() {
        return REGISTRY_TYPE.DEVELOPMENT == this.type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadConfig() throws InvalidConfigException {
        InputStreamUtils streamUtils = new InputStreamUtils();
        InputStream configStream = streamUtils.classpathStream("application.properties");
        try {
            Properties props = new Properties();
            if (configStream == null) {
                LOG.error("Could not load default configuration from application.properties in classpath");
            } else {
                props.load(configStream);
                LOG.debug("Loaded default configuration from application.properties in classpath");
            }
            if (this.dataDir.isConfigured()) {
                File userCfgFile = new File(this.dataDir.dataDir, "config/ipt.properties");
                if (userCfgFile.exists()) {
                    FileInputStream fis = null;
                    try {
                        fis = new FileInputStream(userCfgFile);
                        props.load(fis);
                        LOG.debug("Loaded user configuration from " + userCfgFile.getAbsolutePath());
                    }
                    catch (IOException e) {
                        LOG.warn("DataDir configured, but failed to load ipt.properties from " + userCfgFile.getAbsolutePath(), (Throwable)e);
                    }
                    finally {
                        if (fis != null) {
                            try {
                                fis.close();
                            }
                            catch (IOException e) {
                                LOG.debug("Failed to close input stream on ipt.properties file");
                            }
                        }
                    }
                } else {
                    LOG.warn("DataDir configured, but user configuration doesnt exist: " + userCfgFile.getAbsolutePath());
                }
                File cfgFile = new File(this.dataDir.dataDir, "config/.uiSettings/ipt-color-scheme.properties");
                if (!cfgFile.exists()) {
                    LOG.info("IPT UI settings not found, try to create them and then load");
                    Path parentDir = cfgFile.getParentFile().toPath();
                    if (!Files.exists(parentDir, new LinkOption[0])) {
                        try {
                            Files.createDirectories(parentDir, new FileAttribute[0]);
                        }
                        catch (IOException e) {
                            LOG.error("Failed to create .uiSettings directory", (Throwable)e);
                        }
                    }
                    try (OutputStream out = Files.newOutputStream(cfgFile.toPath(), new OpenOption[0]);){
                        this.colorScheme = new IptColorScheme();
                        Properties uiProps = this.colorScheme.toProperties();
                        uiProps.store(out, "Default IPT color scheme configuration, last saved " + String.valueOf(new Date()));
                    }
                    catch (IOException e) {
                        LOG.error("Failed to load the default application configuration from ipt-color-scheme.properties", (Throwable)e);
                    }
                } else {
                    LOG.info("Loading IPT UI settings");
                    try (InputStream in = Files.newInputStream(cfgFile.toPath(), new OpenOption[0]);){
                        Properties uiProps = new Properties();
                        uiProps.load(in);
                        this.colorScheme = new IptColorScheme(uiProps);
                    }
                    catch (IOException e) {
                        LOG.error("Failed to load the application configuration from ipt-color-scheme.properties", (Throwable)e);
                    }
                }
                this.readRegistryLock();
            }
            this.properties = props;
            this.populateCoreConfiguration();
        }
        catch (IOException e) {
            LOG.error("Failed to load the default application configuration from application.properties", (Throwable)e);
        }
    }

    private void populateCoreConfiguration() {
        String cores = this.properties.getProperty("ipt.core_rowTypes");
        String ids = this.properties.getProperty("ipt.core_idTerms");
        if (cores != null && ids != null) {
            LOG.info("Using custom core mapping");
            List configCores = Arrays.stream(cores.split("\\|")).map(StringUtils::trim).filter(org.apache.commons.lang3.StringUtils::isNotEmpty).collect(Collectors.toList());
            List configIDs = Arrays.stream(ids.split("\\|")).map(StringUtils::trim).filter(org.apache.commons.lang3.StringUtils::isNotEmpty).collect(Collectors.toList());
            if (configCores.size() == configIDs.size()) {
                coreRowTypes = new ArrayList(DEFAULT_CORE_ROW_TYPES);
                coreRowTypes.addAll(configCores);
                coreRowTypeIdTerms = new HashMap(DEFAULT_CORE_ROW_TYPES_ID_TERMS);
                for (int i = 0; i < configCores.size(); ++i) {
                    coreRowTypeIdTerms.put((String)configCores.get(i), (String)configIDs.get(i));
                }
                LOG.info("IPT configured to support cores and id terms: " + String.valueOf(coreRowTypeIdTerms));
                return;
            }
            LOG.error("Invalid configuration of [ipt.core_rowTypes,ipt.core_idTerms].  Should have same number of elements - using defaults");
        }
        coreRowTypes = DEFAULT_CORE_ROW_TYPES;
        coreRowTypeIdTerms = DEFAULT_CORE_ROW_TYPES_ID_TERMS;
    }

    private void readRegistryLock() throws InvalidConfigException {
        File lockFile = this.getRegistryTypeLockFile();
        if (lockFile.exists()) {
            try {
                LOG.info("Reading registry lock file to determine if the DataDir is locked to a registry yet.");
                String regTypeAsString = org.apache.commons.lang3.StringUtils.trimToEmpty((String)FileUtils.readFileToString((File)lockFile, (String)"UTF-8"));
                this.type = REGISTRY_TYPE.valueOf((String)regTypeAsString);
                LOG.info("DataDir is locked to registry type: " + String.valueOf(this.type));
            }
            catch (IllegalArgumentException e) {
                LOG.error("Cannot interpret registry lock file contents!", (Throwable)e);
                throw new InvalidConfigException(InvalidConfigException.TYPE.INVALID_DATA_DIR, "Cannot interpret registry lock file contents!");
            }
            catch (IOException e) {
                LOG.error("Cannot read registry lock file!", (Throwable)e);
                throw new InvalidConfigException(InvalidConfigException.TYPE.INVALID_DATA_DIR, "Cannot read registry lock file!");
            }
        } else {
            LOG.warn("Registry lock file not found meaning the DataDir is NOT locked to a registry yet!");
        }
    }

    public void saveColorSchemeConfig(IptColorScheme colorScheme) throws IOException {
        this.colorScheme = colorScheme;
        File cfgFile = new File(this.dataDir.dataDir, "config/.uiSettings/ipt-color-scheme.properties");
        try (OutputStream out = Files.newOutputStream(cfgFile.toPath(), new OpenOption[0]);){
            Properties props = colorScheme.toProperties();
            props.store(out, "IPT color scheme configuration, last saved " + String.valueOf(new Date()));
        }
    }

    public IptColorScheme getColorSchemeConfig() {
        return this.colorScheme;
    }

    public String getLogoRedirectUrl() {
        return this.properties.getProperty("logoRedirectUrl");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveConfig() throws IOException {
        try (OutputStream out = null;){
            File userCfgFile = new File(this.dataDir.dataDir, "config/ipt.properties");
            out = new FileOutputStream(userCfgFile);
            Properties props = (Properties)this.properties.clone();
            Enumeration<?> e = props.propertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                if (!key.startsWith("dev.")) continue;
                props.remove(key);
            }
            props.store(out, "IPT configuration, last saved " + String.valueOf(new Date()));
            out.close();
        }
    }

    public void setProperty(String key, String value) {
        this.properties.setProperty(key, org.apache.commons.lang3.StringUtils.trimToEmpty((String)value));
    }

    public void setDefaultLocale(String value) {
        this.properties.setProperty("defaultLocale", value);
    }

    protected void setRegistryType(REGISTRY_TYPE newType) throws InvalidConfigException {
        Objects.requireNonNull(newType, "Registry type cannot be null");
        if (this.type != null) {
            if (this.type == newType) {
                return;
            }
            throw new InvalidConfigException(InvalidConfigException.TYPE.DATADIR_ALREADY_REGISTERED, "The datadir is already designated as " + String.valueOf(this.type));
        }
        try {
            this.writeRegistryLockFile(newType);
            this.type = newType;
        }
        catch (IOException e) {
            LOG.error("Cannot lock the datadir to registry type " + String.valueOf(newType), (Throwable)e);
            throw new InvalidConfigException(InvalidConfigException.TYPE.CONFIG_WRITE, "Cannot lock the datadir to registry type " + String.valueOf(newType));
        }
    }

    private void writeRegistryLockFile(REGISTRY_TYPE registryType) throws IOException {
        File lockFile = this.getRegistryTypeLockFile();
        try (BufferedWriter lock = Files.newBufferedWriter(lockFile.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
            lock.write(registryType.name());
            ((Writer)lock).flush();
            LOG.info("Locked DataDir to registry of type " + String.valueOf(registryType));
        }
    }

    public boolean isSupportedLanguage(String language) {
        return IPT_SUPPORTED_LANGUAGES.contains(language);
    }

    public boolean isSupportedLocale(Locale locale) {
        return IPT_SUPPORTED_LOCALES.contains(locale);
    }

    public void setLogoRedirectUrl(String logoRedirectUrl) {
        this.properties.setProperty("logoRedirectUrl", logoRedirectUrl);
    }

    public boolean isDatapackageForeignKeysValidationEnabled() {
        return "true".equalsIgnoreCase(this.properties.getProperty("datapackage.fk.validation"));
    }

    static {
        DEFAULT_CORE_ROW_TYPES_ID_TERMS.put(Constants.DWC_ROWTYPE_OCCURRENCE, "http://rs.tdwg.org/dwc/terms/occurrenceID");
        DEFAULT_CORE_ROW_TYPES_ID_TERMS.put(Constants.DWC_ROWTYPE_TAXON, "http://rs.tdwg.org/dwc/terms/taxonID");
        DEFAULT_CORE_ROW_TYPES_ID_TERMS.put(Constants.DWC_ROWTYPE_EVENT, "http://rs.tdwg.org/dwc/terms/eventID");
        coreRowTypes = DEFAULT_CORE_ROW_TYPES;
        coreRowTypeIdTerms = DEFAULT_CORE_ROW_TYPES_ID_TERMS;
        IPT_SUPPORTED_LOCALES = new HashSet();
        IPT_SUPPORTED_LOCALES.add(Locale.UK);
        IPT_SUPPORTED_LOCALES.add(Locale.FRENCH);
        IPT_SUPPORTED_LOCALES.add(Locale.CHINESE);
        IPT_SUPPORTED_LOCALES.add(Locale.JAPANESE);
        IPT_SUPPORTED_LOCALES.add(new Locale("es"));
        IPT_SUPPORTED_LOCALES.add(new Locale("pt"));
        IPT_SUPPORTED_LOCALES.add(new Locale("ru"));
        IPT_SUPPORTED_LANGUAGES = new HashSet();
        IPT_SUPPORTED_LANGUAGES.add("en");
        IPT_SUPPORTED_LANGUAGES.add("fr");
        IPT_SUPPORTED_LANGUAGES.add("zh");
        IPT_SUPPORTED_LANGUAGES.add("ja");
        IPT_SUPPORTED_LANGUAGES.add("es");
        IPT_SUPPORTED_LANGUAGES.add("pt");
        IPT_SUPPORTED_LANGUAGES.add("ru");
    }
}

