/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.action.portal;

import com.opensymphony.xwork2.ActionSupport;
import java.io.File;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.json.annotations.JSON;
import org.gbif.api.model.common.DOI;
import org.gbif.ipt.action.portal.InventoryV2Action;
import org.gbif.ipt.config.AppConfig;
import org.gbif.ipt.model.Organisation;
import org.gbif.ipt.model.Resource;
import org.gbif.ipt.model.VersionHistory;
import org.gbif.ipt.model.voc.PublicationStatus;
import org.gbif.ipt.service.manage.ResourceManager;
import org.gbif.ipt.utils.ResourceUtils;

public class InventoryV2Action
extends ActionSupport {
    private static final long serialVersionUID = 2207415310987539257L;
    private static final Logger LOG = LogManager.getLogger(InventoryV2Action.class);
    private final AppConfig cfg;
    private final ResourceManager resourceManager;
    private List<DatasetItemV2> inventory = new ArrayList();
    private String status;
    private String type;

    @Inject
    public InventoryV2Action(AppConfig cfg, ResourceManager resourceManager) {
        this.cfg = cfg;
        this.resourceManager = resourceManager;
    }

    public String execute() {
        List resources;
        PublicationStatus parsedStatus = Optional.ofNullable(this.status).flatMap(s -> {
            try {
                return Optional.of(PublicationStatus.valueOf((String)s.toUpperCase()));
            }
            catch (IllegalArgumentException e) {
                return Optional.empty();
            }
        }).orElse(null);
        boolean statusIsPresent = parsedStatus != null;
        List<Object> list = resources = statusIsPresent ? this.resourceManager.list(parsedStatus) : this.resourceManager.listPublishedPublicVersions();
        if (StringUtils.isNotEmpty((CharSequence)this.type)) {
            resources = resources.stream().filter(r -> this.filterByType(r, this.type)).collect(Collectors.toList());
        }
        if (!resources.isEmpty()) {
            this.populateInventory(resources);
        }
        return "success";
    }

    private boolean filterByType(Resource resource, String type) {
        String t;
        String archiveType = resource.getCoreType();
        String dp = resource.getDataPackageIdentifier();
        switch (t = type.toLowerCase()) {
            case "camtrap": 
            case "camtrapdp": 
            case "camtrap-dp": {
                return "camtrap-dp".equalsIgnoreCase(archiveType);
            }
            case "coldp": {
                return "coldp".equalsIgnoreCase(archiveType);
            }
            case "dwca": {
                return dp == null && resource.getCoreRowType() != null;
            }
            case "datapackage": {
                return "camtrap-dp".equalsIgnoreCase(dp) || "coldp".equalsIgnoreCase(dp);
            }
        }
        return false;
    }

    @JSON(name="resources")
    public List<DatasetItemV2> getInventory() {
        return this.inventory;
    }

    public void populateInventory(List<Resource> resources) {
        ArrayList<DatasetItemV2> items = new ArrayList<DatasetItemV2>();
        for (Resource r : resources) {
            BigDecimal version = r.getLastPublishedVersionsVersion();
            if (version == null) continue;
            try {
                DatasetItemV2 item = r.isDataPackage() ? this.convertToFrictionlessDatasetItem(r) : this.convertToDwcaDatasetItem(r);
                items.add(item);
            }
            catch (Exception e) {
                LOG.error("Failed to populate inventory. Resource {}, type {}", (Object)r.getShortname(), (Object)r.getCoreType());
            }
        }
        this.setInventory(items);
    }

    private DatasetItemV2 convertToDwcaDatasetItem(Resource r) {
        DatasetItemV2 item = new DatasetItemV2();
        BigDecimal version = r.getLastPublishedVersionsVersion();
        String shortname = r.getShortname();
        VersionHistory versionHistory = r.getLastPublishedVersion();
        DOI doi = Optional.ofNullable(versionHistory).map(VersionHistory::getDoi).orElse(null);
        File versionEmlFile = this.cfg.getDataDir().resourceEmlFile(shortname, version);
        UUID gbifKey = r.getKey();
        Resource lastPublished = ResourceUtils.reconstructVersion((BigDecimal)version, (String)shortname, (String)r.getCoreType(), (String)r.getDataPackageIdentifier(), (DOI)doi, (Organisation)r.getOrganisation(), (VersionHistory)versionHistory, (File)versionEmlFile, (UUID)gbifKey);
        item.setId(shortname);
        item.setTitle(StringUtils.trimToNull((String)lastPublished.getTitle()));
        item.setRecords(lastPublished.getRecordsPublished());
        item.setLastPublished(lastPublished.getLastPublished());
        Optional.of(lastPublished).map(Resource::getKey).map(UUID::toString).ifPresent(arg_0 -> ((DatasetItemV2)item).setGbifKey(arg_0));
        ArrayList<InventoryArchiveInfo> archives = new ArrayList<InventoryArchiveInfo>();
        InventoryArchiveInfo archiveInfo = new InventoryArchiveInfo();
        if (!ResourceFormatType.METADATA.toString().equalsIgnoreCase(r.getCoreType())) {
            archiveInfo.setType(ArchiveFormatType.DWCA);
            archiveInfo.setUrl(this.cfg.getResourceArchiveUrl(shortname));
            archives.add(archiveInfo);
            item.setArchive(archives);
        }
        ArrayList<InventoryMetadataInfo> metadataList = new ArrayList<InventoryMetadataInfo>();
        InventoryMetadataInfo metadata = new InventoryMetadataInfo();
        metadata.setType(MetadataFormatType.EML);
        metadata.setUrl(this.cfg.getResourceEmlUrl(shortname));
        metadataList.add(metadata);
        item.setMetadata(metadataList);
        item.setVersion(version);
        if (ResourceFormatType.METADATA.toString().equalsIgnoreCase(r.getCoreType())) {
            item.setFormat(ResourceFormatType.METADATA);
        } else if (!lastPublished.isDataPackage()) {
            item.setFormat(ResourceFormatType.DWCA);
            HashMap<String, Object> metrics = new HashMap<String, Object>();
            metrics.put("recordsByExtension", lastPublished.getRecordsByExtension());
            metrics.put("core", r.getCoreType());
            item.setAdditionalProperties(metrics);
        }
        return item;
    }

    private DatasetItemV2 convertToFrictionlessDatasetItem(Resource r) {
        DatasetItemV2 item = new DatasetItemV2();
        BigDecimal version = r.getLastPublishedVersionsVersion();
        String shortname = r.getShortname();
        VersionHistory versionHistory = r.getLastPublishedVersion();
        DOI doi = Optional.ofNullable(versionHistory).map(VersionHistory::getDoi).orElse(null);
        File versionedDatapackageFile = this.cfg.getDataDir().resourceDatapackageMetadataFile(shortname, r.getCoreType(), version);
        UUID gbifKey = r.getKey();
        Resource lastPublished = ResourceUtils.reconstructVersion((BigDecimal)version, (String)shortname, (String)r.getCoreType(), (String)r.getDataPackageIdentifier(), (DOI)doi, (Organisation)r.getOrganisation(), (VersionHistory)versionHistory, (File)versionedDatapackageFile, (UUID)gbifKey);
        item.setId(shortname);
        item.setTitle(StringUtils.trimToNull((String)lastPublished.getTitle()));
        item.setRecords(lastPublished.getRecordsPublished());
        item.setLastPublished(lastPublished.getLastPublished());
        Optional.of(lastPublished).map(Resource::getKey).map(UUID::toString).ifPresent(arg_0 -> ((DatasetItemV2)item).setGbifKey(arg_0));
        ArrayList<InventoryArchiveInfo> archives = new ArrayList<InventoryArchiveInfo>();
        InventoryArchiveInfo archiveInfo = new InventoryArchiveInfo();
        if ("camtrap-dp".equalsIgnoreCase(r.getCoreType())) {
            archiveInfo.setType(ArchiveFormatType.CAMTRAP_DP);
            archiveInfo.setUrl(this.cfg.getResourceArchiveUrl(shortname));
            archives.add(archiveInfo);
            item.setArchive(archives);
            item.setFormat(ResourceFormatType.CAMTRAP_DP);
        } else if ("coldp".equalsIgnoreCase(r.getCoreType())) {
            archiveInfo.setType(ArchiveFormatType.COLDP);
            archiveInfo.setUrl(this.cfg.getResourceArchiveUrl(shortname));
            archives.add(archiveInfo);
            item.setArchive(archives);
            item.setFormat(ResourceFormatType.COLDP);
        } else {
            LOG.warn("Unsupported archive type {}", (Object)r.getCoreType());
        }
        ArrayList<InventoryMetadataInfo> metadataList = new ArrayList<InventoryMetadataInfo>();
        InventoryMetadataInfo metadata = new InventoryMetadataInfo();
        metadata.setType(MetadataFormatType.FRICTIONLESS);
        metadata.setUrl(this.cfg.getResourceDataPackageMetadataUrl(shortname));
        metadataList.add(metadata);
        item.setMetadata(metadataList);
        item.setVersion(version);
        HashMap<String, Map> metrics = new HashMap<String, Map>();
        metrics.put("recordsByTable", lastPublished.getRecordsByExtension());
        item.setAdditionalProperties(metrics);
        return item;
    }

    public void setInventory(List<DatasetItemV2> inventory) {
        this.inventory = inventory;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setType(String type) {
        this.type = type;
    }
}

