/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.action.portal;

import com.opensymphony.xwork2.ActionSupport;
import java.io.File;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.json.annotations.JSON;
import org.gbif.api.model.common.DOI;
import org.gbif.ipt.action.portal.InventoryAction;
import org.gbif.ipt.config.AppConfig;
import org.gbif.ipt.model.Organisation;
import org.gbif.ipt.model.Resource;
import org.gbif.ipt.model.VersionHistory;
import org.gbif.ipt.model.voc.PublicationStatus;
import org.gbif.ipt.service.manage.ResourceManager;
import org.gbif.ipt.utils.ResourceUtils;

public class InventoryAction
extends ActionSupport {
    private static final Logger LOG = LogManager.getLogger(InventoryAction.class);
    private final AppConfig cfg;
    private final ResourceManager resourceManager;
    private List<DatasetItem> inventory = new ArrayList();

    @Inject
    public InventoryAction(AppConfig cfg, ResourceManager resourceManager) {
        this.cfg = cfg;
        this.resourceManager = resourceManager;
    }

    public String execute() {
        List registered = this.resourceManager.list(PublicationStatus.REGISTERED);
        if (!registered.isEmpty()) {
            this.populateInventory(registered);
        }
        return "success";
    }

    @JSON(name="registeredResources")
    public List<DatasetItem> getInventory() {
        return this.inventory;
    }

    public void setInventory(List<DatasetItem> inventory) {
        this.inventory = inventory;
    }

    public void populateInventory(List<Resource> resources) {
        ArrayList<DatasetItem> items = new ArrayList<DatasetItem>();
        for (Resource r : resources) {
            BigDecimal version = r.getLastPublishedVersionsVersion();
            if (version == null || r.isDataPackage()) continue;
            try {
                DatasetItem item = this.convertToDatasetItem(r);
                items.add(item);
            }
            catch (Exception e) {
                LOG.error("Failed to populate inventory (v1). Resource {}, type {}. Error: {}", (Object)r.getShortname(), (Object)r.getCoreType(), (Object)e.getMessage());
            }
        }
        this.setInventory(items);
    }

    private DatasetItem convertToDatasetItem(Resource r) {
        DatasetItem item = new DatasetItem();
        BigDecimal version = r.getLastPublishedVersionsVersion();
        String shortname = r.getShortname();
        VersionHistory versionHistory = r.getLastPublishedVersion();
        DOI doi = versionHistory.getDoi();
        File versionEmlFile = this.cfg.getDataDir().resourceEmlFile(shortname, version);
        UUID gbifKey = r.getKey();
        Resource lastPublished = ResourceUtils.reconstructVersion((BigDecimal)version, (String)shortname, (String)r.getCoreType(), (String)r.getDataPackageIdentifier(), (DOI)doi, (Organisation)r.getOrganisation(), (VersionHistory)versionHistory, (File)versionEmlFile, (UUID)gbifKey);
        item.setTitle(StringUtils.trimToNull((String)lastPublished.getTitle()));
        item.setRecords(lastPublished.getRecordsPublished());
        item.setLastPublished(lastPublished.getLastPublished());
        item.setGbifKey(lastPublished.getKey().toString());
        item.setRecordsByExtension(lastPublished.getRecordsByExtension());
        item.setEml(this.cfg.getResourceEmlUrl(shortname));
        item.setDwca(this.cfg.getResourceArchiveUrl(shortname));
        item.setVersion(version);
        item.setType(StringUtils.trimToNull((String)r.getCoreType()));
        return item;
    }
}

