/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.action.portal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.gbif.ipt.action.portal.PortalBaseAction;
import org.gbif.ipt.config.AppConfig;
import org.gbif.ipt.config.Constants;
import org.gbif.ipt.config.DataDir;
import org.gbif.ipt.model.Source;
import org.gbif.ipt.service.admin.RegistrationManager;
import org.gbif.ipt.service.manage.ResourceManager;
import org.gbif.ipt.struts2.SimpleTextProvider;

public class AppFileAction
extends PortalBaseAction {
    private static final Logger LOG = LogManager.getLogger(AppFileAction.class);
    private final DataDir dataDir;
    protected Source source;
    private InputStream inputStream;
    protected File data;
    protected String mimeType = "text/plain";
    protected String filename;

    @Inject
    public AppFileAction(SimpleTextProvider textProvider, AppConfig cfg, RegistrationManager registrationManager, DataDir dataDir, ResourceManager resourceManager) {
        super(textProvider, cfg, registrationManager, resourceManager);
        this.dataDir = dataDir;
    }

    public String execute() {
        if (this.data == null) {
            return "404";
        }
        if (this.filename == null) {
            this.filename = this.data.getName();
        }
        try {
            this.inputStream = new FileInputStream(this.data);
            long lastModified = 1000L * ((this.data.lastModified() + 500L) / 1000L);
            this.response.setDateHeader("Last-Modified", lastModified);
            try {
                long since = this.req.getDateHeader("If-Modified-Since");
                if (since >= lastModified) {
                    return "304";
                }
            }
            catch (IllegalArgumentException e) {
                LOG.warn("Conditional get with If-Modified-Since header couldn't be interpreted", (Throwable)e);
            }
        }
        catch (FileNotFoundException e) {
            LOG.warn("Data dir file not found", (Throwable)e);
            return "404";
        }
        return "success";
    }

    public File getData() {
        return this.data;
    }

    public String getFilename() {
        return this.filename;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String logo() {
        for (String type : Constants.IMAGE_TYPES) {
            this.data = this.dataDir.appLogoFile(type);
            if (!this.data.exists()) continue;
            this.mimeType = "image/" + type;
            this.filename = "logo" + type;
            break;
        }
        if (!this.data.exists()) {
            return "404";
        }
        return this.execute();
    }

    public void prepare() {
        super.prepare();
    }
}

