/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.action.manage;

import com.opensymphony.xwork2.ActionSupport;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.ServletActionContext;
import org.gbif.ipt.model.UrlMetadata;
import org.gbif.ipt.utils.FileUtils;

public class UrlMetadataAction
extends ActionSupport {
    private static final long serialVersionUID = 4678767005519916360L;
    private static final Logger LOG = LogManager.getLogger(UrlMetadataAction.class);
    private static final String JSON_RESPONSE = "{\"status\": %d, \"contentType\": \"%s\", \"contentLength\": %d, \"lastModified\": \"%s\", \"acceptRanges\": \"%s\"}";
    private String url;

    public String execute() {
        HttpServletResponse response = ServletActionContext.getResponse();
        response.setContentType("application/json");
        if (this.url == null || this.url.isEmpty()) {
            try {
                response.sendError(400, "Missing 'url' parameter");
            }
            catch (IOException e) {
                LOG.error("Failed to send error response: {}", (Object)e.getMessage());
            }
            return "none";
        }
        try {
            UrlMetadata urlMetadata = FileUtils.fetchUrlMetadata((String)this.url);
            String json = String.format(JSON_RESPONSE, urlMetadata.getStatus(), this.escapeJson(urlMetadata.getContentType()), urlMetadata.getContentLength(), this.escapeJson(urlMetadata.getLastModified()), this.escapeJson(urlMetadata.getAcceptRanges()));
            response.getWriter().write(json);
        }
        catch (IOException e) {
            try {
                response.sendError(500, "Error fetching metadata: " + e.getMessage());
            }
            catch (IOException ex) {
                LOG.error("Failed to send error response: {}", (Object)e.getMessage());
            }
        }
        return "none";
    }

    private String escapeJson(String value) {
        if (value == null) {
            return "";
        }
        return value.replace("\"", "\\\"");
    }

    public void setUrl(String url) {
        this.url = url;
    }
}

